import bz2
import io
import lzma
from io import BufferedIOBase as BufferedIOBase
from typing import Any, BinaryIO, ClassVar, Generic, Literal

from _typeshed import ReadableBuffer, WriteableBuffer
from joblib.backports import LooseVersion as LooseVersion
from lz4.frame import LZ4FrameFile  # type: ignore
from typing_extensions import TypeVar

_BufferedIOBaseT = TypeVar("_BufferedIOBaseT", bound=BufferedIOBase)

LZ4_NOT_INSTALLED_ERROR: str
_COMPRESSORS: dict[str, CompressorWrapper[Any]]
_ZFILE_PREFIX: bytes
_ZLIB_PREFIX: bytes
_GZIP_PREFIX: bytes
_BZ2_PREFIX: bytes
_XZ_PREFIX: bytes
_LZMA_PREFIX: bytes
_LZ4_PREFIX: bytes

def register_compressor(
    compressor_name: str, compressor: CompressorWrapper[Any], force: bool = ...
) -> None: ...

class CompressorWrapper(Generic[_BufferedIOBaseT]):
    fileobj_factory: type[_BufferedIOBaseT]
    prefix: bytes
    extension: str
    def __init__(self, obj: Any, prefix: bytes = ..., extension: str = ...) -> None: ...
    def compressor_file(
        self, fileobj: Any, compresslevel: int | None = ...
    ) -> _BufferedIOBaseT: ...
    def decompressor_file(self, fileobj: Any) -> _BufferedIOBaseT: ...

class BZ2CompressorWrapper(CompressorWrapper[bz2.BZ2File]): ...
class LZMACompressorWrapper(CompressorWrapper[lzma.LZMAFile]): ...
class XZCompressorWrapper(LZMACompressorWrapper): ...
class LZ4CompressorWrapper(CompressorWrapper[LZ4FrameFile]): ...

_MODE_CLOSED: Literal[0]
_MODE_READ: Literal[1]
_MODE_READ_EOF: Literal[2]
_MODE_WRITE: Literal[3]
_BUFFER_SIZE: Literal[8192]

class BinaryZlibFile(io.BufferedIOBase):
    wbits: ClassVar[int]
    compresslevel: int
    def __init__(
        self,
        filename: str | bytes | BinaryIO,
        mode: Literal["rb", "wb"] = ...,
        compresslevel: int = ...,
    ) -> None: ...
    def close(self) -> None: ...
    @property
    def closed(self) -> bool: ...
    def fileno(self) -> int: ...
    def seekable(self) -> bool: ...
    def readable(self) -> bool: ...
    def writable(self) -> bool: ...
    def read(self, size: int = ...) -> bytes | None: ...  # type: ignore[override]
    def readinto(self, b: WriteableBuffer) -> int: ...
    def write(self, data: ReadableBuffer) -> int: ...
    def seek(self, offset: int, whence: int = ...) -> int: ...
    def tell(self) -> int: ...

class ZlibCompressorWrapper(CompressorWrapper[BinaryZlibFile]):
    def __init__(self) -> None: ...

class BinaryGzipFile(BinaryZlibFile): ...

class GzipCompressorWrapper(CompressorWrapper[BinaryGzipFile]):
    def __init__(self) -> None: ...
