"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ControlPolicy = exports.ControlPolicyProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const resourcemanager_generated_1 = require("./resourcemanager.generated");
Object.defineProperty(exports, "ControlPolicyProperty", { enumerable: true, get: function () { return resourcemanager_generated_1.RosControlPolicy; } });
/**
 * A ROS resource type:  `ALIYUN::ResourceManager::ControlPolicy`
 */
class ControlPolicy extends ros.Resource {
    /**
     * Create a new `ALIYUN::ResourceManager::ControlPolicy`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosControlPolicy = new resourcemanager_generated_1.RosControlPolicy(this, id, {
            description: props.description,
            policyDocument: props.policyDocument,
            controlPolicyName: props.controlPolicyName,
            effectScope: props.effectScope,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosControlPolicy;
        this.attrAttachmentCount = rosControlPolicy.attrAttachmentCount;
        this.attrControlPolicyName = rosControlPolicy.attrControlPolicyName;
        this.attrDescription = rosControlPolicy.attrDescription;
        this.attrEffectScope = rosControlPolicy.attrEffectScope;
        this.attrPolicyDocument = rosControlPolicy.attrPolicyDocument;
        this.attrPolicyId = rosControlPolicy.attrPolicyId;
        this.attrPolicyType = rosControlPolicy.attrPolicyType;
    }
}
exports.ControlPolicy = ControlPolicy;
//# sourceMappingURL=data:application/json;base64,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