"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ControlPolicyAttachment = exports.ControlPolicyAttachmentProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const resourcemanager_generated_1 = require("./resourcemanager.generated");
Object.defineProperty(exports, "ControlPolicyAttachmentProperty", { enumerable: true, get: function () { return resourcemanager_generated_1.RosControlPolicyAttachment; } });
/**
 * A ROS resource type:  `ALIYUN::ResourceManager::ControlPolicyAttachment`
 */
class ControlPolicyAttachment extends ros.Resource {
    /**
     * Create a new `ALIYUN::ResourceManager::ControlPolicyAttachment`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosControlPolicyAttachment = new resourcemanager_generated_1.RosControlPolicyAttachment(this, id, {
            targetId: props.targetId,
            policyId: props.policyId,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosControlPolicyAttachment;
        this.attrAttachDate = rosControlPolicyAttachment.attrAttachDate;
        this.attrDescription = rosControlPolicyAttachment.attrDescription;
        this.attrPolicyId = rosControlPolicyAttachment.attrPolicyId;
        this.attrPolicyName = rosControlPolicyAttachment.attrPolicyName;
        this.attrPolicyType = rosControlPolicyAttachment.attrPolicyType;
        this.attrTargetId = rosControlPolicyAttachment.attrTargetId;
    }
}
exports.ControlPolicyAttachment = ControlPolicyAttachment;
//# sourceMappingURL=data:application/json;base64,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