
def calc_spread(prices, spread_coefficients):
    """Calculate the spread based on spread_coefficients.

    Args:
        spread_coefficients (list): A list of signed integers defining
            how much of each product to buy (positive) or sell (negative)
            when buying or selling the spread.
        prices (numpy.array): Array containing the prices (bid, ask) of different products, i.e: [p1_b, p1_a, p2_b, p2_a].

    Returns:
        tuple: bid and ask spread prices.
    """
    spread_bid = sum([
        spread_coefficients[i] *
        prices[2 * i + int(spread_coefficients[i] < 0)]
        for i in range(len(spread_coefficients))]
    )
    spread_ask = sum([
        spread_coefficients[i] *
        prices[2 * i + int(spread_coefficients[i] > 0)]
        for i in range(len(spread_coefficients))]
    )
    return spread_bid, spread_ask
