# coding=utf-8
#####################################################
# THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT #
#####################################################
# noqa: E128,E201
from ..client import BaseClient
from ..client import createApiClient
from ..client import config
from ..client import createTemporaryCredentials
from ..client import createSession
_defaultConfig = config


class AwsProvisioner(BaseClient):
    """
    The AWS Provisioner is responsible for provisioning instances on EC2 for use in
    Taskcluster.  The provisioner maintains a set of worker configurations which
    can be managed with an API that is typically available at
    aws-provisioner.taskcluster.net/v1.  This API can also perform basic instance
    management tasks in addition to maintaining the internal state of worker type
    configuration information.

    The Provisioner runs at a configurable interval.  Each iteration of the
    provisioner fetches a current copy the state that the AWS EC2 api reports.  In
    each iteration, we ask the Queue how many tasks are pending for that worker
    type.  Based on the number of tasks pending and the scaling ratio, we may
    submit requests for new instances.  We use pricing information, capacity and
    utility factor information to decide which instance type in which region would
    be the optimal configuration.

    Each EC2 instance type will declare a capacity and utility factor.  Capacity is
    the number of tasks that a given machine is capable of running concurrently.
    Utility factor is a relative measure of performance between two instance types.
    We multiply the utility factor by the spot price to compare instance types and
    regions when making the bidding choices.

    When a new EC2 instance is instantiated, its user data contains a token in
    `securityToken` that can be used with the `getSecret` method to retrieve
    the worker's credentials and any needed passwords or other restricted
    information.  The worker is responsible for deleting the secret after
    retrieving it, to prevent dissemination of the secret to other proceses
    which can read the instance user data.

    """

    classOptions = {
    }
    serviceName = 'aws-provisioner'
    apiVersion = 'v1'

    def listWorkerTypeSummaries(self, *args, **kwargs):
        """
        List worker types with details

        Return a list of worker types, including some summary information about
        current capacity for each.  While this list includes all defined worker types,
        there may be running EC2 instances for deleted worker types that are not
        included here.  The list is unordered.

        This method is ``stable``
        """

        return self._makeApiCall(self.funcinfo["listWorkerTypeSummaries"], *args, **kwargs)

    def createWorkerType(self, *args, **kwargs):
        """
        Create new Worker Type

        Create a worker type.  A worker type contains all the configuration
        needed for the provisioner to manage the instances.  Each worker type
        knows which regions and which instance types are allowed for that
        worker type.  Remember that Capacity is the number of concurrent tasks
        that can be run on a given EC2 resource and that Utility is the relative
        performance rate between different instance types.  There is no way to
        configure different regions to have different sets of instance types
        so ensure that all instance types are available in all regions.
        This function is idempotent.

        Once a worker type is in the provisioner, a back ground process will
        begin creating instances for it based on its capacity bounds and its
        pending task count from the Queue.  It is the worker's responsibility
        to shut itself down.  The provisioner has a limit (currently 96hours)
        for all instances to prevent zombie instances from running indefinitely.

        The provisioner will ensure that all instances created are tagged with
        aws resource tags containing the provisioner id and the worker type.

        If provided, the secrets in the global, region and instance type sections
        are available using the secrets api.  If specified, the scopes provided
        will be used to generate a set of temporary credentials available with
        the other secrets.

        This method is ``stable``
        """

        return self._makeApiCall(self.funcinfo["createWorkerType"], *args, **kwargs)

    def updateWorkerType(self, *args, **kwargs):
        """
        Update Worker Type

        Provide a new copy of a worker type to replace the existing one.
        This will overwrite the existing worker type definition if there
        is already a worker type of that name.  This method will return a
        200 response along with a copy of the worker type definition created
        Note that if you are using the result of a GET on the worker-type
        end point that you will need to delete the lastModified and workerType
        keys from the object returned, since those fields are not allowed
        the request body for this method

        Otherwise, all input requirements and actions are the same as the
        create method.

        This method is ``stable``
        """

        return self._makeApiCall(self.funcinfo["updateWorkerType"], *args, **kwargs)

    def workerTypeLastModified(self, *args, **kwargs):
        """
        Get Worker Type Last Modified Time

        This method is provided to allow workers to see when they were
        last modified.  The value provided through UserData can be
        compared against this value to see if changes have been made
        If the worker type definition has not been changed, the date
        should be identical as it is the same stored value.

        This method is ``stable``
        """

        return self._makeApiCall(self.funcinfo["workerTypeLastModified"], *args, **kwargs)

    def workerType(self, *args, **kwargs):
        """
        Get Worker Type

        Retrieve a copy of the requested worker type definition.
        This copy contains a lastModified field as well as the worker
        type name.  As such, it will require manipulation to be able to
        use the results of this method to submit date to the update
        method.

        This method is ``stable``
        """

        return self._makeApiCall(self.funcinfo["workerType"], *args, **kwargs)

    def removeWorkerType(self, *args, **kwargs):
        """
        Delete Worker Type

        Delete a worker type definition.  This method will only delete
        the worker type definition from the storage table.  The actual
        deletion will be handled by a background worker.  As soon as this
        method is called for a worker type, the background worker will
        immediately submit requests to cancel all spot requests for this
        worker type as well as killing all instances regardless of their
        state.  If you want to gracefully remove a worker type, you must
        either ensure that no tasks are created with that worker type name
        or you could theoretically set maxCapacity to 0, though, this is
        not a supported or tested action

        This method is ``stable``
        """

        return self._makeApiCall(self.funcinfo["removeWorkerType"], *args, **kwargs)

    def listWorkerTypes(self, *args, **kwargs):
        """
        List Worker Types

        Return a list of string worker type names.  These are the names
        of all managed worker types known to the provisioner.  This does
        not include worker types which are left overs from a deleted worker
        type definition but are still running in AWS.

        This method is ``stable``
        """

        return self._makeApiCall(self.funcinfo["listWorkerTypes"], *args, **kwargs)

    def createSecret(self, *args, **kwargs):
        """
        Create new Secret

        Insert a secret into the secret storage.  The supplied secrets will
        be provided verbatime via `getSecret`, while the supplied scopes will
        be converted into credentials by `getSecret`.

        This method is not ordinarily used in production; instead, the provisioner
        creates a new secret directly for each spot bid.

        This method is ``stable``
        """

        return self._makeApiCall(self.funcinfo["createSecret"], *args, **kwargs)

    def getSecret(self, *args, **kwargs):
        """
        Get a Secret

        Retrieve a secret from storage.  The result contains any passwords or
        other restricted information verbatim as well as a temporary credential
        based on the scopes specified when the secret was created.

        It is important that this secret is deleted by the consumer (`removeSecret`),
        or else the secrets will be visible to any process which can access the
        user data associated with the instance.

        This method is ``stable``
        """

        return self._makeApiCall(self.funcinfo["getSecret"], *args, **kwargs)

    def instanceStarted(self, *args, **kwargs):
        """
        Report an instance starting

        An instance will report in by giving its instance id as well
        as its security token.  The token is given and checked to ensure
        that it matches a real token that exists to ensure that random
        machines do not check in.  We could generate a different token
        but that seems like overkill

        This method is ``stable``
        """

        return self._makeApiCall(self.funcinfo["instanceStarted"], *args, **kwargs)

    def removeSecret(self, *args, **kwargs):
        """
        Remove a Secret

        Remove a secret.  After this call, a call to `getSecret` with the given
        token will return no information.

        It is very important that the consumer of a
        secret delete the secret from storage before handing over control
        to untrusted processes to prevent credential and/or secret leakage.

        This method is ``stable``
        """

        return self._makeApiCall(self.funcinfo["removeSecret"], *args, **kwargs)

    def getLaunchSpecs(self, *args, **kwargs):
        """
        Get All Launch Specifications for WorkerType

        This method returns a preview of all possible launch specifications
        that this worker type definition could submit to EC2.  It is used to
        test worker types, nothing more

        **This API end-point is experimental and may be subject to change without warning.**

        This method is ``experimental``
        """

        return self._makeApiCall(self.funcinfo["getLaunchSpecs"], *args, **kwargs)

    def state(self, *args, **kwargs):
        """
        Get AWS State for a worker type

        Return the state of a given workertype as stored by the provisioner.
        This state is stored as three lists: 1 for running instances, 1 for
        pending requests.  The `summary` property contains an updated summary
        similar to that returned from `listWorkerTypeSummaries`.

        This method is ``stable``
        """

        return self._makeApiCall(self.funcinfo["state"], *args, **kwargs)

    def backendStatus(self, *args, **kwargs):
        """
        Backend Status

        This endpoint is used to show when the last time the provisioner
        has checked in.  A check in is done through the deadman's snitch
        api.  It is done at the conclusion of a provisioning iteration
        and used to tell if the background provisioning process is still
        running.

        **Warning** this api end-point is **not stable**.

        This method is ``experimental``
        """

        return self._makeApiCall(self.funcinfo["backendStatus"], *args, **kwargs)

    def ping(self, *args, **kwargs):
        """
        Ping Server

        Respond without doing anything.
        This endpoint is used to check that the service is up.

        This method is ``stable``
        """

        return self._makeApiCall(self.funcinfo["ping"], *args, **kwargs)

    funcinfo = {
        "backendStatus": {
            'args': [],
            'method': 'get',
            'name': 'backendStatus',
            'output': 'v1/backend-status-response.json#',
            'route': '/backend-status',
            'stability': 'experimental',
        },
        "createSecret": {
            'args': ['token'],
            'input': 'v1/create-secret-request.json#',
            'method': 'put',
            'name': 'createSecret',
            'route': '/secret/<token>',
            'stability': 'stable',
        },
        "createWorkerType": {
            'args': ['workerType'],
            'input': 'v1/create-worker-type-request.json#',
            'method': 'put',
            'name': 'createWorkerType',
            'output': 'v1/get-worker-type-response.json#',
            'route': '/worker-type/<workerType>',
            'stability': 'stable',
        },
        "getLaunchSpecs": {
            'args': ['workerType'],
            'method': 'get',
            'name': 'getLaunchSpecs',
            'output': 'v1/get-launch-specs-response.json#',
            'route': '/worker-type/<workerType>/launch-specifications',
            'stability': 'experimental',
        },
        "getSecret": {
            'args': ['token'],
            'method': 'get',
            'name': 'getSecret',
            'output': 'v1/get-secret-response.json#',
            'route': '/secret/<token>',
            'stability': 'stable',
        },
        "instanceStarted": {
            'args': ['instanceId', 'token'],
            'method': 'get',
            'name': 'instanceStarted',
            'route': '/instance-started/<instanceId>/<token>',
            'stability': 'stable',
        },
        "listWorkerTypeSummaries": {
            'args': [],
            'method': 'get',
            'name': 'listWorkerTypeSummaries',
            'output': 'v1/list-worker-types-summaries-response.json#',
            'route': '/list-worker-type-summaries',
            'stability': 'stable',
        },
        "listWorkerTypes": {
            'args': [],
            'method': 'get',
            'name': 'listWorkerTypes',
            'output': 'v1/list-worker-types-response.json#',
            'route': '/list-worker-types',
            'stability': 'stable',
        },
        "ping": {
            'args': [],
            'method': 'get',
            'name': 'ping',
            'route': '/ping',
            'stability': 'stable',
        },
        "removeSecret": {
            'args': ['token'],
            'method': 'delete',
            'name': 'removeSecret',
            'route': '/secret/<token>',
            'stability': 'stable',
        },
        "removeWorkerType": {
            'args': ['workerType'],
            'method': 'delete',
            'name': 'removeWorkerType',
            'route': '/worker-type/<workerType>',
            'stability': 'stable',
        },
        "state": {
            'args': ['workerType'],
            'method': 'get',
            'name': 'state',
            'route': '/state/<workerType>',
            'stability': 'stable',
        },
        "updateWorkerType": {
            'args': ['workerType'],
            'input': 'v1/create-worker-type-request.json#',
            'method': 'post',
            'name': 'updateWorkerType',
            'output': 'v1/get-worker-type-response.json#',
            'route': '/worker-type/<workerType>/update',
            'stability': 'stable',
        },
        "workerType": {
            'args': ['workerType'],
            'method': 'get',
            'name': 'workerType',
            'output': 'v1/get-worker-type-response.json#',
            'route': '/worker-type/<workerType>',
            'stability': 'stable',
        },
        "workerTypeLastModified": {
            'args': ['workerType'],
            'method': 'get',
            'name': 'workerTypeLastModified',
            'output': 'v1/get-worker-type-last-modified.json#',
            'route': '/worker-type-last-modified/<workerType>',
            'stability': 'stable',
        },
    }


__all__ = ['createTemporaryCredentials', 'config', '_defaultConfig', 'createApiClient', 'createSession', 'AwsProvisioner']
