# -*- coding: utf-8 -*-
import datetime
from south.db import db
from south.v2 import SchemaMigration
from django.db import models, connection


class Migration(SchemaMigration):

    def forwards(self, orm):
        table_names = connection.introspection.table_names()
        if 'cmsplugin_video' in table_names:
            db.rename_table('cmsplugin_video', 'djangocms_video_video')
        elif 'video_video' in table_names:
            db.rename_table('video_video', 'djangocms_video_video')
        else:
            # Adding model 'Video'
            db.create_table(u'djangocms_video_video', (
                (u'cmsplugin_ptr', self.gf('django.db.models.fields.related.OneToOneField')(to=orm['cms.CMSPlugin'], unique=True, primary_key=True)),
                ('movie', self.gf('django.db.models.fields.files.FileField')(max_length=100, null=True, blank=True)),
                ('movie_url', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
                ('image', self.gf('django.db.models.fields.files.ImageField')(max_length=100, null=True, blank=True)),
                ('width', self.gf('django.db.models.fields.PositiveSmallIntegerField')()),
                ('height', self.gf('django.db.models.fields.PositiveSmallIntegerField')()),
                ('auto_play', self.gf('django.db.models.fields.BooleanField')(default=False)),
                ('auto_hide', self.gf('django.db.models.fields.BooleanField')(default=False)),
                ('fullscreen', self.gf('django.db.models.fields.BooleanField')(default=True)),
                ('loop', self.gf('django.db.models.fields.BooleanField')(default=False)),
                ('bgcolor', self.gf('django.db.models.fields.CharField')(default='000000', max_length=6)),
                ('textcolor', self.gf('django.db.models.fields.CharField')(default='FFFFFF', max_length=6)),
                ('seekbarcolor', self.gf('django.db.models.fields.CharField')(default='13ABEC', max_length=6)),
                ('seekbarbgcolor', self.gf('django.db.models.fields.CharField')(default='333333', max_length=6)),
                ('loadingbarcolor', self.gf('django.db.models.fields.CharField')(default='828282', max_length=6)),
                ('buttonoutcolor', self.gf('django.db.models.fields.CharField')(default='333333', max_length=6)),
                ('buttonovercolor', self.gf('django.db.models.fields.CharField')(default='000000', max_length=6)),
                ('buttonhighlightcolor', self.gf('django.db.models.fields.CharField')(default='FFFFFF', max_length=6)),
            ))
            db.send_create_signal(u'djangocms_video', ['Video'])

    def backwards(self, orm):
        # Deleting model 'Video'
        db.delete_table(u'djangocms_video_video')


    models = {
        'cms.cmsplugin': {
            'Meta': {'object_name': 'CMSPlugin'},
            'changed_date': ('django.db.models.fields.DateTimeField', [], {'auto_now': 'True', 'blank': 'True'}),
            'creation_date': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now'}),
            u'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'language': ('django.db.models.fields.CharField', [], {'max_length': '15', 'db_index': 'True'}),
            'level': ('django.db.models.fields.PositiveIntegerField', [], {'db_index': 'True'}),
            'lft': ('django.db.models.fields.PositiveIntegerField', [], {'db_index': 'True'}),
            'parent': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['cms.CMSPlugin']", 'null': 'True', 'blank': 'True'}),
            'placeholder': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['cms.Placeholder']", 'null': 'True'}),
            'plugin_type': ('django.db.models.fields.CharField', [], {'max_length': '50', 'db_index': 'True'}),
            'position': ('django.db.models.fields.PositiveSmallIntegerField', [], {'null': 'True', 'blank': 'True'}),
            'rght': ('django.db.models.fields.PositiveIntegerField', [], {'db_index': 'True'}),
            'tree_id': ('django.db.models.fields.PositiveIntegerField', [], {'db_index': 'True'})
        },
        'cms.placeholder': {
            'Meta': {'object_name': 'Placeholder'},
            'default_width': ('django.db.models.fields.PositiveSmallIntegerField', [], {'null': 'True'}),
            u'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'slot': ('django.db.models.fields.CharField', [], {'max_length': '50', 'db_index': 'True'})
        },
        u'djangocms_video.video': {
            'Meta': {'object_name': 'Video', '_ormbases': ['cms.CMSPlugin']},
            'auto_hide': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'auto_play': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'bgcolor': ('django.db.models.fields.CharField', [], {'default': "'000000'", 'max_length': '6'}),
            'buttonhighlightcolor': ('django.db.models.fields.CharField', [], {'default': "'FFFFFF'", 'max_length': '6'}),
            'buttonoutcolor': ('django.db.models.fields.CharField', [], {'default': "'333333'", 'max_length': '6'}),
            'buttonovercolor': ('django.db.models.fields.CharField', [], {'default': "'000000'", 'max_length': '6'}),
            u'cmsplugin_ptr': ('django.db.models.fields.related.OneToOneField', [], {'to': "orm['cms.CMSPlugin']", 'unique': 'True', 'primary_key': 'True'}),
            'fullscreen': ('django.db.models.fields.BooleanField', [], {'default': 'True'}),
            'height': ('django.db.models.fields.PositiveSmallIntegerField', [], {}),
            'image': ('django.db.models.fields.files.ImageField', [], {'max_length': '100', 'null': 'True', 'blank': 'True'}),
            'loadingbarcolor': ('django.db.models.fields.CharField', [], {'default': "'828282'", 'max_length': '6'}),
            'loop': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'movie': ('django.db.models.fields.files.FileField', [], {'max_length': '100', 'null': 'True', 'blank': 'True'}),
            'movie_url': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'seekbarbgcolor': ('django.db.models.fields.CharField', [], {'default': "'333333'", 'max_length': '6'}),
            'seekbarcolor': ('django.db.models.fields.CharField', [], {'default': "'13ABEC'", 'max_length': '6'}),
            'textcolor': ('django.db.models.fields.CharField', [], {'default': "'FFFFFF'", 'max_length': '6'}),
            'width': ('django.db.models.fields.PositiveSmallIntegerField', [], {})
        }
    }

    complete_apps = ['djangocms_video']