# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SensorAlertsProfilesArgs', 'SensorAlertsProfiles']

@pulumi.input_type
class SensorAlertsProfilesArgs:
    def __init__(__self__, *,
                 network_id: pulumi.Input[builtins.str],
                 conditions: Optional[pulumi.Input[Sequence[pulumi.Input['SensorAlertsProfilesConditionArgs']]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 recipients: Optional[pulumi.Input['SensorAlertsProfilesRecipientsArgs']] = None,
                 schedule: Optional[pulumi.Input['SensorAlertsProfilesScheduleArgs']] = None,
                 serials: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a SensorAlertsProfiles resource.
        :param pulumi.Input[builtins.str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[Sequence[pulumi.Input['SensorAlertsProfilesConditionArgs']]] conditions: List of conditions that will cause the profile to send an alert.
        :param pulumi.Input[builtins.str] name: Name of the sensor alert profile.
        :param pulumi.Input['SensorAlertsProfilesRecipientsArgs'] recipients: List of recipients that will receive the alert.
        :param pulumi.Input['SensorAlertsProfilesScheduleArgs'] schedule: The sensor schedule to use with the alert profile.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] serials: List of device serials assigned to this sensor alert profile.
        """
        pulumi.set(__self__, "network_id", network_id)
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if recipients is not None:
            pulumi.set(__self__, "recipients", recipients)
        if schedule is not None:
            pulumi.set(__self__, "schedule", schedule)
        if serials is not None:
            pulumi.set(__self__, "serials", serials)

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Input[builtins.str]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "network_id", value)

    @property
    @pulumi.getter
    def conditions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SensorAlertsProfilesConditionArgs']]]]:
        """
        List of conditions that will cause the profile to send an alert.
        """
        return pulumi.get(self, "conditions")

    @conditions.setter
    def conditions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SensorAlertsProfilesConditionArgs']]]]):
        pulumi.set(self, "conditions", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the sensor alert profile.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def recipients(self) -> Optional[pulumi.Input['SensorAlertsProfilesRecipientsArgs']]:
        """
        List of recipients that will receive the alert.
        """
        return pulumi.get(self, "recipients")

    @recipients.setter
    def recipients(self, value: Optional[pulumi.Input['SensorAlertsProfilesRecipientsArgs']]):
        pulumi.set(self, "recipients", value)

    @property
    @pulumi.getter
    def schedule(self) -> Optional[pulumi.Input['SensorAlertsProfilesScheduleArgs']]:
        """
        The sensor schedule to use with the alert profile.
        """
        return pulumi.get(self, "schedule")

    @schedule.setter
    def schedule(self, value: Optional[pulumi.Input['SensorAlertsProfilesScheduleArgs']]):
        pulumi.set(self, "schedule", value)

    @property
    @pulumi.getter
    def serials(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of device serials assigned to this sensor alert profile.
        """
        return pulumi.get(self, "serials")

    @serials.setter
    def serials(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "serials", value)


@pulumi.input_type
class _SensorAlertsProfilesState:
    def __init__(__self__, *,
                 conditions: Optional[pulumi.Input[Sequence[pulumi.Input['SensorAlertsProfilesConditionArgs']]]] = None,
                 conditions_responses: Optional[pulumi.Input[Sequence[pulumi.Input['SensorAlertsProfilesConditionsResponseArgs']]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network_id: Optional[pulumi.Input[builtins.str]] = None,
                 profile_id: Optional[pulumi.Input[builtins.str]] = None,
                 recipients: Optional[pulumi.Input['SensorAlertsProfilesRecipientsArgs']] = None,
                 schedule: Optional[pulumi.Input['SensorAlertsProfilesScheduleArgs']] = None,
                 serials: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering SensorAlertsProfiles resources.
        :param pulumi.Input[Sequence[pulumi.Input['SensorAlertsProfilesConditionArgs']]] conditions: List of conditions that will cause the profile to send an alert.
        :param pulumi.Input[Sequence[pulumi.Input['SensorAlertsProfilesConditionsResponseArgs']]] conditions_responses: List of conditions that will cause the profile to send an alert.
        :param pulumi.Input[builtins.str] name: Name of the sensor alert profile.
        :param pulumi.Input[builtins.str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[builtins.str] profile_id: ID of the sensor alert profile.
        :param pulumi.Input['SensorAlertsProfilesRecipientsArgs'] recipients: List of recipients that will receive the alert.
        :param pulumi.Input['SensorAlertsProfilesScheduleArgs'] schedule: The sensor schedule to use with the alert profile.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] serials: List of device serials assigned to this sensor alert profile.
        """
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if conditions_responses is not None:
            pulumi.set(__self__, "conditions_responses", conditions_responses)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_id is not None:
            pulumi.set(__self__, "network_id", network_id)
        if profile_id is not None:
            pulumi.set(__self__, "profile_id", profile_id)
        if recipients is not None:
            pulumi.set(__self__, "recipients", recipients)
        if schedule is not None:
            pulumi.set(__self__, "schedule", schedule)
        if serials is not None:
            pulumi.set(__self__, "serials", serials)

    @property
    @pulumi.getter
    def conditions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SensorAlertsProfilesConditionArgs']]]]:
        """
        List of conditions that will cause the profile to send an alert.
        """
        return pulumi.get(self, "conditions")

    @conditions.setter
    def conditions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SensorAlertsProfilesConditionArgs']]]]):
        pulumi.set(self, "conditions", value)

    @property
    @pulumi.getter(name="conditionsResponses")
    def conditions_responses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SensorAlertsProfilesConditionsResponseArgs']]]]:
        """
        List of conditions that will cause the profile to send an alert.
        """
        return pulumi.get(self, "conditions_responses")

    @conditions_responses.setter
    def conditions_responses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SensorAlertsProfilesConditionsResponseArgs']]]]):
        pulumi.set(self, "conditions_responses", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the sensor alert profile.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "network_id", value)

    @property
    @pulumi.getter(name="profileId")
    def profile_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ID of the sensor alert profile.
        """
        return pulumi.get(self, "profile_id")

    @profile_id.setter
    def profile_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "profile_id", value)

    @property
    @pulumi.getter
    def recipients(self) -> Optional[pulumi.Input['SensorAlertsProfilesRecipientsArgs']]:
        """
        List of recipients that will receive the alert.
        """
        return pulumi.get(self, "recipients")

    @recipients.setter
    def recipients(self, value: Optional[pulumi.Input['SensorAlertsProfilesRecipientsArgs']]):
        pulumi.set(self, "recipients", value)

    @property
    @pulumi.getter
    def schedule(self) -> Optional[pulumi.Input['SensorAlertsProfilesScheduleArgs']]:
        """
        The sensor schedule to use with the alert profile.
        """
        return pulumi.get(self, "schedule")

    @schedule.setter
    def schedule(self, value: Optional[pulumi.Input['SensorAlertsProfilesScheduleArgs']]):
        pulumi.set(self, "schedule", value)

    @property
    @pulumi.getter
    def serials(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of device serials assigned to this sensor alert profile.
        """
        return pulumi.get(self, "serials")

    @serials.setter
    def serials(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "serials", value)


@pulumi.type_token("meraki:networks/sensorAlertsProfiles:SensorAlertsProfiles")
class SensorAlertsProfiles(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 conditions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SensorAlertsProfilesConditionArgs', 'SensorAlertsProfilesConditionArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network_id: Optional[pulumi.Input[builtins.str]] = None,
                 recipients: Optional[pulumi.Input[Union['SensorAlertsProfilesRecipientsArgs', 'SensorAlertsProfilesRecipientsArgsDict']]] = None,
                 schedule: Optional[pulumi.Input[Union['SensorAlertsProfilesScheduleArgs', 'SensorAlertsProfilesScheduleArgsDict']]] = None,
                 serials: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        """
        ## Example Usage

        ## Import

        ```sh
        $ pulumi import meraki:networks/sensorAlertsProfiles:SensorAlertsProfiles example "id,network_id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SensorAlertsProfilesConditionArgs', 'SensorAlertsProfilesConditionArgsDict']]]] conditions: List of conditions that will cause the profile to send an alert.
        :param pulumi.Input[builtins.str] name: Name of the sensor alert profile.
        :param pulumi.Input[builtins.str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[Union['SensorAlertsProfilesRecipientsArgs', 'SensorAlertsProfilesRecipientsArgsDict']] recipients: List of recipients that will receive the alert.
        :param pulumi.Input[Union['SensorAlertsProfilesScheduleArgs', 'SensorAlertsProfilesScheduleArgsDict']] schedule: The sensor schedule to use with the alert profile.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] serials: List of device serials assigned to this sensor alert profile.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SensorAlertsProfilesArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ## Import

        ```sh
        $ pulumi import meraki:networks/sensorAlertsProfiles:SensorAlertsProfiles example "id,network_id"
        ```

        :param str resource_name: The name of the resource.
        :param SensorAlertsProfilesArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SensorAlertsProfilesArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 conditions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SensorAlertsProfilesConditionArgs', 'SensorAlertsProfilesConditionArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network_id: Optional[pulumi.Input[builtins.str]] = None,
                 recipients: Optional[pulumi.Input[Union['SensorAlertsProfilesRecipientsArgs', 'SensorAlertsProfilesRecipientsArgsDict']]] = None,
                 schedule: Optional[pulumi.Input[Union['SensorAlertsProfilesScheduleArgs', 'SensorAlertsProfilesScheduleArgsDict']]] = None,
                 serials: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SensorAlertsProfilesArgs.__new__(SensorAlertsProfilesArgs)

            __props__.__dict__["conditions"] = conditions
            __props__.__dict__["name"] = name
            if network_id is None and not opts.urn:
                raise TypeError("Missing required property 'network_id'")
            __props__.__dict__["network_id"] = network_id
            __props__.__dict__["recipients"] = recipients
            __props__.__dict__["schedule"] = schedule
            __props__.__dict__["serials"] = serials
            __props__.__dict__["conditions_responses"] = None
            __props__.__dict__["profile_id"] = None
        super(SensorAlertsProfiles, __self__).__init__(
            'meraki:networks/sensorAlertsProfiles:SensorAlertsProfiles',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            conditions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SensorAlertsProfilesConditionArgs', 'SensorAlertsProfilesConditionArgsDict']]]]] = None,
            conditions_responses: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SensorAlertsProfilesConditionsResponseArgs', 'SensorAlertsProfilesConditionsResponseArgsDict']]]]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            network_id: Optional[pulumi.Input[builtins.str]] = None,
            profile_id: Optional[pulumi.Input[builtins.str]] = None,
            recipients: Optional[pulumi.Input[Union['SensorAlertsProfilesRecipientsArgs', 'SensorAlertsProfilesRecipientsArgsDict']]] = None,
            schedule: Optional[pulumi.Input[Union['SensorAlertsProfilesScheduleArgs', 'SensorAlertsProfilesScheduleArgsDict']]] = None,
            serials: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None) -> 'SensorAlertsProfiles':
        """
        Get an existing SensorAlertsProfiles resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SensorAlertsProfilesConditionArgs', 'SensorAlertsProfilesConditionArgsDict']]]] conditions: List of conditions that will cause the profile to send an alert.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SensorAlertsProfilesConditionsResponseArgs', 'SensorAlertsProfilesConditionsResponseArgsDict']]]] conditions_responses: List of conditions that will cause the profile to send an alert.
        :param pulumi.Input[builtins.str] name: Name of the sensor alert profile.
        :param pulumi.Input[builtins.str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[builtins.str] profile_id: ID of the sensor alert profile.
        :param pulumi.Input[Union['SensorAlertsProfilesRecipientsArgs', 'SensorAlertsProfilesRecipientsArgsDict']] recipients: List of recipients that will receive the alert.
        :param pulumi.Input[Union['SensorAlertsProfilesScheduleArgs', 'SensorAlertsProfilesScheduleArgsDict']] schedule: The sensor schedule to use with the alert profile.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] serials: List of device serials assigned to this sensor alert profile.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SensorAlertsProfilesState.__new__(_SensorAlertsProfilesState)

        __props__.__dict__["conditions"] = conditions
        __props__.__dict__["conditions_responses"] = conditions_responses
        __props__.__dict__["name"] = name
        __props__.__dict__["network_id"] = network_id
        __props__.__dict__["profile_id"] = profile_id
        __props__.__dict__["recipients"] = recipients
        __props__.__dict__["schedule"] = schedule
        __props__.__dict__["serials"] = serials
        return SensorAlertsProfiles(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def conditions(self) -> pulumi.Output[Optional[Sequence['outputs.SensorAlertsProfilesCondition']]]:
        """
        List of conditions that will cause the profile to send an alert.
        """
        return pulumi.get(self, "conditions")

    @property
    @pulumi.getter(name="conditionsResponses")
    def conditions_responses(self) -> pulumi.Output[Sequence['outputs.SensorAlertsProfilesConditionsResponse']]:
        """
        List of conditions that will cause the profile to send an alert.
        """
        return pulumi.get(self, "conditions_responses")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Name of the sensor alert profile.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Output[builtins.str]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @property
    @pulumi.getter(name="profileId")
    def profile_id(self) -> pulumi.Output[builtins.str]:
        """
        ID of the sensor alert profile.
        """
        return pulumi.get(self, "profile_id")

    @property
    @pulumi.getter
    def recipients(self) -> pulumi.Output['outputs.SensorAlertsProfilesRecipients']:
        """
        List of recipients that will receive the alert.
        """
        return pulumi.get(self, "recipients")

    @property
    @pulumi.getter
    def schedule(self) -> pulumi.Output['outputs.SensorAlertsProfilesSchedule']:
        """
        The sensor schedule to use with the alert profile.
        """
        return pulumi.get(self, "schedule")

    @property
    @pulumi.getter
    def serials(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        List of device serials assigned to this sensor alert profile.
        """
        return pulumi.get(self, "serials")

