# coding: utf-8

"""
Earnix DataService API

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

The version of the OpenAPI document: 0.0.1
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from datetime import datetime
from typing import Any, ClassVar, Dict, List, Optional, Set

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing_extensions import Annotated, Self


class ProblemDetail(BaseModel):
    """
    Definition of [RFC7807](https://tools.ietf.org/html/rfc7807) problem detail
    """  # noqa: E501

    type: Optional[StrictStr] = Field(
        default=None, description="A URI reference that identifies the problem type."
    )
    title: StrictStr = Field(
        description="A short, human-readable summary of the problem type."
    )
    status: Annotated[int, Field(le=599, strict=True, ge=100)] = Field(
        description="The HTTP status code generated by the origin server for this occurrence of the problem."
    )
    detail: StrictStr = Field(
        description="A human-readable explanation specific to this occurrence of the problem."
    )
    instance: Optional[StrictStr] = Field(
        default=None,
        description="A URI reference that identifies the specific occurrence of the problem. It may or may not yield further information if dereferenced.",
    )
    code: StrictStr = Field(description="Unique error code")
    timestamp: datetime = Field(description="The time the problem was generated")
    extra_details: Optional[Dict[str, Any]] = Field(default=None, alias="extraDetails")
    trace_id: Optional[StrictStr] = Field(
        default=None,
        description="Unique identifier of the request that caused the problem",
        alias="traceId",
    )
    __properties: ClassVar[List[str]] = [
        "type",
        "title",
        "status",
        "detail",
        "instance",
        "code",
        "timestamp",
        "extraDetails",
        "traceId",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ProblemDetail from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ProblemDetail from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "type": obj.get("type"),
                "title": obj.get("title"),
                "status": obj.get("status"),
                "detail": obj.get("detail"),
                "instance": obj.get("instance"),
                "code": obj.get("code"),
                "timestamp": obj.get("timestamp"),
                "extraDetails": obj.get("extraDetails"),
                "traceId": obj.get("traceId"),
            }
        )
        return _obj
