"use strict";
const lib_1 = require("../lib");
module.exports = {
    'plainText'(test) {
        // GIVEN
        const stack = new lib_1.Stack();
        // WHEN
        const v = lib_1.SecretValue.plainText('this just resolves to a string');
        // THEN
        test.deepEqual(stack.resolve(v), 'this just resolves to a string');
        test.done();
    },
    'secretsManager'(test) {
        // GIVEN
        const stack = new lib_1.Stack();
        // WHEN
        const v = lib_1.SecretValue.secretsManager('secret-id', {
            jsonField: 'json-key',
            versionId: 'version-id',
            versionStage: 'version-stage'
        });
        // THEN
        test.deepEqual(stack.resolve(v), '{{resolve:secretsmanager:secret-id:SecretString:json-key:version-stage:version-id}}');
        test.done();
    },
    'secretsManager with defaults'(test) {
        // GIVEN
        const stack = new lib_1.Stack();
        // WHEN
        const v = lib_1.SecretValue.secretsManager('secret-id');
        // THEN
        test.deepEqual(stack.resolve(v), '{{resolve:secretsmanager:secret-id:SecretString:::}}');
        test.done();
    },
    'secretsManager with an empty ID'(test) {
        test.throws(() => lib_1.SecretValue.secretsManager(''), /secretId cannot be empty/);
        test.done();
    },
    'ssmSecure'(test) {
        // GIVEN
        const stack = new lib_1.Stack();
        // WHEN
        const v = lib_1.SecretValue.ssmSecure('param-name', 'param-version');
        // THEN
        test.deepEqual(stack.resolve(v), '{{resolve:ssm-secure:param-name:param-version}}');
        test.done();
    },
    'cfnDynamicReference'(test) {
        // GIVEN
        const stack = new lib_1.Stack();
        // WHEN
        const v = lib_1.SecretValue.cfnDynamicReference(new lib_1.CfnDynamicReference(lib_1.CfnDynamicReferenceService.SSM, 'foo:bar'));
        // THEN
        test.deepEqual(stack.resolve(v), '{{resolve:ssm:foo:bar}}');
        test.done();
    },
    'cfnParameter (with NoEcho)'(test) {
        // GIVEN
        const stack = new lib_1.Stack();
        const p = new lib_1.CfnParameter(stack, 'MyParam', { type: 'String', noEcho: true });
        // WHEN
        const v = lib_1.SecretValue.cfnParameter(p);
        // THEN
        test.deepEqual(stack.resolve(v), { Ref: 'MyParam' });
        test.done();
    },
    'fails if cfnParameter does not have NoEcho'(test) {
        // GIVEN
        const stack = new lib_1.Stack();
        const p = new lib_1.CfnParameter(stack, 'MyParam', { type: 'String' });
        // THEN
        test.throws(() => lib_1.SecretValue.cfnParameter(p), /CloudFormation parameter must be configured with "NoEcho"/);
        test.done();
    }
};
//# sourceMappingURL=data:application/json;base64,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