r"""
Provide physical constants.

## Universal Constants

| Symbol | Units                             | Description                       | Reference          |
| :----- | :-------------------------------- | :-------------------------------- | :----------------- |
| c      | m·s<sup>-1</sup>                  | speed of light in vacuum          | nist2018-constants |
| G      | m3.kg<sup>-1</sup>.s<sup>-2</sup> | Newtonian constant of gravitation | nist2018-constants |
| h      | J.s                               | Planck constant                   | nist2018-constants |
| h_bar  | J.s                               | reduced Planck constant \\(\tfrac{h}{2\pi}\\) | nist2018-constants |


## Physico-chemical Constants

| Symbol | Units                                       | Description                       | Reference          |
| :----- | :------------------------------------------ | :-------------------------------- | :----------------- |
| m_u    | kg                                          | atomic mass constant              | nist2018-constants |
| N_A    | mol<sup>-1</sup>                            | Avogadro's number                 | nist2018-constants |
| k_B    | J.K<sup>-1</sup>                            | Boltzmann constant                | nist2018-constants |
| F      | C·mol<sup>-1</sup>                          | Faraday constant                  | nist2018-constants |
| R      | J.K<sup>-1</sup>.mol<sup>-1</sup>           | molar gas constant                | nist2018-constants |
| σ      | W.m<sup>-2</sup>.K<sup><sup>-4</sup></sup>  | Stefan-Boltzmann constant         | nist2018-constants |
| μ0     | N.A<sup>-2</sup>                            | Vacuum magnetic permeability      | nist2018-constants |


## Other Constants

| Symbol | Units             | Description                                 | Reference          |
| :----- | :---------------- | :------------------------------------------ | :----------------- |
| g      | m.s<sup>-2</sup>  | standard acceleration of gravity on earth   | nist2018-constants |
| T_NTP  | K                 | Temperature under normal  (NTP) conditions  | nist2018-constants |
| P_NTP  | Pa                | Pressure under normal (NTP) conditions      | nist2018-constants |
| T_STP  | K                 | Temperature under standard (STP) conditions | nist2018-constants |
| P_STP  | Pa                | Pressure under standard (STP) conditions    | nist2018-constants |
"""

from ._constants import (
    c,
    G,
    h,
    h_bar,
    m_u,
    N_A,
    k_B,
    F,
    R,
    σ,
    μ0,
    g,
    T_NTP,
    P_NTP,
    T_STP,
    P_STP,
)

__all__ = [
    "c",
    "G",
    "h",
    "h_bar",
    "m_u",
    "N_A",
    "k_B",
    "F",
    "R",
    "σ",
    "μ0",
    "g",
    "T_NTP",
    "P_NTP",
    "T_STP",
    "P_STP",
]
