# coding: utf-8

"""
    VRt.Studio [ST]

    The version of the OpenAPI document: 6.13.2112

    Generated by OpenAPI Generator: 6.6.0

    Do not edit the code manually

    2023 Veeroute
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, conint, conlist, constr
from vrt_lss_studio.models.attribute import Attribute
from vrt_lss_studio.models.demand_type import DemandType
from vrt_lss_studio.models.possible_event import PossibleEvent

class Demand(BaseModel):
    """
    Request for a single action with a cargo (pickup / drop) or work at a location.
    """
    key: constr(strict=True, max_length=1024, min_length=1) = Field(..., description="Demand key, unique identifier.")
    demand_type: DemandType = Field(...)
    target_cargos: Optional[conlist(constr(strict=True, max_length=1024, min_length=1), max_items=1000, min_items=0, unique_items=True)] = Field(None, description="The list of cargo keys depends on the type of order in which the cargoes are located:   * `PICKUP` - list of keys   * `DROP` - one key   * `WORK` - empty list   * `PICKUP_TO_BOX` - one key   * `DROP_FROM_BOX` - one key ")
    precedence_in_trip: Optional[conint(strict=True, le=15001, ge=0)] = Field(0, description="Precedence within a trip, 0 - the precedence is not taken into account.")
    precedence_in_order: Optional[conint(strict=True, le=15001, ge=0)] = Field(0, description="Precedence within an order, 0 - the precedence is not taken into account.")
    possible_events: conlist(PossibleEvent, max_items=25, min_items=1, unique_items=True) = Field(..., description="List of possible time windows and location keys to fulfil an order.")
    attributes: Optional[conlist(Attribute, max_items=1000, min_items=0, unique_items=True)] = Field(None, description="Attributes. Used to add service information.")
    __properties = ["key", "demand_type", "target_cargos", "precedence_in_trip", "precedence_in_order", "possible_events", "attributes"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Demand:
        """Create an instance of Demand from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in possible_events (list)
        _items = []
        if self.possible_events:
            for _item in self.possible_events:
                if _item:
                    _items.append(_item.to_dict())
            _dict['possible_events'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in attributes (list)
        _items = []
        if self.attributes:
            for _item in self.attributes:
                if _item:
                    _items.append(_item.to_dict())
            _dict['attributes'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Demand:
        """Create an instance of Demand from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return Demand.parse_obj(obj)

        _obj = Demand.parse_obj({
            "key": obj.get("key"),
            "demand_type": obj.get("demand_type"),
            "target_cargos": obj.get("target_cargos"),
            "precedence_in_trip": obj.get("precedence_in_trip") if obj.get("precedence_in_trip") is not None else 0,
            "precedence_in_order": obj.get("precedence_in_order") if obj.get("precedence_in_order") is not None else 0,
            "possible_events": [PossibleEvent.from_dict(_item) for _item in obj.get("possible_events")] if obj.get("possible_events") is not None else None,
            "attributes": [Attribute.from_dict(_item) for _item in obj.get("attributes")] if obj.get("attributes") is not None else None
        })
        return _obj

