# coding: utf-8

"""
    VRt.Studio [ST]

    The version of the OpenAPI document: 6.13.2112

    Generated by OpenAPI Generator: 6.6.0

    Do not edit the code manually

    2023 Veeroute
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, conint
from vrt_lss_studio.models.capacity import Capacity

class TransportLimits(BaseModel):
    """
    Transport load limits. 
    """
    max_boxes: Optional[conint(strict=True, le=100, ge=0)] = Field(None, description="Limit of the number of transports's unique locations in one trip. If not specified or null, number of using boxes is not limited. The limit should not exceed the number of boxes. ")
    max_capacity: Optional[Capacity] = None
    __properties = ["max_boxes", "max_capacity"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> TransportLimits:
        """Create an instance of TransportLimits from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of max_capacity
        if self.max_capacity:
            _dict['max_capacity'] = self.max_capacity.to_dict()
        # set to None if max_boxes (nullable) is None
        # and __fields_set__ contains the field
        if self.max_boxes is None and "max_boxes" in self.__fields_set__:
            _dict['max_boxes'] = None

        # set to None if max_capacity (nullable) is None
        # and __fields_set__ contains the field
        if self.max_capacity is None and "max_capacity" in self.__fields_set__:
            _dict['max_capacity'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> TransportLimits:
        """Create an instance of TransportLimits from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return TransportLimits.parse_obj(obj)

        _obj = TransportLimits.parse_obj({
            "max_boxes": obj.get("max_boxes"),
            "max_capacity": Capacity.from_dict(obj.get("max_capacity")) if obj.get("max_capacity") is not None else None
        })
        return _obj

