# coding: utf-8

"""
    VRt.Studio [ST]

    The version of the OpenAPI document: 6.13.2112

    Generated by OpenAPI Generator: 6.6.0

    Do not edit the code manually

    2023 Veeroute
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import Optional, Union
from pydantic import BaseModel, Field, confloat, conint

class TransportTariffConstraint(BaseModel):
    """
    Paid mileage is an integral part of the tariff.
    """
    stage_length: Optional[conint(strict=True, le=100000000, ge=1)] = Field(100000000, description="The length of the paid part of the way, in meters.")
    cost_per_unit: Optional[Union[confloat(le=10000, ge=0.001, strict=True), conint(le=10000, ge=1, strict=True)]] = Field(0.001, description="The cost within the paid part of the way, monetary unit per meter. ")
    __properties = ["stage_length", "cost_per_unit"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> TransportTariffConstraint:
        """Create an instance of TransportTariffConstraint from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> TransportTariffConstraint:
        """Create an instance of TransportTariffConstraint from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return TransportTariffConstraint.parse_obj(obj)

        _obj = TransportTariffConstraint.parse_obj({
            "stage_length": obj.get("stage_length") if obj.get("stage_length") is not None else 100000000,
            "cost_per_unit": obj.get("cost_per_unit") if obj.get("cost_per_unit") is not None else 0.001
        })
        return _obj

