# coding: utf-8

"""
    VRt.Studio [ST]

    The version of the OpenAPI document: 6.13.2112

    Generated by OpenAPI Generator: 6.6.0

    Do not edit the code manually

    2023 Veeroute
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json



from pydantic import BaseModel, Field, StrictBool, constr
from vrt_lss_studio.models.geopoint import Geopoint

class WebLocationGeopoint(BaseModel):
    """
    Geopoint for map.
    """
    geopoint: Geopoint = Field(...)
    location_key: constr(strict=True, max_length=1024, min_length=1) = Field(..., description="Location key, unique identifier.")
    linked: StrictBool = Field(..., description="Flag indicating the presence of links to the location.")
    __properties = ["geopoint", "location_key", "linked"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> WebLocationGeopoint:
        """Create an instance of WebLocationGeopoint from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of geopoint
        if self.geopoint:
            _dict['geopoint'] = self.geopoint.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> WebLocationGeopoint:
        """Create an instance of WebLocationGeopoint from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return WebLocationGeopoint.parse_obj(obj)

        _obj = WebLocationGeopoint.parse_obj({
            "geopoint": Geopoint.from_dict(obj.get("geopoint")) if obj.get("geopoint") is not None else None,
            "location_key": obj.get("location_key"),
            "linked": obj.get("linked") if obj.get("linked") is not None else False
        })
        return _obj

