# coding: utf-8

"""
    VRt.Studio [ST]

    The version of the OpenAPI document: 6.13.2112

    Generated by OpenAPI Generator: 6.6.0

    Do not edit the code manually

    2023 Veeroute
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, conint, constr
from vrt_lss_studio.models.demand_type import DemandType
from vrt_lss_studio.models.geopoint import Geopoint

class WebOrderGeopoint(BaseModel):
    """
    Geopoint for map.
    """
    geopoint: Geopoint = Field(...)
    order_key: constr(strict=True, max_length=1024, min_length=1) = Field(..., description="Key of the order with which an action is taken.")
    demand_key: constr(strict=True, max_length=1024, min_length=1) = Field(..., description="Key of the demand with which an action is taken.")
    event_key: constr(strict=True, max_length=1024, min_length=1) = Field(..., description="Key of the event at which an action is taken.")
    demand_type: DemandType = Field(...)
    trip_key: Optional[constr(strict=True, max_length=1024, min_length=1)] = Field(None, description="Key, unique identifier.")
    trip_name: Optional[constr(strict=True, max_length=64, min_length=0)] = Field('', description="Trip name.")
    stop_number: Optional[conint(strict=True, le=1000, ge=0)] = Field(0, description="Sequence number of the stop in the trip.")
    __properties = ["geopoint", "order_key", "demand_key", "event_key", "demand_type", "trip_key", "trip_name", "stop_number"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> WebOrderGeopoint:
        """Create an instance of WebOrderGeopoint from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of geopoint
        if self.geopoint:
            _dict['geopoint'] = self.geopoint.to_dict()
        # set to None if trip_key (nullable) is None
        # and __fields_set__ contains the field
        if self.trip_key is None and "trip_key" in self.__fields_set__:
            _dict['trip_key'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> WebOrderGeopoint:
        """Create an instance of WebOrderGeopoint from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return WebOrderGeopoint.parse_obj(obj)

        _obj = WebOrderGeopoint.parse_obj({
            "geopoint": Geopoint.from_dict(obj.get("geopoint")) if obj.get("geopoint") is not None else None,
            "order_key": obj.get("order_key"),
            "demand_key": obj.get("demand_key"),
            "event_key": obj.get("event_key"),
            "demand_type": obj.get("demand_type"),
            "trip_key": obj.get("trip_key"),
            "trip_name": obj.get("trip_name") if obj.get("trip_name") is not None else '',
            "stop_number": obj.get("stop_number") if obj.get("stop_number") is not None else 0
        })
        return _obj

