# AUTOGENERATED! DO NOT EDIT! File to edit: ../../nbs/12c_keypoint.core.ipynb.

# %% auto 0
__all__ = ['Keypoints']

# %% ../../nbs/12c_keypoint.core.ipynb 3
from fastcore.all import *
import numpy as np
import polvo as pv

# %% ../../nbs/12c_keypoint.core.ipynb 4
class Keypoints:
    def __init__(self, points):
        if points.ndim != 2: raise ValueError(f'points should be 2-dim [(x1, y1), (x2, y2), ...] but got {points.ndim}-dim')
        self.points = points
        
    @property
    def xy_points(self): return self.points
        
    def accept_visit(self, visitor): return visitor.visit_keypoints(self)
    
    def normalized(self, imagew, imageh):
        scale = np.array([imagew, imageh])
        return self.points / scale
    
    @classmethod
    def from_2d(cls, points): return cls(points)
    @classmethod
    def from_flat(cls, points): return cls(np.reshape(points, (-1, 2)))
    
    def __repr__(self):
        return f"<{self.__class__.__name__} {self.points}>"
