# AUTOGENERATED! DO NOT EDIT! File to edit: ../../nbs/10e_keypoints.vis.ipynb.

# %% auto 0
__all__ = ['overlay']

# %% ../../nbs/10e_keypoints.vis.ipynb 3
from fastcore.all import *
import PIL
import numpy as np
import polvo as pv
# from typing import Tuple
# from PIL import Image, ImageFont
from PIL.ImageDraw import ImageDraw
# from polvo.bbox import BBox, OBBox, BBoxLabeled, OBBoxLabeled
from . import Keypoints

# %% ../../nbs/10e_keypoints.vis.ipynb 4
def overlay(image:PIL.Image, keypoints:Keypoints, color:Tuple[int,int,int]=None, dot_radius=None):
    """Draws a box on an image with a given color.
    # Arguments
        image     : The image to draw on.
        box       : A list of 4 elements (x1, y1, x2, y2).
        color     : The color of the box.
    """
    draw = PIL.ImageDraw.Draw(image)
    color = color or (255, 50, 50)
    
    r = dot_radius or int(min(image.size)/100)
    for i, (x,y) in enumerate(keypoints.xy_points):
        coords = x-r,y-r,x+r,y+r
        draw.ellipse(coords, fill=color)
        
    return image
