# AUTOGENERATED! DO NOT EDIT! File to edit: ../../nbs/17c_visitor.core.ipynb.

# %% auto 0
__all__ = ['Visitor']

# %% ../../nbs/17c_visitor.core.ipynb 3
from fastcore.all import *

# %% ../../nbs/17c_visitor.core.ipynb 4
class Visitor:
    def _visit_image_file(self, image_file, **kwargs): raise NotImplementedError
    def _visit_bbox(self, bbox, **kwargs): raise NotImplementedError
    def _visit_bbox_labelled(self, bbox, **kwargs): raise NotImplementedError
    def _visit_obbox(self, bbox, **kwargs): raise NotImplementedError
    def _visit_obbox_labelled(self, obbox, **kwargs): raise NotImplementedError
    def _visit_keypoints(self, keypoints, **kwargs): raise NotImplementedError
    def _visit_segmask(self, segmask, **kwargs): raise NotImplementedError
        
    # separating the drawing functions from its call allows us to pass custom arguments to each item
    def collect_accept_fns(self, record):
        return [item.accept_visit(self) for item in record]
    
    def execute_accept_fns(self, fns, kwargs_list=None):
        kwargs_list = kwargs_list or [{} for _ in fns]
        for fn, kwargs in zip(fns, kwargs_list): fn(**kwargs)
        
    def visit_all(self, record, kwargs_list=None):
        fns = self.collect_accept_fns(record)
        return self.execute_accept_fns(fns, kwargs_list=kwargs_list)
    
    def visit_image_file(self, image_file, **kwargs): return partial(self._visit_image_file, image_file, **kwargs)
    def visit_bbox(self, bbox, **kwargs): return partial(self._visit_bbox, bbox, **kwargs)
    def visit_bbox_labelled(self, bbox, **kwargs): return partial(self._visit_bbox_labelled, bbox, **kwargs)
    def visit_obbox(self, bbox, **kwargs): return partial(self._visit_obbox, bbox, **kwargs)
    def visit_obbox_labelled(self, bbox, **kwargs): return partial(self._visit_obbox_labelled, bbox, **kwargs)
    def visit_keypoints(self, keypoints, **kwargs): return partial(self._visit_keypoints, keypoints, **kwargs)
    def visit_segmask(self, segmax, **kwargs): return partial(self._visit_segmask, segmax, **kwargs)
