'''
Generated like so:

>>> import os
...
... from scepticoin.datatypes import Block
... from scepticoin.coinstate import CoinState
... from scepticoin.humans import human
...
...
... coinstate = CoinState.empty()
... for filename in sorted(os.listdir('chain')):
...     block = Block.stream_deserialize(open('chain/%s' % filename, 'rb'))
...     coinstate = coinstate.add_block_no_validation(block)
...
...
... for i in range(0, 20000, 500):
...     block = coinstate.at_head.block_by_height[i]
...     print("""    %-8d: '%s',""" % (block.height, human(block.hash())))
'''

KNOWN_HASHES = {
    0       : '00c4ff1d0788c7058f3d8388d77b2feda0921fa141078fb895871634e0c36780',
    500     : '00786517cfdd81bbab75cc7d9ca738038cab005b0e0a6205b2aa07bfa917db25',
    1000    : '00fefe403e7108adca4f47a05ca59c61c08de1ee644d5d8a23b16b0f187de916',
    1500    : '004367b96c71fa69d931630a43dc60a070abb47c0febfa1b665690d5174a0869',
    2000    : '00c816a7c07d49ad3599c2ccfabf0e5055a0d547ebbc89ec358bb94328b1fef0',
    2500    : '0017f18030825766556c9e48d938092d3671b942c144e3ad84b06416ddabd8f3',
    3000    : '00b896c88866cf585491ef22d7ca42b8e70231815c6c7cc4863bce8a48bf7b83',
    3500    : '0027a1cc062e155cb83c8f47e4f1fd9b800614327c6e004c825793cdc010b5d6',
    4000    : '000b4a2d5ca016ee7f8e48438b139bc196610b379c85a73917c42d8bc06f4008',
    4500    : '00728eb4953a19471e1e0decb2d8b862fdd296740af14aa6db93943c9a786f2d',
    5000    : '0092f95d626f87faeae098b804470932b06ce0fcdded2a6c132078d764562ae4',
    5500    : '00a11402f94e899beab029b85b692f8d3247a3b98df375377f67e7ab6db6792a',
    6000    : '00591fee548a6cd736effe8143944f51e73fa6231ddf950eae92822cf914aa95',
    6500    : '0056e853dd5368797ccf4a9d2277002ca28d4b9c760ca28c2d136857101679fe',
    7000    : '00cae677cb2263dbf387a8232b05a73bd4464a0a559c7ce621934662c26321e0',
    7500    : '0033d2556494c990b83c80328be69aa88c83708d50d0764d2500380652e716b0',
    8000    : '006cf2ce65228fcd159ec63f44e7b666ac5378647342e917a2bb28fdfdbb326d',
    8500    : '001050a19cdfc579cf94811d793b9db54eb357aa98982f8eb6a985f41ab1464f',
    9000    : '0083671511256574b0d570f3143507f667414d150ef67157ab5d1f47a7732b52',
    9500    : '00429f3326540fe6ca64bb71f27785bbda820087c03828604776afe34af0ef94',
    10000   : '00e682c20eb9b53b176f64b33551f46bf03414328828717aae98733ac94e50d1',
    10500   : '00f8ff5cf06468c82ddf2ba5bb129c529496a664ee74a46e36dd6b8738130973',
    11000   : '010305c482e0675e9af8e539dc766a15c33f9e3270643d80b93b8bdd0358dc7b',
    11500   : '01a9fa19ea48c7492ee9a4eaaf86f80449c1c45f4db694642601fa0f959bab63',
    12000   : '008c8d01275a2b2467a4b5f81ffd4e276a323a7595f7043019bcff66dea2d6ba',
    12500   : '01e7366ff56295f9dbef382c35cebc96ea26738615ac23eddc88d8e678647bc6',
    13000   : '019c3834f6b28bef7825426198b0a8e7275d5883f92ab82c293e2e741c9d4908',
    13500   : '000571b36313a0ddf000bfef6daa9806bea85a6404451362fa601e3750245f21',
    14000   : '01316d05404a59ba9665b98e72cf746b80fe3240812edaa44f308cffb703d8fe',
    14500   : '0090f53d8908abaa2393fb7849e32d301ab08862b88a64ed3bd856c9dbf1da57',
    15000   : '015cd3436dcdd70d8999588f34a0d50f6a8ed77bc60fa3992970298b7d1a697a',
    15500   : '01909a27e929ec66cb10cc16c139d567ce64c929b3f2009c8751e50a18c61a85',
    16000   : '015ea1a4adce1cff0b8165e666fa3bcd76818627a510020b70fffbc8707579e4',
    16500   : '0123f7e399a69d35e4e38b33a4ce16b8f5f148e1e570d7386ab939268514fe84',
    17000   : '0097bb6832f6bd146352951bee48606e7ec66c7ffc535e0b8d123a1e72f7f9bb',
    17500   : '019f52e13ebf7fff127b4961dc32df935ed158a9a9163066b95c61cb71bfa403',
    18000   : '00bc834df67129b24bd70ad58a1380e1e7d38e75a55958f5c3b4fff02d134fcd',
    18500   : '00c9a686b830a342b5cba05807ed5affa79fe314b2fb96f4c7133f2fd58ef73e',
    19000   : '0130dc3498df05743b3b9a94a8543a5bb06167d7351b827312508b34bb351014',
}

MAX_KNOWN_HASH_HEIGHT = max(KNOWN_HASHES.keys())
