# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetBlockchainPlatformResult',
    'AwaitableGetBlockchainPlatformResult',
    'get_blockchain_platform',
    'get_blockchain_platform_output',
]

@pulumi.output_type
class GetBlockchainPlatformResult:
    """
    A collection of values returned by getBlockchainPlatform.
    """
    def __init__(__self__, blockchain_platform_id=None, ca_cert_archive_text=None, compartment_id=None, component_details=None, compute_shape=None, defined_tags=None, description=None, display_name=None, federated_user_id=None, freeform_tags=None, host_ocpu_utilization_infos=None, id=None, idcs_access_token=None, is_byol=None, is_multi_ad=None, lifecycle_details=None, load_balancer_shape=None, platform_role=None, platform_shape_type=None, platform_version=None, replicas=None, service_endpoint=None, service_version=None, state=None, storage_size_in_tbs=None, storage_used_in_tbs=None, time_created=None, time_updated=None, total_ocpu_capacity=None):
        if blockchain_platform_id and not isinstance(blockchain_platform_id, str):
            raise TypeError("Expected argument 'blockchain_platform_id' to be a str")
        pulumi.set(__self__, "blockchain_platform_id", blockchain_platform_id)
        if ca_cert_archive_text and not isinstance(ca_cert_archive_text, str):
            raise TypeError("Expected argument 'ca_cert_archive_text' to be a str")
        pulumi.set(__self__, "ca_cert_archive_text", ca_cert_archive_text)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if component_details and not isinstance(component_details, list):
            raise TypeError("Expected argument 'component_details' to be a list")
        pulumi.set(__self__, "component_details", component_details)
        if compute_shape and not isinstance(compute_shape, str):
            raise TypeError("Expected argument 'compute_shape' to be a str")
        pulumi.set(__self__, "compute_shape", compute_shape)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if federated_user_id and not isinstance(federated_user_id, str):
            raise TypeError("Expected argument 'federated_user_id' to be a str")
        pulumi.set(__self__, "federated_user_id", federated_user_id)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if host_ocpu_utilization_infos and not isinstance(host_ocpu_utilization_infos, list):
            raise TypeError("Expected argument 'host_ocpu_utilization_infos' to be a list")
        pulumi.set(__self__, "host_ocpu_utilization_infos", host_ocpu_utilization_infos)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if idcs_access_token and not isinstance(idcs_access_token, str):
            raise TypeError("Expected argument 'idcs_access_token' to be a str")
        pulumi.set(__self__, "idcs_access_token", idcs_access_token)
        if is_byol and not isinstance(is_byol, bool):
            raise TypeError("Expected argument 'is_byol' to be a bool")
        pulumi.set(__self__, "is_byol", is_byol)
        if is_multi_ad and not isinstance(is_multi_ad, bool):
            raise TypeError("Expected argument 'is_multi_ad' to be a bool")
        pulumi.set(__self__, "is_multi_ad", is_multi_ad)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if load_balancer_shape and not isinstance(load_balancer_shape, str):
            raise TypeError("Expected argument 'load_balancer_shape' to be a str")
        pulumi.set(__self__, "load_balancer_shape", load_balancer_shape)
        if platform_role and not isinstance(platform_role, str):
            raise TypeError("Expected argument 'platform_role' to be a str")
        pulumi.set(__self__, "platform_role", platform_role)
        if platform_shape_type and not isinstance(platform_shape_type, str):
            raise TypeError("Expected argument 'platform_shape_type' to be a str")
        pulumi.set(__self__, "platform_shape_type", platform_shape_type)
        if platform_version and not isinstance(platform_version, str):
            raise TypeError("Expected argument 'platform_version' to be a str")
        pulumi.set(__self__, "platform_version", platform_version)
        if replicas and not isinstance(replicas, list):
            raise TypeError("Expected argument 'replicas' to be a list")
        pulumi.set(__self__, "replicas", replicas)
        if service_endpoint and not isinstance(service_endpoint, str):
            raise TypeError("Expected argument 'service_endpoint' to be a str")
        pulumi.set(__self__, "service_endpoint", service_endpoint)
        if service_version and not isinstance(service_version, str):
            raise TypeError("Expected argument 'service_version' to be a str")
        pulumi.set(__self__, "service_version", service_version)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if storage_size_in_tbs and not isinstance(storage_size_in_tbs, float):
            raise TypeError("Expected argument 'storage_size_in_tbs' to be a float")
        pulumi.set(__self__, "storage_size_in_tbs", storage_size_in_tbs)
        if storage_used_in_tbs and not isinstance(storage_used_in_tbs, float):
            raise TypeError("Expected argument 'storage_used_in_tbs' to be a float")
        pulumi.set(__self__, "storage_used_in_tbs", storage_used_in_tbs)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)
        if total_ocpu_capacity and not isinstance(total_ocpu_capacity, int):
            raise TypeError("Expected argument 'total_ocpu_capacity' to be a int")
        pulumi.set(__self__, "total_ocpu_capacity", total_ocpu_capacity)

    @property
    @pulumi.getter(name="blockchainPlatformId")
    def blockchain_platform_id(self) -> str:
        return pulumi.get(self, "blockchain_platform_id")

    @property
    @pulumi.getter(name="caCertArchiveText")
    def ca_cert_archive_text(self) -> str:
        return pulumi.get(self, "ca_cert_archive_text")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        Compartment Identifier
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="componentDetails")
    def component_details(self) -> Sequence['outputs.GetBlockchainPlatformComponentDetailResult']:
        """
        Blockchain Platform component details.
        """
        return pulumi.get(self, "component_details")

    @property
    @pulumi.getter(name="computeShape")
    def compute_shape(self) -> str:
        """
        Compute shape - STANDARD or ENTERPRISE_SMALL or ENTERPRISE_MEDIUM or ENTERPRISE_LARGE or ENTERPRISE_EXTRA_LARGE or ENTERPRISE_CUSTOM
        """
        return pulumi.get(self, "compute_shape")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Platform Instance Description
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        Platform Instance Display name, can be renamed
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="federatedUserId")
    def federated_user_id(self) -> str:
        return pulumi.get(self, "federated_user_id")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="hostOcpuUtilizationInfos")
    def host_ocpu_utilization_infos(self) -> Sequence['outputs.GetBlockchainPlatformHostOcpuUtilizationInfoResult']:
        """
        List of OcpuUtilization for all hosts
        """
        return pulumi.get(self, "host_ocpu_utilization_infos")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        unique identifier that is immutable on creation
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="idcsAccessToken")
    def idcs_access_token(self) -> str:
        return pulumi.get(self, "idcs_access_token")

    @property
    @pulumi.getter(name="isByol")
    def is_byol(self) -> bool:
        """
        Bring your own license
        """
        return pulumi.get(self, "is_byol")

    @property
    @pulumi.getter(name="isMultiAd")
    def is_multi_ad(self) -> bool:
        """
        True for multi-AD blockchain plaforms, false for single-AD
        """
        return pulumi.get(self, "is_multi_ad")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        """
        An message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="loadBalancerShape")
    def load_balancer_shape(self) -> str:
        """
        Type of Load Balancer shape - LB_100_MBPS or LB_400_MBPS. Default is LB_100_MBPS.
        """
        return pulumi.get(self, "load_balancer_shape")

    @property
    @pulumi.getter(name="platformRole")
    def platform_role(self) -> str:
        """
        Role of platform - FOUNDER or PARTICIPANT
        """
        return pulumi.get(self, "platform_role")

    @property
    @pulumi.getter(name="platformShapeType")
    def platform_shape_type(self) -> str:
        """
        Type of Platform shape - DEFAULT or CUSTOM
        """
        return pulumi.get(self, "platform_shape_type")

    @property
    @pulumi.getter(name="platformVersion")
    def platform_version(self) -> str:
        """
        Platform Version
        """
        return pulumi.get(self, "platform_version")

    @property
    @pulumi.getter
    def replicas(self) -> Sequence['outputs.GetBlockchainPlatformReplicaResult']:
        """
        Number of replicas of service components like Rest Proxy, CA and Console
        """
        return pulumi.get(self, "replicas")

    @property
    @pulumi.getter(name="serviceEndpoint")
    def service_endpoint(self) -> str:
        """
        Service endpoint URL, valid post-provisioning
        """
        return pulumi.get(self, "service_endpoint")

    @property
    @pulumi.getter(name="serviceVersion")
    def service_version(self) -> str:
        """
        The version of the Platform Instance.
        """
        return pulumi.get(self, "service_version")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of the Platform Instance.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="storageSizeInTbs")
    def storage_size_in_tbs(self) -> float:
        """
        Storage size in TBs
        """
        return pulumi.get(self, "storage_size_in_tbs")

    @property
    @pulumi.getter(name="storageUsedInTbs")
    def storage_used_in_tbs(self) -> float:
        """
        Storage used in TBs
        """
        return pulumi.get(self, "storage_used_in_tbs")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The time the the Platform Instance was created. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The time the Platform Instance was updated. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter(name="totalOcpuCapacity")
    def total_ocpu_capacity(self) -> int:
        """
        Number of total OCPUs allocated to the platform cluster
        """
        return pulumi.get(self, "total_ocpu_capacity")


class AwaitableGetBlockchainPlatformResult(GetBlockchainPlatformResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetBlockchainPlatformResult(
            blockchain_platform_id=self.blockchain_platform_id,
            ca_cert_archive_text=self.ca_cert_archive_text,
            compartment_id=self.compartment_id,
            component_details=self.component_details,
            compute_shape=self.compute_shape,
            defined_tags=self.defined_tags,
            description=self.description,
            display_name=self.display_name,
            federated_user_id=self.federated_user_id,
            freeform_tags=self.freeform_tags,
            host_ocpu_utilization_infos=self.host_ocpu_utilization_infos,
            id=self.id,
            idcs_access_token=self.idcs_access_token,
            is_byol=self.is_byol,
            is_multi_ad=self.is_multi_ad,
            lifecycle_details=self.lifecycle_details,
            load_balancer_shape=self.load_balancer_shape,
            platform_role=self.platform_role,
            platform_shape_type=self.platform_shape_type,
            platform_version=self.platform_version,
            replicas=self.replicas,
            service_endpoint=self.service_endpoint,
            service_version=self.service_version,
            state=self.state,
            storage_size_in_tbs=self.storage_size_in_tbs,
            storage_used_in_tbs=self.storage_used_in_tbs,
            time_created=self.time_created,
            time_updated=self.time_updated,
            total_ocpu_capacity=self.total_ocpu_capacity)


def get_blockchain_platform(blockchain_platform_id: Optional[str] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetBlockchainPlatformResult:
    """
    This data source provides details about a specific Blockchain Platform resource in Oracle Cloud Infrastructure Blockchain service.

    Gets information about a Blockchain Platform identified by the specific id

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_blockchain_platform = oci.Blockchain.get_blockchain_platform(blockchain_platform_id=test_blockchain_platform_oci_blockchain_blockchain_platform["id"])
    ```


    :param str blockchain_platform_id: Unique service identifier.
    """
    __args__ = dict()
    __args__['blockchainPlatformId'] = blockchain_platform_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Blockchain/getBlockchainPlatform:getBlockchainPlatform', __args__, opts=opts, typ=GetBlockchainPlatformResult).value

    return AwaitableGetBlockchainPlatformResult(
        blockchain_platform_id=pulumi.get(__ret__, 'blockchain_platform_id'),
        ca_cert_archive_text=pulumi.get(__ret__, 'ca_cert_archive_text'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        component_details=pulumi.get(__ret__, 'component_details'),
        compute_shape=pulumi.get(__ret__, 'compute_shape'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        description=pulumi.get(__ret__, 'description'),
        display_name=pulumi.get(__ret__, 'display_name'),
        federated_user_id=pulumi.get(__ret__, 'federated_user_id'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        host_ocpu_utilization_infos=pulumi.get(__ret__, 'host_ocpu_utilization_infos'),
        id=pulumi.get(__ret__, 'id'),
        idcs_access_token=pulumi.get(__ret__, 'idcs_access_token'),
        is_byol=pulumi.get(__ret__, 'is_byol'),
        is_multi_ad=pulumi.get(__ret__, 'is_multi_ad'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        load_balancer_shape=pulumi.get(__ret__, 'load_balancer_shape'),
        platform_role=pulumi.get(__ret__, 'platform_role'),
        platform_shape_type=pulumi.get(__ret__, 'platform_shape_type'),
        platform_version=pulumi.get(__ret__, 'platform_version'),
        replicas=pulumi.get(__ret__, 'replicas'),
        service_endpoint=pulumi.get(__ret__, 'service_endpoint'),
        service_version=pulumi.get(__ret__, 'service_version'),
        state=pulumi.get(__ret__, 'state'),
        storage_size_in_tbs=pulumi.get(__ret__, 'storage_size_in_tbs'),
        storage_used_in_tbs=pulumi.get(__ret__, 'storage_used_in_tbs'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'),
        total_ocpu_capacity=pulumi.get(__ret__, 'total_ocpu_capacity'))
def get_blockchain_platform_output(blockchain_platform_id: Optional[pulumi.Input[str]] = None,
                                   opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetBlockchainPlatformResult]:
    """
    This data source provides details about a specific Blockchain Platform resource in Oracle Cloud Infrastructure Blockchain service.

    Gets information about a Blockchain Platform identified by the specific id

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_blockchain_platform = oci.Blockchain.get_blockchain_platform(blockchain_platform_id=test_blockchain_platform_oci_blockchain_blockchain_platform["id"])
    ```


    :param str blockchain_platform_id: Unique service identifier.
    """
    __args__ = dict()
    __args__['blockchainPlatformId'] = blockchain_platform_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Blockchain/getBlockchainPlatform:getBlockchainPlatform', __args__, opts=opts, typ=GetBlockchainPlatformResult)
    return __ret__.apply(lambda __response__: GetBlockchainPlatformResult(
        blockchain_platform_id=pulumi.get(__response__, 'blockchain_platform_id'),
        ca_cert_archive_text=pulumi.get(__response__, 'ca_cert_archive_text'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        component_details=pulumi.get(__response__, 'component_details'),
        compute_shape=pulumi.get(__response__, 'compute_shape'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        description=pulumi.get(__response__, 'description'),
        display_name=pulumi.get(__response__, 'display_name'),
        federated_user_id=pulumi.get(__response__, 'federated_user_id'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        host_ocpu_utilization_infos=pulumi.get(__response__, 'host_ocpu_utilization_infos'),
        id=pulumi.get(__response__, 'id'),
        idcs_access_token=pulumi.get(__response__, 'idcs_access_token'),
        is_byol=pulumi.get(__response__, 'is_byol'),
        is_multi_ad=pulumi.get(__response__, 'is_multi_ad'),
        lifecycle_details=pulumi.get(__response__, 'lifecycle_details'),
        load_balancer_shape=pulumi.get(__response__, 'load_balancer_shape'),
        platform_role=pulumi.get(__response__, 'platform_role'),
        platform_shape_type=pulumi.get(__response__, 'platform_shape_type'),
        platform_version=pulumi.get(__response__, 'platform_version'),
        replicas=pulumi.get(__response__, 'replicas'),
        service_endpoint=pulumi.get(__response__, 'service_endpoint'),
        service_version=pulumi.get(__response__, 'service_version'),
        state=pulumi.get(__response__, 'state'),
        storage_size_in_tbs=pulumi.get(__response__, 'storage_size_in_tbs'),
        storage_used_in_tbs=pulumi.get(__response__, 'storage_used_in_tbs'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_updated=pulumi.get(__response__, 'time_updated'),
        total_ocpu_capacity=pulumi.get(__response__, 'total_ocpu_capacity')))
