# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetRunLogsResult',
    'AwaitableGetRunLogsResult',
    'get_run_logs',
    'get_run_logs_output',
]

@pulumi.output_type
class GetRunLogsResult:
    """
    A collection of values returned by getRunLogs.
    """
    def __init__(__self__, filters=None, id=None, run_id=None, run_logs=None):
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if run_id and not isinstance(run_id, str):
            raise TypeError("Expected argument 'run_id' to be a str")
        pulumi.set(__self__, "run_id", run_id)
        if run_logs and not isinstance(run_logs, list):
            raise TypeError("Expected argument 'run_logs' to be a list")
        pulumi.set(__self__, "run_logs", run_logs)

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetRunLogsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="runId")
    def run_id(self) -> str:
        return pulumi.get(self, "run_id")

    @property
    @pulumi.getter(name="runLogs")
    def run_logs(self) -> Sequence['outputs.GetRunLogsRunLogResult']:
        """
        The list of run_logs.
        """
        return pulumi.get(self, "run_logs")


class AwaitableGetRunLogsResult(GetRunLogsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRunLogsResult(
            filters=self.filters,
            id=self.id,
            run_id=self.run_id,
            run_logs=self.run_logs)


def get_run_logs(filters: Optional[Sequence[Union['GetRunLogsFilterArgs', 'GetRunLogsFilterArgsDict']]] = None,
                 run_id: Optional[str] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRunLogsResult:
    """
    This data source provides the list of Run Logs in Oracle Cloud Infrastructure Data Flow service.

    Retrieves summaries of the run's logs.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_run_logs = oci.DataFlow.get_run_logs(run_id=test_run["id"])
    ```


    :param str run_id: The unique ID for the run
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['runId'] = run_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DataFlow/getRunLogs:getRunLogs', __args__, opts=opts, typ=GetRunLogsResult).value

    return AwaitableGetRunLogsResult(
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        run_id=pulumi.get(__ret__, 'run_id'),
        run_logs=pulumi.get(__ret__, 'run_logs'))
def get_run_logs_output(filters: Optional[pulumi.Input[Optional[Sequence[Union['GetRunLogsFilterArgs', 'GetRunLogsFilterArgsDict']]]]] = None,
                        run_id: Optional[pulumi.Input[str]] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetRunLogsResult]:
    """
    This data source provides the list of Run Logs in Oracle Cloud Infrastructure Data Flow service.

    Retrieves summaries of the run's logs.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_run_logs = oci.DataFlow.get_run_logs(run_id=test_run["id"])
    ```


    :param str run_id: The unique ID for the run
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['runId'] = run_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:DataFlow/getRunLogs:getRunLogs', __args__, opts=opts, typ=GetRunLogsResult)
    return __ret__.apply(lambda __response__: GetRunLogsResult(
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        run_id=pulumi.get(__response__, 'run_id'),
        run_logs=pulumi.get(__response__, 'run_logs')))
