# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetRunbooksResult',
    'AwaitableGetRunbooksResult',
    'get_runbooks',
    'get_runbooks_output',
]

@pulumi.output_type
class GetRunbooksResult:
    """
    A collection of values returned by getRunbooks.
    """
    def __init__(__self__, compartment_id=None, display_name=None, filters=None, id=None, operation=None, platform=None, runbook_collections=None, runbook_relevance=None, state=None, type=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if operation and not isinstance(operation, str):
            raise TypeError("Expected argument 'operation' to be a str")
        pulumi.set(__self__, "operation", operation)
        if platform and not isinstance(platform, str):
            raise TypeError("Expected argument 'platform' to be a str")
        pulumi.set(__self__, "platform", platform)
        if runbook_collections and not isinstance(runbook_collections, list):
            raise TypeError("Expected argument 'runbook_collections' to be a list")
        pulumi.set(__self__, "runbook_collections", runbook_collections)
        if runbook_relevance and not isinstance(runbook_relevance, str):
            raise TypeError("Expected argument 'runbook_relevance' to be a str")
        pulumi.set(__self__, "runbook_relevance", runbook_relevance)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[str]:
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.  Example: `My new resource`
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetRunbooksFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The OCID of the resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def operation(self) -> Optional[str]:
        """
        The lifecycle operation performed by the task.
        """
        return pulumi.get(self, "operation")

    @property
    @pulumi.getter
    def platform(self) -> Optional[str]:
        """
        The platform of the runbook.
        """
        return pulumi.get(self, "platform")

    @property
    @pulumi.getter(name="runbookCollections")
    def runbook_collections(self) -> Sequence['outputs.GetRunbooksRunbookCollectionResult']:
        """
        The list of runbook_collection.
        """
        return pulumi.get(self, "runbook_collections")

    @property
    @pulumi.getter(name="runbookRelevance")
    def runbook_relevance(self) -> Optional[str]:
        """
        Type of runbook structure.
        """
        return pulumi.get(self, "runbook_relevance")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The current state of the Runbook.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The type of the runbook.
        """
        return pulumi.get(self, "type")


class AwaitableGetRunbooksResult(GetRunbooksResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRunbooksResult(
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            operation=self.operation,
            platform=self.platform,
            runbook_collections=self.runbook_collections,
            runbook_relevance=self.runbook_relevance,
            state=self.state,
            type=self.type)


def get_runbooks(compartment_id: Optional[str] = None,
                 display_name: Optional[str] = None,
                 filters: Optional[Sequence[Union['GetRunbooksFilterArgs', 'GetRunbooksFilterArgsDict']]] = None,
                 id: Optional[str] = None,
                 operation: Optional[str] = None,
                 platform: Optional[str] = None,
                 runbook_relevance: Optional[str] = None,
                 state: Optional[str] = None,
                 type: Optional[str] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRunbooksResult:
    """
    This data source provides the list of Runbooks in Oracle Cloud Infrastructure Fleet Apps Management service.

    Returns a list of Runbooks.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_runbooks = oci.FleetAppsManagement.get_runbooks(compartment_id=compartment_id,
        display_name=runbook_display_name,
        id=runbook_id,
        operation=runbook_operation,
        platform=runbook_platform,
        runbook_relevance=runbook_runbook_relevance,
        state=runbook_state,
        type=runbook_type)
    ```


    :param str compartment_id: The ID of the compartment in which to list resources.
    :param str display_name: A filter to return only resources that match the entire display name given.
    :param str id: unique Runbook identifier
    :param str operation: The runbook lifecycle.
    :param str platform: The ID of the runbook platform.
    :param str runbook_relevance: The runbook relevance of product or full-stack.
    :param str state: A filter to return only resources their lifecycleState matches the given lifecycleState.
    :param str type: The ID of the runbook type.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['operation'] = operation
    __args__['platform'] = platform
    __args__['runbookRelevance'] = runbook_relevance
    __args__['state'] = state
    __args__['type'] = type
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:FleetAppsManagement/getRunbooks:getRunbooks', __args__, opts=opts, typ=GetRunbooksResult).value

    return AwaitableGetRunbooksResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        operation=pulumi.get(__ret__, 'operation'),
        platform=pulumi.get(__ret__, 'platform'),
        runbook_collections=pulumi.get(__ret__, 'runbook_collections'),
        runbook_relevance=pulumi.get(__ret__, 'runbook_relevance'),
        state=pulumi.get(__ret__, 'state'),
        type=pulumi.get(__ret__, 'type'))
def get_runbooks_output(compartment_id: Optional[pulumi.Input[Optional[str]]] = None,
                        display_name: Optional[pulumi.Input[Optional[str]]] = None,
                        filters: Optional[pulumi.Input[Optional[Sequence[Union['GetRunbooksFilterArgs', 'GetRunbooksFilterArgsDict']]]]] = None,
                        id: Optional[pulumi.Input[Optional[str]]] = None,
                        operation: Optional[pulumi.Input[Optional[str]]] = None,
                        platform: Optional[pulumi.Input[Optional[str]]] = None,
                        runbook_relevance: Optional[pulumi.Input[Optional[str]]] = None,
                        state: Optional[pulumi.Input[Optional[str]]] = None,
                        type: Optional[pulumi.Input[Optional[str]]] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetRunbooksResult]:
    """
    This data source provides the list of Runbooks in Oracle Cloud Infrastructure Fleet Apps Management service.

    Returns a list of Runbooks.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_runbooks = oci.FleetAppsManagement.get_runbooks(compartment_id=compartment_id,
        display_name=runbook_display_name,
        id=runbook_id,
        operation=runbook_operation,
        platform=runbook_platform,
        runbook_relevance=runbook_runbook_relevance,
        state=runbook_state,
        type=runbook_type)
    ```


    :param str compartment_id: The ID of the compartment in which to list resources.
    :param str display_name: A filter to return only resources that match the entire display name given.
    :param str id: unique Runbook identifier
    :param str operation: The runbook lifecycle.
    :param str platform: The ID of the runbook platform.
    :param str runbook_relevance: The runbook relevance of product or full-stack.
    :param str state: A filter to return only resources their lifecycleState matches the given lifecycleState.
    :param str type: The ID of the runbook type.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['operation'] = operation
    __args__['platform'] = platform
    __args__['runbookRelevance'] = runbook_relevance
    __args__['state'] = state
    __args__['type'] = type
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:FleetAppsManagement/getRunbooks:getRunbooks', __args__, opts=opts, typ=GetRunbooksResult)
    return __ret__.apply(lambda __response__: GetRunbooksResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        operation=pulumi.get(__response__, 'operation'),
        platform=pulumi.get(__response__, 'platform'),
        runbook_collections=pulumi.get(__response__, 'runbook_collections'),
        runbook_relevance=pulumi.get(__response__, 'runbook_relevance'),
        state=pulumi.get(__response__, 'state'),
        type=pulumi.get(__response__, 'type')))
