# The FHIR-Wrapper for Harmonization

This package contains functions useful in the normalization and sanitization of FHIR-formatted input data (e.g. JSON-formatted dictionaries and bundles of FHIR resources). The `__init__.py` defines the publicly-available namespace functions available within the package; functions within other files should typically not be imported directly, as they are helper functions that operate under the hood. The functions in this package (e.g. `standardize_names`, `standardize_phones`, etc.) accept both individual resources as well as a bundle of resources without need to modify other parameter settings. For an overview of the package as well as common use cases, see the _harmonization-tutorial_ in `/tutorials` at the project root. For a more in-depth explanation of specific formatting and parameters, see the docstrings and comments for each function.