from .variables import *


conjugations = {
    EIMAI: {SG: {PRI: ['είμαι'], SEC: ['είσαι'], TER: ['είναι']},
            PL: {PRI: ['είμαστε'], SEC: ['είστε', 'είσαστε'], TER: ['είναι']}},
    EIMAI_PARATATIKOS: {SG: {PRI: ['ήμουν', 'ήμουνα'], SEC: ['ήσουν', 'ήσουνα'], TER: ['ήταν', 'ήτανε']},
                        PL: {PRI: ['ήμαστε', 'ήμασταν'], SEC: ['ήσαστε', 'ήσασταν'], TER: ['ήταν', 'ήτανε']}},
    CON1_ACT: {SG: {PRI: ['ω'], SEC: ['εις'], TER: ['ει']}, PL: {PRI: ['ουμε'], SEC: ['ετε'], TER: ['ουν', 'ουνε']}},
    CON2A_ACT: {SG: {PRI: ['ώ', 'άω'], SEC: ['άς'], TER: ['ά', 'άει']},
                PL: {PRI: ['ούμε', 'άμε'], SEC: ['άτε'], TER: ['άνε', 'άν', 'ούν', 'ούνε']}},
    CON2B_ACT: {SG: {PRI: ['ώ'], SEC: ['είς'], TER: ['εί']}, PL: {PRI: ['ούμε'], SEC: ['είτε'], TER: ['ούνε', 'ούν']}},
    CON2C_ACT: {SG: {PRI: ['ω'], SEC: ['ς'], TER: ['ει']}, PL: {PRI: ['με'], SEC: ['τε'], TER: ['νε', 'ν']}},
    CON2D_ACT: {SG: {PRI: ['ώ'], SEC: ['οίς'], TER: ['οί']},
                PL: {PRI: ['ούμε', 'ούμεν'], SEC: ['ούτε'], TER: ['ούνε', 'ούν']}},
    CON1_ACT_MODAL: {SG: {TER: ['ει']}},
    CON2_ACT_MODAL: {SG: {TER: ['εί']}},

    CON1_PASS: {SG: {PRI: ['ομαι'], SEC: ['εσαι'], TER: ['εται']},
                PL: {PRI: ['όμαστε'], SEC: ['εστε', 'όσαστε'], TER: ['ονται']}},
    CON2A_PASS: {SG: {PRI: ['ιέμαι'], SEC: ['ιέσαι'], TER: ['ιέται']},
                 PL: {PRI: ['ιόμαστε', 'ιούμαστε'], SEC: ['ιέστε', 'ιόσαστε'], TER: ['ιούνται', 'ιόνται']}},
    CON2AB_PASS: {SG: {PRI: ['ώμαι'], SEC: ['άσαι'], TER: ['άται']}, PL: {PRI: ['όμαστε'], SEC: ['άστε'],
                                                                          TER: ['ώνται']}},

    CON2B_PASS: {SG: {PRI: ['ούμαι'], SEC: ['είσαι'], TER: ['είται']},
                 PL: {PRI: ['ούμαστε', 'ούμεθα'], SEC: ['είστε', 'είσθε'], TER: ['ούνται']}},
    CON2C_PASS: {SG: {PRI: ['άμαι'], SEC: ['άσαι'], TER: ['άται']},
                 PL: {PRI: ['όμαστε'], SEC: ['άστε', 'όσαστε'], TER: ['ούνται']}},
    CON2SA_PASS: {SG: {PRI: ['ούμαι'], SEC: ['ούσαι'], TER: ['ούται']}, PL: {PRI: ['ούμεθα'], SEC: ['ούσθε'],
                                                                             TER: ['ούνται']}},
    CON2D_PASS: {SG: {PRI: ['μαι'], SEC: ['σαι'], TER: ['ται']}, PL: {PRI: ['μεθα'], SEC: ['σθε'],
                                                                      TER: ['νται']}},
    CON2E_PASS: {SG: {PRI: ['αμαι'], SEC: ['ασαι'], TER: ['αται']}, PL: {PRI: ['άμεθα', 'όμαστε'],
                                                                         SEC: ['ασθε', 'αστε'],
                                                                         TER: ['ανται']}},

    AOR_ACT: {SG: {PRI: ['α'], SEC: ['ες'], TER: ['ε']}, PL: {PRI: ['αμε'], SEC: ['ατε'], TER: ['αν', 'ανε']}},
    ARCH_PASS_AOR: {SG: {PRI: ['ην'], SEC: ['ης'], TER: ['η']}, PL: {PRI: ['ημεν'], SEC: ['ητε'], TER: ['ησαν']}},
    ARCH_SEC_AOR: {SG: {PRI: ['ον'], SEC: ['ες'], TER: ['ε']}, PL: {PRI: ['ομεν'], SEC: ['ετε'], TER: ['ον']}},

    PARAT2_ACT: {SG: {PRI: ['α'], SEC: ['ες'], TER: ['ε']}, PL: {PRI: ['αμε'], SEC: ['ατε'], TER: ['αν', 'ανε']}},
    PARAT_ACT_MODAL: {SG: {TER: ['ε']}},
    PARAT1_PASS: {SG: {PRI: ['όμουν', 'όμουνα'], SEC: ['όσουν', 'όσουνα'], TER: ['όταν', 'ότανε']},
                  PL: {PRI: ['όμασταν', 'όμαστε'], SEC: ['όσασταν', 'όσαστε'], TER: ['ονταν', 'όντουσαν']}},
    PARAT2A_PASS: {SG: {PRI: ['ιόμουν', 'ιόμουνα'], SEC: ['ιόσουν', 'ιόσουνα'], TER: ['ιόταν', 'ιότανε']},
                   PL: {PRI: ['ιόμασταν', 'ιόμαστε'], SEC: ['ιόσασταν', 'ιόσαστε'],
                        TER: ['ιούνταν', 'ιόνταν', 'ιόντουσαν']}},
    PARAT2B_PASS: {SG: {PRI: ['ούμουν'], SEC: ['ούσουν'], TER: ['είτο', 'ούνταν', 'ούντανε']},
                   PL: {PRI: ['ούμασταν', 'ούμαστε'], SEC: ['ούσασταν', 'ούσαστε'],
                        TER: ['ούνταν', 'ούντο', 'ούντανε']}},
    PARAT2B_PASS_LOGIA: {SG: {PRI: ['ούμην'], SEC: ['είσο'], TER: ['είτο']},
                         PL: {PRI: ['ούμεθα'], SEC: ['είσθε'], TER: ['ούντο']}},
    PARAT2C_PASS: {SG: {PRI: ['όμουν', 'όμουνα'], SEC: ['όσουν', 'όσουνα'], TER: ['όταν', 'ότανε']},
                   PL: {PRI: ['όμασταν', 'όμαστε'], SEC: ['όσασταν', 'όσαστε'], TER: ['ούνταν', 'όντουσαν']}},
    PARAT2D_PASS: {SG: {PRI: ['όμουν', 'έμην'], SEC: ['όσουν', 'εσο'], TER: ['όταν', 'ετο']},
                   PL: {PRI: ['όμασταν', 'έμεθα'], SEC: ['όσασταν', 'εσθε'], TER: ['ούνταν', 'εντο']}},
    PARAT2E_PASS: {SG: {PRI: ['άμην'], SEC: ['ασο'], TER: ['ατο']},
                   PL: {PRI: ['άμεθα', 'όμαστε', 'όμασταν'], SEC: ['ασθε', 'άστε', 'όσασταν', 'όσαστε'],
                        TER: ['αντο']}},
    IMPER_ACT_CONT_1: {SG: {SEC: ['ε']}, PL: {SEC: ['ετε']}},
    IMPER_ACT_EIMAI: {SG: {TER: ['έστω']}},
    IMPER_ACT_CONT_2A: {SG: {SEC: ['α', 'αγε']}, PL: {SEC: ['άτε']}},
    IMPER_ACT_CONT_2B: {SG: {SEC: ['ει']}, PL: {SEC: ['είτε']}},
    IMPER_ACT_CONT_2D: {PL: {SEC: ['ούτε']}},
    IMPER_ACT_CONT_2C: {SG: {SEC: ['γε']}, PL: {SEC: ['γετε', 'τε']}},
    IMPER_PASS_CONT_2D: {SG: {SEC: ['σο']}, PL: {SEC: ['σθε']}},
    IMPER_PASS_CONT_2E: {PL: {SEC: ['ασθε']}},
    IMPER_PASS_CONT_1: {PL: {SEC: ['εστε']}},
    IMPER_PASS_CONT_2A: {PL: {SEC: ['ιέστε']}},
    IMPER_PASS_CONT_2B: {PL: {SEC: ['είστε']}},
    IMPER_PASS_CONT_2C: {PL: {SEC: ['άστε']}},
    IMPER_PASS_CONT_2SA: {PL: {SEC: ['ούσθε']}},

    IMPER_ACT_AOR_A: {SG: {SEC: ['ε']}, PL: {SEC: ['τε']}},
    IMPER_ACT_AOR_B: {SG: {SEC: ['ε']}, PL: {SEC: ['ετε']}},
    IMPER_ACT_AOR_C: {SG: {SEC: ['ες']}, PL: {SEC: ['έστε', 'είτε']}},
    IMPER_ACT_AOR_D: {SG: {SEC: []}, PL: {SEC: ['είτε']}},

    IMPER_ACT_AOR_CA: {SG: {SEC: ['α']}, PL: {SEC: ['είτε']}},
    IMPER_PASS_AOR_A: {SG: {SEC: ['ου']}, PL: {SEC: ['είτε']}},
    IMPER_PASS_AOR_B: {PL: {SEC: ['είτε']}},
    PRESENT_ACTIVE_PART_1: {ND: {ND: ['οντας']}},
    PRESENT_ACTIVE_PART_EIMAI: {ND: {ND: ['όντας']}},
    PRESENT_ACTIVE_PART_2C: {ND: {ND: ['γοντας']}},
    PRESENT_ACTIVE_PART_2: {ND: {ND: ['ώντας']}},
    PRESENT_PASSIVE_PART_1: {SG: {ND: ['όμενος']}},
    PRESENT_PASSIVE_PART_2A: {SG: {ND: ['ώμενος']}},
    PRESENT_PASSIVE_PART_2AB: {SG: {ND: ['ώμενος']}},
    PRESENT_PASSIVE_PART_2B: {SG: {ND: ['ούμενος']}},
    PRESENT_PASSIVE_PART_2D: {SG: {ND: ['έμενος']}},
    PRESENT_PASSIVE_PART_2E: {SG: {ND: ['μενος']}},
    PAST_PASSIVE_PART: {SG: {ND: ['μένος']}},
    MODAL: None
}

irregular_imperative_forms = {
    'σηκωθ': {SG: {SEC: 'σήκω'}},
    'ακού': {SG: {SEC: 'άκου'}},
    'ακούσ': {SG: {SEC: 'άκου'}},
    'ανέβ': {SG: {SEC: 'ανέβα'}, PL: {SEC: 'ανεβείτε'}},
    'κατέβ': {SG: {SEC: 'κατέβα'}, PL: {SEC: 'κατεβείτε'}},
    'ανεβ': {SG: {SEC: 'ανέβα'}, PL: {SEC: 'ανεβείτε'}},
    'κατεβ': {SG: {SEC: 'κατέβα'}, PL: {SEC: 'κατεβείτε'}},
    "φύγ": {SG: {SEC: 'φεύγα'}, PL: {SEC: 'φευγάτε'}},
    "τρέξ": {SG: {SEC: 'τρέχα'}, PL: {SEC: 'τρεχάτε'}},
    "πλύν": {PL: {SEC: 'πλύντε'}},
    "πά": {SG: {SEC: 'πήγαινε'}, PL: {SEC: 'πηγαίνετε'}},
    "έρθ": {SG: {SEC: 'έλα'}, PL: {SEC: 'ελάτε'}},
    "έλθ": {SG: {SEC: 'έλα'}, PL: {SEC: 'ελάτε'}},
}

irregular_active_roots = \
    [['βρίθω', None], ['ξέρω', None],
     ['έχω', None],
     ['απέχω', None],
     ['οφείλω', None],
     ['εξέχω', None],
     ['ξέρω', None],
     ['στέκω', None],
     ['χρωστάω', None],
     ['χρωστώ', None],
     ['πρέπει', None],
     ['αξίζω', None],
     ['φρονώ', None],
     ['οπλομαχώ', None],
     ['εποφθαλμιώ', None],
     ['κραδαίνω', None],
     ['αναλογώ', None],
     ['λάμνω', None],
     ['μέλει', None],
     ['θαμπίζω', None],
     ['χάσκω', None],
     ['τυρβάζω', None],
     ['αδημονώ', None],
     ['αμερικανίζω', None],
     ['αδυνατώ', None],
     ['ελλείπω', None],
     ['νεοσσεύω', None],
     ['ρηγνύω', None],
     ['κωλύω', None],
     ['παιδιακίζω', None],
     ['σιαλίζω', None],
     ['προσήκω', None],
     ['χατίζω', None],
     ['ταλασιουργώ', None],
     ['ταυτογνωμώ', None],
     ['αγαθοφέρνω', None],
     ['μέλλει', None],
     ['θεόω', None], ['δ', 'δεήσ'],
     ['απάδω', None],
     ['ανεβαίν', 'ανέβ,ανεβ'], ['δέ', 'δεήσ'], ['περιμέν', 'περιμέν'], ['πον', 'πονέσ'], ['κατεβαίν', 'κατέβ,κατεβ'], ['αίρ', 'άρ'],
     ['βάλλ', 'βάλ'], ['απολαμβάν', 'απολαύσ'], ['λαμβάν', 'λάβ'], ['γέρν', 'γείρ'], ['χυμ', 'χυμήξ'],
     ['βάζ', 'βάλ'], ['βγάζ', 'βγάλ'], ['λαβαίν', 'λάβ'], ['αγγέλν', 'αγγείλ'], ['αγγέλλ', 'αγγείλ'],
     ['στάν', 'στήσ'], ['σταίν', 'στήσ'], ['πίπτ', 'πέσ'], ['φέρν', 'φέρ'], ['φεύγ', 'φύγ'], ['άγ', 'αγάγ'],
     ['γέρν', 'γεράσ'], ['πάσχ', 'πάθ'], ['σέρν', 'σύρ'], ['τέμν', 'τμήσ'], ['εφιστ', 'επιστήσ'],
     ['καθιστ', 'καταστήσ'], ['λανθάν', 'λάθ'], ['λαγχάνω', 'λάχ'], ['λαχαίν', 'λάχ'], ['αίρν', 'άρ'], ['αίρ', 'άρ'],
     ['δίν', 'δώσ'], ['δίδ', 'δώσ'], ['μέν', 'μείν'], ['στέλν', 'στείλ'], ['στέλλ', 'στείλ'], ['πλέν', 'πλύν'],
     ['βαίν', 'β'], ['βγαίν', 'βγ'], ['αυξάν', 'αυξήσ'], ['μεθ', 'μεθύσ'], ['σπέρν', 'σπείρ'], ['αλίσκ', 'αλώσ'],
     ['μπαίν', 'μπ'], ['μην', 'μηνύσ'], ['πλέ', 'πλεύσ'], ['πνέ', 'πνεύσ'], ['ρέ', 'ρεύσ'], ['βρίσκ', 'βρ'],
     ['πίν', 'πι'], ['τρώ', 'φά'], ['λέ', 'π'], ['λέγ', 'π,λέξ'], ['τρώγ', 'φάγ'], ['δέρν', 'δείρ'], ['κλίν', 'κλίν'],
     ['κάν', 'κάν'], ['μαθαίν', 'μάθ'], ['παθαίν', 'πάθ'], ['πεθαίν', 'πεθάν'], ['βλέπ', 'δ,ιδ'], ['θνήσκ', 'θάν'],
     ['τείν', 'τείν'], ['πέφτ', 'πέσ'], ['πέπτ', 'πέσ'], ['πηγαίν', 'πά'], ['τυχαίν', 'τύχ'], ['πετυχαίν', 'πετύχ'],
     ['τυγχάν', 'τύχ'], ['άσχ', 'ασχέσ'], ['τρέφ', 'θρέψ'], ['ελαύν', 'ελάσ'], ['κρέμ', 'κρεμάσ'], ['ευρίσκ', 'εύρ'],
     ['έχ', 'άσχ'], ['έλκ', 'έλκυσ'], ['θαρρ', 'θαρρέψ'], ['χέ', 'χύσ'], ['νιστ', 'στήσ'], ['ιστάν', 'αστήσ'],
     ['σπά', 'σπάσ'], ['θέλ', 'θελήσ'], ['κρίν', 'κρίν'], ['νέμ', 'νείμ'],
     ['δεικνύ', 'δείξ'], ['μειγνύ', 'μείξ'], ['ρηγνύ', 'ρήξ'], ['γιγνώσκ', 'γνώσ'], ['πηγνύ', 'πήξ'], ['τρώ', 'φά,φάγ'],
     ['τρώγ', 'φά,φάγ'], ['πά', 'πά'], ['φυλ', 'φυλάξ']
     ]



irregular_passive_roots = \
    [['υπέρκειμαι', None],
     ['πηγαινόρχομαι', None],
     ['πέρδομαι', None],
     ['επείγομαι', None],
     ['φύομαι', None],
     ['αγάλλομαι', None],
     ['ίπταμαι', None],
     ['φθέγγομαι', None],
     ['απόκειμαι', None],
     ['απόκειμαι', None],
     ['εναπόκειμαι', None],
     ['εναπόκειμαι', None],
     ['ανίπταμαι', None],
     ['κωλύομαι', None],
     ['πηγαινοέρχομαι', None],
     ['τεκμαίρομαι', None],
     ['ακκίζομαι', None],
     ['ευθύνομαι', None],
     ['οφείλομαι', None],
     ['απεχθάνομαι', None],
     ['μάχομαι', None], ['βάλλ', 'βληθ'], ['βάζ', 'βαλθ'], ['αίρ', 'αρθ'], ['βγάζ', 'βγαλθ'], ['λαμβάν', 'ληφθ'],
     ['πον', 'πονεθ'],
     ['ρήγνυ', 'ραγ,ρηχθ,ρηχτ'], ['ρηγνύ', 'ραγ,ρηχθ,ρηχτ'], ['αίρν', 'αρθ'], ['γράφ', 'γραφ,γραφτ'], ['αίρ', 'αρθ'],
     ['δέρν', 'δαρθ'], ['άσχ', 'ασχεθ'], ['καλ', 'κληθ'], ['εύχ', 'ευχηθ'], ['δίν', 'δοθ'], ['δίδ', 'δοθ'],
     ['δεικνύ', 'δειχθ'], ['τρίβ', 'τριβ,τριφτ,τριφθ'], ['κλέπτ', 'κλαπ,κλεφτ,κλεφθ'], ['φέρ', 'φερθ'],
     ['υπόσχ', 'υποσχεθ'], ['κόπτ', 'κοπ'], ['κόβ', 'κοπ'], ['ακού', 'ακουστ'], ['στέλν', 'σταλθ,σταλ'],
     ['στέλλ', 'σταλθ,σταλ'], ['πλέν', 'πλυθ'], ['έρχ', 'έλθ,έρθ,`ρθ,`λθ'], ['κάθ', 'καθίσ,κάτσ'], ['γίν', 'γίν'],
     ['καί', 'κα'], ['στέκ', 'σταθ'], ['στήν', 'σταθ'], ['οφείλ', 'οφεληθ'], ['πνίγ', 'πνιγ,πνιχτ,πνιχθ'],
     ['θέτ', 'τεθ'], ['θάβ', 'θαφτ,θαφθ,ταφ'], ['αλλάσσ', 'αλλαγ,αλλαχθ,αλλαχτ'], ['χέ','χυθ'],
     ['βλέπ', 'ιδωθ'], ['λέγ', 'ειπωθ,ιπωθ,λεγ'], ['τείν', 'ταθ'], ['φαίν', 'φαν'], ['σέρν', 'συρθ'],
     ['αυξάν', 'αυξηθ'], ['σπέρν', 'σπαρθ'], ['αλίσκ', 'αλωθ'], ['τρέφ', 'τραφ'], ['τέμν', 'τμηθ'], ['κρέμ', 'κρεμαστ'],
     ['βρίσκ', 'βρεθ'], ['τρώ', 'φαγωθ'], ['λέ', 'ειπωθ'], ['τρώγ', 'φαγωθ'], ['αφήν', 'αφεθ'], ['τρέπ', 'τραπ'],
     ['στρέφ', 'στραφ'], ['τίθε', 'τεθ'], ['σέβ', 'σεβαστ'], ['χαίρ', 'χαρ'], ['λέγ', 'λεγ'], ['θιστ', 'ταστ'],
     ['επαφίε', 'επαφεθ'], ['ρήγνυ', 'ραγ'], ['ίστ', 'αστ'], ['ιστ', 'αστ'], ['θίστ', 'ταστ'], ['έλκ', 'ελκυστ'],
     ['χέ', 'χυσθ'],
     ['νιστ', 'σταθ'], ['ελαύν', 'ελαθ'], ['ιστάν', 'ασταθ'], ['δεικνύ', 'δειχθ'], ['δείκνυ', 'δειχθ'],
     ['μειγνύ', 'μειχθ'], ['γιγνώσκ', 'γνωσθ'], ['πηγνύ', 'παγ'], ['ενδείκνυ', 'ενδειχθ'], ['ευρίσκ', 'ευρεθ'],
     ['τρώ', 'φαγωθ'], ['τρώγ', 'φαγωθ'], ['σπά', 'σπαστ'], ['φυλ', 'φυλαχτ'], ['άγ', 'αχθ'], ['φθείρ', 'φθαρ'],
     ['φθείρ', 'φθαρθ'], ['πλήττ', 'πλαγ,πληγ'], ['πλήσσ', 'πλαγ,πληγ'], ['σταίν', 'στ']
]

irregular_passive_perfect_participles = {'άγω': 'ηγμένος', 'έχομαι': None, 'αγανακτώ': 'αγανακτισμένος',
                                         'αποτυχαίνω': 'αποτυχημένος', 'κάνω': 'καμωμένος', 'λανθάνω': 'λανθασμένος',
                                         'αγαπάω': 'αγαπημένος', 'αγωνίζομαι': 'αγωνισμένος', 'κάμνω': 'καμωμένος',
                                         'δυστυχώ': 'δυστυχισμένος', 'ευτυχώ': 'ευτυχισμένος', 'θυμώνω': 'θυμωμένος',
                                         'αγοράζω': 'αγορασμένος', 'αφαιρώ': 'αφηρημένος', 'αισθάνομαι': 'αισθαμένος',
                                         'ακολουθώ': 'ακολουθημένος', 'ακούω': 'ακουσμένος', 'αλλάζω': 'αλλαγμένος',
                                         'ανάβω': 'αναμμένος', 'αναγκάζω': 'αναγκασμένος', 'ανήκω': None,
                                         'δίνω': 'δοσμένος', 'κάθομαι': 'καθισμένος', 'καίω': 'κεκαυμένος',
                                         'κλαίω': 'κλαμένος', 'βάλλω': 'βεβλημένος', 'θυμάμαι': 'θυμισμένος',
                                         'τρώω': 'φαγωμένος', 'στρέφω': 'στραμμένος', 'ανοίγω': 'ανοιγμένος',
                                         'αξίζω': None, 'απαγορεύω': 'απαγορευμένος', 'απαντάω': 'απαντημένος',
                                         'αποκτώ': 'αποκτημένος', 'απορώ': None, 'αποτελούμαι': 'αποτελεσμένος',
                                         'αποφασίζω': 'αποφασισμένος', 'αργώ': None, 'αρέσω': None,
                                         'βρέχω': 'βρεγμένος', 'αρχίζω': None, 'αστειεύομαι': None, 'αφήνω': 'αφημένος',
                                         'βάζω': 'βαλμένος', 'βάφω': 'βαμμένος', 'βαριέμαι': 'βαρεμένος',
                                         'βγάζω': 'βγαλμένος', 'βγαίνω': None, 'βιάζομαι': 'βιασμένος',
                                         'βλέπω': 'ιδωμένος', 'βοηθάω': 'βοηθημένος', 'βρίσκω': None,
                                         'βράζω': 'βρασμένος', 'γδύνω': 'γδυμένος', 'γελάω': 'γελασμένος',
                                         'γεμίζω': 'γεμισμένος', 'γεννάω': 'γεννημένος', 'γίνομαι': 'γινωμένος',
                                         'γκρινιάζω': None, 'γυρίζω': 'γυρισμένος',
                                         'δανείζω': 'δανεισμένος', 'δείχνω': 'δειγμένος', 'δένω': 'δεμένος',
                                         'δέχομαι': 'δεχτός, δεκτός', 'διαβάζω': 'διαβασμένος',
                                         'διαλέγω': 'διαλεγμένος', 'διαμαρτύρομαι': 'διαμαρτυρημένος', 'διαφωνώ': None,
                                         'διηγούμαι': 'διηγημένος', 'διορθώνω': 'διορθωμένος', 'διψάω': 'διψασμένος',
                                         'διώχνω': 'διωγμένος', 'δοκιμάζω': 'δοκιμασμένος', 'δουλεύω': None,
                                         'είμαι': None, 'εκφράζω': 'εκφρασμένος', 'ελπίζω': None,
                                         'εμφανίζομαι': 'εμφανισμένος', 'ενδιαφέρομαι': None, 'εξηγώ': 'εξηγημένος',
                                         'εξαφανίζομαι': 'εξαφανισμένος', 'επηρεάζω': 'επηρεασμένος',
                                         'επιτρέπω': 'επιτετραμμένος', 'έρχομαι': None, 'ετοιμάζω': 'ετοιμασμένος',
                                         'εύχομαι': None, 'έχω': None, 'ζεσταίνω': 'ζεσταμένος', 'ζηλεύω': 'ζηλεμένος',
                                         'ζητάω': 'ζητημένος', 'ζω': 'βιωμένος', 'θέλω': None,
                                         'καθαρίζω': 'καθαρισμένος', 'καλώ': 'καλεσμένος', 'καπνίζω': None,
                                         'καταλαβαίνω': None, 'καταστρέφω': 'κατεστραμμένος',
                                         'κατεβάζω': 'κατεβασμένος', 'κατεβαίνω': None, 'κερνάω': 'κερασμένος',
                                         'κλείνω': 'κλεισμένος', 'κόβω': 'κομμένος', 'κοιμάμαι': 'κοιμισμένος',
                                         'κοιτάζω': 'κοιταγμένος', 'κουράζω': 'κουρασμένος', 'κρατάω': 'κρατημένος',
                                         'κρύβω': 'κρυμμένος', 'λέω': 'ειπωμένος', 'λείπω': None, 'λύνω': 'λυμένος',
                                         'λυπάμαι': 'λυπημένος', 'μαγειρεύω': 'μαγειρεμένος', 'μαζεύω': 'μαζεμένος',
                                         'μαθαίνω': 'μαθημένος', 'μιμούμαι': None, 'μένω': None, 'μοιάζω': None,
                                         'μοιράζω': 'μοιρασμένος', 'μπαίνω': None, 'μπορώ': None, 'νικάω': 'νικημένος',
                                         'νοιάζομαι': 'νοιασμένος', 'νομίζω': None, 'ντρέπομαι': None,
                                         'ντύνω': 'ντυμένος', 'ξαπλώνω': 'ξαπλωμένος', 'ξεκινάω': 'ξεκινημένος',
                                         'ξέρω': None, 'ξεχνάω': 'ξεχασμένος', 'ξυπνάω': 'ξυπνημένος',
                                         'ξυρίζω': 'ξυρισμένος', 'οδηγώ': 'οδηγημένος', 'ονειρεύομαι': 'ονειρεμένος',
                                         'ονομάζω': 'ονομασμένος', 'οφείλω': None, 'πεθαίνω': 'πεθαμένος',
                                         'παίζω': None, 'παντρεύομαι': 'παντρεμένος',
                                         'παραγγέλνω': None, 'παραπονιέμαι': 'παραπονεμένος', 'παριστάνω': None,
                                         'παθαίνω': 'παθημένος', 'πάσχω': 'παθημένος', 'πείθω': 'πεπεισμένος',
                                         'πεινάω': 'πεινασμένος',
                                         'περιμένω': None, 'περνάω': 'περασμένος', 'περπατάω': 'περπατημένος',
                                         'πετυχαίνω': 'πετυχημένος', 'πετάω': 'πεταγμένος', 'πέφτω': 'πεσμένος',
                                         'πηγαίνω': None, 'πιάνω': 'πιασμένος', 'πιέζω': 'πιεσμένος',
                                         'πίνω': 'πιωμένος', 'πιστεύω': None, 'πλένω': 'πλυμένος',
                                         'πληρώνω': 'πληρωμένος', 'πονάω': 'πονεμένος', 'πουλάω': 'πουλημένος',
                                         'πρέπει': None, 'πρόκειται': None, 'προκύπτω': None,
                                         'προσθέτω': 'προστεθειμένος', 'προσέχω': None, 'προσποιούμαι': 'προσποιημένος',
                                         'προτείνω': 'προτεταμένος', 'προτιμάω': 'προτιμημένος', 'ράβω': 'ραμμένος',
                                         'ρίχνω': 'ριγμένος', 'ρωτάω': 'ρωτημένος', 'σβήνω': 'σβησμένος',
                                         'σέβομαι': 'σεβασμένος', 'σηκώνω': 'σηκωμένος', 'σημαίνω': None,
                                         'σκεπάζω': 'σκεπασμένος', 'σκέφτομαι': None, 'σκοτώνω': 'σκοτωμένος',
                                         'σκουπίζω': 'σκουπισμένος', 'σπουδάζω': 'σπουδασμένος', 'στέλνω': 'σταλμένος',
                                         'στενοχωριέμαι': 'στενοχωρημένος', 'συμμετέχω': None, 'συμπεριφέρομαι': None,
                                         'συμφωνώ': 'συμφωνημένος', 'στηρίζω': 'στηριγμένος',
                                         'συνηθίζω': 'συνηθισμένος', 'συστήνω': 'συστημένος', 'σώζω': 'σωσμένος',
                                         'ταξιδεύω': None, 'τρελαίνομαι': 'τρελαμένος', 'τρέχω': None, 'υπάρχω': None,
                                         'υποπτεύομαι': None, 'υπόσχομαι': 'υποσχεμένος', 'υποφέρω': 'υποσχεμένος',
                                         'υποψιάζομαι': 'υποψιασμένος', 'φαίνομαι': None, 'φαντάζομαι': 'φαντασμένος',
                                         'φέρνω': 'φερμένος', 'φεύγω': None, 'φοβάμαι': 'φοβισμένος',
                                         'φοράω': 'φορεμένος', 'στήν': 'στημένος',
                                         'φταίω': 'φοβημένος', 'φτάνω': None, 'φτιάχνω': 'φτιαγμένος', 'φωνάζω': None,
                                         'χαίρομαι': 'χαρούμενος', 'χαλάω': None, 'χάνω': 'χαμένος', 'χρειάζομαι': None,
                                         'χρησιμοποιώ': 'χρησιμοποιημένος', 'χρωστάω': None, 'χτυπάω': 'χτυπημένος',
                                         'χωράω': None, 'ψάχνω': 'ψαγμένος', 'ωφελώ': 'ωφελημένος',
                                         'θέτω': 'τεθειμένος', 'τίθεμαι': 'τεθειμένος'}

irregular_active_aorists = {'βαίνω': 'βηκα', 'μπαίνω': 'μπήκα', 'αίρω': 'ήρα', 'βγαίνω': 'βγήκα', 'βρίσκω': 'βρήκα',
                            'πηγαίνω': 'πήγα', 'παίρνω': 'πήρα', 'λέω': 'είπα', 'λέγω': 'είπα', 'πίνω': 'ήπια',
                            'τρώω': 'έφαγα', 'τρώγω': 'έφαγα', 'βλέπω': 'είδα', 'πάω': 'πήγα',
                            'καταλαβαίνω': 'κατάλαβα', 'καταλαμβάνω': 'κατέλαβα'}

irregular_active_paratatikos = {'πάω': 'πήγαινα', 'σπάω': 'σπαγα'}

irregular_passive_aorists = {'λέω': 'ειπώθηκα', 'λέγω': 'ειπώθηκα', 'βλέπω': 'ειδώθηκα', 'αίρομαι': 'άρθηκα'}

deponens_with_active_perf_forms = ['έρχομαι', 'κάθομαι', 'γίνομαι']