import enum
from _typeshed import Incomplete
from typing import Any, Dict, Iterator, List, Optional, Tuple

class BVType(enum.Enum):
    NULL: int
    BIGINT: int
    BOOL: int
    BYTES: int
    DATE: int
    FLOAT: int
    INTEGER: int
    INTERVAL: int
    JSON: int
    DECIMAL: int
    TEXT: int
    TIME: int
    TIMESTAMP: int
    UNKNOWN: int
    ARRAY: int
    INTEGERARRAY: int
    STRINGARRAY: int

class QueryResult:
    """The BV representation of a result of a query."""
    result_format: Incomplete
    def __init__(self) -> None: ...
    def has_results(self) -> bool: ...
    def column_count(self) -> None: ...
    def column(self, index: int) -> Tuple[str, BVType]: ...
    def rows(self) -> Iterator[List]: ...
    def status(self) -> str: ...

class Session:
    id: Incomplete
    def __init__(self) -> None: ...
    def cursor(self) -> None: ...
    def close(self) -> None: ...
    def execute_sql(self, sql: str, params: Incomplete | None = None) -> QueryResult: ...
    def in_transaction(self) -> bool: ...
    def load_df_function(self, table: str): ...

class Connection:
    """Translation layer from an upstream data source into the BV representation of a query result."""
    def __init__(self) -> None: ...
    def create_session(self) -> Session: ...
    def get_session(self, id: int) -> Optional[Session]: ...
    def close_session(self, session: Session): ...
    def new_session(self) -> Session: ...
    def parameters(self) -> Dict[str, str]: ...

class Extension:
    @classmethod
    def check_json(cls, payload: str) -> Optional[dict]: ...
    def type(self) -> str: ...
    def apply(self, params: dict, session: Session) -> QueryResult: ...

class SimpleQueryResult(QueryResult):
    name: Incomplete
    value: Incomplete
    type: Incomplete
    def __init__(self, name: str, value: Any, type: BVType) -> None: ...
    def has_results(self): ...
    def column_count(self): ...
    def column(self, index: int) -> Tuple[str, BVType]: ...
    def rows(self) -> Iterator[List]: ...
    def status(self) -> str: ...
