from typing import Any, ClassVar, Optional

import FGJSBBase
import FGLinearization
import _cython_3_0_5
import _jsbsim
import enum
import numpy
import typing
Optional: typing._SpecialForm
_append_xml: _cython_3_0_5.cython_function_or_method
get_default_root_dir: _cython_3_0_5.cython_function_or_method

class BaseError(RuntimeError): ...

class FGAerodynamics:
    __pyx_vtable__: ClassVar[PyCapsule] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    def get_forces(self) -> numpy.ndarray: ...
    def get_moments_MRC(self) -> numpy.ndarray: ...
    def __bool__(self) -> bool: ...
    def __reduce__(self) -> Any: ...
    def __setstate__(self, state) -> Any: ...

class FGAircraft:
    __pyx_vtable__: ClassVar[PyCapsule] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    def get_xyz_rp(self) -> numpy.ndarray: ...
    def __bool__(self) -> bool: ...
    def __reduce__(self) -> Any: ...
    def __setstate__(self, state) -> Any: ...

class FGAtmosphere:
    __pyx_vtable__: ClassVar[PyCapsule] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    def get_temperature(self, doubleh: float) -> float: ...
    def set_pressure_SL(self, unit: ePressure, doublep: float) -> None: ...
    def set_temperature(self, doublet: float, doubleh: float, unit: eTemperature) -> None: ...
    def __bool__(self) -> bool: ...
    def __reduce__(self) -> Any: ...
    def __setstate__(self, state) -> Any: ...

class FGAuxiliary:
    __pyx_vtable__: ClassVar[PyCapsule] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    def get_Tb2w(self) -> numpy.ndarray: ...
    def get_Tw2b(self) -> numpy.ndarray: ...
    def __bool__(self) -> bool: ...
    def __reduce__(self) -> Any: ...
    def __setstate__(self, state) -> Any: ...

class FGEngine:
    __pyx_vtable__: ClassVar[PyCapsule] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    def init_running(self) -> int: ...
    def __bool__(self) -> bool: ...
    def __reduce__(self) -> Any: ...
    def __setstate__(self, state) -> Any: ...

class FGFDMExec(_jsbsim.FGJSBBase):
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    def check_incremental_hold(self) -> None: ...
    def disable_output(self) -> None: ...
    def do_trim(self, intmode: int) -> None: ...
    def enable_increment_then_hold(self, inttime_steps: int) -> None: ...
    def enable_output(self) -> None: ...
    def get_aerodynamics(self) -> FGAerodynamics: ...
    def get_aircraft(self) -> FGAircraft: ...
    def get_aircraft_path(self) -> str: ...
    def get_atmosphere(self) -> FGAtmosphere: ...
    def get_auxiliary(self) -> FGAuxiliary: ...
    def get_debug_level(self) -> int: ...
    def get_delta_t(self) -> float: ...
    def get_engine_path(self) -> str: ...
    def get_full_aircraft_path(self) -> str: ...
    def get_ground_reactions(self) -> FGGroundReactions: ...
    def get_mass_balance(self) -> FGMassBalance: ...
    def get_model_name(self) -> str: ...
    def get_output_filename(self, intn: int) -> str: ...
    def get_output_path(self) -> str: ...
    def get_propagate(self) -> FGPropagate: ...
    def get_property_catalog(self) -> list[str]: ...
    def get_property_manager(self) -> FGPropertyManager: ...
    def get_property_value(self, unicodename: str) -> float: ...
    def get_propulsion(self) -> FGPropulsion: ...
    def get_propulsion_tank_report(self) -> str: ...
    def get_root_dir(self) -> str: ...
    def get_sim_time(self) -> float: ...
    def get_systems_path(self) -> str: ...
    def get_trim_status(self) -> bool: ...
    def hold(self) -> None: ...
    def holding(self) -> bool: ...
    def incr_time(self) -> float: ...
    def integration_suspended(self) -> bool: ...
    def load_ic(self, unicoderstfile: str, booluseAircraftPath: bool) -> bool: ...
    def load_model(self, unicodemodel: str, booladd_model_to_path: bool = ...) -> bool: ...
    def load_model_with_paths(self, unicodemodel: str, unicodeaircraft_path: str, unicodeengine_path: str, unicodesystems_path: str, booladd_model_to_path: bool = ...) -> bool: ...
    def load_planet(self, unicodeplanet_path: str, booluseAircraftPath: bool) -> bool: ...
    def load_script(self, unicodescript: str, doubledelta_t: float = ..., unicodeinitfile: str = ...) -> bool: ...
    def print_property_catalog(self) -> None: ...
    def print_simulation_configuration(self) -> None: ...
    def query_property_catalog(self, unicodecheck: str) -> str: ...
    def reset_to_initial_conditions(self, intmode: int) -> None: ...
    def resume(self) -> None: ...
    def resume_integration(self) -> None: ...
    def run(self) -> bool: ...
    def run_ic(self) -> bool: ...
    def set_aircraft_path(self, unicodepath: str) -> bool: ...
    def set_debug_level(self, intlevel: int) -> None: ...
    def set_dt(self, doubledt: float) -> None: ...
    def set_engine_path(self, unicodepath: str) -> bool: ...
    def set_logging_rate(self, doublerate: float) -> None: ...
    def set_output_directive(self, unicodefname: str) -> bool: ...
    def set_output_filename(self, intn: int, unicodefname: str) -> bool: ...
    def set_output_path(self, unicodepath: str) -> bool: ...
    def set_property_value(self, unicodename: str, doublevalue: float) -> None: ...
    def set_root_dir(self, unicodepath: str) -> None: ...
    def set_sim_time(self, doubletime: float) -> bool: ...
    def set_systems_path(self, unicodepath: str) -> bool: ...
    def set_trim_status(self, boolstatus: bool) -> None: ...
    def suspend_integration(self) -> None: ...
    def __delitem__(self, other) -> Any: ...
    def __getitem__(self, index) -> Any: ...
    def __reduce__(self) -> Any: ...
    def __setitem__(self, index, object) -> None: ...
    def __setstate__(self, state) -> Any: ...

class FGGroundReactions:
    __pyx_vtable__: ClassVar[PyCapsule] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    def get_gear_unit(self, intgear: int) -> FGLGear: ...
    def get_num_gear_units(self) -> int: ...
    def __bool__(self) -> bool: ...
    def __reduce__(self) -> Any: ...
    def __setstate__(self, state) -> Any: ...

class FGJSBBase:
    debug_lvl: FGJSBBase.debug_lvl
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    def disable_highlighting(self) -> None: ...
    def get_version(self) -> str: ...
    def __reduce__(self) -> Any: ...
    def __setstate__(self, state) -> Any: ...

class FGLGear:
    __pyx_vtable__: ClassVar[PyCapsule] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    def get_acting_location(self) -> numpy.ndarray: ...
    def get_body_x_force(self) -> float: ...
    def get_body_y_force(self) -> float: ...
    def get_body_z_force(self) -> float: ...
    def get_location(self) -> numpy.ndarray: ...
    def get_steer_norm(self) -> float: ...
    def __bool__(self) -> bool: ...
    def __reduce__(self) -> Any: ...
    def __setstate__(self, state) -> Any: ...

class FGLinearization:
    __pyx_vtable__: ClassVar[PyCapsule] = ...
    feedforward_matrix: FGLinearization.feedforward_matrix
    input_matrix: FGLinearization.input_matrix
    output_matrix: FGLinearization.output_matrix
    state_space: FGLinearization.state_space
    system_matrix: FGLinearization.system_matrix
    u0: FGLinearization.u0
    u_names: FGLinearization.u_names
    u_units: FGLinearization.u_units
    x0: FGLinearization.x0
    x_names: FGLinearization.x_names
    x_units: FGLinearization.x_units
    y0: FGLinearization.y0
    y_names: FGLinearization.y_names
    y_units: FGLinearization.y_units
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    def write_scicoslab(self, unicodepath: str) -> None: ...
    def __bool__(self) -> bool: ...
    def __reduce__(self) -> Any: ...
    def __setstate__(self, state) -> Any: ...

class FGMassBalance:
    __pyx_vtable__: ClassVar[PyCapsule] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    def get_J(self) -> numpy.ndarray: ...
    def get_Jinv(self) -> numpy.ndarray: ...
    def get_xyz_cg(self) -> numpy.ndarray: ...
    def __bool__(self) -> bool: ...
    def __reduce__(self) -> Any: ...
    def __setstate__(self, state) -> Any: ...

class FGPropagate:
    __pyx_vtable__: ClassVar[PyCapsule] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    def get_Tec2b(self) -> numpy.ndarray: ...
    def get_Tl2b(self) -> numpy.ndarray: ...
    def get_uvw(self) -> numpy.ndarray: ...
    def __bool__(self) -> bool: ...
    def __reduce__(self) -> Any: ...
    def __setstate__(self, state) -> Any: ...

class FGPropertyManager:
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    def get_node(self, unicodepath: Optional[str] = ..., boolcreate: bool = ...) -> Optional[FGPropertyNode]: ...
    def hasNode(self, unicodepath: str) -> bool: ...
    def __reduce__(self) -> Any: ...
    def __setstate__(self, state) -> Any: ...

class FGPropertyNode:
    __pyx_vtable__: ClassVar[PyCapsule] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    def get_double_value(self) -> float: ...
    def get_fully_qualified_name(self) -> str: ...
    def get_name(self) -> str: ...
    def get_node(self, unicodepath: str, boolcreate: bool = ...) -> Optional[FGPropertyNode]: ...
    def set_double_value(self, doublevalue: float) -> None: ...
    def __bool__(self) -> bool: ...
    def __reduce__(self) -> Any: ...
    def __setstate__(self, state) -> Any: ...

class FGPropulsion:
    __pyx_vtable__: ClassVar[PyCapsule] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    def get_engine(self, intidx: int) -> FGEngine: ...
    def get_num_engines(self) -> int: ...
    def get_steady_state(self) -> bool: ...
    def init_running(self, intn: int) -> None: ...
    def __bool__(self) -> bool: ...
    def __reduce__(self) -> Any: ...
    def __setstate__(self, state) -> Any: ...

class GeographicError(_jsbsim.BaseError): ...

class TrimFailureError(_jsbsim.BaseError): ...

class ePressure(enum.Enum):
    class _member_type_:
        def __init__(self, *args, **kwargs) -> None: ...
        def __delattr__(self, name) -> Any: ...
        def __dir__(self) -> Any: ...
        def __eq__(self, other) -> bool: ...
        def __format__(self, *args, **kwargs) -> Any: ...
        def __ge__(self, other) -> bool: ...
        def __gt__(self, other) -> bool: ...
        def __hash__(self) -> int: ...
        @classmethod
        def __init_subclass__(cls, *args, **kwargs) -> Any: ...
        def __le__(self, other) -> bool: ...
        def __lt__(self, other) -> bool: ...
        def __ne__(self, other) -> bool: ...
        def __reduce__(self) -> Any: ...
        def __reduce_ex__(self, protocol) -> Any: ...
        def __setattr__(self, name, value) -> Any: ...
        def __sizeof__(self) -> int: ...
        @classmethod
        def __subclasshook__(cls, *args, **kwargs) -> Any: ...
    __new__: ClassVar[function] = ...
    _generate_next_value_: ClassVar[function] = ...
    _member_map_: ClassVar[dict] = ...
    _member_names_: ClassVar[list] = ...
    _value2member_map_: ClassVar[dict] = ...
    eInchesHg: ClassVar[_jsbsim.ePressure] = ...
    eMillibars: ClassVar[_jsbsim.ePressure] = ...
    eNoPressUnit: ClassVar[_jsbsim.ePressure] = ...
    ePSF: ClassVar[_jsbsim.ePressure] = ...
    ePascals: ClassVar[_jsbsim.ePressure] = ...

class eTemperature(enum.Enum):
    class _member_type_:
        def __init__(self, *args, **kwargs) -> None: ...
        def __delattr__(self, name) -> Any: ...
        def __dir__(self) -> Any: ...
        def __eq__(self, other) -> bool: ...
        def __format__(self, *args, **kwargs) -> Any: ...
        def __ge__(self, other) -> bool: ...
        def __gt__(self, other) -> bool: ...
        def __hash__(self) -> int: ...
        @classmethod
        def __init_subclass__(cls, *args, **kwargs) -> Any: ...
        def __le__(self, other) -> bool: ...
        def __lt__(self, other) -> bool: ...
        def __ne__(self, other) -> bool: ...
        def __reduce__(self) -> Any: ...
        def __reduce_ex__(self, protocol) -> Any: ...
        def __setattr__(self, name, value) -> Any: ...
        def __sizeof__(self) -> int: ...
        @classmethod
        def __subclasshook__(cls, *args, **kwargs) -> Any: ...
    __new__: ClassVar[function] = ...
    _generate_next_value_: ClassVar[function] = ...
    _member_map_: ClassVar[dict] = ...
    _member_names_: ClassVar[list] = ...
    _value2member_map_: ClassVar[dict] = ...
    eCelsius: ClassVar[_jsbsim.eTemperature] = ...
    eFahrenheit: ClassVar[_jsbsim.eTemperature] = ...
    eKelvin: ClassVar[_jsbsim.eTemperature] = ...
    eNoTempUnit: ClassVar[_jsbsim.eTemperature] = ...
    eRankine: ClassVar[_jsbsim.eTemperature] = ...
