# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: nillion/nada/v1/mir.proto
# plugin: python-betterproto
# This file has been @generated

from dataclasses import dataclass
from typing import (
    Dict,
    List,
)

import betterproto

from ...operations import v1 as __operations_v1__
from ...types import v1 as __types_v1__


@dataclass(eq=False, repr=False)
class OperationMapEntry(betterproto.Message):
    id: int = betterproto.uint64_field(1)
    """id"""

    operation: "__operations_v1__.Operation" = betterproto.message_field(2)
    """Value"""


@dataclass(eq=False, repr=False)
class NadaFunctionArg(betterproto.Message):
    name: str = betterproto.string_field(1)
    """Argument name"""

    type: "__types_v1__.NadaType" = betterproto.message_field(2)
    """Argument type"""

    source_ref_index: int = betterproto.uint64_field(3)
    """Source code info about this element."""


@dataclass(eq=False, repr=False)
class NadaFunction(betterproto.Message):
    id: int = betterproto.uint64_field(1)
    """Function identifier"""

    args: List["NadaFunctionArg"] = betterproto.message_field(2)
    """Function arguments"""

    name: str = betterproto.string_field(3)
    """The name of the function"""

    operations: List["OperationMapEntry"] = betterproto.message_field(4)
    """
    Table of operations, we use repeated OperationMapEntry ordered by id to have deterministic compilation
    """

    return_operation_id: int = betterproto.uint64_field(5)
    """
    Identifier of the operation (in the operations map) that represents
     the return of this function
    """

    return_type: "__types_v1__.NadaType" = betterproto.message_field(6)
    """Function return type"""

    source_ref_index: int = betterproto.uint64_field(7)
    """NadaFunction source file information."""


@dataclass(eq=False, repr=False)
class Party(betterproto.Message):
    name: str = betterproto.string_field(1)
    """Name of the party"""

    source_ref_index: int = betterproto.uint64_field(2)
    """Source reference"""


@dataclass(eq=False, repr=False)
class Input(betterproto.Message):
    type: "__types_v1__.NadaType" = betterproto.message_field(1)
    """Operation type"""

    party: str = betterproto.string_field(2)
    """Party that contains this input"""

    name: str = betterproto.string_field(3)
    """Input name"""

    doc: str = betterproto.string_field(4)
    """The documentation."""

    source_ref_index: int = betterproto.uint64_field(5)
    """Source file info related with this operation."""


@dataclass(eq=False, repr=False)
class Literal(betterproto.Message):
    name: str = betterproto.string_field(2)
    """Name"""

    value: str = betterproto.string_field(3)
    """Value"""

    type: "__types_v1__.NadaType" = betterproto.message_field(4)
    """Type"""


@dataclass(eq=False, repr=False)
class SourceRef(betterproto.Message):
    file: str = betterproto.string_field(1)
    """Nada-lang file that contains the elements"""

    lineno: int = betterproto.uint32_field(2)
    """Line number into the file that contains the element"""

    offset: int = betterproto.uint32_field(3)
    """Element's offset into the file"""

    length: int = betterproto.uint32_field(4)
    """Element's length into the file"""


@dataclass(eq=False, repr=False)
class Output(betterproto.Message):
    name: str = betterproto.string_field(1)
    """Output name"""

    operation_id: int = betterproto.uint64_field(2)
    """Output operation ID"""

    party: str = betterproto.string_field(3)
    """Party contains this output"""

    type: "__types_v1__.NadaType" = betterproto.message_field(4)
    """Output type"""

    source_ref_index: int = betterproto.uint64_field(5)
    """Source file info related with this output."""


@dataclass(eq=False, repr=False)
class ProgramMir(betterproto.Message):
    """
    The Program MIR.
     This is the container of all the MIR representation for a program.
    """

    functions: List["NadaFunction"] = betterproto.message_field(1)
    """List of the functions are used by the program"""

    parties: List["Party"] = betterproto.message_field(2)
    """Program parties"""

    inputs: List["Input"] = betterproto.message_field(3)
    """Program inputs"""

    literals: List["Literal"] = betterproto.message_field(4)
    """Program literals"""

    outputs: List["Output"] = betterproto.message_field(5)
    """Program output"""

    operations: List["OperationMapEntry"] = betterproto.message_field(6)
    """
    Table of operations, we use repeated OperationMapEntry ordered by id to have deterministic compilation
    """

    source_files: Dict[str, str] = betterproto.map_field(
        7, betterproto.TYPE_STRING, betterproto.TYPE_STRING
    )
    """Source file info related with the program."""

    source_refs: List["SourceRef"] = betterproto.message_field(8)
    """Array of source references"""
