# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: nillion/nada/v1/operations.proto
# plugin: python-betterproto
# This file has been @generated

from dataclasses import dataclass
from typing import List

import betterproto
import betterproto.lib.google.protobuf as betterproto_lib_google_protobuf

from ...types import v1 as __types_v1__


class BinaryOperationVariant(betterproto.Enum):
    """The variant of the binary operation."""

    ADDITION = 0
    """Addition operation variant"""

    SUBTRACTION = 1
    """Addition operation variant"""

    MULTIPLICATION = 2
    """Multiplication operation variant"""

    LESS_THAN = 3
    """Less-than comparison operation variant"""

    LESS_EQ = 4
    """Less-or-equal-than comparison operation variant"""

    GREATER_THAN = 5
    """Greater-than comparison operation variant"""

    GREATER_EQ = 6
    """Greater-or-equal-than comparison operation variant"""

    EQUALS_PUBLIC_OUTPUT = 7
    """Equals public output comparison operation variant"""

    EQUALS = 8
    """
    Equals comparison operation variant also public-public
     comparisons
    """

    MODULO = 9
    """Modulo operation variant"""

    POWER = 10
    """Power operation variant"""

    DIVISION = 11
    """Division operation variant"""

    LEFT_SHIFT = 12
    """Left Shift operation variant"""

    RIGHT_SHIFT = 13
    """Right Shift operation variant"""

    TRUNC_PR = 14
    """Probabilistic truncation operation variant"""

    NOT_EQUALS = 15
    """Not equals operation"""

    BOOL_AND = 16
    """Boolean AND operation variant"""

    BOOL_OR = 17
    """Boolean OR operation variant"""

    BOOL_XOR = 18
    """Boolean XOR operation variant"""

    ZIP = 19
    """Zip operation variant"""

    INNER_PRODUCT = 20
    """Inner product operation variant"""

    ECDSA_SIGN = 21
    """ECDSA sign operation variant"""


class UnaryOperationVariant(betterproto.Enum):
    """The variant of the binary operation."""

    UNZIP = 0
    """Unzip operation variant"""

    REVEAL = 1
    """Reveal operation variant"""

    NOT = 2
    """Not operation variant"""


class TupleIndex(betterproto.Enum):
    LEFT = 0
    """The left element of the tuple"""

    RIGHT = 1
    """The right element of the tuple"""


@dataclass(eq=False, repr=False)
class BinaryOperation(betterproto.Message):
    """
    MIR Binary operation.
     Basically most arithmetic operations: Addition, Subtraction
     Division, Modulo, Power, etc.
    """

    variant: "BinaryOperationVariant" = betterproto.enum_field(1)
    """Operation variant"""

    left: int = betterproto.uint64_field(2)
    """Left operand of the operation"""

    right: int = betterproto.uint64_field(3)
    """Right operand of the operation"""


@dataclass(eq=False, repr=False)
class UnaryOperation(betterproto.Message):
    """
    Represents a MIR Unary operation:
     - Cast
     - Not
     - Reveal
     - Unzip
    """

    variant: "UnaryOperationVariant" = betterproto.enum_field(1)
    """Operation variant"""

    this: int = betterproto.uint64_field(2)
    """The operand of the operation"""


@dataclass(eq=False, repr=False)
class IfElseOperation(betterproto.Message):
    cond: int = betterproto.uint64_field(1)
    """operand of the conditional operation"""

    first: int = betterproto.uint64_field(2)
    """operand of the first operation"""

    second: int = betterproto.uint64_field(3)
    """operand of the second operation"""


@dataclass(eq=False, repr=False)
class InputReference(betterproto.Message):
    """
    Input reference structure, can be used for:
     - Input
     - Literal
     Also, it is used to describe the nada function arguments.
    """

    refers_to: str = betterproto.string_field(1)
    """Index of the input/literal operation referred by this operation"""


@dataclass(eq=False, repr=False)
class LiteralReference(betterproto.Message):
    refers_to: str = betterproto.string_field(1)
    """Literal refers to"""


@dataclass(eq=False, repr=False)
class MapOperation(betterproto.Message):
    fn: int = betterproto.uint64_field(1)
    """Function to execute"""

    child: int = betterproto.uint64_field(2)
    """Map operation child"""


@dataclass(eq=False, repr=False)
class ReduceOperation(betterproto.Message):
    fn: int = betterproto.uint64_field(1)
    """Function to execute"""

    child: int = betterproto.uint64_field(2)
    """Reduce operation child"""

    initial: int = betterproto.uint64_field(3)
    """Initial accumulator value"""


@dataclass(eq=False, repr=False)
class NewOperation(betterproto.Message):
    elements: List[int] = betterproto.uint64_field(1)
    """The elements of this compound type"""


@dataclass(eq=False, repr=False)
class ArrayAccessor(betterproto.Message):
    index: int = betterproto.uint32_field(1)
    """
    array index - for now an integer but eventually it could be the result of
     an operation
    """

    source: int = betterproto.uint64_field(2)
    """source - The Operation that represents the array we are accessing"""


@dataclass(eq=False, repr=False)
class TupleAccessor(betterproto.Message):
    index: "TupleIndex" = betterproto.enum_field(1)
    """tuple index (left or right)"""

    source: int = betterproto.uint64_field(2)
    """source - The Operation that represents the tuple we are accessing"""


@dataclass(eq=False, repr=False)
class NtupleAccessor(betterproto.Message):
    index: int = betterproto.uint32_field(1)
    """tuple index (left or right)"""

    source: int = betterproto.uint64_field(2)
    """source - The Operation that represents the tuple we are accessing"""


@dataclass(eq=False, repr=False)
class ObjectAccessor(betterproto.Message):
    key: str = betterproto.string_field(1)
    """object key"""

    source: int = betterproto.uint64_field(2)
    """source - The Operation that represents the object we are accessing"""


@dataclass(eq=False, repr=False)
class NadaFunctionArgRef(betterproto.Message):
    function_id: int = betterproto.uint64_field(1)
    """Function owner of this argument"""

    refers_to: str = betterproto.string_field(2)
    """Refers to the argument"""


@dataclass(eq=False, repr=False)
class CastOperation(betterproto.Message):
    target: int = betterproto.uint64_field(1)
    """The operand of the operation"""

    cast_to: "__types_v1__.NadaType" = betterproto.message_field(2)
    """The type to cast to"""


@dataclass(eq=False, repr=False)
class Operation(betterproto.Message):
    """
    The Operation.
     An operation is identified by:
     - The operation variant
    """

    id: int = betterproto.uint64_field(1)
    """Operation identifier"""

    type: "__types_v1__.NadaType" = betterproto.message_field(2)
    """The output type of the operation"""

    source_ref_index: int = betterproto.uint64_field(3)
    """Source file info related with this operation."""

    binary: "BinaryOperation" = betterproto.message_field(4, group="operation")
    unary: "UnaryOperation" = betterproto.message_field(5, group="operation")
    ifelse: "IfElseOperation" = betterproto.message_field(6, group="operation")
    random: "betterproto_lib_google_protobuf.Empty" = betterproto.message_field(
        7, group="operation"
    )
    input_ref: "InputReference" = betterproto.message_field(8, group="operation")
    literal_ref: "LiteralReference" = betterproto.message_field(9, group="operation")
    arg_ref: "NadaFunctionArgRef" = betterproto.message_field(10, group="operation")
    map: "MapOperation" = betterproto.message_field(11, group="operation")
    reduce: "ReduceOperation" = betterproto.message_field(12, group="operation")
    new: "NewOperation" = betterproto.message_field(13, group="operation")
    array_accessor: "ArrayAccessor" = betterproto.message_field(14, group="operation")
    tuple_accessor: "TupleAccessor" = betterproto.message_field(15, group="operation")
    ntuple_accessor: "NtupleAccessor" = betterproto.message_field(16, group="operation")
    object_accessor: "ObjectAccessor" = betterproto.message_field(17, group="operation")
    cast: "CastOperation" = betterproto.message_field(18, group="operation")
