import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface BackupProtectedVmConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/backup_protected_vm.html#backup_policy_id BackupProtectedVm#backup_policy_id}.
     *
     * @stability stable
     */
    readonly backupPolicyId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/backup_protected_vm.html#exclude_disk_luns BackupProtectedVm#exclude_disk_luns}.
     *
     * @stability stable
     */
    readonly excludeDiskLuns?: number[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/backup_protected_vm.html#include_disk_luns BackupProtectedVm#include_disk_luns}.
     *
     * @stability stable
     */
    readonly includeDiskLuns?: number[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/backup_protected_vm.html#recovery_vault_name BackupProtectedVm#recovery_vault_name}.
     *
     * @stability stable
     */
    readonly recoveryVaultName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/backup_protected_vm.html#resource_group_name BackupProtectedVm#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/backup_protected_vm.html#source_vm_id BackupProtectedVm#source_vm_id}.
     *
     * @stability stable
     */
    readonly sourceVmId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/backup_protected_vm.html#tags BackupProtectedVm#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/backup_protected_vm.html#timeouts BackupProtectedVm#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: BackupProtectedVmTimeouts;
}
/**
 * @stability stable
 */
export interface BackupProtectedVmTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/backup_protected_vm.html#create BackupProtectedVm#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/backup_protected_vm.html#delete BackupProtectedVm#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/backup_protected_vm.html#read BackupProtectedVm#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/backup_protected_vm.html#update BackupProtectedVm#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function backupProtectedVmTimeoutsToTerraform(struct?: BackupProtectedVmTimeoutsOutputReference | BackupProtectedVmTimeouts): any;
/**
 * @stability stable
 */
export declare class BackupProtectedVmTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): BackupProtectedVmTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: BackupProtectedVmTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/backup_protected_vm.html azurerm_backup_protected_vm}.
 *
 * @stability stable
 */
export declare class BackupProtectedVm extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/backup_protected_vm.html azurerm_backup_protected_vm} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: BackupProtectedVmConfig);
    private _backupPolicyId?;
    /**
     * @stability stable
     */
    get backupPolicyId(): string;
    /**
     * @stability stable
     */
    set backupPolicyId(value: string);
    /**
     * @stability stable
     */
    get backupPolicyIdInput(): string | undefined;
    private _excludeDiskLuns?;
    /**
     * @stability stable
     */
    get excludeDiskLuns(): number[];
    /**
     * @stability stable
     */
    set excludeDiskLuns(value: number[]);
    /**
     * @stability stable
     */
    resetExcludeDiskLuns(): void;
    /**
     * @stability stable
     */
    get excludeDiskLunsInput(): number[] | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _includeDiskLuns?;
    /**
     * @stability stable
     */
    get includeDiskLuns(): number[];
    /**
     * @stability stable
     */
    set includeDiskLuns(value: number[]);
    /**
     * @stability stable
     */
    resetIncludeDiskLuns(): void;
    /**
     * @stability stable
     */
    get includeDiskLunsInput(): number[] | undefined;
    private _recoveryVaultName?;
    /**
     * @stability stable
     */
    get recoveryVaultName(): string;
    /**
     * @stability stable
     */
    set recoveryVaultName(value: string);
    /**
     * @stability stable
     */
    get recoveryVaultNameInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _sourceVmId?;
    /**
     * @stability stable
     */
    get sourceVmId(): string;
    /**
     * @stability stable
     */
    set sourceVmId(value: string);
    /**
     * @stability stable
     */
    get sourceVmIdInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): BackupProtectedVmTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: BackupProtectedVmTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): BackupProtectedVmTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
