import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataAzurermDataFactoryConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/data_factory.html#name DataAzurermDataFactory#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/data_factory.html#resource_group_name DataAzurermDataFactory#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/data_factory.html#timeouts DataAzurermDataFactory#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataAzurermDataFactoryTimeouts;
}
/**
 * @stability stable
 */
export declare class DataAzurermDataFactoryGithubConfiguration extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get accountName(): string;
    /**
     * @stability stable
     */
    get branchName(): string;
    /**
     * @stability stable
     */
    get gitUrl(): string;
    /**
     * @stability stable
     */
    get repositoryName(): string;
    /**
     * @stability stable
     */
    get rootFolder(): string;
}
/**
 * @stability stable
 */
export declare class DataAzurermDataFactoryIdentity extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get identityIds(): string[];
    /**
     * @stability stable
     */
    get principalId(): string;
    /**
     * @stability stable
     */
    get tenantId(): string;
    /**
     * @stability stable
     */
    get type(): string;
}
/**
 * @stability stable
 */
export declare class DataAzurermDataFactoryVstsConfiguration extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get accountName(): string;
    /**
     * @stability stable
     */
    get branchName(): string;
    /**
     * @stability stable
     */
    get projectName(): string;
    /**
     * @stability stable
     */
    get repositoryName(): string;
    /**
     * @stability stable
     */
    get rootFolder(): string;
    /**
     * @stability stable
     */
    get tenantId(): string;
}
/**
 * @stability stable
 */
export interface DataAzurermDataFactoryTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/data_factory.html#read DataAzurermDataFactory#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataAzurermDataFactoryTimeoutsToTerraform(struct?: DataAzurermDataFactoryTimeoutsOutputReference | DataAzurermDataFactoryTimeouts): any;
/**
 * @stability stable
 */
export declare class DataAzurermDataFactoryTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzurermDataFactoryTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzurermDataFactoryTimeouts | undefined);
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/data_factory.html azurerm_data_factory}.
 *
 * @stability stable
 */
export declare class DataAzurermDataFactory extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/data_factory.html azurerm_data_factory} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataAzurermDataFactoryConfig);
    /**
     * @stability stable
     */
    githubConfiguration(index: string): DataAzurermDataFactoryGithubConfiguration;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    identity(index: string): DataAzurermDataFactoryIdentity;
    /**
     * @stability stable
     */
    get location(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    /**
     * @stability stable
     */
    tags(key: string): string;
    /**
     * @stability stable
     */
    vstsConfiguration(index: string): DataAzurermDataFactoryVstsConfiguration;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataAzurermDataFactoryTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataAzurermDataFactoryTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataAzurermDataFactoryTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
