import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataAzurermVpnGatewayConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/vpn_gateway.html#name DataAzurermVpnGateway#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/vpn_gateway.html#resource_group_name DataAzurermVpnGateway#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/vpn_gateway.html#timeouts DataAzurermVpnGateway#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataAzurermVpnGatewayTimeouts;
}
/**
 * @stability stable
 */
export declare class DataAzurermVpnGatewayBgpSettingsInstance0BgpPeeringAddress extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get customIps(): string[];
    /**
     * @stability stable
     */
    get defaultIps(): string[];
    /**
     * @stability stable
     */
    get ipConfigurationId(): string;
    /**
     * @stability stable
     */
    get tunnelIps(): string[];
}
/**
 * @stability stable
 */
export declare class DataAzurermVpnGatewayBgpSettingsInstance1BgpPeeringAddress extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get customIps(): string[];
    /**
     * @stability stable
     */
    get defaultIps(): string[];
    /**
     * @stability stable
     */
    get ipConfigurationId(): string;
    /**
     * @stability stable
     */
    get tunnelIps(): string[];
}
/**
 * @stability stable
 */
export declare class DataAzurermVpnGatewayBgpSettings extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get asn(): number;
    /**
     * @stability stable
     */
    get bgpPeeringAddress(): string;
    /**
     * @stability stable
     */
    get instance0BgpPeeringAddress(): any;
    /**
     * @stability stable
     */
    get instance1BgpPeeringAddress(): any;
    /**
     * @stability stable
     */
    get peerWeight(): number;
}
/**
 * @stability stable
 */
export interface DataAzurermVpnGatewayTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/vpn_gateway.html#read DataAzurermVpnGateway#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataAzurermVpnGatewayTimeoutsToTerraform(struct?: DataAzurermVpnGatewayTimeoutsOutputReference | DataAzurermVpnGatewayTimeouts): any;
/**
 * @stability stable
 */
export declare class DataAzurermVpnGatewayTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzurermVpnGatewayTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzurermVpnGatewayTimeouts | undefined);
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/vpn_gateway.html azurerm_vpn_gateway}.
 *
 * @stability stable
 */
export declare class DataAzurermVpnGateway extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/vpn_gateway.html azurerm_vpn_gateway} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataAzurermVpnGatewayConfig);
    /**
     * @stability stable
     */
    bgpSettings(index: string): DataAzurermVpnGatewayBgpSettings;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get location(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get scaleUnit(): number;
    /**
     * @stability stable
     */
    tags(key: string): string;
    /**
     * @stability stable
     */
    get virtualHubId(): string;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataAzurermVpnGatewayTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataAzurermVpnGatewayTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataAzurermVpnGatewayTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
