import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface SqlManagedInstanceActiveDirectoryAdministratorConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sql_managed_instance_active_directory_administrator.html#azuread_authentication_only SqlManagedInstanceActiveDirectoryAdministrator#azuread_authentication_only}.
     *
     * @stability stable
     */
    readonly azureadAuthenticationOnly?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sql_managed_instance_active_directory_administrator.html#login SqlManagedInstanceActiveDirectoryAdministrator#login}.
     *
     * @stability stable
     */
    readonly login: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sql_managed_instance_active_directory_administrator.html#managed_instance_name SqlManagedInstanceActiveDirectoryAdministrator#managed_instance_name}.
     *
     * @stability stable
     */
    readonly managedInstanceName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sql_managed_instance_active_directory_administrator.html#object_id SqlManagedInstanceActiveDirectoryAdministrator#object_id}.
     *
     * @stability stable
     */
    readonly objectId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sql_managed_instance_active_directory_administrator.html#resource_group_name SqlManagedInstanceActiveDirectoryAdministrator#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sql_managed_instance_active_directory_administrator.html#tenant_id SqlManagedInstanceActiveDirectoryAdministrator#tenant_id}.
     *
     * @stability stable
     */
    readonly tenantId: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sql_managed_instance_active_directory_administrator.html#timeouts SqlManagedInstanceActiveDirectoryAdministrator#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: SqlManagedInstanceActiveDirectoryAdministratorTimeouts;
}
/**
 * @stability stable
 */
export interface SqlManagedInstanceActiveDirectoryAdministratorTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sql_managed_instance_active_directory_administrator.html#create SqlManagedInstanceActiveDirectoryAdministrator#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sql_managed_instance_active_directory_administrator.html#delete SqlManagedInstanceActiveDirectoryAdministrator#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sql_managed_instance_active_directory_administrator.html#read SqlManagedInstanceActiveDirectoryAdministrator#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sql_managed_instance_active_directory_administrator.html#update SqlManagedInstanceActiveDirectoryAdministrator#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function sqlManagedInstanceActiveDirectoryAdministratorTimeoutsToTerraform(struct?: SqlManagedInstanceActiveDirectoryAdministratorTimeoutsOutputReference | SqlManagedInstanceActiveDirectoryAdministratorTimeouts): any;
/**
 * @stability stable
 */
export declare class SqlManagedInstanceActiveDirectoryAdministratorTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): SqlManagedInstanceActiveDirectoryAdministratorTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: SqlManagedInstanceActiveDirectoryAdministratorTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/sql_managed_instance_active_directory_administrator.html azurerm_sql_managed_instance_active_directory_administrator}.
 *
 * @stability stable
 */
export declare class SqlManagedInstanceActiveDirectoryAdministrator extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/sql_managed_instance_active_directory_administrator.html azurerm_sql_managed_instance_active_directory_administrator} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: SqlManagedInstanceActiveDirectoryAdministratorConfig);
    private _azureadAuthenticationOnly?;
    /**
     * @stability stable
     */
    get azureadAuthenticationOnly(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set azureadAuthenticationOnly(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAzureadAuthenticationOnly(): void;
    /**
     * @stability stable
     */
    get azureadAuthenticationOnlyInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _login?;
    /**
     * @stability stable
     */
    get login(): string;
    /**
     * @stability stable
     */
    set login(value: string);
    /**
     * @stability stable
     */
    get loginInput(): string | undefined;
    private _managedInstanceName?;
    /**
     * @stability stable
     */
    get managedInstanceName(): string;
    /**
     * @stability stable
     */
    set managedInstanceName(value: string);
    /**
     * @stability stable
     */
    get managedInstanceNameInput(): string | undefined;
    private _objectId?;
    /**
     * @stability stable
     */
    get objectId(): string;
    /**
     * @stability stable
     */
    set objectId(value: string);
    /**
     * @stability stable
     */
    get objectIdInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _tenantId?;
    /**
     * @stability stable
     */
    get tenantId(): string;
    /**
     * @stability stable
     */
    set tenantId(value: string);
    /**
     * @stability stable
     */
    get tenantIdInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): SqlManagedInstanceActiveDirectoryAdministratorTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: SqlManagedInstanceActiveDirectoryAdministratorTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): SqlManagedInstanceActiveDirectoryAdministratorTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
