# -*- coding: utf-8 -*-

# Copyright (c) 2015-2016, Camptocamp SA
# All rights reserved.

# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:

# 1. Redistributions of source code must retain the above copyright notice, this
#    list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.

# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
# ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
# DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
# (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
# LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
# ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
# SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

# The views and conclusions contained in the software and documentation are those
# of the authors and should not be interpreted as representing official policies,
# either expressed or implied, of the FreeBSD Project.

"""add column time_widget

Revision ID: 5109242131ce
Revises: 164ac0819a61
Create Date: 2015-04-27 17:31:41.760977
"""

from alembic import op, context
from sqlalchemy import Column
from sqlalchemy.types import Unicode

# revision identifiers, used by Alembic.
revision = '5109242131ce'
down_revision = '164ac0819a61'


def upgrade():
    schema = context.get_context().config.get_main_option('schema')

    # Instructions
    for table in ['layerv1', 'layer_internal_wms', 'layer_external_wms']:
        op.add_column(table, Column('time_widget', Unicode(10), default=u'slider'), schema=schema)
        op.execute("UPDATE %(schema)s.%(table)s SET time_widget = 'slider'" % {
            'schema': schema, 'table': table
        })


def downgrade():
    schema = context.get_context().config.get_main_option('schema')

    # Instructions
    for table in ['layerv1', 'layer_internal_wms', 'layer_external_wms']:
        op.drop_column(table, 'time_widget', schema=schema)
