# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AuthorizationGlobalExceptionRuleArgs', 'AuthorizationGlobalExceptionRule']

@pulumi.input_type
class AuthorizationGlobalExceptionRuleArgs:
    def __init__(__self__, *,
                 childrens: Optional[pulumi.Input[Sequence[pulumi.Input['AuthorizationGlobalExceptionRuleChildrenArgs']]]] = None,
                 condition_attribute_name: Optional[pulumi.Input[str]] = None,
                 condition_attribute_value: Optional[pulumi.Input[str]] = None,
                 condition_dictionary_name: Optional[pulumi.Input[str]] = None,
                 condition_dictionary_value: Optional[pulumi.Input[str]] = None,
                 condition_id: Optional[pulumi.Input[str]] = None,
                 condition_is_negate: Optional[pulumi.Input[bool]] = None,
                 condition_operator: Optional[pulumi.Input[str]] = None,
                 condition_type: Optional[pulumi.Input[str]] = None,
                 default: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 profiles: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 rank: Optional[pulumi.Input[int]] = None,
                 security_group: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a AuthorizationGlobalExceptionRule resource.
        :param pulumi.Input[Sequence[pulumi.Input['AuthorizationGlobalExceptionRuleChildrenArgs']]] childrens: List of child conditions. `condition_type` must be one of `ConditionAndBlock` or `ConditionOrBlock`.
        :param pulumi.Input[str] condition_attribute_name: Dictionary attribute name
        :param pulumi.Input[str] condition_attribute_value: Attribute value for condition. Value type is specified in dictionary object.
        :param pulumi.Input[str] condition_dictionary_name: Dictionary name
        :param pulumi.Input[str] condition_dictionary_value: Dictionary value
        :param pulumi.Input[str] condition_id: UUID for condition
        :param pulumi.Input[bool] condition_is_negate: Indicates whereas this condition is in negate mode
        :param pulumi.Input[str] condition_operator: Equality operator - Choices: `contains`, `endsWith`, `equals`, `greaterOrEquals`, `greaterThan`, `in`, `ipEquals`,
               `ipGreaterThan`, `ipLessThan`, `ipNotEquals`, `lessOrEquals`, `lessThan`, `matches`, `notContains`, `notEndsWith`,
               `notEquals`, `notIn`, `notStartsWith`, `startsWith`
        :param pulumi.Input[str] condition_type: Indicates whether the record is the condition itself or a logical aggregation. Logical aggreation indicates that
               additional conditions are present under the children attribute. - Choices: `ConditionAndBlock`, `ConditionAttributes`,
               `ConditionOrBlock`, `ConditionReference`
        :param pulumi.Input[bool] default: Indicates if this rule is the default one
        :param pulumi.Input[str] name: Rule name, [Valid characters are alphanumerics, underscore, hyphen, space, period, parentheses]
        :param pulumi.Input[Sequence[pulumi.Input[str]]] profiles: The authorization profile(s)
        :param pulumi.Input[int] rank: The rank (priority) in relation to other rules. Lower rank is higher priority.
        :param pulumi.Input[str] security_group: Security group used in authorization policies
        :param pulumi.Input[str] state: The state that the rule is in. A disabled rule cannot be matched. - Choices: `disabled`, `enabled`, `monitor`
        """
        if childrens is not None:
            pulumi.set(__self__, "childrens", childrens)
        if condition_attribute_name is not None:
            pulumi.set(__self__, "condition_attribute_name", condition_attribute_name)
        if condition_attribute_value is not None:
            pulumi.set(__self__, "condition_attribute_value", condition_attribute_value)
        if condition_dictionary_name is not None:
            pulumi.set(__self__, "condition_dictionary_name", condition_dictionary_name)
        if condition_dictionary_value is not None:
            pulumi.set(__self__, "condition_dictionary_value", condition_dictionary_value)
        if condition_id is not None:
            pulumi.set(__self__, "condition_id", condition_id)
        if condition_is_negate is not None:
            pulumi.set(__self__, "condition_is_negate", condition_is_negate)
        if condition_operator is not None:
            pulumi.set(__self__, "condition_operator", condition_operator)
        if condition_type is not None:
            pulumi.set(__self__, "condition_type", condition_type)
        if default is not None:
            pulumi.set(__self__, "default", default)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if profiles is not None:
            pulumi.set(__self__, "profiles", profiles)
        if rank is not None:
            pulumi.set(__self__, "rank", rank)
        if security_group is not None:
            pulumi.set(__self__, "security_group", security_group)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def childrens(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AuthorizationGlobalExceptionRuleChildrenArgs']]]]:
        """
        List of child conditions. `condition_type` must be one of `ConditionAndBlock` or `ConditionOrBlock`.
        """
        return pulumi.get(self, "childrens")

    @childrens.setter
    def childrens(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AuthorizationGlobalExceptionRuleChildrenArgs']]]]):
        pulumi.set(self, "childrens", value)

    @property
    @pulumi.getter(name="conditionAttributeName")
    def condition_attribute_name(self) -> Optional[pulumi.Input[str]]:
        """
        Dictionary attribute name
        """
        return pulumi.get(self, "condition_attribute_name")

    @condition_attribute_name.setter
    def condition_attribute_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "condition_attribute_name", value)

    @property
    @pulumi.getter(name="conditionAttributeValue")
    def condition_attribute_value(self) -> Optional[pulumi.Input[str]]:
        """
        Attribute value for condition. Value type is specified in dictionary object.
        """
        return pulumi.get(self, "condition_attribute_value")

    @condition_attribute_value.setter
    def condition_attribute_value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "condition_attribute_value", value)

    @property
    @pulumi.getter(name="conditionDictionaryName")
    def condition_dictionary_name(self) -> Optional[pulumi.Input[str]]:
        """
        Dictionary name
        """
        return pulumi.get(self, "condition_dictionary_name")

    @condition_dictionary_name.setter
    def condition_dictionary_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "condition_dictionary_name", value)

    @property
    @pulumi.getter(name="conditionDictionaryValue")
    def condition_dictionary_value(self) -> Optional[pulumi.Input[str]]:
        """
        Dictionary value
        """
        return pulumi.get(self, "condition_dictionary_value")

    @condition_dictionary_value.setter
    def condition_dictionary_value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "condition_dictionary_value", value)

    @property
    @pulumi.getter(name="conditionId")
    def condition_id(self) -> Optional[pulumi.Input[str]]:
        """
        UUID for condition
        """
        return pulumi.get(self, "condition_id")

    @condition_id.setter
    def condition_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "condition_id", value)

    @property
    @pulumi.getter(name="conditionIsNegate")
    def condition_is_negate(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whereas this condition is in negate mode
        """
        return pulumi.get(self, "condition_is_negate")

    @condition_is_negate.setter
    def condition_is_negate(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "condition_is_negate", value)

    @property
    @pulumi.getter(name="conditionOperator")
    def condition_operator(self) -> Optional[pulumi.Input[str]]:
        """
        Equality operator - Choices: `contains`, `endsWith`, `equals`, `greaterOrEquals`, `greaterThan`, `in`, `ipEquals`,
        `ipGreaterThan`, `ipLessThan`, `ipNotEquals`, `lessOrEquals`, `lessThan`, `matches`, `notContains`, `notEndsWith`,
        `notEquals`, `notIn`, `notStartsWith`, `startsWith`
        """
        return pulumi.get(self, "condition_operator")

    @condition_operator.setter
    def condition_operator(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "condition_operator", value)

    @property
    @pulumi.getter(name="conditionType")
    def condition_type(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates whether the record is the condition itself or a logical aggregation. Logical aggreation indicates that
        additional conditions are present under the children attribute. - Choices: `ConditionAndBlock`, `ConditionAttributes`,
        `ConditionOrBlock`, `ConditionReference`
        """
        return pulumi.get(self, "condition_type")

    @condition_type.setter
    def condition_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "condition_type", value)

    @property
    @pulumi.getter
    def default(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates if this rule is the default one
        """
        return pulumi.get(self, "default")

    @default.setter
    def default(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "default", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Rule name, [Valid characters are alphanumerics, underscore, hyphen, space, period, parentheses]
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def profiles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The authorization profile(s)
        """
        return pulumi.get(self, "profiles")

    @profiles.setter
    def profiles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "profiles", value)

    @property
    @pulumi.getter
    def rank(self) -> Optional[pulumi.Input[int]]:
        """
        The rank (priority) in relation to other rules. Lower rank is higher priority.
        """
        return pulumi.get(self, "rank")

    @rank.setter
    def rank(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "rank", value)

    @property
    @pulumi.getter(name="securityGroup")
    def security_group(self) -> Optional[pulumi.Input[str]]:
        """
        Security group used in authorization policies
        """
        return pulumi.get(self, "security_group")

    @security_group.setter
    def security_group(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "security_group", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The state that the rule is in. A disabled rule cannot be matched. - Choices: `disabled`, `enabled`, `monitor`
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)


@pulumi.input_type
class _AuthorizationGlobalExceptionRuleState:
    def __init__(__self__, *,
                 childrens: Optional[pulumi.Input[Sequence[pulumi.Input['AuthorizationGlobalExceptionRuleChildrenArgs']]]] = None,
                 condition_attribute_name: Optional[pulumi.Input[str]] = None,
                 condition_attribute_value: Optional[pulumi.Input[str]] = None,
                 condition_dictionary_name: Optional[pulumi.Input[str]] = None,
                 condition_dictionary_value: Optional[pulumi.Input[str]] = None,
                 condition_id: Optional[pulumi.Input[str]] = None,
                 condition_is_negate: Optional[pulumi.Input[bool]] = None,
                 condition_operator: Optional[pulumi.Input[str]] = None,
                 condition_type: Optional[pulumi.Input[str]] = None,
                 default: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 profiles: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 rank: Optional[pulumi.Input[int]] = None,
                 security_group: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering AuthorizationGlobalExceptionRule resources.
        :param pulumi.Input[Sequence[pulumi.Input['AuthorizationGlobalExceptionRuleChildrenArgs']]] childrens: List of child conditions. `condition_type` must be one of `ConditionAndBlock` or `ConditionOrBlock`.
        :param pulumi.Input[str] condition_attribute_name: Dictionary attribute name
        :param pulumi.Input[str] condition_attribute_value: Attribute value for condition. Value type is specified in dictionary object.
        :param pulumi.Input[str] condition_dictionary_name: Dictionary name
        :param pulumi.Input[str] condition_dictionary_value: Dictionary value
        :param pulumi.Input[str] condition_id: UUID for condition
        :param pulumi.Input[bool] condition_is_negate: Indicates whereas this condition is in negate mode
        :param pulumi.Input[str] condition_operator: Equality operator - Choices: `contains`, `endsWith`, `equals`, `greaterOrEquals`, `greaterThan`, `in`, `ipEquals`,
               `ipGreaterThan`, `ipLessThan`, `ipNotEquals`, `lessOrEquals`, `lessThan`, `matches`, `notContains`, `notEndsWith`,
               `notEquals`, `notIn`, `notStartsWith`, `startsWith`
        :param pulumi.Input[str] condition_type: Indicates whether the record is the condition itself or a logical aggregation. Logical aggreation indicates that
               additional conditions are present under the children attribute. - Choices: `ConditionAndBlock`, `ConditionAttributes`,
               `ConditionOrBlock`, `ConditionReference`
        :param pulumi.Input[bool] default: Indicates if this rule is the default one
        :param pulumi.Input[str] name: Rule name, [Valid characters are alphanumerics, underscore, hyphen, space, period, parentheses]
        :param pulumi.Input[Sequence[pulumi.Input[str]]] profiles: The authorization profile(s)
        :param pulumi.Input[int] rank: The rank (priority) in relation to other rules. Lower rank is higher priority.
        :param pulumi.Input[str] security_group: Security group used in authorization policies
        :param pulumi.Input[str] state: The state that the rule is in. A disabled rule cannot be matched. - Choices: `disabled`, `enabled`, `monitor`
        """
        if childrens is not None:
            pulumi.set(__self__, "childrens", childrens)
        if condition_attribute_name is not None:
            pulumi.set(__self__, "condition_attribute_name", condition_attribute_name)
        if condition_attribute_value is not None:
            pulumi.set(__self__, "condition_attribute_value", condition_attribute_value)
        if condition_dictionary_name is not None:
            pulumi.set(__self__, "condition_dictionary_name", condition_dictionary_name)
        if condition_dictionary_value is not None:
            pulumi.set(__self__, "condition_dictionary_value", condition_dictionary_value)
        if condition_id is not None:
            pulumi.set(__self__, "condition_id", condition_id)
        if condition_is_negate is not None:
            pulumi.set(__self__, "condition_is_negate", condition_is_negate)
        if condition_operator is not None:
            pulumi.set(__self__, "condition_operator", condition_operator)
        if condition_type is not None:
            pulumi.set(__self__, "condition_type", condition_type)
        if default is not None:
            pulumi.set(__self__, "default", default)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if profiles is not None:
            pulumi.set(__self__, "profiles", profiles)
        if rank is not None:
            pulumi.set(__self__, "rank", rank)
        if security_group is not None:
            pulumi.set(__self__, "security_group", security_group)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def childrens(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AuthorizationGlobalExceptionRuleChildrenArgs']]]]:
        """
        List of child conditions. `condition_type` must be one of `ConditionAndBlock` or `ConditionOrBlock`.
        """
        return pulumi.get(self, "childrens")

    @childrens.setter
    def childrens(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AuthorizationGlobalExceptionRuleChildrenArgs']]]]):
        pulumi.set(self, "childrens", value)

    @property
    @pulumi.getter(name="conditionAttributeName")
    def condition_attribute_name(self) -> Optional[pulumi.Input[str]]:
        """
        Dictionary attribute name
        """
        return pulumi.get(self, "condition_attribute_name")

    @condition_attribute_name.setter
    def condition_attribute_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "condition_attribute_name", value)

    @property
    @pulumi.getter(name="conditionAttributeValue")
    def condition_attribute_value(self) -> Optional[pulumi.Input[str]]:
        """
        Attribute value for condition. Value type is specified in dictionary object.
        """
        return pulumi.get(self, "condition_attribute_value")

    @condition_attribute_value.setter
    def condition_attribute_value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "condition_attribute_value", value)

    @property
    @pulumi.getter(name="conditionDictionaryName")
    def condition_dictionary_name(self) -> Optional[pulumi.Input[str]]:
        """
        Dictionary name
        """
        return pulumi.get(self, "condition_dictionary_name")

    @condition_dictionary_name.setter
    def condition_dictionary_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "condition_dictionary_name", value)

    @property
    @pulumi.getter(name="conditionDictionaryValue")
    def condition_dictionary_value(self) -> Optional[pulumi.Input[str]]:
        """
        Dictionary value
        """
        return pulumi.get(self, "condition_dictionary_value")

    @condition_dictionary_value.setter
    def condition_dictionary_value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "condition_dictionary_value", value)

    @property
    @pulumi.getter(name="conditionId")
    def condition_id(self) -> Optional[pulumi.Input[str]]:
        """
        UUID for condition
        """
        return pulumi.get(self, "condition_id")

    @condition_id.setter
    def condition_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "condition_id", value)

    @property
    @pulumi.getter(name="conditionIsNegate")
    def condition_is_negate(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whereas this condition is in negate mode
        """
        return pulumi.get(self, "condition_is_negate")

    @condition_is_negate.setter
    def condition_is_negate(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "condition_is_negate", value)

    @property
    @pulumi.getter(name="conditionOperator")
    def condition_operator(self) -> Optional[pulumi.Input[str]]:
        """
        Equality operator - Choices: `contains`, `endsWith`, `equals`, `greaterOrEquals`, `greaterThan`, `in`, `ipEquals`,
        `ipGreaterThan`, `ipLessThan`, `ipNotEquals`, `lessOrEquals`, `lessThan`, `matches`, `notContains`, `notEndsWith`,
        `notEquals`, `notIn`, `notStartsWith`, `startsWith`
        """
        return pulumi.get(self, "condition_operator")

    @condition_operator.setter
    def condition_operator(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "condition_operator", value)

    @property
    @pulumi.getter(name="conditionType")
    def condition_type(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates whether the record is the condition itself or a logical aggregation. Logical aggreation indicates that
        additional conditions are present under the children attribute. - Choices: `ConditionAndBlock`, `ConditionAttributes`,
        `ConditionOrBlock`, `ConditionReference`
        """
        return pulumi.get(self, "condition_type")

    @condition_type.setter
    def condition_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "condition_type", value)

    @property
    @pulumi.getter
    def default(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates if this rule is the default one
        """
        return pulumi.get(self, "default")

    @default.setter
    def default(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "default", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Rule name, [Valid characters are alphanumerics, underscore, hyphen, space, period, parentheses]
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def profiles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The authorization profile(s)
        """
        return pulumi.get(self, "profiles")

    @profiles.setter
    def profiles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "profiles", value)

    @property
    @pulumi.getter
    def rank(self) -> Optional[pulumi.Input[int]]:
        """
        The rank (priority) in relation to other rules. Lower rank is higher priority.
        """
        return pulumi.get(self, "rank")

    @rank.setter
    def rank(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "rank", value)

    @property
    @pulumi.getter(name="securityGroup")
    def security_group(self) -> Optional[pulumi.Input[str]]:
        """
        Security group used in authorization policies
        """
        return pulumi.get(self, "security_group")

    @security_group.setter
    def security_group(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "security_group", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The state that the rule is in. A disabled rule cannot be matched. - Choices: `disabled`, `enabled`, `monitor`
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)


class AuthorizationGlobalExceptionRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 childrens: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AuthorizationGlobalExceptionRuleChildrenArgs', 'AuthorizationGlobalExceptionRuleChildrenArgsDict']]]]] = None,
                 condition_attribute_name: Optional[pulumi.Input[str]] = None,
                 condition_attribute_value: Optional[pulumi.Input[str]] = None,
                 condition_dictionary_name: Optional[pulumi.Input[str]] = None,
                 condition_dictionary_value: Optional[pulumi.Input[str]] = None,
                 condition_id: Optional[pulumi.Input[str]] = None,
                 condition_is_negate: Optional[pulumi.Input[bool]] = None,
                 condition_operator: Optional[pulumi.Input[str]] = None,
                 condition_type: Optional[pulumi.Input[str]] = None,
                 default: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 profiles: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 rank: Optional[pulumi.Input[int]] = None,
                 security_group: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource can manage a Network Access Authorization Global Exception Rule.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_ise as ise

        example = ise.networkaccess.AuthorizationGlobalExceptionRule("example",
            name="Rule1",
            default=False,
            rank=0,
            state="enabled",
            condition_type="ConditionAttributes",
            condition_is_negate=False,
            condition_attribute_name="Location",
            condition_attribute_value="All Locations",
            condition_dictionary_name="DEVICE",
            condition_operator="equals",
            profiles=["PermitAccess"],
            security_group="BYOD")
        ```

        ## Import

        ```sh
        $ pulumi import ise:networkaccess/authorizationGlobalExceptionRule:AuthorizationGlobalExceptionRule example "76d24097-41c4-4558-a4d0-a8c07ac08470"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AuthorizationGlobalExceptionRuleChildrenArgs', 'AuthorizationGlobalExceptionRuleChildrenArgsDict']]]] childrens: List of child conditions. `condition_type` must be one of `ConditionAndBlock` or `ConditionOrBlock`.
        :param pulumi.Input[str] condition_attribute_name: Dictionary attribute name
        :param pulumi.Input[str] condition_attribute_value: Attribute value for condition. Value type is specified in dictionary object.
        :param pulumi.Input[str] condition_dictionary_name: Dictionary name
        :param pulumi.Input[str] condition_dictionary_value: Dictionary value
        :param pulumi.Input[str] condition_id: UUID for condition
        :param pulumi.Input[bool] condition_is_negate: Indicates whereas this condition is in negate mode
        :param pulumi.Input[str] condition_operator: Equality operator - Choices: `contains`, `endsWith`, `equals`, `greaterOrEquals`, `greaterThan`, `in`, `ipEquals`,
               `ipGreaterThan`, `ipLessThan`, `ipNotEquals`, `lessOrEquals`, `lessThan`, `matches`, `notContains`, `notEndsWith`,
               `notEquals`, `notIn`, `notStartsWith`, `startsWith`
        :param pulumi.Input[str] condition_type: Indicates whether the record is the condition itself or a logical aggregation. Logical aggreation indicates that
               additional conditions are present under the children attribute. - Choices: `ConditionAndBlock`, `ConditionAttributes`,
               `ConditionOrBlock`, `ConditionReference`
        :param pulumi.Input[bool] default: Indicates if this rule is the default one
        :param pulumi.Input[str] name: Rule name, [Valid characters are alphanumerics, underscore, hyphen, space, period, parentheses]
        :param pulumi.Input[Sequence[pulumi.Input[str]]] profiles: The authorization profile(s)
        :param pulumi.Input[int] rank: The rank (priority) in relation to other rules. Lower rank is higher priority.
        :param pulumi.Input[str] security_group: Security group used in authorization policies
        :param pulumi.Input[str] state: The state that the rule is in. A disabled rule cannot be matched. - Choices: `disabled`, `enabled`, `monitor`
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[AuthorizationGlobalExceptionRuleArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource can manage a Network Access Authorization Global Exception Rule.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_ise as ise

        example = ise.networkaccess.AuthorizationGlobalExceptionRule("example",
            name="Rule1",
            default=False,
            rank=0,
            state="enabled",
            condition_type="ConditionAttributes",
            condition_is_negate=False,
            condition_attribute_name="Location",
            condition_attribute_value="All Locations",
            condition_dictionary_name="DEVICE",
            condition_operator="equals",
            profiles=["PermitAccess"],
            security_group="BYOD")
        ```

        ## Import

        ```sh
        $ pulumi import ise:networkaccess/authorizationGlobalExceptionRule:AuthorizationGlobalExceptionRule example "76d24097-41c4-4558-a4d0-a8c07ac08470"
        ```

        :param str resource_name: The name of the resource.
        :param AuthorizationGlobalExceptionRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AuthorizationGlobalExceptionRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 childrens: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AuthorizationGlobalExceptionRuleChildrenArgs', 'AuthorizationGlobalExceptionRuleChildrenArgsDict']]]]] = None,
                 condition_attribute_name: Optional[pulumi.Input[str]] = None,
                 condition_attribute_value: Optional[pulumi.Input[str]] = None,
                 condition_dictionary_name: Optional[pulumi.Input[str]] = None,
                 condition_dictionary_value: Optional[pulumi.Input[str]] = None,
                 condition_id: Optional[pulumi.Input[str]] = None,
                 condition_is_negate: Optional[pulumi.Input[bool]] = None,
                 condition_operator: Optional[pulumi.Input[str]] = None,
                 condition_type: Optional[pulumi.Input[str]] = None,
                 default: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 profiles: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 rank: Optional[pulumi.Input[int]] = None,
                 security_group: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AuthorizationGlobalExceptionRuleArgs.__new__(AuthorizationGlobalExceptionRuleArgs)

            __props__.__dict__["childrens"] = childrens
            __props__.__dict__["condition_attribute_name"] = condition_attribute_name
            __props__.__dict__["condition_attribute_value"] = condition_attribute_value
            __props__.__dict__["condition_dictionary_name"] = condition_dictionary_name
            __props__.__dict__["condition_dictionary_value"] = condition_dictionary_value
            __props__.__dict__["condition_id"] = condition_id
            __props__.__dict__["condition_is_negate"] = condition_is_negate
            __props__.__dict__["condition_operator"] = condition_operator
            __props__.__dict__["condition_type"] = condition_type
            __props__.__dict__["default"] = default
            __props__.__dict__["name"] = name
            __props__.__dict__["profiles"] = profiles
            __props__.__dict__["rank"] = rank
            __props__.__dict__["security_group"] = security_group
            __props__.__dict__["state"] = state
        super(AuthorizationGlobalExceptionRule, __self__).__init__(
            'ise:networkaccess/authorizationGlobalExceptionRule:AuthorizationGlobalExceptionRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            childrens: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AuthorizationGlobalExceptionRuleChildrenArgs', 'AuthorizationGlobalExceptionRuleChildrenArgsDict']]]]] = None,
            condition_attribute_name: Optional[pulumi.Input[str]] = None,
            condition_attribute_value: Optional[pulumi.Input[str]] = None,
            condition_dictionary_name: Optional[pulumi.Input[str]] = None,
            condition_dictionary_value: Optional[pulumi.Input[str]] = None,
            condition_id: Optional[pulumi.Input[str]] = None,
            condition_is_negate: Optional[pulumi.Input[bool]] = None,
            condition_operator: Optional[pulumi.Input[str]] = None,
            condition_type: Optional[pulumi.Input[str]] = None,
            default: Optional[pulumi.Input[bool]] = None,
            name: Optional[pulumi.Input[str]] = None,
            profiles: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            rank: Optional[pulumi.Input[int]] = None,
            security_group: Optional[pulumi.Input[str]] = None,
            state: Optional[pulumi.Input[str]] = None) -> 'AuthorizationGlobalExceptionRule':
        """
        Get an existing AuthorizationGlobalExceptionRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AuthorizationGlobalExceptionRuleChildrenArgs', 'AuthorizationGlobalExceptionRuleChildrenArgsDict']]]] childrens: List of child conditions. `condition_type` must be one of `ConditionAndBlock` or `ConditionOrBlock`.
        :param pulumi.Input[str] condition_attribute_name: Dictionary attribute name
        :param pulumi.Input[str] condition_attribute_value: Attribute value for condition. Value type is specified in dictionary object.
        :param pulumi.Input[str] condition_dictionary_name: Dictionary name
        :param pulumi.Input[str] condition_dictionary_value: Dictionary value
        :param pulumi.Input[str] condition_id: UUID for condition
        :param pulumi.Input[bool] condition_is_negate: Indicates whereas this condition is in negate mode
        :param pulumi.Input[str] condition_operator: Equality operator - Choices: `contains`, `endsWith`, `equals`, `greaterOrEquals`, `greaterThan`, `in`, `ipEquals`,
               `ipGreaterThan`, `ipLessThan`, `ipNotEquals`, `lessOrEquals`, `lessThan`, `matches`, `notContains`, `notEndsWith`,
               `notEquals`, `notIn`, `notStartsWith`, `startsWith`
        :param pulumi.Input[str] condition_type: Indicates whether the record is the condition itself or a logical aggregation. Logical aggreation indicates that
               additional conditions are present under the children attribute. - Choices: `ConditionAndBlock`, `ConditionAttributes`,
               `ConditionOrBlock`, `ConditionReference`
        :param pulumi.Input[bool] default: Indicates if this rule is the default one
        :param pulumi.Input[str] name: Rule name, [Valid characters are alphanumerics, underscore, hyphen, space, period, parentheses]
        :param pulumi.Input[Sequence[pulumi.Input[str]]] profiles: The authorization profile(s)
        :param pulumi.Input[int] rank: The rank (priority) in relation to other rules. Lower rank is higher priority.
        :param pulumi.Input[str] security_group: Security group used in authorization policies
        :param pulumi.Input[str] state: The state that the rule is in. A disabled rule cannot be matched. - Choices: `disabled`, `enabled`, `monitor`
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AuthorizationGlobalExceptionRuleState.__new__(_AuthorizationGlobalExceptionRuleState)

        __props__.__dict__["childrens"] = childrens
        __props__.__dict__["condition_attribute_name"] = condition_attribute_name
        __props__.__dict__["condition_attribute_value"] = condition_attribute_value
        __props__.__dict__["condition_dictionary_name"] = condition_dictionary_name
        __props__.__dict__["condition_dictionary_value"] = condition_dictionary_value
        __props__.__dict__["condition_id"] = condition_id
        __props__.__dict__["condition_is_negate"] = condition_is_negate
        __props__.__dict__["condition_operator"] = condition_operator
        __props__.__dict__["condition_type"] = condition_type
        __props__.__dict__["default"] = default
        __props__.__dict__["name"] = name
        __props__.__dict__["profiles"] = profiles
        __props__.__dict__["rank"] = rank
        __props__.__dict__["security_group"] = security_group
        __props__.__dict__["state"] = state
        return AuthorizationGlobalExceptionRule(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def childrens(self) -> pulumi.Output[Optional[Sequence['outputs.AuthorizationGlobalExceptionRuleChildren']]]:
        """
        List of child conditions. `condition_type` must be one of `ConditionAndBlock` or `ConditionOrBlock`.
        """
        return pulumi.get(self, "childrens")

    @property
    @pulumi.getter(name="conditionAttributeName")
    def condition_attribute_name(self) -> pulumi.Output[Optional[str]]:
        """
        Dictionary attribute name
        """
        return pulumi.get(self, "condition_attribute_name")

    @property
    @pulumi.getter(name="conditionAttributeValue")
    def condition_attribute_value(self) -> pulumi.Output[Optional[str]]:
        """
        Attribute value for condition. Value type is specified in dictionary object.
        """
        return pulumi.get(self, "condition_attribute_value")

    @property
    @pulumi.getter(name="conditionDictionaryName")
    def condition_dictionary_name(self) -> pulumi.Output[Optional[str]]:
        """
        Dictionary name
        """
        return pulumi.get(self, "condition_dictionary_name")

    @property
    @pulumi.getter(name="conditionDictionaryValue")
    def condition_dictionary_value(self) -> pulumi.Output[Optional[str]]:
        """
        Dictionary value
        """
        return pulumi.get(self, "condition_dictionary_value")

    @property
    @pulumi.getter(name="conditionId")
    def condition_id(self) -> pulumi.Output[Optional[str]]:
        """
        UUID for condition
        """
        return pulumi.get(self, "condition_id")

    @property
    @pulumi.getter(name="conditionIsNegate")
    def condition_is_negate(self) -> pulumi.Output[Optional[bool]]:
        """
        Indicates whereas this condition is in negate mode
        """
        return pulumi.get(self, "condition_is_negate")

    @property
    @pulumi.getter(name="conditionOperator")
    def condition_operator(self) -> pulumi.Output[Optional[str]]:
        """
        Equality operator - Choices: `contains`, `endsWith`, `equals`, `greaterOrEquals`, `greaterThan`, `in`, `ipEquals`,
        `ipGreaterThan`, `ipLessThan`, `ipNotEquals`, `lessOrEquals`, `lessThan`, `matches`, `notContains`, `notEndsWith`,
        `notEquals`, `notIn`, `notStartsWith`, `startsWith`
        """
        return pulumi.get(self, "condition_operator")

    @property
    @pulumi.getter(name="conditionType")
    def condition_type(self) -> pulumi.Output[Optional[str]]:
        """
        Indicates whether the record is the condition itself or a logical aggregation. Logical aggreation indicates that
        additional conditions are present under the children attribute. - Choices: `ConditionAndBlock`, `ConditionAttributes`,
        `ConditionOrBlock`, `ConditionReference`
        """
        return pulumi.get(self, "condition_type")

    @property
    @pulumi.getter
    def default(self) -> pulumi.Output[Optional[bool]]:
        """
        Indicates if this rule is the default one
        """
        return pulumi.get(self, "default")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Rule name, [Valid characters are alphanumerics, underscore, hyphen, space, period, parentheses]
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def profiles(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        The authorization profile(s)
        """
        return pulumi.get(self, "profiles")

    @property
    @pulumi.getter
    def rank(self) -> pulumi.Output[Optional[int]]:
        """
        The rank (priority) in relation to other rules. Lower rank is higher priority.
        """
        return pulumi.get(self, "rank")

    @property
    @pulumi.getter(name="securityGroup")
    def security_group(self) -> pulumi.Output[Optional[str]]:
        """
        Security group used in authorization policies
        """
        return pulumi.get(self, "security_group")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[Optional[str]]:
        """
        The state that the rule is in. A disabled rule cannot be matched. - Choices: `disabled`, `enabled`, `monitor`
        """
        return pulumi.get(self, "state")

