# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ResourceServerArgs', 'ResourceServer']

@pulumi.input_type
class ResourceServerArgs:
    def __init__(__self__, *,
                 identifier: pulumi.Input[builtins.str],
                 allow_offline_access: Optional[pulumi.Input[builtins.bool]] = None,
                 authorization_details: Optional[pulumi.Input[Sequence[pulumi.Input['ResourceServerAuthorizationDetailArgs']]]] = None,
                 consent_policy: Optional[pulumi.Input[builtins.str]] = None,
                 enforce_policies: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 proof_of_possession: Optional[pulumi.Input['ResourceServerProofOfPossessionArgs']] = None,
                 signing_alg: Optional[pulumi.Input[builtins.str]] = None,
                 signing_secret: Optional[pulumi.Input[builtins.str]] = None,
                 skip_consent_for_verifiable_first_party_clients: Optional[pulumi.Input[builtins.bool]] = None,
                 token_dialect: Optional[pulumi.Input[builtins.str]] = None,
                 token_encryption: Optional[pulumi.Input['ResourceServerTokenEncryptionArgs']] = None,
                 token_lifetime: Optional[pulumi.Input[builtins.int]] = None,
                 token_lifetime_for_web: Optional[pulumi.Input[builtins.int]] = None,
                 verification_location: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a ResourceServer resource.
        :param pulumi.Input[builtins.str] identifier: Unique identifier for the resource server. Used as the audience parameter for authorization calls. Cannot be changed once set.
        :param pulumi.Input[builtins.bool] allow_offline_access: Indicates whether refresh tokens can be issued for this resource server.
        :param pulumi.Input[Sequence[pulumi.Input['ResourceServerAuthorizationDetailArgs']]] authorization_details: Authorization details for this resource server.
        :param pulumi.Input[builtins.str] consent_policy: Consent policy for this resource server. Options include `transactional-authorization-with-mfa`, or `null` to disable.
        :param pulumi.Input[builtins.bool] enforce_policies: If this setting is enabled, RBAC authorization policies will be enforced for this API. Role and permission assignments will be evaluated during the login transaction.
        :param pulumi.Input[builtins.str] name: Friendly name for the resource server. Cannot include `<` or `>` characters.
        :param pulumi.Input['ResourceServerProofOfPossessionArgs'] proof_of_possession: Configuration settings for proof-of-possession for this resource server.
        :param pulumi.Input[builtins.str] signing_alg: Algorithm used to sign JWTs. Options include `HS256`, `RS256`, and `PS256`.
        :param pulumi.Input[builtins.str] signing_secret: Secret used to sign tokens when using symmetric algorithms (HS256).
        :param pulumi.Input[builtins.bool] skip_consent_for_verifiable_first_party_clients: Indicates whether to skip user consent for applications flagged as first party.
        :param pulumi.Input[builtins.str] token_dialect: Dialect of access tokens that should be issued for this resource server. Options include `access_token`, `rfc9068_profile`, `access_token_authz`, and `rfc9068_profile_authz`. `access_token` is a JWT containing standard Auth0 claims. `rfc9068_profile` is a JWT conforming to the IETF JWT Access Token Profile. `access_token_authz` is a JWT containing standard Auth0 claims, including RBAC permissions claims. `rfc9068_profile_authz` is a JWT conforming to the IETF JWT Access Token Profile, including RBAC permissions claims. RBAC permissions claims are available if RBAC (`enforce_policies`) is enabled for this API. For more details, refer to [Access Token Profiles](https://auth0.com/docs/secure/tokens/access-tokens/access-token-profiles).
        :param pulumi.Input['ResourceServerTokenEncryptionArgs'] token_encryption: Configuration for JSON Web Encryption(JWE) of tokens for this resource server.
        :param pulumi.Input[builtins.int] token_lifetime: Number of seconds during which access tokens issued for this resource server from the token endpoint remain valid.
        :param pulumi.Input[builtins.int] token_lifetime_for_web: Number of seconds during which access tokens issued for this resource server via implicit or hybrid flows remain valid. Cannot be greater than the `token_lifetime` value.
        :param pulumi.Input[builtins.str] verification_location: URL from which to retrieve JWKs for this resource server. Used for verifying the JWT sent to Auth0 for token introspection.
        """
        pulumi.set(__self__, "identifier", identifier)
        if allow_offline_access is not None:
            pulumi.set(__self__, "allow_offline_access", allow_offline_access)
        if authorization_details is not None:
            pulumi.set(__self__, "authorization_details", authorization_details)
        if consent_policy is not None:
            pulumi.set(__self__, "consent_policy", consent_policy)
        if enforce_policies is not None:
            pulumi.set(__self__, "enforce_policies", enforce_policies)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if proof_of_possession is not None:
            pulumi.set(__self__, "proof_of_possession", proof_of_possession)
        if signing_alg is not None:
            pulumi.set(__self__, "signing_alg", signing_alg)
        if signing_secret is not None:
            pulumi.set(__self__, "signing_secret", signing_secret)
        if skip_consent_for_verifiable_first_party_clients is not None:
            pulumi.set(__self__, "skip_consent_for_verifiable_first_party_clients", skip_consent_for_verifiable_first_party_clients)
        if token_dialect is not None:
            pulumi.set(__self__, "token_dialect", token_dialect)
        if token_encryption is not None:
            pulumi.set(__self__, "token_encryption", token_encryption)
        if token_lifetime is not None:
            pulumi.set(__self__, "token_lifetime", token_lifetime)
        if token_lifetime_for_web is not None:
            pulumi.set(__self__, "token_lifetime_for_web", token_lifetime_for_web)
        if verification_location is not None:
            pulumi.set(__self__, "verification_location", verification_location)

    @property
    @pulumi.getter
    def identifier(self) -> pulumi.Input[builtins.str]:
        """
        Unique identifier for the resource server. Used as the audience parameter for authorization calls. Cannot be changed once set.
        """
        return pulumi.get(self, "identifier")

    @identifier.setter
    def identifier(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "identifier", value)

    @property
    @pulumi.getter(name="allowOfflineAccess")
    def allow_offline_access(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Indicates whether refresh tokens can be issued for this resource server.
        """
        return pulumi.get(self, "allow_offline_access")

    @allow_offline_access.setter
    def allow_offline_access(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "allow_offline_access", value)

    @property
    @pulumi.getter(name="authorizationDetails")
    def authorization_details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ResourceServerAuthorizationDetailArgs']]]]:
        """
        Authorization details for this resource server.
        """
        return pulumi.get(self, "authorization_details")

    @authorization_details.setter
    def authorization_details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ResourceServerAuthorizationDetailArgs']]]]):
        pulumi.set(self, "authorization_details", value)

    @property
    @pulumi.getter(name="consentPolicy")
    def consent_policy(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Consent policy for this resource server. Options include `transactional-authorization-with-mfa`, or `null` to disable.
        """
        return pulumi.get(self, "consent_policy")

    @consent_policy.setter
    def consent_policy(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "consent_policy", value)

    @property
    @pulumi.getter(name="enforcePolicies")
    def enforce_policies(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If this setting is enabled, RBAC authorization policies will be enforced for this API. Role and permission assignments will be evaluated during the login transaction.
        """
        return pulumi.get(self, "enforce_policies")

    @enforce_policies.setter
    def enforce_policies(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enforce_policies", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Friendly name for the resource server. Cannot include `<` or `>` characters.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="proofOfPossession")
    def proof_of_possession(self) -> Optional[pulumi.Input['ResourceServerProofOfPossessionArgs']]:
        """
        Configuration settings for proof-of-possession for this resource server.
        """
        return pulumi.get(self, "proof_of_possession")

    @proof_of_possession.setter
    def proof_of_possession(self, value: Optional[pulumi.Input['ResourceServerProofOfPossessionArgs']]):
        pulumi.set(self, "proof_of_possession", value)

    @property
    @pulumi.getter(name="signingAlg")
    def signing_alg(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Algorithm used to sign JWTs. Options include `HS256`, `RS256`, and `PS256`.
        """
        return pulumi.get(self, "signing_alg")

    @signing_alg.setter
    def signing_alg(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "signing_alg", value)

    @property
    @pulumi.getter(name="signingSecret")
    def signing_secret(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Secret used to sign tokens when using symmetric algorithms (HS256).
        """
        return pulumi.get(self, "signing_secret")

    @signing_secret.setter
    def signing_secret(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "signing_secret", value)

    @property
    @pulumi.getter(name="skipConsentForVerifiableFirstPartyClients")
    def skip_consent_for_verifiable_first_party_clients(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Indicates whether to skip user consent for applications flagged as first party.
        """
        return pulumi.get(self, "skip_consent_for_verifiable_first_party_clients")

    @skip_consent_for_verifiable_first_party_clients.setter
    def skip_consent_for_verifiable_first_party_clients(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "skip_consent_for_verifiable_first_party_clients", value)

    @property
    @pulumi.getter(name="tokenDialect")
    def token_dialect(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Dialect of access tokens that should be issued for this resource server. Options include `access_token`, `rfc9068_profile`, `access_token_authz`, and `rfc9068_profile_authz`. `access_token` is a JWT containing standard Auth0 claims. `rfc9068_profile` is a JWT conforming to the IETF JWT Access Token Profile. `access_token_authz` is a JWT containing standard Auth0 claims, including RBAC permissions claims. `rfc9068_profile_authz` is a JWT conforming to the IETF JWT Access Token Profile, including RBAC permissions claims. RBAC permissions claims are available if RBAC (`enforce_policies`) is enabled for this API. For more details, refer to [Access Token Profiles](https://auth0.com/docs/secure/tokens/access-tokens/access-token-profiles).
        """
        return pulumi.get(self, "token_dialect")

    @token_dialect.setter
    def token_dialect(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "token_dialect", value)

    @property
    @pulumi.getter(name="tokenEncryption")
    def token_encryption(self) -> Optional[pulumi.Input['ResourceServerTokenEncryptionArgs']]:
        """
        Configuration for JSON Web Encryption(JWE) of tokens for this resource server.
        """
        return pulumi.get(self, "token_encryption")

    @token_encryption.setter
    def token_encryption(self, value: Optional[pulumi.Input['ResourceServerTokenEncryptionArgs']]):
        pulumi.set(self, "token_encryption", value)

    @property
    @pulumi.getter(name="tokenLifetime")
    def token_lifetime(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Number of seconds during which access tokens issued for this resource server from the token endpoint remain valid.
        """
        return pulumi.get(self, "token_lifetime")

    @token_lifetime.setter
    def token_lifetime(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "token_lifetime", value)

    @property
    @pulumi.getter(name="tokenLifetimeForWeb")
    def token_lifetime_for_web(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Number of seconds during which access tokens issued for this resource server via implicit or hybrid flows remain valid. Cannot be greater than the `token_lifetime` value.
        """
        return pulumi.get(self, "token_lifetime_for_web")

    @token_lifetime_for_web.setter
    def token_lifetime_for_web(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "token_lifetime_for_web", value)

    @property
    @pulumi.getter(name="verificationLocation")
    def verification_location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        URL from which to retrieve JWKs for this resource server. Used for verifying the JWT sent to Auth0 for token introspection.
        """
        return pulumi.get(self, "verification_location")

    @verification_location.setter
    def verification_location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "verification_location", value)


@pulumi.input_type
class _ResourceServerState:
    def __init__(__self__, *,
                 allow_offline_access: Optional[pulumi.Input[builtins.bool]] = None,
                 authorization_details: Optional[pulumi.Input[Sequence[pulumi.Input['ResourceServerAuthorizationDetailArgs']]]] = None,
                 consent_policy: Optional[pulumi.Input[builtins.str]] = None,
                 enforce_policies: Optional[pulumi.Input[builtins.bool]] = None,
                 identifier: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 proof_of_possession: Optional[pulumi.Input['ResourceServerProofOfPossessionArgs']] = None,
                 signing_alg: Optional[pulumi.Input[builtins.str]] = None,
                 signing_secret: Optional[pulumi.Input[builtins.str]] = None,
                 skip_consent_for_verifiable_first_party_clients: Optional[pulumi.Input[builtins.bool]] = None,
                 token_dialect: Optional[pulumi.Input[builtins.str]] = None,
                 token_encryption: Optional[pulumi.Input['ResourceServerTokenEncryptionArgs']] = None,
                 token_lifetime: Optional[pulumi.Input[builtins.int]] = None,
                 token_lifetime_for_web: Optional[pulumi.Input[builtins.int]] = None,
                 verification_location: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering ResourceServer resources.
        :param pulumi.Input[builtins.bool] allow_offline_access: Indicates whether refresh tokens can be issued for this resource server.
        :param pulumi.Input[Sequence[pulumi.Input['ResourceServerAuthorizationDetailArgs']]] authorization_details: Authorization details for this resource server.
        :param pulumi.Input[builtins.str] consent_policy: Consent policy for this resource server. Options include `transactional-authorization-with-mfa`, or `null` to disable.
        :param pulumi.Input[builtins.bool] enforce_policies: If this setting is enabled, RBAC authorization policies will be enforced for this API. Role and permission assignments will be evaluated during the login transaction.
        :param pulumi.Input[builtins.str] identifier: Unique identifier for the resource server. Used as the audience parameter for authorization calls. Cannot be changed once set.
        :param pulumi.Input[builtins.str] name: Friendly name for the resource server. Cannot include `<` or `>` characters.
        :param pulumi.Input['ResourceServerProofOfPossessionArgs'] proof_of_possession: Configuration settings for proof-of-possession for this resource server.
        :param pulumi.Input[builtins.str] signing_alg: Algorithm used to sign JWTs. Options include `HS256`, `RS256`, and `PS256`.
        :param pulumi.Input[builtins.str] signing_secret: Secret used to sign tokens when using symmetric algorithms (HS256).
        :param pulumi.Input[builtins.bool] skip_consent_for_verifiable_first_party_clients: Indicates whether to skip user consent for applications flagged as first party.
        :param pulumi.Input[builtins.str] token_dialect: Dialect of access tokens that should be issued for this resource server. Options include `access_token`, `rfc9068_profile`, `access_token_authz`, and `rfc9068_profile_authz`. `access_token` is a JWT containing standard Auth0 claims. `rfc9068_profile` is a JWT conforming to the IETF JWT Access Token Profile. `access_token_authz` is a JWT containing standard Auth0 claims, including RBAC permissions claims. `rfc9068_profile_authz` is a JWT conforming to the IETF JWT Access Token Profile, including RBAC permissions claims. RBAC permissions claims are available if RBAC (`enforce_policies`) is enabled for this API. For more details, refer to [Access Token Profiles](https://auth0.com/docs/secure/tokens/access-tokens/access-token-profiles).
        :param pulumi.Input['ResourceServerTokenEncryptionArgs'] token_encryption: Configuration for JSON Web Encryption(JWE) of tokens for this resource server.
        :param pulumi.Input[builtins.int] token_lifetime: Number of seconds during which access tokens issued for this resource server from the token endpoint remain valid.
        :param pulumi.Input[builtins.int] token_lifetime_for_web: Number of seconds during which access tokens issued for this resource server via implicit or hybrid flows remain valid. Cannot be greater than the `token_lifetime` value.
        :param pulumi.Input[builtins.str] verification_location: URL from which to retrieve JWKs for this resource server. Used for verifying the JWT sent to Auth0 for token introspection.
        """
        if allow_offline_access is not None:
            pulumi.set(__self__, "allow_offline_access", allow_offline_access)
        if authorization_details is not None:
            pulumi.set(__self__, "authorization_details", authorization_details)
        if consent_policy is not None:
            pulumi.set(__self__, "consent_policy", consent_policy)
        if enforce_policies is not None:
            pulumi.set(__self__, "enforce_policies", enforce_policies)
        if identifier is not None:
            pulumi.set(__self__, "identifier", identifier)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if proof_of_possession is not None:
            pulumi.set(__self__, "proof_of_possession", proof_of_possession)
        if signing_alg is not None:
            pulumi.set(__self__, "signing_alg", signing_alg)
        if signing_secret is not None:
            pulumi.set(__self__, "signing_secret", signing_secret)
        if skip_consent_for_verifiable_first_party_clients is not None:
            pulumi.set(__self__, "skip_consent_for_verifiable_first_party_clients", skip_consent_for_verifiable_first_party_clients)
        if token_dialect is not None:
            pulumi.set(__self__, "token_dialect", token_dialect)
        if token_encryption is not None:
            pulumi.set(__self__, "token_encryption", token_encryption)
        if token_lifetime is not None:
            pulumi.set(__self__, "token_lifetime", token_lifetime)
        if token_lifetime_for_web is not None:
            pulumi.set(__self__, "token_lifetime_for_web", token_lifetime_for_web)
        if verification_location is not None:
            pulumi.set(__self__, "verification_location", verification_location)

    @property
    @pulumi.getter(name="allowOfflineAccess")
    def allow_offline_access(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Indicates whether refresh tokens can be issued for this resource server.
        """
        return pulumi.get(self, "allow_offline_access")

    @allow_offline_access.setter
    def allow_offline_access(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "allow_offline_access", value)

    @property
    @pulumi.getter(name="authorizationDetails")
    def authorization_details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ResourceServerAuthorizationDetailArgs']]]]:
        """
        Authorization details for this resource server.
        """
        return pulumi.get(self, "authorization_details")

    @authorization_details.setter
    def authorization_details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ResourceServerAuthorizationDetailArgs']]]]):
        pulumi.set(self, "authorization_details", value)

    @property
    @pulumi.getter(name="consentPolicy")
    def consent_policy(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Consent policy for this resource server. Options include `transactional-authorization-with-mfa`, or `null` to disable.
        """
        return pulumi.get(self, "consent_policy")

    @consent_policy.setter
    def consent_policy(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "consent_policy", value)

    @property
    @pulumi.getter(name="enforcePolicies")
    def enforce_policies(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If this setting is enabled, RBAC authorization policies will be enforced for this API. Role and permission assignments will be evaluated during the login transaction.
        """
        return pulumi.get(self, "enforce_policies")

    @enforce_policies.setter
    def enforce_policies(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enforce_policies", value)

    @property
    @pulumi.getter
    def identifier(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Unique identifier for the resource server. Used as the audience parameter for authorization calls. Cannot be changed once set.
        """
        return pulumi.get(self, "identifier")

    @identifier.setter
    def identifier(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "identifier", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Friendly name for the resource server. Cannot include `<` or `>` characters.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="proofOfPossession")
    def proof_of_possession(self) -> Optional[pulumi.Input['ResourceServerProofOfPossessionArgs']]:
        """
        Configuration settings for proof-of-possession for this resource server.
        """
        return pulumi.get(self, "proof_of_possession")

    @proof_of_possession.setter
    def proof_of_possession(self, value: Optional[pulumi.Input['ResourceServerProofOfPossessionArgs']]):
        pulumi.set(self, "proof_of_possession", value)

    @property
    @pulumi.getter(name="signingAlg")
    def signing_alg(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Algorithm used to sign JWTs. Options include `HS256`, `RS256`, and `PS256`.
        """
        return pulumi.get(self, "signing_alg")

    @signing_alg.setter
    def signing_alg(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "signing_alg", value)

    @property
    @pulumi.getter(name="signingSecret")
    def signing_secret(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Secret used to sign tokens when using symmetric algorithms (HS256).
        """
        return pulumi.get(self, "signing_secret")

    @signing_secret.setter
    def signing_secret(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "signing_secret", value)

    @property
    @pulumi.getter(name="skipConsentForVerifiableFirstPartyClients")
    def skip_consent_for_verifiable_first_party_clients(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Indicates whether to skip user consent for applications flagged as first party.
        """
        return pulumi.get(self, "skip_consent_for_verifiable_first_party_clients")

    @skip_consent_for_verifiable_first_party_clients.setter
    def skip_consent_for_verifiable_first_party_clients(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "skip_consent_for_verifiable_first_party_clients", value)

    @property
    @pulumi.getter(name="tokenDialect")
    def token_dialect(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Dialect of access tokens that should be issued for this resource server. Options include `access_token`, `rfc9068_profile`, `access_token_authz`, and `rfc9068_profile_authz`. `access_token` is a JWT containing standard Auth0 claims. `rfc9068_profile` is a JWT conforming to the IETF JWT Access Token Profile. `access_token_authz` is a JWT containing standard Auth0 claims, including RBAC permissions claims. `rfc9068_profile_authz` is a JWT conforming to the IETF JWT Access Token Profile, including RBAC permissions claims. RBAC permissions claims are available if RBAC (`enforce_policies`) is enabled for this API. For more details, refer to [Access Token Profiles](https://auth0.com/docs/secure/tokens/access-tokens/access-token-profiles).
        """
        return pulumi.get(self, "token_dialect")

    @token_dialect.setter
    def token_dialect(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "token_dialect", value)

    @property
    @pulumi.getter(name="tokenEncryption")
    def token_encryption(self) -> Optional[pulumi.Input['ResourceServerTokenEncryptionArgs']]:
        """
        Configuration for JSON Web Encryption(JWE) of tokens for this resource server.
        """
        return pulumi.get(self, "token_encryption")

    @token_encryption.setter
    def token_encryption(self, value: Optional[pulumi.Input['ResourceServerTokenEncryptionArgs']]):
        pulumi.set(self, "token_encryption", value)

    @property
    @pulumi.getter(name="tokenLifetime")
    def token_lifetime(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Number of seconds during which access tokens issued for this resource server from the token endpoint remain valid.
        """
        return pulumi.get(self, "token_lifetime")

    @token_lifetime.setter
    def token_lifetime(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "token_lifetime", value)

    @property
    @pulumi.getter(name="tokenLifetimeForWeb")
    def token_lifetime_for_web(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Number of seconds during which access tokens issued for this resource server via implicit or hybrid flows remain valid. Cannot be greater than the `token_lifetime` value.
        """
        return pulumi.get(self, "token_lifetime_for_web")

    @token_lifetime_for_web.setter
    def token_lifetime_for_web(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "token_lifetime_for_web", value)

    @property
    @pulumi.getter(name="verificationLocation")
    def verification_location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        URL from which to retrieve JWKs for this resource server. Used for verifying the JWT sent to Auth0 for token introspection.
        """
        return pulumi.get(self, "verification_location")

    @verification_location.setter
    def verification_location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "verification_location", value)


@pulumi.type_token("auth0:index/resourceServer:ResourceServer")
class ResourceServer(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allow_offline_access: Optional[pulumi.Input[builtins.bool]] = None,
                 authorization_details: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ResourceServerAuthorizationDetailArgs', 'ResourceServerAuthorizationDetailArgsDict']]]]] = None,
                 consent_policy: Optional[pulumi.Input[builtins.str]] = None,
                 enforce_policies: Optional[pulumi.Input[builtins.bool]] = None,
                 identifier: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 proof_of_possession: Optional[pulumi.Input[Union['ResourceServerProofOfPossessionArgs', 'ResourceServerProofOfPossessionArgsDict']]] = None,
                 signing_alg: Optional[pulumi.Input[builtins.str]] = None,
                 signing_secret: Optional[pulumi.Input[builtins.str]] = None,
                 skip_consent_for_verifiable_first_party_clients: Optional[pulumi.Input[builtins.bool]] = None,
                 token_dialect: Optional[pulumi.Input[builtins.str]] = None,
                 token_encryption: Optional[pulumi.Input[Union['ResourceServerTokenEncryptionArgs', 'ResourceServerTokenEncryptionArgsDict']]] = None,
                 token_lifetime: Optional[pulumi.Input[builtins.int]] = None,
                 token_lifetime_for_web: Optional[pulumi.Input[builtins.int]] = None,
                 verification_location: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        With this resource, you can set up APIs that can be consumed from your authorized applications.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_auth0 as auth0

        my_resource_server = auth0.ResourceServer("my_resource_server",
            name="Example Resource Server (Managed by Terraform)",
            identifier="https://api.example.com",
            signing_alg="RS256",
            allow_offline_access=True,
            token_lifetime=8600,
            skip_consent_for_verifiable_first_party_clients=True,
            consent_policy="transactional-authorization-with-mfa",
            token_encryption={
                "format": "compact-nested-jwe",
                "encryption_key": {
                    "name": "keyname",
                    "algorithm": "RSA-OAEP-256",
                    "pem": \"\"\"-----BEGIN CERTIFICATE-----
        MIIFWDCCA0ACCQDXqpBo3R...G9w0BAQsFADBuMQswCQYDVQQGEwJl
        -----END CERTIFICATE-----
        \"\"\",
                },
            },
            authorization_details=[
                {
                    "type": "payment",
                },
                {
                    "type": "non-payment",
                },
            ],
            proof_of_possession={
                "mechanism": "mtls",
                "required": True,
            })
        ```

        ## Import

        Existing resource servers can be imported using their ID.

        Example:

        ```sh
        $ pulumi import auth0:index/resourceServer:ResourceServer my_resource_server "XXXXXXXXXXXXXXXXXXXXXXX"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] allow_offline_access: Indicates whether refresh tokens can be issued for this resource server.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ResourceServerAuthorizationDetailArgs', 'ResourceServerAuthorizationDetailArgsDict']]]] authorization_details: Authorization details for this resource server.
        :param pulumi.Input[builtins.str] consent_policy: Consent policy for this resource server. Options include `transactional-authorization-with-mfa`, or `null` to disable.
        :param pulumi.Input[builtins.bool] enforce_policies: If this setting is enabled, RBAC authorization policies will be enforced for this API. Role and permission assignments will be evaluated during the login transaction.
        :param pulumi.Input[builtins.str] identifier: Unique identifier for the resource server. Used as the audience parameter for authorization calls. Cannot be changed once set.
        :param pulumi.Input[builtins.str] name: Friendly name for the resource server. Cannot include `<` or `>` characters.
        :param pulumi.Input[Union['ResourceServerProofOfPossessionArgs', 'ResourceServerProofOfPossessionArgsDict']] proof_of_possession: Configuration settings for proof-of-possession for this resource server.
        :param pulumi.Input[builtins.str] signing_alg: Algorithm used to sign JWTs. Options include `HS256`, `RS256`, and `PS256`.
        :param pulumi.Input[builtins.str] signing_secret: Secret used to sign tokens when using symmetric algorithms (HS256).
        :param pulumi.Input[builtins.bool] skip_consent_for_verifiable_first_party_clients: Indicates whether to skip user consent for applications flagged as first party.
        :param pulumi.Input[builtins.str] token_dialect: Dialect of access tokens that should be issued for this resource server. Options include `access_token`, `rfc9068_profile`, `access_token_authz`, and `rfc9068_profile_authz`. `access_token` is a JWT containing standard Auth0 claims. `rfc9068_profile` is a JWT conforming to the IETF JWT Access Token Profile. `access_token_authz` is a JWT containing standard Auth0 claims, including RBAC permissions claims. `rfc9068_profile_authz` is a JWT conforming to the IETF JWT Access Token Profile, including RBAC permissions claims. RBAC permissions claims are available if RBAC (`enforce_policies`) is enabled for this API. For more details, refer to [Access Token Profiles](https://auth0.com/docs/secure/tokens/access-tokens/access-token-profiles).
        :param pulumi.Input[Union['ResourceServerTokenEncryptionArgs', 'ResourceServerTokenEncryptionArgsDict']] token_encryption: Configuration for JSON Web Encryption(JWE) of tokens for this resource server.
        :param pulumi.Input[builtins.int] token_lifetime: Number of seconds during which access tokens issued for this resource server from the token endpoint remain valid.
        :param pulumi.Input[builtins.int] token_lifetime_for_web: Number of seconds during which access tokens issued for this resource server via implicit or hybrid flows remain valid. Cannot be greater than the `token_lifetime` value.
        :param pulumi.Input[builtins.str] verification_location: URL from which to retrieve JWKs for this resource server. Used for verifying the JWT sent to Auth0 for token introspection.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ResourceServerArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        With this resource, you can set up APIs that can be consumed from your authorized applications.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_auth0 as auth0

        my_resource_server = auth0.ResourceServer("my_resource_server",
            name="Example Resource Server (Managed by Terraform)",
            identifier="https://api.example.com",
            signing_alg="RS256",
            allow_offline_access=True,
            token_lifetime=8600,
            skip_consent_for_verifiable_first_party_clients=True,
            consent_policy="transactional-authorization-with-mfa",
            token_encryption={
                "format": "compact-nested-jwe",
                "encryption_key": {
                    "name": "keyname",
                    "algorithm": "RSA-OAEP-256",
                    "pem": \"\"\"-----BEGIN CERTIFICATE-----
        MIIFWDCCA0ACCQDXqpBo3R...G9w0BAQsFADBuMQswCQYDVQQGEwJl
        -----END CERTIFICATE-----
        \"\"\",
                },
            },
            authorization_details=[
                {
                    "type": "payment",
                },
                {
                    "type": "non-payment",
                },
            ],
            proof_of_possession={
                "mechanism": "mtls",
                "required": True,
            })
        ```

        ## Import

        Existing resource servers can be imported using their ID.

        Example:

        ```sh
        $ pulumi import auth0:index/resourceServer:ResourceServer my_resource_server "XXXXXXXXXXXXXXXXXXXXXXX"
        ```

        :param str resource_name: The name of the resource.
        :param ResourceServerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ResourceServerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allow_offline_access: Optional[pulumi.Input[builtins.bool]] = None,
                 authorization_details: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ResourceServerAuthorizationDetailArgs', 'ResourceServerAuthorizationDetailArgsDict']]]]] = None,
                 consent_policy: Optional[pulumi.Input[builtins.str]] = None,
                 enforce_policies: Optional[pulumi.Input[builtins.bool]] = None,
                 identifier: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 proof_of_possession: Optional[pulumi.Input[Union['ResourceServerProofOfPossessionArgs', 'ResourceServerProofOfPossessionArgsDict']]] = None,
                 signing_alg: Optional[pulumi.Input[builtins.str]] = None,
                 signing_secret: Optional[pulumi.Input[builtins.str]] = None,
                 skip_consent_for_verifiable_first_party_clients: Optional[pulumi.Input[builtins.bool]] = None,
                 token_dialect: Optional[pulumi.Input[builtins.str]] = None,
                 token_encryption: Optional[pulumi.Input[Union['ResourceServerTokenEncryptionArgs', 'ResourceServerTokenEncryptionArgsDict']]] = None,
                 token_lifetime: Optional[pulumi.Input[builtins.int]] = None,
                 token_lifetime_for_web: Optional[pulumi.Input[builtins.int]] = None,
                 verification_location: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ResourceServerArgs.__new__(ResourceServerArgs)

            __props__.__dict__["allow_offline_access"] = allow_offline_access
            __props__.__dict__["authorization_details"] = authorization_details
            __props__.__dict__["consent_policy"] = consent_policy
            __props__.__dict__["enforce_policies"] = enforce_policies
            if identifier is None and not opts.urn:
                raise TypeError("Missing required property 'identifier'")
            __props__.__dict__["identifier"] = identifier
            __props__.__dict__["name"] = name
            __props__.__dict__["proof_of_possession"] = proof_of_possession
            __props__.__dict__["signing_alg"] = signing_alg
            __props__.__dict__["signing_secret"] = signing_secret
            __props__.__dict__["skip_consent_for_verifiable_first_party_clients"] = skip_consent_for_verifiable_first_party_clients
            __props__.__dict__["token_dialect"] = token_dialect
            __props__.__dict__["token_encryption"] = token_encryption
            __props__.__dict__["token_lifetime"] = token_lifetime
            __props__.__dict__["token_lifetime_for_web"] = token_lifetime_for_web
            __props__.__dict__["verification_location"] = verification_location
        super(ResourceServer, __self__).__init__(
            'auth0:index/resourceServer:ResourceServer',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            allow_offline_access: Optional[pulumi.Input[builtins.bool]] = None,
            authorization_details: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ResourceServerAuthorizationDetailArgs', 'ResourceServerAuthorizationDetailArgsDict']]]]] = None,
            consent_policy: Optional[pulumi.Input[builtins.str]] = None,
            enforce_policies: Optional[pulumi.Input[builtins.bool]] = None,
            identifier: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            proof_of_possession: Optional[pulumi.Input[Union['ResourceServerProofOfPossessionArgs', 'ResourceServerProofOfPossessionArgsDict']]] = None,
            signing_alg: Optional[pulumi.Input[builtins.str]] = None,
            signing_secret: Optional[pulumi.Input[builtins.str]] = None,
            skip_consent_for_verifiable_first_party_clients: Optional[pulumi.Input[builtins.bool]] = None,
            token_dialect: Optional[pulumi.Input[builtins.str]] = None,
            token_encryption: Optional[pulumi.Input[Union['ResourceServerTokenEncryptionArgs', 'ResourceServerTokenEncryptionArgsDict']]] = None,
            token_lifetime: Optional[pulumi.Input[builtins.int]] = None,
            token_lifetime_for_web: Optional[pulumi.Input[builtins.int]] = None,
            verification_location: Optional[pulumi.Input[builtins.str]] = None) -> 'ResourceServer':
        """
        Get an existing ResourceServer resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] allow_offline_access: Indicates whether refresh tokens can be issued for this resource server.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ResourceServerAuthorizationDetailArgs', 'ResourceServerAuthorizationDetailArgsDict']]]] authorization_details: Authorization details for this resource server.
        :param pulumi.Input[builtins.str] consent_policy: Consent policy for this resource server. Options include `transactional-authorization-with-mfa`, or `null` to disable.
        :param pulumi.Input[builtins.bool] enforce_policies: If this setting is enabled, RBAC authorization policies will be enforced for this API. Role and permission assignments will be evaluated during the login transaction.
        :param pulumi.Input[builtins.str] identifier: Unique identifier for the resource server. Used as the audience parameter for authorization calls. Cannot be changed once set.
        :param pulumi.Input[builtins.str] name: Friendly name for the resource server. Cannot include `<` or `>` characters.
        :param pulumi.Input[Union['ResourceServerProofOfPossessionArgs', 'ResourceServerProofOfPossessionArgsDict']] proof_of_possession: Configuration settings for proof-of-possession for this resource server.
        :param pulumi.Input[builtins.str] signing_alg: Algorithm used to sign JWTs. Options include `HS256`, `RS256`, and `PS256`.
        :param pulumi.Input[builtins.str] signing_secret: Secret used to sign tokens when using symmetric algorithms (HS256).
        :param pulumi.Input[builtins.bool] skip_consent_for_verifiable_first_party_clients: Indicates whether to skip user consent for applications flagged as first party.
        :param pulumi.Input[builtins.str] token_dialect: Dialect of access tokens that should be issued for this resource server. Options include `access_token`, `rfc9068_profile`, `access_token_authz`, and `rfc9068_profile_authz`. `access_token` is a JWT containing standard Auth0 claims. `rfc9068_profile` is a JWT conforming to the IETF JWT Access Token Profile. `access_token_authz` is a JWT containing standard Auth0 claims, including RBAC permissions claims. `rfc9068_profile_authz` is a JWT conforming to the IETF JWT Access Token Profile, including RBAC permissions claims. RBAC permissions claims are available if RBAC (`enforce_policies`) is enabled for this API. For more details, refer to [Access Token Profiles](https://auth0.com/docs/secure/tokens/access-tokens/access-token-profiles).
        :param pulumi.Input[Union['ResourceServerTokenEncryptionArgs', 'ResourceServerTokenEncryptionArgsDict']] token_encryption: Configuration for JSON Web Encryption(JWE) of tokens for this resource server.
        :param pulumi.Input[builtins.int] token_lifetime: Number of seconds during which access tokens issued for this resource server from the token endpoint remain valid.
        :param pulumi.Input[builtins.int] token_lifetime_for_web: Number of seconds during which access tokens issued for this resource server via implicit or hybrid flows remain valid. Cannot be greater than the `token_lifetime` value.
        :param pulumi.Input[builtins.str] verification_location: URL from which to retrieve JWKs for this resource server. Used for verifying the JWT sent to Auth0 for token introspection.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ResourceServerState.__new__(_ResourceServerState)

        __props__.__dict__["allow_offline_access"] = allow_offline_access
        __props__.__dict__["authorization_details"] = authorization_details
        __props__.__dict__["consent_policy"] = consent_policy
        __props__.__dict__["enforce_policies"] = enforce_policies
        __props__.__dict__["identifier"] = identifier
        __props__.__dict__["name"] = name
        __props__.__dict__["proof_of_possession"] = proof_of_possession
        __props__.__dict__["signing_alg"] = signing_alg
        __props__.__dict__["signing_secret"] = signing_secret
        __props__.__dict__["skip_consent_for_verifiable_first_party_clients"] = skip_consent_for_verifiable_first_party_clients
        __props__.__dict__["token_dialect"] = token_dialect
        __props__.__dict__["token_encryption"] = token_encryption
        __props__.__dict__["token_lifetime"] = token_lifetime
        __props__.__dict__["token_lifetime_for_web"] = token_lifetime_for_web
        __props__.__dict__["verification_location"] = verification_location
        return ResourceServer(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="allowOfflineAccess")
    def allow_offline_access(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Indicates whether refresh tokens can be issued for this resource server.
        """
        return pulumi.get(self, "allow_offline_access")

    @property
    @pulumi.getter(name="authorizationDetails")
    def authorization_details(self) -> pulumi.Output[Sequence['outputs.ResourceServerAuthorizationDetail']]:
        """
        Authorization details for this resource server.
        """
        return pulumi.get(self, "authorization_details")

    @property
    @pulumi.getter(name="consentPolicy")
    def consent_policy(self) -> pulumi.Output[builtins.str]:
        """
        Consent policy for this resource server. Options include `transactional-authorization-with-mfa`, or `null` to disable.
        """
        return pulumi.get(self, "consent_policy")

    @property
    @pulumi.getter(name="enforcePolicies")
    def enforce_policies(self) -> pulumi.Output[builtins.bool]:
        """
        If this setting is enabled, RBAC authorization policies will be enforced for this API. Role and permission assignments will be evaluated during the login transaction.
        """
        return pulumi.get(self, "enforce_policies")

    @property
    @pulumi.getter
    def identifier(self) -> pulumi.Output[builtins.str]:
        """
        Unique identifier for the resource server. Used as the audience parameter for authorization calls. Cannot be changed once set.
        """
        return pulumi.get(self, "identifier")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Friendly name for the resource server. Cannot include `<` or `>` characters.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="proofOfPossession")
    def proof_of_possession(self) -> pulumi.Output['outputs.ResourceServerProofOfPossession']:
        """
        Configuration settings for proof-of-possession for this resource server.
        """
        return pulumi.get(self, "proof_of_possession")

    @property
    @pulumi.getter(name="signingAlg")
    def signing_alg(self) -> pulumi.Output[builtins.str]:
        """
        Algorithm used to sign JWTs. Options include `HS256`, `RS256`, and `PS256`.
        """
        return pulumi.get(self, "signing_alg")

    @property
    @pulumi.getter(name="signingSecret")
    def signing_secret(self) -> pulumi.Output[builtins.str]:
        """
        Secret used to sign tokens when using symmetric algorithms (HS256).
        """
        return pulumi.get(self, "signing_secret")

    @property
    @pulumi.getter(name="skipConsentForVerifiableFirstPartyClients")
    def skip_consent_for_verifiable_first_party_clients(self) -> pulumi.Output[builtins.bool]:
        """
        Indicates whether to skip user consent for applications flagged as first party.
        """
        return pulumi.get(self, "skip_consent_for_verifiable_first_party_clients")

    @property
    @pulumi.getter(name="tokenDialect")
    def token_dialect(self) -> pulumi.Output[builtins.str]:
        """
        Dialect of access tokens that should be issued for this resource server. Options include `access_token`, `rfc9068_profile`, `access_token_authz`, and `rfc9068_profile_authz`. `access_token` is a JWT containing standard Auth0 claims. `rfc9068_profile` is a JWT conforming to the IETF JWT Access Token Profile. `access_token_authz` is a JWT containing standard Auth0 claims, including RBAC permissions claims. `rfc9068_profile_authz` is a JWT conforming to the IETF JWT Access Token Profile, including RBAC permissions claims. RBAC permissions claims are available if RBAC (`enforce_policies`) is enabled for this API. For more details, refer to [Access Token Profiles](https://auth0.com/docs/secure/tokens/access-tokens/access-token-profiles).
        """
        return pulumi.get(self, "token_dialect")

    @property
    @pulumi.getter(name="tokenEncryption")
    def token_encryption(self) -> pulumi.Output['outputs.ResourceServerTokenEncryption']:
        """
        Configuration for JSON Web Encryption(JWE) of tokens for this resource server.
        """
        return pulumi.get(self, "token_encryption")

    @property
    @pulumi.getter(name="tokenLifetime")
    def token_lifetime(self) -> pulumi.Output[builtins.int]:
        """
        Number of seconds during which access tokens issued for this resource server from the token endpoint remain valid.
        """
        return pulumi.get(self, "token_lifetime")

    @property
    @pulumi.getter(name="tokenLifetimeForWeb")
    def token_lifetime_for_web(self) -> pulumi.Output[builtins.int]:
        """
        Number of seconds during which access tokens issued for this resource server via implicit or hybrid flows remain valid. Cannot be greater than the `token_lifetime` value.
        """
        return pulumi.get(self, "token_lifetime_for_web")

    @property
    @pulumi.getter(name="verificationLocation")
    def verification_location(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        URL from which to retrieve JWKs for this resource server. Used for verifying the JWT sent to Auth0 for token introspection.
        """
        return pulumi.get(self, "verification_location")

