# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""

from enum import Enum
from apimatic_core.http.configurations.http_client_configuration import HttpClientConfiguration
from apimatic_requests_client_adapter.requests_client import RequestsClient


class Environment(Enum):
    """An enum for SDK environments"""
    PRODUCTION = 0


class Server(Enum):
    """An enum for API servers"""
    CONSENT = 0
    CORE = 1
    CUSTOMER = 2
    EVENTNOTIFICATIONS = 3
    FRAUD = 4
    META = 5
    MONEYMOVEMENT = 6
    PAYROLL = 7
    RECIPIENTREGISTRATION = 8
    REGISTRY = 9
    USTAX = 10
    RESOURCE = 11


class Configuration(HttpClientConfiguration):
    """A class used for configuring the SDK by a user.
    """

    @property
    def environment(self):
        return self._environment

    @property
    def bearer_auth_credentials(self):
        return self._bearer_auth_credentials

    @property
    def tax_basic_auth_credentials(self):
        return self._tax_basic_auth_credentials

    def __init__(self, http_client_instance=None,
                 override_http_client_configuration=False, http_call_back=None,
                 timeout=60, max_retries=0, backoff_factor=2,
                 retry_statuses=None, retry_methods=None, proxy_settings=None,
                 logging_configuration=None, environment=Environment.PRODUCTION,
                 bearer_auth_credentials=None, tax_basic_auth_credentials=None):
        if retry_methods is None:
            retry_methods = ['GET', 'PUT']

        if retry_statuses is None:
            retry_statuses = [408, 413, 429, 500, 502, 503, 504, 521, 522, 524]

        super().__init__(
            http_client_instance=http_client_instance,
            override_http_client_configuration=override_http_client_configuration,
            http_call_back=http_call_back, timeout=timeout,
            max_retries=max_retries, backoff_factor=backoff_factor,
            retry_statuses=retry_statuses, retry_methods=retry_methods,
            proxy_settings=proxy_settings,
            logging_configuration=logging_configuration
        )

        # Current API environment
        self._environment = environment

        # The object holding OAuth 2 Bearer token credentials
        self._bearer_auth_credentials = bearer_auth_credentials

        # The object holding Basic Authentication credentials
        self._tax_basic_auth_credentials = tax_basic_auth_credentials

        # The Http Client to use for making requests.
        self.set_http_client(self.create_http_client())

    def clone_with(self, http_client_instance=None,
                   override_http_client_configuration=None, http_call_back=None,
                   timeout=None, max_retries=None, backoff_factor=None,
                   retry_statuses=None, retry_methods=None, proxy_settings=None,
                   logging_configuration=None, environment=None,
                   bearer_auth_credentials=None,
                   tax_basic_auth_credentials=None):
        http_client_instance = http_client_instance or self.http_client_instance
        override_http_client_configuration = override_http_client_configuration or self.override_http_client_configuration
        http_call_back = http_call_back or self.http_callback
        timeout = timeout or self.timeout
        max_retries = max_retries or self.max_retries
        backoff_factor = backoff_factor or self.backoff_factor
        retry_statuses = retry_statuses or self.retry_statuses
        retry_methods = retry_methods or self.retry_methods
        proxy_settings = proxy_settings or self.proxy_settings
        logging_configuration = logging_configuration or self.logging_configuration
        environment = environment or self.environment
        bearer_auth_credentials = bearer_auth_credentials or self.bearer_auth_credentials
        tax_basic_auth_credentials = tax_basic_auth_credentials or self.tax_basic_auth_credentials
        return Configuration(
            http_client_instance=http_client_instance,
            override_http_client_configuration=override_http_client_configuration,
            http_call_back=http_call_back, timeout=timeout,
            max_retries=max_retries, backoff_factor=backoff_factor,
            retry_statuses=retry_statuses, retry_methods=retry_methods,
            proxy_settings=proxy_settings,
            logging_configuration=logging_configuration, environment=environment,
            bearer_auth_credentials=bearer_auth_credentials,
            tax_basic_auth_credentials=tax_basic_auth_credentials
        )

    def create_http_client(self):
        return RequestsClient(
            timeout=self.timeout, max_retries=self.max_retries,
            backoff_factor=self.backoff_factor, retry_statuses=self.retry_statuses,
            retry_methods=self.retry_methods,
            http_client_instance=self.http_client_instance,
            override_http_client_configuration=self.override_http_client_configuration,
            response_factory=self.http_response_factory,
            proxies=self.proxy_settings.to_proxies() if self.proxy_settings else None
        )

    # All the environments the SDK can run in
    environments = {
        Environment.PRODUCTION: {
            Server.CONSENT: 'https://financialdataexchange-prod.apigee.net/fdx-consent-api-v6.2.0',
            Server.CORE: 'https://financialdataexchange-prod.apigee.net/fdx-core-api-v6.2.0',
            Server.CUSTOMER: 'https://financialdataexchange-prod.apigee.net/fdx-customer-api-v6.2.0',
            Server.EVENTNOTIFICATIONS: 'https://financialdataexchange-prod.apigee.net/fdx-event-notifications-api-v6.2.0',
            Server.FRAUD: 'https://financialdataexchange-prod.apigee.net/fdx-fraud-api-v6.2.0',
            Server.META: 'https://financialdataexchange-prod.apigee.net/fdx-meta-api-v6.2.0',
            Server.MONEYMOVEMENT: 'https://financialdataexchange-prod.apigee.net/fdx-money-movement-api-v6.2.0',
            Server.PAYROLL: 'https://financialdataexchange-prod.apigee.net/fdx-payroll-api-v6.2.0',
            Server.RECIPIENTREGISTRATION: 'https://financialdataexchange-prod.apigee.net/fdx-recipient-registration-api-v6.1.0',
            Server.REGISTRY: 'https://financialdataexchange-prod.apigee.net/fdx-registry-api-v6.1.0',
            Server.USTAX: 'https://financialdataexchange-prod.apigee.net/fdx-tax-api-v6.1.0',
            Server.RESOURCE: 'https://financialdataexchange-prod.apigee.net/fdx-resource-api-v6.1.0'
        }
    }

    def get_base_uri(self, server=Server.CONSENT):
        """Generates the appropriate base URI for the environment and the
        server.

        Args:
            server (Configuration.Server): The server enum for which the base
            URI is required.

        Returns:
            String: The base URI.

        """
        return self.environments[self.environment][server]
