# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""

from fdxapi.api_helper import APIHelper
from fdxapi.configuration import Server
from fdxapi.http.api_response import ApiResponse
from fdxapi.controllers.base_controller import BaseController
from apimatic_core.request_builder import RequestBuilder
from apimatic_core.response_handler import ResponseHandler
from apimatic_core.types.parameter import Parameter
from fdxapi.http.http_method_enum import HttpMethodEnum
from apimatic_core.authentication.multiple.single_auth import Single
from fdxapi.models.notification_subscription_entity import NotificationSubscriptionEntity
from fdxapi.models.notifications_entity import NotificationsEntity
from fdxapi.exceptions.error_exception import ErrorException


class EventNotificationsController(BaseController):

    """A Controller to access Endpoints in the fdxapi API."""
    def __init__(self, config):
        super(EventNotificationsController, self).__init__(config)

    def create_notification_subscription(self,
                                         x_fapi_interaction_id,
                                         fdx_api_actor_type=None,
                                         body=None):
        """Does a POST request to /notification-subscriptions.

        Creates notification subscription entry on the server

        Args:
            x_fapi_interaction_id (uuid|str): Unique identifier for this
                interaction
            fdx_api_actor_type (FdxApiActorType, optional): Identifies whether
                the customer is present (USER) or it is a BATCH operation
            body (NotificationSubscriptionEntity, optional): Notification
                subscription

        Returns:
            ApiResponse: An object with the response value as well as other
                useful information such as status codes and headers. Created

        Raises:
            ApiException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        return super().new_api_call_builder.request(
            RequestBuilder().server(Server.EVENTNOTIFICATIONS)
            .path('/notification-subscriptions')
            .http_method(HttpMethodEnum.POST)
            .header_param(Parameter()
                          .key('x-fapi-interaction-id')
                          .value(x_fapi_interaction_id)
                          .is_required(True))
            .header_param(Parameter()
                          .key('Content-Type')
                          .value('application/json'))
            .header_param(Parameter()
                          .key('FDX-API-Actor-Type')
                          .value(fdx_api_actor_type))
            .body_param(Parameter()
                        .value(body))
            .header_param(Parameter()
                          .key('accept')
                          .value('application/json'))
            .body_serializer(APIHelper.json_serialize)
            .auth(Single('bearerAuth'))
        ).response(
            ResponseHandler()
            .deserializer(APIHelper.json_deserialize)
            .deserialize_into(NotificationSubscriptionEntity.from_dictionary)
            .is_api_response(True)
            .local_error('400', 'Input sent by client does not satisfy API specification', ErrorException)
            .local_error('401', 'Request lacks valid authentication credentials for the target resource', ErrorException)
            .local_error('405', 'Method Not Allowed', ErrorException)
            .local_error('429', 'Too Many Requests', ErrorException)
            .local_error('500', 'Catch-all exception where request was not processed due to an internal outage/issue. Consider other more specific errors before using this error', ErrorException)
            .local_error('501', 'Error when FdxVersion in Header is not one of those implemented at backend', ErrorException)
            .local_error('503', 'System is down for maintenance', ErrorException)
        ).execute()

    def get_notification_subscription(self,
                                      x_fapi_interaction_id,
                                      subscription_id,
                                      fdx_api_actor_type=None):
        """Does a GET request to /notification-subscriptions/{subscriptionId}.

        Call to get notification subscription

        Args:
            x_fapi_interaction_id (uuid|str): Unique identifier for this
                interaction
            subscription_id (str): ID of notification subscription
            fdx_api_actor_type (FdxApiActorType, optional): Identifies whether
                the customer is present (USER) or it is a BATCH operation

        Returns:
            ApiResponse: An object with the response value as well as other
                useful information such as status codes and headers. OK

        Raises:
            ApiException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        return super().new_api_call_builder.request(
            RequestBuilder().server(Server.EVENTNOTIFICATIONS)
            .path('/notification-subscriptions/{subscriptionId}')
            .http_method(HttpMethodEnum.GET)
            .header_param(Parameter()
                          .key('x-fapi-interaction-id')
                          .value(x_fapi_interaction_id)
                          .is_required(True))
            .template_param(Parameter()
                            .key('subscriptionId')
                            .value(subscription_id)
                            .is_required(True)
                            .should_encode(True))
            .header_param(Parameter()
                          .key('FDX-API-Actor-Type')
                          .value(fdx_api_actor_type))
            .header_param(Parameter()
                          .key('accept')
                          .value('application/json'))
            .auth(Single('bearerAuth'))
        ).response(
            ResponseHandler()
            .deserializer(APIHelper.json_deserialize)
            .deserialize_into(NotificationSubscriptionEntity.from_dictionary)
            .is_api_response(True)
            .local_error('400', 'Input sent by client does not satisfy API specification', ErrorException)
            .local_error('401', 'Request lacks valid authentication credentials for the target resource', ErrorException)
            .local_error('405', 'Method Not Allowed', ErrorException)
            .local_error('429', 'Too Many Requests', ErrorException)
            .local_error('500', 'Catch-all exception where request was not processed due to an internal outage/issue. Consider other more specific errors before using this error', ErrorException)
            .local_error('501', 'Error when FdxVersion in Header is not one of those implemented at backend', ErrorException)
            .local_error('503', 'System is down for maintenance', ErrorException)
        ).execute()

    def delete_notification_subscription(self,
                                         x_fapi_interaction_id,
                                         subscription_id,
                                         fdx_api_actor_type=None):
        """Does a DELETE request to /notification-subscriptions/{subscriptionId}.

        Delete a notification subscription

        Args:
            x_fapi_interaction_id (uuid|str): Unique identifier for this
                interaction
            subscription_id (str): ID of notification subscription
            fdx_api_actor_type (FdxApiActorType, optional): Identifies whether
                the customer is present (USER) or it is a BATCH operation

        Returns:
            ApiResponse: An object with the response value as well as other
                useful information such as status codes and headers. No Content

        Raises:
            ApiException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        return super().new_api_call_builder.request(
            RequestBuilder().server(Server.EVENTNOTIFICATIONS)
            .path('/notification-subscriptions/{subscriptionId}')
            .http_method(HttpMethodEnum.DELETE)
            .header_param(Parameter()
                          .key('x-fapi-interaction-id')
                          .value(x_fapi_interaction_id)
                          .is_required(True))
            .template_param(Parameter()
                            .key('subscriptionId')
                            .value(subscription_id)
                            .is_required(True)
                            .should_encode(True))
            .header_param(Parameter()
                          .key('FDX-API-Actor-Type')
                          .value(fdx_api_actor_type))
            .auth(Single('bearerAuth'))
        ).response(
            ResponseHandler()
            .is_api_response(True)
            .local_error('400', 'Bad Request', ErrorException)
            .local_error('401', 'Request lacks valid authentication credentials for the target resource', ErrorException)
            .local_error('405', 'Method Not Allowed', ErrorException)
            .local_error('429', 'Too Many Requests', ErrorException)
            .local_error('500', 'Catch-all exception where request was not processed due to an internal outage/issue. Consider other more specific errors before using this error', ErrorException)
            .local_error('501', 'Error when FdxVersion in Header is not one of those implemented at backend', ErrorException)
            .local_error('503', 'System is down for maintenance', ErrorException)
        ).execute()

    def publish_notification(self,
                             x_fapi_interaction_id,
                             fdx_api_actor_type=None,
                             body=None):
        """Does a POST request to /notifications.

        Publish Notification

        Args:
            x_fapi_interaction_id (uuid|str): Unique identifier for this
                interaction
            fdx_api_actor_type (FdxApiActorType, optional): Identifies whether
                the customer is present (USER) or it is a BATCH operation
            body (NotificationEntity, optional): The request body parameter.

        Returns:
            ApiResponse: An object with the response value as well as other
                useful information such as status codes and headers. No Content

        Raises:
            ApiException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        return super().new_api_call_builder.request(
            RequestBuilder().server(Server.EVENTNOTIFICATIONS)
            .path('/notifications')
            .http_method(HttpMethodEnum.POST)
            .header_param(Parameter()
                          .key('x-fapi-interaction-id')
                          .value(x_fapi_interaction_id)
                          .is_required(True))
            .header_param(Parameter()
                          .key('Content-Type')
                          .value('application/json'))
            .header_param(Parameter()
                          .key('FDX-API-Actor-Type')
                          .value(fdx_api_actor_type))
            .body_param(Parameter()
                        .value(body))
            .body_serializer(APIHelper.json_serialize)
            .auth(Single('bearerAuth'))
        ).response(
            ResponseHandler()
            .is_api_response(True)
            .local_error('405', 'Method Not Allowed', ErrorException)
            .local_error('429', 'Too Many Requests', ErrorException)
            .local_error('500', 'Catch-all exception where request was not processed due to an internal outage/issue. Consider other more specific errors before using this error', ErrorException)
            .local_error('501', 'Error when FdxVersion in Header is not one of those implemented at backend', ErrorException)
            .local_error('503', 'System is down for maintenance', ErrorException)
        ).execute()

    def get_notifications(self,
                          x_fapi_interaction_id,
                          fdx_api_actor_type=None,
                          limit=None,
                          offset=None,
                          data_recipient_id=None):
        """Does a GET request to /notifications.

        Get Notifications

        Args:
            x_fapi_interaction_id (uuid|str): Unique identifier for this
                interaction
            fdx_api_actor_type (FdxApiActorType, optional): Identifies whether
                the customer is present (USER) or it is a BATCH operation
            limit (int, optional): Number of elements that the consumer wishes
                to receive. Providers should implement reasonable
                default/maximum/minimum values based on their internal
                architecture and update their documentation accordingly
            offset (str, optional): Opaque cursor used by the provider to send
                the next set of records
            data_recipient_id (str, optional): ID of Data Recipient (DR), omit
                for all DRs of a Data Access Platform

        Returns:
            ApiResponse: An object with the response value as well as other
                useful information such as status codes and headers. OK

        Raises:
            ApiException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        return super().new_api_call_builder.request(
            RequestBuilder().server(Server.EVENTNOTIFICATIONS)
            .path('/notifications')
            .http_method(HttpMethodEnum.GET)
            .header_param(Parameter()
                          .key('x-fapi-interaction-id')
                          .value(x_fapi_interaction_id)
                          .is_required(True))
            .header_param(Parameter()
                          .key('FDX-API-Actor-Type')
                          .value(fdx_api_actor_type))
            .query_param(Parameter()
                         .key('limit')
                         .value(limit))
            .query_param(Parameter()
                         .key('offset')
                         .value(offset))
            .query_param(Parameter()
                         .key('dataRecipientId')
                         .value(data_recipient_id))
            .header_param(Parameter()
                          .key('accept')
                          .value('application/json'))
            .auth(Single('bearerAuth'))
        ).response(
            ResponseHandler()
            .deserializer(APIHelper.json_deserialize)
            .deserialize_into(NotificationsEntity.from_dictionary)
            .is_api_response(True)
            .local_error('405', 'Method Not Allowed', ErrorException)
            .local_error('429', 'Too Many Requests', ErrorException)
            .local_error('500', 'Catch-all exception where request was not processed due to an internal outage/issue. Consider other more specific errors before using this error', ErrorException)
            .local_error('501', 'Error when FdxVersion in Header is not one of those implemented at backend', ErrorException)
            .local_error('503', 'System is down for maintenance', ErrorException)
        ).execute()
