# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""

from fdxapi.api_helper import APIHelper
from fdxapi.configuration import Server
from fdxapi.http.api_response import ApiResponse
from fdxapi.controllers.base_controller import BaseController
from apimatic_core.request_builder import RequestBuilder
from apimatic_core.response_handler import ResponseHandler
from apimatic_core.types.parameter import Parameter
from fdxapi.http.http_method_enum import HttpMethodEnum
from apimatic_core.authentication.multiple.single_auth import Single
from fdxapi.models.availability_list_entity import AvailabilityListEntity
from fdxapi.models.capability_entity import CapabilityEntity
from fdxapi.models.certification_metrics_entity import CertificationMetricsEntity


class MetaController(BaseController):

    """A Controller to access Endpoints in the fdxapi API."""
    def __init__(self, config):
        super(MetaController, self).__init__(config)

    def get_availability(self,
                         x_fapi_interaction_id,
                         fdx_api_actor_type=None,
                         operation_id=None):
        """Does a GET request to /availability.

        Get information about this API's availability

        Args:
            x_fapi_interaction_id (uuid|str): Unique identifier for this
                interaction
            fdx_api_actor_type (FdxApiActorType, optional): Identifies whether
                the customer is present (USER) or it is a BATCH operation
            operation_id (FdxResourceOperationId, optional): Specific
                operationId for which to get the metrics. Optional

        Returns:
            ApiResponse: An object with the response value as well as other
                useful information such as status codes and headers. Status
                and planned times of API availability

        Raises:
            ApiException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        return super().new_api_call_builder.request(
            RequestBuilder().server(Server.META)
            .path('/availability')
            .http_method(HttpMethodEnum.GET)
            .header_param(Parameter()
                          .key('x-fapi-interaction-id')
                          .value(x_fapi_interaction_id)
                          .is_required(True))
            .header_param(Parameter()
                          .key('FDX-API-Actor-Type')
                          .value(fdx_api_actor_type))
            .query_param(Parameter()
                         .key('operationId')
                         .value(operation_id))
            .header_param(Parameter()
                          .key('accept')
                          .value('application/json'))
            .auth(Single('bearerAuth'))
        ).response(
            ResponseHandler()
            .deserializer(APIHelper.json_deserialize)
            .deserialize_into(AvailabilityListEntity.from_dictionary)
            .is_api_response(True)
        ).execute()

    def get_capability(self,
                       x_fapi_interaction_id,
                       fdx_api_actor_type=None,
                       operation_id=None,
                       fdx_version=None,
                       result_type='lightweight'):
        """Does a GET request to /capability.

        Get information about this API's capability

        Args:
            x_fapi_interaction_id (uuid|str): Unique identifier for this
                interaction
            fdx_api_actor_type (FdxApiActorType, optional): Identifies whether
                the customer is present (USER) or it is a BATCH operation
            operation_id (FdxResourceOperationId, optional): Specific
                operationId for which to get the metrics. Optional
            fdx_version (FdxVersion, optional): Specific FDX version for which
                to get the capability. Optional
            result_type (ResultType, optional): Flag to indicate if you want a
                lightweight array of metadata (AccountDescriptor or Tax or
                Operations) or full item details (Account or a Tax subclass or
                Availability details). If set to 'lightweight', should only
                return the fields associated with the metadata entity. This
                field is not required, defaults to lightweight

        Returns:
            ApiResponse: An object with the response value as well as other
                useful information such as status codes and headers. API's
                capability for connections, cutoff times and product types

        Raises:
            ApiException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        return super().new_api_call_builder.request(
            RequestBuilder().server(Server.META)
            .path('/capability')
            .http_method(HttpMethodEnum.GET)
            .header_param(Parameter()
                          .key('x-fapi-interaction-id')
                          .value(x_fapi_interaction_id)
                          .is_required(True))
            .header_param(Parameter()
                          .key('FDX-API-Actor-Type')
                          .value(fdx_api_actor_type))
            .query_param(Parameter()
                         .key('operationId')
                         .value(operation_id))
            .query_param(Parameter()
                         .key('fdxVersion')
                         .value(fdx_version))
            .query_param(Parameter()
                         .key('resultType')
                         .value(result_type))
            .header_param(Parameter()
                          .key('accept')
                          .value('application/json'))
            .auth(Single('bearerAuth'))
        ).response(
            ResponseHandler()
            .deserializer(APIHelper.json_deserialize)
            .deserialize_into(CapabilityEntity.from_dictionary)
            .is_api_response(True)
        ).execute()

    def get_certification_metrics(self,
                                  x_fapi_interaction_id,
                                  fdx_api_actor_type=None,
                                  operation_id=None):
        """Does a GET request to /certification-metrics.

        Get certification performance metrics for this implementer's APIs

        Args:
            x_fapi_interaction_id (uuid|str): Unique identifier for this
                interaction
            fdx_api_actor_type (FdxApiActorType, optional): Identifies whether
                the customer is present (USER) or it is a BATCH operation
            operation_id (FdxResourceOperationId, optional): Specific
                operationId for which to get the metrics. Optional

        Returns:
            ApiResponse: An object with the response value as well as other
                useful information such as status codes and headers. Array of
                API's certification metrics

        Raises:
            ApiException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        return super().new_api_call_builder.request(
            RequestBuilder().server(Server.META)
            .path('/certification-metrics')
            .http_method(HttpMethodEnum.GET)
            .header_param(Parameter()
                          .key('x-fapi-interaction-id')
                          .value(x_fapi_interaction_id)
                          .is_required(True))
            .header_param(Parameter()
                          .key('FDX-API-Actor-Type')
                          .value(fdx_api_actor_type))
            .query_param(Parameter()
                         .key('operationId')
                         .value(operation_id))
            .header_param(Parameter()
                          .key('accept')
                          .value('application/json'))
            .auth(Single('bearerAuth'))
        ).response(
            ResponseHandler()
            .deserializer(APIHelper.json_deserialize)
            .deserialize_into(CertificationMetricsEntity.from_dictionary)
            .is_api_response(True)
        ).execute()
