# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""

from fdxapi.api_helper import APIHelper
from fdxapi.configuration import Server
from fdxapi.http.api_response import ApiResponse
from fdxapi.controllers.base_controller import BaseController
from apimatic_core.request_builder import RequestBuilder
from apimatic_core.response_handler import ResponseHandler
from apimatic_core.types.parameter import Parameter
from fdxapi.http.http_method_enum import HttpMethodEnum
from apimatic_core.authentication.multiple.single_auth import Single
from fdxapi.models.payment_initiation_party_create_response_entity import PaymentInitiationPartyCreateResponseEntity
from fdxapi.models.payment_initiation_parties_entity import PaymentInitiationPartiesEntity
from fdxapi.models.payment_initiation_party_entity import PaymentInitiationPartyEntity
from fdxapi.models.payment_initiation_party_method_create_response_entity import PaymentInitiationPartyMethodCreateResponseEntity
from fdxapi.models.payment_initiation_party_to_payment_method_entity import PaymentInitiationPartyToPaymentMethodEntity
from fdxapi.exceptions.error_exception import ErrorException


class PaymentInitiationPartiesController(BaseController):

    """A Controller to access Endpoints in the fdxapi API."""
    def __init__(self, config):
        super(PaymentInitiationPartiesController, self).__init__(config)

    def create_payment_initiation_party(self,
                                        x_fapi_interaction_id,
                                        idempotency_key,
                                        fdx_api_actor_type=None,
                                        body=None):
        """Does a POST request to /payment-initiation-parties.

        Create a payment initiation party associated with a customer profile

        Args:
            x_fapi_interaction_id (uuid|str): Unique identifier for this
                interaction
            idempotency_key (str): Used to de-duplicate requests
            fdx_api_actor_type (FdxApiActorType, optional): Identifies whether
                the customer is present (USER) or it is a BATCH operation
            body (PaymentInitiationPartyEntity, optional): The request body
                parameter.

        Returns:
            ApiResponse: An object with the response value as well as other
                useful information such as status codes and headers. Created
                payment initiation party

        Raises:
            ApiException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        return super().new_api_call_builder.request(
            RequestBuilder().server(Server.MONEYMOVEMENT)
            .path('/payment-initiation-parties')
            .http_method(HttpMethodEnum.POST)
            .header_param(Parameter()
                          .key('x-fapi-interaction-id')
                          .value(x_fapi_interaction_id)
                          .is_required(True))
            .header_param(Parameter()
                          .key('idempotency-key')
                          .value(idempotency_key)
                          .is_required(True))
            .header_param(Parameter()
                          .key('Content-Type')
                          .value('application/json'))
            .header_param(Parameter()
                          .key('FDX-API-Actor-Type')
                          .value(fdx_api_actor_type))
            .body_param(Parameter()
                        .value(body))
            .header_param(Parameter()
                          .key('accept')
                          .value('application/json'))
            .body_serializer(APIHelper.json_serialize)
            .auth(Single('bearerAuth'))
        ).response(
            ResponseHandler()
            .deserializer(APIHelper.json_deserialize)
            .deserialize_into(PaymentInitiationPartyCreateResponseEntity.from_dictionary)
            .is_api_response(True)
            .local_error('500', 'Catch-all exception where request was not processed due to an internal outage/issue. Consider other more specific errors before using this error', ErrorException)
            .local_error('501', 'Error when FdxVersion in Header is not one of those implemented at backend', ErrorException)
            .local_error('503', 'System is down for maintenance', ErrorException)
        ).execute()

    def list_payment_initiation_parties(self,
                                        x_fapi_interaction_id,
                                        fdx_api_actor_type=None,
                                        offset=None,
                                        limit=None):
        """Does a GET request to /payment-initiation-parties.

        Retrieve the payment initiation parties associated with a customer
        profile

        Args:
            x_fapi_interaction_id (uuid|str): Unique identifier for this
                interaction
            fdx_api_actor_type (FdxApiActorType, optional): Identifies whether
                the customer is present (USER) or it is a BATCH operation
            offset (str, optional): Opaque cursor used by the provider to send
                the next set of records
            limit (int, optional): Number of elements that the consumer wishes
                to receive. Providers should implement reasonable
                default/maximum/minimum values based on their internal
                architecture and update their documentation accordingly

        Returns:
            ApiResponse: An object with the response value as well as other
                useful information such as status codes and headers. OK

        Raises:
            ApiException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        return super().new_api_call_builder.request(
            RequestBuilder().server(Server.MONEYMOVEMENT)
            .path('/payment-initiation-parties')
            .http_method(HttpMethodEnum.GET)
            .header_param(Parameter()
                          .key('x-fapi-interaction-id')
                          .value(x_fapi_interaction_id)
                          .is_required(True))
            .header_param(Parameter()
                          .key('FDX-API-Actor-Type')
                          .value(fdx_api_actor_type))
            .query_param(Parameter()
                         .key('offset')
                         .value(offset))
            .query_param(Parameter()
                         .key('limit')
                         .value(limit))
            .header_param(Parameter()
                          .key('accept')
                          .value('application/json'))
            .auth(Single('bearerAuth'))
        ).response(
            ResponseHandler()
            .deserializer(APIHelper.json_deserialize)
            .deserialize_into(PaymentInitiationPartiesEntity.from_dictionary)
            .is_api_response(True)
            .local_error('500', 'Catch-all exception where request was not processed due to an internal outage/issue. Consider other more specific errors before using this error', ErrorException)
            .local_error('501', 'Error when FdxVersion in Header is not one of those implemented at backend', ErrorException)
            .local_error('503', 'System is down for maintenance', ErrorException)
        ).execute()

    def get_payment_initiation_party(self,
                                     x_fapi_interaction_id,
                                     payment_initiation_party_id,
                                     fdx_api_actor_type=None):
        """Does a GET request to /payment-initiation-parties/{paymentInitiationPartyId}.

        Retrieve the payment initiation party details by ID

        Args:
            x_fapi_interaction_id (uuid|str): Unique identifier for this
                interaction
            payment_initiation_party_id (str): This is an unique identifier of
                a payment initiation party
            fdx_api_actor_type (FdxApiActorType, optional): Identifies whether
                the customer is present (USER) or it is a BATCH operation

        Returns:
            ApiResponse: An object with the response value as well as other
                useful information such as status codes and headers. OK

        Raises:
            ApiException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        return super().new_api_call_builder.request(
            RequestBuilder().server(Server.MONEYMOVEMENT)
            .path('/payment-initiation-parties/{paymentInitiationPartyId}')
            .http_method(HttpMethodEnum.GET)
            .header_param(Parameter()
                          .key('x-fapi-interaction-id')
                          .value(x_fapi_interaction_id)
                          .is_required(True))
            .template_param(Parameter()
                            .key('paymentInitiationPartyId')
                            .value(payment_initiation_party_id)
                            .is_required(True)
                            .should_encode(True))
            .header_param(Parameter()
                          .key('FDX-API-Actor-Type')
                          .value(fdx_api_actor_type))
            .header_param(Parameter()
                          .key('accept')
                          .value('application/json'))
            .auth(Single('bearerAuth'))
        ).response(
            ResponseHandler()
            .deserializer(APIHelper.json_deserialize)
            .deserialize_into(PaymentInitiationPartyEntity.from_dictionary)
            .is_api_response(True)
            .local_error('500', 'Catch-all exception where request was not processed due to an internal outage/issue. Consider other more specific errors before using this error', ErrorException)
            .local_error('501', 'Error when FdxVersion in Header is not one of those implemented at backend', ErrorException)
            .local_error('503', 'System is down for maintenance', ErrorException)
        ).execute()

    def update_payment_initiation_party(self,
                                        x_fapi_interaction_id,
                                        payment_initiation_party_id,
                                        idempotency_key,
                                        fdx_api_actor_type=None,
                                        body=None):
        """Does a PATCH request to /payment-initiation-parties/{paymentInitiationPartyId}.

        Update the payment initiation party associated with a customer profile

        Args:
            x_fapi_interaction_id (uuid|str): Unique identifier for this
                interaction
            payment_initiation_party_id (str): This is an unique identifier of
                a payment initiation party
            idempotency_key (str): Used to de-duplicate requests
            fdx_api_actor_type (FdxApiActorType, optional): Identifies whether
                the customer is present (USER) or it is a BATCH operation
            body (PaymentInitiationPartyEntity, optional): The request body
                parameter.

        Returns:
            ApiResponse: An object with the response value as well as other
                useful information such as status codes and headers. OK

        Raises:
            ApiException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        return super().new_api_call_builder.request(
            RequestBuilder().server(Server.MONEYMOVEMENT)
            .path('/payment-initiation-parties/{paymentInitiationPartyId}')
            .http_method(HttpMethodEnum.PATCH)
            .header_param(Parameter()
                          .key('x-fapi-interaction-id')
                          .value(x_fapi_interaction_id)
                          .is_required(True))
            .template_param(Parameter()
                            .key('paymentInitiationPartyId')
                            .value(payment_initiation_party_id)
                            .is_required(True)
                            .should_encode(True))
            .header_param(Parameter()
                          .key('idempotency-key')
                          .value(idempotency_key)
                          .is_required(True))
            .header_param(Parameter()
                          .key('Content-Type')
                          .value('application/json'))
            .header_param(Parameter()
                          .key('FDX-API-Actor-Type')
                          .value(fdx_api_actor_type))
            .body_param(Parameter()
                        .value(body))
            .body_serializer(APIHelper.json_serialize)
            .auth(Single('bearerAuth'))
        ).response(
            ResponseHandler()
            .is_api_response(True)
            .local_error('500', 'Catch-all exception where request was not processed due to an internal outage/issue. Consider other more specific errors before using this error', ErrorException)
            .local_error('501', 'Error when FdxVersion in Header is not one of those implemented at backend', ErrorException)
            .local_error('503', 'System is down for maintenance', ErrorException)
        ).execute()

    def delete_payment_initiation_party(self,
                                        x_fapi_interaction_id,
                                        payment_initiation_party_id,
                                        fdx_api_actor_type=None):
        """Does a DELETE request to /payment-initiation-parties/{paymentInitiationPartyId}.

        Remove the payment initiation party associated with a customer profile

        Args:
            x_fapi_interaction_id (uuid|str): Unique identifier for this
                interaction
            payment_initiation_party_id (str): This is an unique identifier of
                a payment initiation party
            fdx_api_actor_type (FdxApiActorType, optional): Identifies whether
                the customer is present (USER) or it is a BATCH operation

        Returns:
            ApiResponse: An object with the response value as well as other
                useful information such as status codes and headers. No Content

        Raises:
            ApiException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        return super().new_api_call_builder.request(
            RequestBuilder().server(Server.MONEYMOVEMENT)
            .path('/payment-initiation-parties/{paymentInitiationPartyId}')
            .http_method(HttpMethodEnum.DELETE)
            .header_param(Parameter()
                          .key('x-fapi-interaction-id')
                          .value(x_fapi_interaction_id)
                          .is_required(True))
            .template_param(Parameter()
                            .key('paymentInitiationPartyId')
                            .value(payment_initiation_party_id)
                            .is_required(True)
                            .should_encode(True))
            .header_param(Parameter()
                          .key('FDX-API-Actor-Type')
                          .value(fdx_api_actor_type))
            .auth(Single('bearerAuth'))
        ).response(
            ResponseHandler()
            .is_api_response(True)
            .local_error('500', 'Catch-all exception where request was not processed due to an internal outage/issue. Consider other more specific errors before using this error', ErrorException)
            .local_error('501', 'Error when FdxVersion in Header is not one of those implemented at backend', ErrorException)
            .local_error('503', 'System is down for maintenance', ErrorException)
        ).execute()

    def create_payment_method(self,
                              x_fapi_interaction_id,
                              payment_initiation_party_id,
                              idempotency_key,
                              fdx_api_actor_type=None,
                              body=None):
        """Does a POST request to /payment-initiation-parties/{paymentInitiationPartyId}/payment-methods.

        Registration of a payment initiation party to a payment method

        Args:
            x_fapi_interaction_id (uuid|str): Unique identifier for this
                interaction
            payment_initiation_party_id (str): This is an unique identifier of
                a payment initiation party
            idempotency_key (str): Used to de-duplicate requests
            fdx_api_actor_type (FdxApiActorType, optional): Identifies whether
                the customer is present (USER) or it is a BATCH operation
            body (PaymentInitiationPartyToPaymentMethodEntity, optional): The
                request body parameter.

        Returns:
            ApiResponse: An object with the response value as well as other
                useful information such as status codes and headers. Created
                payment method registration

        Raises:
            ApiException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        return super().new_api_call_builder.request(
            RequestBuilder().server(Server.MONEYMOVEMENT)
            .path('/payment-initiation-parties/{paymentInitiationPartyId}/payment-methods')
            .http_method(HttpMethodEnum.POST)
            .header_param(Parameter()
                          .key('x-fapi-interaction-id')
                          .value(x_fapi_interaction_id)
                          .is_required(True))
            .template_param(Parameter()
                            .key('paymentInitiationPartyId')
                            .value(payment_initiation_party_id)
                            .is_required(True)
                            .should_encode(True))
            .header_param(Parameter()
                          .key('idempotency-key')
                          .value(idempotency_key)
                          .is_required(True))
            .header_param(Parameter()
                          .key('Content-Type')
                          .value('application/json'))
            .header_param(Parameter()
                          .key('FDX-API-Actor-Type')
                          .value(fdx_api_actor_type))
            .body_param(Parameter()
                        .value(body))
            .header_param(Parameter()
                          .key('accept')
                          .value('application/json'))
            .body_serializer(APIHelper.json_serialize)
            .auth(Single('bearerAuth'))
        ).response(
            ResponseHandler()
            .deserializer(APIHelper.json_deserialize)
            .deserialize_into(PaymentInitiationPartyMethodCreateResponseEntity.from_dictionary)
            .is_api_response(True)
            .local_error('500', 'Catch-all exception where request was not processed due to an internal outage/issue. Consider other more specific errors before using this error', ErrorException)
            .local_error('501', 'Error when FdxVersion in Header is not one of those implemented at backend', ErrorException)
            .local_error('503', 'System is down for maintenance', ErrorException)
        ).execute()

    def get_payment_method_registration(self,
                                        x_fapi_interaction_id,
                                        payment_initiation_party_id,
                                        payment_method_registration_id,
                                        fdx_api_actor_type=None):
        """Does a GET request to /payment-initiation-parties/{paymentInitiationPartyId}/payment-methods/{paymentMethodRegistrationId}.

        Retrieve the details of a payment method registered with a payment
        initiation party

        Args:
            x_fapi_interaction_id (uuid|str): Unique identifier for this
                interaction
            payment_initiation_party_id (str): This is an unique identifier of
                a payment initiation party
            payment_method_registration_id (str): Registration identifier
                between a payment initiation party and a payment method
            fdx_api_actor_type (FdxApiActorType, optional): Identifies whether
                the customer is present (USER) or it is a BATCH operation

        Returns:
            ApiResponse: An object with the response value as well as other
                useful information such as status codes and headers. OK

        Raises:
            ApiException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        return super().new_api_call_builder.request(
            RequestBuilder().server(Server.MONEYMOVEMENT)
            .path('/payment-initiation-parties/{paymentInitiationPartyId}/payment-methods/{paymentMethodRegistrationId}')
            .http_method(HttpMethodEnum.GET)
            .header_param(Parameter()
                          .key('x-fapi-interaction-id')
                          .value(x_fapi_interaction_id)
                          .is_required(True))
            .template_param(Parameter()
                            .key('paymentInitiationPartyId')
                            .value(payment_initiation_party_id)
                            .is_required(True)
                            .should_encode(True))
            .template_param(Parameter()
                            .key('paymentMethodRegistrationId')
                            .value(payment_method_registration_id)
                            .is_required(True)
                            .should_encode(True))
            .header_param(Parameter()
                          .key('FDX-API-Actor-Type')
                          .value(fdx_api_actor_type))
            .header_param(Parameter()
                          .key('accept')
                          .value('application/json'))
            .auth(Single('bearerAuth'))
        ).response(
            ResponseHandler()
            .deserializer(APIHelper.json_deserialize)
            .deserialize_into(PaymentInitiationPartyToPaymentMethodEntity.from_dictionary)
            .is_api_response(True)
            .local_error('500', 'Catch-all exception where request was not processed due to an internal outage/issue. Consider other more specific errors before using this error', ErrorException)
            .local_error('501', 'Error when FdxVersion in Header is not one of those implemented at backend', ErrorException)
            .local_error('503', 'System is down for maintenance', ErrorException)
        ).execute()

    def delete_payment_method_registration(self,
                                           x_fapi_interaction_id,
                                           payment_initiation_party_id,
                                           payment_method_registration_id,
                                           fdx_api_actor_type=None):
        """Does a DELETE request to /payment-initiation-parties/{paymentInitiationPartyId}/payment-methods/{paymentMethodRegistrationId}.

        Remove the registered payment method from a payment initiation party

        Args:
            x_fapi_interaction_id (uuid|str): Unique identifier for this
                interaction
            payment_initiation_party_id (str): This is an unique identifier of
                a payment initiation party
            payment_method_registration_id (str): Registration identifier
                between a payment initiation party and a payment method
            fdx_api_actor_type (FdxApiActorType, optional): Identifies whether
                the customer is present (USER) or it is a BATCH operation

        Returns:
            ApiResponse: An object with the response value as well as other
                useful information such as status codes and headers. No Content

        Raises:
            ApiException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        return super().new_api_call_builder.request(
            RequestBuilder().server(Server.MONEYMOVEMENT)
            .path('/payment-initiation-parties/{paymentInitiationPartyId}/payment-methods/{paymentMethodRegistrationId}')
            .http_method(HttpMethodEnum.DELETE)
            .header_param(Parameter()
                          .key('x-fapi-interaction-id')
                          .value(x_fapi_interaction_id)
                          .is_required(True))
            .template_param(Parameter()
                            .key('paymentInitiationPartyId')
                            .value(payment_initiation_party_id)
                            .is_required(True)
                            .should_encode(True))
            .template_param(Parameter()
                            .key('paymentMethodRegistrationId')
                            .value(payment_method_registration_id)
                            .is_required(True)
                            .should_encode(True))
            .header_param(Parameter()
                          .key('FDX-API-Actor-Type')
                          .value(fdx_api_actor_type))
            .auth(Single('bearerAuth'))
        ).response(
            ResponseHandler()
            .is_api_response(True)
            .local_error('500', 'Catch-all exception where request was not processed due to an internal outage/issue. Consider other more specific errors before using this error', ErrorException)
            .local_error('501', 'Error when FdxVersion in Header is not one of those implemented at backend', ErrorException)
            .local_error('503', 'System is down for maintenance', ErrorException)
        ).execute()

    def update_payment_method_registration(self,
                                           x_fapi_interaction_id,
                                           payment_initiation_party_id,
                                           payment_method_registration_id,
                                           fdx_api_actor_type=None,
                                           body=None):
        """Does a PATCH request to /payment-initiation-parties/{paymentInitiationPartyId}/payment-methods/{paymentMethodRegistrationId}.

        Update the payment method registration associated with payment
        initiation party

        Args:
            x_fapi_interaction_id (uuid|str): Unique identifier for this
                interaction
            payment_initiation_party_id (str): This is an unique identifier of
                a payment initiation party
            payment_method_registration_id (str): Registration identifier
                between a payment initiation party and a payment method
            fdx_api_actor_type (FdxApiActorType, optional): Identifies whether
                the customer is present (USER) or it is a BATCH operation
            body (PaymentInitiationPartyToPaymentMethodEntity, optional): The
                request body parameter.

        Returns:
            ApiResponse: An object with the response value as well as other
                useful information such as status codes and headers. OK

        Raises:
            ApiException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        return super().new_api_call_builder.request(
            RequestBuilder().server(Server.MONEYMOVEMENT)
            .path('/payment-initiation-parties/{paymentInitiationPartyId}/payment-methods/{paymentMethodRegistrationId}')
            .http_method(HttpMethodEnum.PATCH)
            .header_param(Parameter()
                          .key('x-fapi-interaction-id')
                          .value(x_fapi_interaction_id)
                          .is_required(True))
            .template_param(Parameter()
                            .key('paymentInitiationPartyId')
                            .value(payment_initiation_party_id)
                            .is_required(True)
                            .should_encode(True))
            .template_param(Parameter()
                            .key('paymentMethodRegistrationId')
                            .value(payment_method_registration_id)
                            .is_required(True)
                            .should_encode(True))
            .header_param(Parameter()
                          .key('Content-Type')
                          .value('application/json'))
            .header_param(Parameter()
                          .key('FDX-API-Actor-Type')
                          .value(fdx_api_actor_type))
            .body_param(Parameter()
                        .value(body))
            .body_serializer(APIHelper.json_serialize)
            .auth(Single('bearerAuth'))
        ).response(
            ResponseHandler()
            .is_api_response(True)
            .local_error('500', 'Catch-all exception where request was not processed due to an internal outage/issue. Consider other more specific errors before using this error', ErrorException)
            .local_error('501', 'Error when FdxVersion in Header is not one of those implemented at backend', ErrorException)
            .local_error('503', 'System is down for maintenance', ErrorException)
        ).execute()
