# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""

from fdxapi.api_helper import APIHelper
from fdxapi.configuration import Server
from fdxapi.http.api_response import ApiResponse
from fdxapi.controllers.base_controller import BaseController
from apimatic_core.request_builder import RequestBuilder
from apimatic_core.response_handler import ResponseHandler
from apimatic_core.types.parameter import Parameter
from fdxapi.http.http_method_enum import HttpMethodEnum
from apimatic_core.authentication.multiple.single_auth import Single
from fdxapi.models.recipient_provider import RecipientProvider
from fdxapi.models.recipient_records_at_ecosystem_registry import RecipientRecordsAtEcosystemRegistry
from fdxapi.models.recipient_record_at_ecosystem_registry import RecipientRecordAtEcosystemRegistry


class RecipientsController(BaseController):

    """A Controller to access Endpoints in the fdxapi API."""
    def __init__(self, config):
        super(RecipientsController, self).__init__(config)

    def create_recipient(self,
                         x_fapi_interaction_id,
                         fdx_api_actor_type=None,
                         body=None):
        """Does a POST request to /register.

        Request to Register Recipient by Creating a Recipient Record

        Args:
            x_fapi_interaction_id (uuid|str): Unique identifier for this
                interaction
            fdx_api_actor_type (FdxApiActorType, optional): Identifies whether
                the customer is present (USER) or it is a BATCH operation
            body (RecipientRequest, optional): The request body parameter.

        Returns:
            ApiResponse: An object with the response value as well as other
                useful information such as status codes and headers. Created

        Raises:
            ApiException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        return super().new_api_call_builder.request(
            RequestBuilder().server(Server.RECIPIENTREGISTRATION)
            .path('/register')
            .http_method(HttpMethodEnum.POST)
            .header_param(Parameter()
                          .key('x-fapi-interaction-id')
                          .value(x_fapi_interaction_id)
                          .is_required(True))
            .header_param(Parameter()
                          .key('Content-Type')
                          .value('application/json'))
            .header_param(Parameter()
                          .key('FDX-API-Actor-Type')
                          .value(fdx_api_actor_type))
            .body_param(Parameter()
                        .value(body))
            .header_param(Parameter()
                          .key('accept')
                          .value('application/json'))
            .body_serializer(APIHelper.json_serialize)
            .auth(Single('bearerAuth'))
        ).response(
            ResponseHandler()
            .deserializer(APIHelper.json_deserialize)
            .deserialize_into(RecipientProvider.from_dictionary)
            .is_api_response(True)
        ).execute()

    def get_recipient(self,
                      x_fapi_interaction_id,
                      client_id,
                      fdx_api_actor_type=None):
        """Does a GET request to /register/{clientId}.

        Get a specific recipient data identified with clientId

        Args:
            x_fapi_interaction_id (uuid|str): Unique identifier for this
                interaction
            client_id (str): Client Identifier. Uniquely identifies a Client
            fdx_api_actor_type (FdxApiActorType, optional): Identifies whether
                the customer is present (USER) or it is a BATCH operation

        Returns:
            ApiResponse: An object with the response value as well as other
                useful information such as status codes and headers. OK

        Raises:
            ApiException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        return super().new_api_call_builder.request(
            RequestBuilder().server(Server.RECIPIENTREGISTRATION)
            .path('/register/{clientId}')
            .http_method(HttpMethodEnum.GET)
            .header_param(Parameter()
                          .key('x-fapi-interaction-id')
                          .value(x_fapi_interaction_id)
                          .is_required(True))
            .template_param(Parameter()
                            .key('clientId')
                            .value(client_id)
                            .is_required(True)
                            .should_encode(True))
            .header_param(Parameter()
                          .key('FDX-API-Actor-Type')
                          .value(fdx_api_actor_type))
            .header_param(Parameter()
                          .key('accept')
                          .value('application/json'))
            .auth(Single('bearerAuth'))
        ).response(
            ResponseHandler()
            .deserializer(APIHelper.json_deserialize)
            .deserialize_into(RecipientProvider.from_dictionary)
            .is_api_response(True)
        ).execute()

    def update_recipient(self,
                         x_fapi_interaction_id,
                         client_id,
                         fdx_api_actor_type=None,
                         body=None):
        """Does a PUT request to /register/{clientId}.

        Update data for a specific recipient identified with clientId

        Args:
            x_fapi_interaction_id (uuid|str): Unique identifier for this
                interaction
            client_id (str): Client Identifier. Uniquely identifies a Client
            fdx_api_actor_type (FdxApiActorType, optional): Identifies whether
                the customer is present (USER) or it is a BATCH operation
            body (RecipientRequest, optional): The request body parameter.

        Returns:
            ApiResponse: An object with the response value as well as other
                useful information such as status codes and headers. OK

        Raises:
            ApiException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        return super().new_api_call_builder.request(
            RequestBuilder().server(Server.RECIPIENTREGISTRATION)
            .path('/register/{clientId}')
            .http_method(HttpMethodEnum.PUT)
            .header_param(Parameter()
                          .key('x-fapi-interaction-id')
                          .value(x_fapi_interaction_id)
                          .is_required(True))
            .template_param(Parameter()
                            .key('clientId')
                            .value(client_id)
                            .is_required(True)
                            .should_encode(True))
            .header_param(Parameter()
                          .key('Content-Type')
                          .value('application/json'))
            .header_param(Parameter()
                          .key('FDX-API-Actor-Type')
                          .value(fdx_api_actor_type))
            .body_param(Parameter()
                        .value(body))
            .header_param(Parameter()
                          .key('accept')
                          .value('application/json'))
            .body_serializer(APIHelper.json_serialize)
            .auth(Single('bearerAuth'))
        ).response(
            ResponseHandler()
            .deserializer(APIHelper.json_deserialize)
            .deserialize_into(RecipientProvider.from_dictionary)
            .is_api_response(True)
        ).execute()

    def delete_recipient(self,
                         x_fapi_interaction_id,
                         client_id,
                         fdx_api_actor_type=None):
        """Does a DELETE request to /register/{clientId}.

        Delete data for a specific recipient identified with clientId

        Args:
            x_fapi_interaction_id (uuid|str): Unique identifier for this
                interaction
            client_id (str): Client Identifier. Uniquely identifies a Client
            fdx_api_actor_type (FdxApiActorType, optional): Identifies whether
                the customer is present (USER) or it is a BATCH operation

        Returns:
            ApiResponse: An object with the response value as well as other
                useful information such as status codes and headers. No Content

        Raises:
            ApiException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        return super().new_api_call_builder.request(
            RequestBuilder().server(Server.RECIPIENTREGISTRATION)
            .path('/register/{clientId}')
            .http_method(HttpMethodEnum.DELETE)
            .header_param(Parameter()
                          .key('x-fapi-interaction-id')
                          .value(x_fapi_interaction_id)
                          .is_required(True))
            .template_param(Parameter()
                            .key('clientId')
                            .value(client_id)
                            .is_required(True)
                            .should_encode(True))
            .header_param(Parameter()
                          .key('FDX-API-Actor-Type')
                          .value(fdx_api_actor_type))
            .auth(Single('bearerAuth'))
        ).response(
            ResponseHandler()
            .is_api_response(True)
        ).execute()

    def get_registry_recipients(self,
                                x_fapi_interaction_id,
                                fdx_api_actor_type=None,
                                offset=None,
                                limit=None):
        """Does a GET request to /recipients.

        Get recipients

        Args:
            x_fapi_interaction_id (uuid|str): Unique identifier for this
                interaction
            fdx_api_actor_type (FdxApiActorType, optional): Identifies whether
                the customer is present (USER) or it is a BATCH operation
            offset (str, optional): Opaque cursor used by the provider to send
                the next set of records
            limit (int, optional): Number of elements that the consumer wishes
                to receive. Providers should implement reasonable
                default/maximum/minimum values based on their internal
                architecture and update their documentation accordingly

        Returns:
            ApiResponse: An object with the response value as well as other
                useful information such as status codes and headers. OK

        Raises:
            ApiException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        return super().new_api_call_builder.request(
            RequestBuilder().server(Server.REGISTRY)
            .path('/recipients')
            .http_method(HttpMethodEnum.GET)
            .header_param(Parameter()
                          .key('x-fapi-interaction-id')
                          .value(x_fapi_interaction_id)
                          .is_required(True))
            .header_param(Parameter()
                          .key('FDX-API-Actor-Type')
                          .value(fdx_api_actor_type))
            .query_param(Parameter()
                         .key('offset')
                         .value(offset))
            .query_param(Parameter()
                         .key('limit')
                         .value(limit))
            .header_param(Parameter()
                          .key('accept')
                          .value('application/json'))
            .auth(Single('bearerAuth'))
        ).response(
            ResponseHandler()
            .deserializer(APIHelper.json_deserialize)
            .deserialize_into(RecipientRecordsAtEcosystemRegistry.from_dictionary)
            .is_api_response(True)
        ).execute()

    def get_registry_recipient(self,
                               x_fapi_interaction_id,
                               recipient_id,
                               fdx_api_actor_type=None):
        """Does a GET request to /recipients/{recipientId}.

        Get a specific recipient

        Args:
            x_fapi_interaction_id (uuid|str): Unique identifier for this
                interaction
            recipient_id (str): Recipient Identifier. Uniquely identifies a
                Recipient
            fdx_api_actor_type (FdxApiActorType, optional): Identifies whether
                the customer is present (USER) or it is a BATCH operation

        Returns:
            ApiResponse: An object with the response value as well as other
                useful information such as status codes and headers. OK

        Raises:
            ApiException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        return super().new_api_call_builder.request(
            RequestBuilder().server(Server.REGISTRY)
            .path('/recipients/{recipientId}')
            .http_method(HttpMethodEnum.GET)
            .header_param(Parameter()
                          .key('x-fapi-interaction-id')
                          .value(x_fapi_interaction_id)
                          .is_required(True))
            .template_param(Parameter()
                            .key('recipientId')
                            .value(recipient_id)
                            .is_required(True)
                            .should_encode(True))
            .header_param(Parameter()
                          .key('FDX-API-Actor-Type')
                          .value(fdx_api_actor_type))
            .header_param(Parameter()
                          .key('accept')
                          .value('application/json'))
            .auth(Single('bearerAuth'))
        ).response(
            ResponseHandler()
            .deserializer(APIHelper.json_deserialize)
            .deserialize_into(RecipientRecordAtEcosystemRegistry.from_dictionary)
            .is_api_response(True)
        ).execute()
