# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""

from fdxapi.api_helper import APIHelper
from fdxapi.configuration import Server
from fdxapi.http.api_response import ApiResponse
from fdxapi.controllers.base_controller import BaseController
from apimatic_core.request_builder import RequestBuilder
from apimatic_core.response_handler import ResponseHandler
from apimatic_core.types.parameter import Parameter
from fdxapi.http.http_method_enum import HttpMethodEnum
from apimatic_core.authentication.multiple.single_auth import Single
from fdxapi.models.recurring_payments_entity import RecurringPaymentsEntity
from fdxapi.models.recurring_payment_entity import RecurringPaymentEntity
from fdxapi.models.payments_entity import PaymentsEntity
from fdxapi.exceptions.error_exception import ErrorException
from fdxapi.exceptions.recurring_payment_entity_error_exception import RecurringPaymentEntityErrorException


class RecurringPaymentsController(BaseController):

    """A Controller to access Endpoints in the fdxapi API."""
    def __init__(self, config):
        super(RecurringPaymentsController, self).__init__(config)

    def search_for_recurring_payments(self,
                                      x_fapi_interaction_id,
                                      fdx_api_actor_type=None,
                                      updated_since=None,
                                      offset=None,
                                      limit=None):
        """Does a GET request to /recurring-payments.

        Search for recurring payments

        Args:
            x_fapi_interaction_id (uuid|str): Unique identifier for this
                interaction
            fdx_api_actor_type (FdxApiActorType, optional): Identifies whether
                the customer is present (USER) or it is a BATCH operation
            updated_since (str, optional): Return items that have been created
                or updated since the nextUpdateId
            offset (str, optional): Opaque cursor used by the provider to send
                the next set of records
            limit (int, optional): Number of elements that the consumer wishes
                to receive. Providers should implement reasonable
                default/maximum/minimum values based on their internal
                architecture and update their documentation accordingly

        Returns:
            ApiResponse: An object with the response value as well as other
                useful information such as status codes and headers. Ok

        Raises:
            ApiException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        return super().new_api_call_builder.request(
            RequestBuilder().server(Server.MONEYMOVEMENT)
            .path('/recurring-payments')
            .http_method(HttpMethodEnum.GET)
            .header_param(Parameter()
                          .key('x-fapi-interaction-id')
                          .value(x_fapi_interaction_id)
                          .is_required(True))
            .header_param(Parameter()
                          .key('FDX-API-Actor-Type')
                          .value(fdx_api_actor_type))
            .query_param(Parameter()
                         .key('updatedSince')
                         .value(updated_since))
            .query_param(Parameter()
                         .key('offset')
                         .value(offset))
            .query_param(Parameter()
                         .key('limit')
                         .value(limit))
            .header_param(Parameter()
                          .key('accept')
                          .value('application/json'))
            .auth(Single('bearerAuth'))
        ).response(
            ResponseHandler()
            .deserializer(APIHelper.json_deserialize)
            .deserialize_into(RecurringPaymentsEntity.from_dictionary)
            .is_api_response(True)
            .local_error('404', 'Data not found for request parameters', ErrorException)
            .local_error('500', 'Catch-all exception where request was not processed due to an internal outage/issue. Consider other more specific errors before using this error', ErrorException)
            .local_error('501', 'Error when FdxVersion in Header is not one of those implemented at backend', ErrorException)
            .local_error('503', 'System is down for maintenance', ErrorException)
        ).execute()

    def schedule_recurring_payment(self,
                                   x_fapi_interaction_id,
                                   idempotency_key,
                                   fdx_api_actor_type=None,
                                   body=None):
        """Does a POST request to /recurring-payments.

        Schedule a recurring payment

        Args:
            x_fapi_interaction_id (uuid|str): Unique identifier for this
                interaction
            idempotency_key (str): Used to de-duplicate requests
            fdx_api_actor_type (FdxApiActorType, optional): Identifies whether
                the customer is present (USER) or it is a BATCH operation
            body (RecurringPaymentForUpdateEntity1, optional): The request
                body parameter.

        Returns:
            ApiResponse: An object with the response value as well as other
                useful information such as status codes and headers. Duplicate
                Recurring Payment

        Raises:
            ApiException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        return super().new_api_call_builder.request(
            RequestBuilder().server(Server.MONEYMOVEMENT)
            .path('/recurring-payments')
            .http_method(HttpMethodEnum.POST)
            .header_param(Parameter()
                          .key('x-fapi-interaction-id')
                          .value(x_fapi_interaction_id)
                          .is_required(True))
            .header_param(Parameter()
                          .key('idempotency-key')
                          .value(idempotency_key)
                          .is_required(True))
            .header_param(Parameter()
                          .key('Content-Type')
                          .value('application/json'))
            .header_param(Parameter()
                          .key('FDX-API-Actor-Type')
                          .value(fdx_api_actor_type))
            .body_param(Parameter()
                        .value(body))
            .header_param(Parameter()
                          .key('accept')
                          .value('application/json'))
            .body_serializer(APIHelper.json_serialize)
            .auth(Single('bearerAuth'))
        ).response(
            ResponseHandler()
            .deserializer(APIHelper.json_deserialize)
            .deserialize_into(RecurringPaymentEntity.from_dictionary)
            .is_api_response(True)
            .local_error('400', 'Request is invalid', ErrorException)
            .local_error('404', 'Requested payment is invalid', ErrorException)
            .local_error('409', 'Duplicate Request', RecurringPaymentEntityErrorException)
            .local_error('422', 'Account type not supported', ErrorException)
            .local_error('500', 'Catch-all exception where request was not processed due to an internal outage/issue. Consider other more specific errors before using this error', ErrorException)
            .local_error('501', 'Error when FdxVersion in Header is not one of those implemented at backend', ErrorException)
            .local_error('503', 'System is down for maintenance', ErrorException)
        ).execute()

    def get_recurring_payment(self,
                              x_fapi_interaction_id,
                              recurring_payment_id,
                              fdx_api_actor_type=None):
        """Does a GET request to /recurring-payments/{recurringPaymentId}.

        Get a recurring payment

        Args:
            x_fapi_interaction_id (uuid|str): Unique identifier for this
                interaction
            recurring_payment_id (str): Recurring Payment Identifier. Uniquely
                identifies a recurring payment
            fdx_api_actor_type (FdxApiActorType, optional): Identifies whether
                the customer is present (USER) or it is a BATCH operation

        Returns:
            ApiResponse: An object with the response value as well as other
                useful information such as status codes and headers. Ok

        Raises:
            ApiException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        return super().new_api_call_builder.request(
            RequestBuilder().server(Server.MONEYMOVEMENT)
            .path('/recurring-payments/{recurringPaymentId}')
            .http_method(HttpMethodEnum.GET)
            .header_param(Parameter()
                          .key('x-fapi-interaction-id')
                          .value(x_fapi_interaction_id)
                          .is_required(True))
            .template_param(Parameter()
                            .key('recurringPaymentId')
                            .value(recurring_payment_id)
                            .is_required(True)
                            .should_encode(True))
            .header_param(Parameter()
                          .key('FDX-API-Actor-Type')
                          .value(fdx_api_actor_type))
            .header_param(Parameter()
                          .key('accept')
                          .value('application/json'))
            .auth(Single('bearerAuth'))
        ).response(
            ResponseHandler()
            .deserializer(APIHelper.json_deserialize)
            .deserialize_into(RecurringPaymentEntity.from_dictionary)
            .is_api_response(True)
            .local_error('404', 'A recurring payment with provided ID was not found', ErrorException)
            .local_error('500', 'Catch-all exception where request was not processed due to an internal outage/issue. Consider other more specific errors before using this error', ErrorException)
            .local_error('501', 'Error when FdxVersion in Header is not one of those implemented at backend', ErrorException)
            .local_error('503', 'System is down for maintenance', ErrorException)
        ).execute()

    def update_recurring_payment(self,
                                 x_fapi_interaction_id,
                                 recurring_payment_id,
                                 idempotency_key,
                                 fdx_api_actor_type=None,
                                 body=None):
        """Does a PATCH request to /recurring-payments/{recurringPaymentId}.

        Update a recurring payment

        Args:
            x_fapi_interaction_id (uuid|str): Unique identifier for this
                interaction
            recurring_payment_id (str): Recurring Payment Identifier. Uniquely
                identifies a recurring payment
            idempotency_key (str): Used to de-duplicate requests
            fdx_api_actor_type (FdxApiActorType, optional): Identifies whether
                the customer is present (USER) or it is a BATCH operation
            body (RecurringPaymentForUpdateEntity2, optional): The request
                body parameter.

        Returns:
            ApiResponse: An object with the response value as well as other
                useful information such as status codes and headers. Ok

        Raises:
            ApiException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        return super().new_api_call_builder.request(
            RequestBuilder().server(Server.MONEYMOVEMENT)
            .path('/recurring-payments/{recurringPaymentId}')
            .http_method(HttpMethodEnum.PATCH)
            .header_param(Parameter()
                          .key('x-fapi-interaction-id')
                          .value(x_fapi_interaction_id)
                          .is_required(True))
            .template_param(Parameter()
                            .key('recurringPaymentId')
                            .value(recurring_payment_id)
                            .is_required(True)
                            .should_encode(True))
            .header_param(Parameter()
                          .key('idempotency-key')
                          .value(idempotency_key)
                          .is_required(True))
            .header_param(Parameter()
                          .key('Content-Type')
                          .value('application/json'))
            .header_param(Parameter()
                          .key('FDX-API-Actor-Type')
                          .value(fdx_api_actor_type))
            .body_param(Parameter()
                        .value(body))
            .header_param(Parameter()
                          .key('accept')
                          .value('application/json'))
            .body_serializer(APIHelper.json_serialize)
            .auth(Single('bearerAuth'))
        ).response(
            ResponseHandler()
            .deserializer(APIHelper.json_deserialize)
            .deserialize_into(RecurringPaymentEntity.from_dictionary)
            .is_api_response(True)
            .local_error('400', 'Request is invalid', ErrorException)
            .local_error('404', 'Requested recurring payment change is invalid', ErrorException)
            .local_error('409', 'Duplicate Request', RecurringPaymentEntityErrorException)
            .local_error('422', 'Account type not supported', ErrorException)
            .local_error('500', 'Catch-all exception where request was not processed due to an internal outage/issue. Consider other more specific errors before using this error', ErrorException)
            .local_error('501', 'Error when FdxVersion in Header is not one of those implemented at backend', ErrorException)
            .local_error('503', 'System is down for maintenance', ErrorException)
        ).execute()

    def cancel_recurring_payment(self,
                                 x_fapi_interaction_id,
                                 recurring_payment_id,
                                 fdx_api_actor_type=None):
        """Does a DELETE request to /recurring-payments/{recurringPaymentId}.

        Cancel a recurring payment

        Args:
            x_fapi_interaction_id (uuid|str): Unique identifier for this
                interaction
            recurring_payment_id (str): Recurring Payment Identifier. Uniquely
                identifies a recurring payment
            fdx_api_actor_type (FdxApiActorType, optional): Identifies whether
                the customer is present (USER) or it is a BATCH operation

        Returns:
            ApiResponse: An object with the response value as well as other
                useful information such as status codes and headers. Ok

        Raises:
            ApiException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        return super().new_api_call_builder.request(
            RequestBuilder().server(Server.MONEYMOVEMENT)
            .path('/recurring-payments/{recurringPaymentId}')
            .http_method(HttpMethodEnum.DELETE)
            .header_param(Parameter()
                          .key('x-fapi-interaction-id')
                          .value(x_fapi_interaction_id)
                          .is_required(True))
            .template_param(Parameter()
                            .key('recurringPaymentId')
                            .value(recurring_payment_id)
                            .is_required(True)
                            .should_encode(True))
            .header_param(Parameter()
                          .key('FDX-API-Actor-Type')
                          .value(fdx_api_actor_type))
            .header_param(Parameter()
                          .key('accept')
                          .value('application/json'))
            .auth(Single('bearerAuth'))
        ).response(
            ResponseHandler()
            .deserializer(APIHelper.json_deserialize)
            .deserialize_into(RecurringPaymentEntity.from_dictionary)
            .is_api_response(True)
            .local_error('400', 'Recurring payment cannot be modified or cancelled at this time. Likely due to the state that it is in', ErrorException)
            .local_error('404', 'A recurring payment with provided ID was not found', ErrorException)
            .local_error('500', 'Catch-all exception where request was not processed due to an internal outage/issue. Consider other more specific errors before using this error', ErrorException)
            .local_error('501', 'Error when FdxVersion in Header is not one of those implemented at backend', ErrorException)
            .local_error('503', 'System is down for maintenance', ErrorException)
        ).execute()

    def get_payments_for_recurring_payment(self,
                                           x_fapi_interaction_id,
                                           recurring_payment_id,
                                           fdx_api_actor_type=None,
                                           updated_since=None,
                                           offset=None,
                                           limit=None):
        """Does a GET request to /recurring-payments/{recurringPaymentId}/payments.

        Search for payments associated with the recurring payment

        Args:
            x_fapi_interaction_id (uuid|str): Unique identifier for this
                interaction
            recurring_payment_id (str): Recurring Payment Identifier. Uniquely
                identifies a recurring payment
            fdx_api_actor_type (FdxApiActorType, optional): Identifies whether
                the customer is present (USER) or it is a BATCH operation
            updated_since (str, optional): Return items that have been created
                or updated since the nextUpdateId
            offset (str, optional): Opaque cursor used by the provider to send
                the next set of records
            limit (int, optional): Number of elements that the consumer wishes
                to receive. Providers should implement reasonable
                default/maximum/minimum values based on their internal
                architecture and update their documentation accordingly

        Returns:
            ApiResponse: An object with the response value as well as other
                useful information such as status codes and headers. Ok

        Raises:
            ApiException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        return super().new_api_call_builder.request(
            RequestBuilder().server(Server.MONEYMOVEMENT)
            .path('/recurring-payments/{recurringPaymentId}/payments')
            .http_method(HttpMethodEnum.GET)
            .header_param(Parameter()
                          .key('x-fapi-interaction-id')
                          .value(x_fapi_interaction_id)
                          .is_required(True))
            .template_param(Parameter()
                            .key('recurringPaymentId')
                            .value(recurring_payment_id)
                            .is_required(True)
                            .should_encode(True))
            .header_param(Parameter()
                          .key('FDX-API-Actor-Type')
                          .value(fdx_api_actor_type))
            .query_param(Parameter()
                         .key('updatedSince')
                         .value(updated_since))
            .query_param(Parameter()
                         .key('offset')
                         .value(offset))
            .query_param(Parameter()
                         .key('limit')
                         .value(limit))
            .header_param(Parameter()
                          .key('accept')
                          .value('application/json'))
            .auth(Single('bearerAuth'))
        ).response(
            ResponseHandler()
            .deserializer(APIHelper.json_deserialize)
            .deserialize_into(PaymentsEntity.from_dictionary)
            .is_api_response(True)
            .local_error('404', 'A recurring payment with provided ID was not found', ErrorException)
            .local_error('500', 'Catch-all exception where request was not processed due to an internal outage/issue. Consider other more specific errors before using this error', ErrorException)
            .local_error('501', 'Error when FdxVersion in Header is not one of those implemented at backend', ErrorException)
            .local_error('503', 'System is down for maintenance', ErrorException)
        ).execute()
