# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""

from fdxapi.api_helper import APIHelper
from fdxapi.configuration import Server
from fdxapi.http.api_response import ApiResponse
from fdxapi.controllers.base_controller import BaseController
from apimatic_core.request_builder import RequestBuilder
from apimatic_core.response_handler import ResponseHandler
from apimatic_core.types.parameter import Parameter
from fdxapi.http.http_method_enum import HttpMethodEnum
from apimatic_core.authentication.multiple.single_auth import Single
from fdxapi.models.resource_list_entity import ResourceListEntity
from fdxapi.models.resource_entity import ResourceEntity
from fdxapi.exceptions.error_exception import ErrorException


class ResourceInformationController(BaseController):

    """A Controller to access Endpoints in the fdxapi API."""
    def __init__(self, config):
        super(ResourceInformationController, self).__init__(config)

    def get_resources(self,
                      x_fapi_interaction_id,
                      fdx_api_actor_type=None,
                      result_type='lightweight',
                      offset=None,
                      limit=None):
        """Does a GET request to /resources.

        Retrieve all the resources

        Args:
            x_fapi_interaction_id (uuid|str): Unique identifier for this
                interaction
            fdx_api_actor_type (FdxApiActorType, optional): Identifies whether
                the customer is present (USER) or it is a BATCH operation
            result_type (ResultType, optional): Flag to indicate if you want a
                lightweight array of metadata (AccountDescriptor or Tax or
                Operations) or full item details (Account or a Tax subclass or
                Availability details). If set to 'lightweight', should only
                return the fields associated with the metadata entity. This
                field is not required, defaults to lightweight
            offset (str, optional): Opaque cursor used by the provider to send
                the next set of records
            limit (int, optional): Number of elements that the consumer wishes
                to receive. Providers should implement reasonable
                default/maximum/minimum values based on their internal
                architecture and update their documentation accordingly

        Returns:
            ApiResponse: An object with the response value as well as other
                useful information such as status codes and headers. List of
                resources found

        Raises:
            ApiException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        return super().new_api_call_builder.request(
            RequestBuilder().server(Server.RESOURCE)
            .path('/resources')
            .http_method(HttpMethodEnum.GET)
            .header_param(Parameter()
                          .key('x-fapi-interaction-id')
                          .value(x_fapi_interaction_id)
                          .is_required(True))
            .header_param(Parameter()
                          .key('FDX-API-Actor-Type')
                          .value(fdx_api_actor_type))
            .query_param(Parameter()
                         .key('resultType')
                         .value(result_type))
            .query_param(Parameter()
                         .key('offset')
                         .value(offset))
            .query_param(Parameter()
                         .key('limit')
                         .value(limit))
            .header_param(Parameter()
                          .key('accept')
                          .value('application/json'))
            .auth(Single('bearerAuth'))
        ).response(
            ResponseHandler()
            .deserializer(APIHelper.json_deserialize)
            .deserialize_into(ResourceListEntity.from_dictionary)
            .is_api_response(True)
            .local_error('400', 'Input sent by client does not satisfy API specification', ErrorException)
            .local_error('401', 'Request lacks valid authentication credentials for the target resource', ErrorException)
            .local_error('404', 'Data not found for request parameters', ErrorException)
            .local_error('500', 'Catch-all exception where request was not processed due to an internal outage/issue. Consider other more specific errors before using this error', ErrorException)
            .local_error('501', 'Error when FdxVersion in Header is not one of those implemented at backend', ErrorException)
            .local_error('503', 'System is down for maintenance', ErrorException)
        ).execute()

    def get_resource(self,
                     resource_id,
                     x_fapi_interaction_id,
                     fdx_api_actor_type=None):
        """Does a GET request to /resources/{resourceId}.

        Retrieve the details of the identified resource

        Args:
            resource_id (str): Specific resourceId for which to retrieve
                details
            x_fapi_interaction_id (uuid|str): Unique identifier for this
                interaction
            fdx_api_actor_type (FdxApiActorType, optional): Identifies whether
                the customer is present (USER) or it is a BATCH operation

        Returns:
            ApiResponse: An object with the response value as well as other
                useful information such as status codes and headers. Details
                of the specific resource

        Raises:
            ApiException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        return super().new_api_call_builder.request(
            RequestBuilder().server(Server.RESOURCE)
            .path('/resources/{resourceId}')
            .http_method(HttpMethodEnum.GET)
            .template_param(Parameter()
                            .key('resourceId')
                            .value(resource_id)
                            .is_required(True)
                            .should_encode(True))
            .header_param(Parameter()
                          .key('x-fapi-interaction-id')
                          .value(x_fapi_interaction_id)
                          .is_required(True))
            .header_param(Parameter()
                          .key('FDX-API-Actor-Type')
                          .value(fdx_api_actor_type))
            .header_param(Parameter()
                          .key('accept')
                          .value('application/json'))
            .auth(Single('bearerAuth'))
        ).response(
            ResponseHandler()
            .deserializer(APIHelper.json_deserialize)
            .deserialize_into(ResourceEntity.from_dictionary)
            .is_api_response(True)
            .local_error('400', 'Required input data not sent', ErrorException)
            .local_error('404', 'Resource with provided ID was not found', ErrorException)
            .local_error('500', 'Catch-all exception where request was not processed due to an internal outage/issue. Consider other more specific errors before using this error', ErrorException)
            .local_error('501', 'Error when FdxVersion in Header is not one of those implemented at backend', ErrorException)
            .local_error('503', 'System is down for maintenance', ErrorException)
        ).execute()
