# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""

from fdxapi.api_helper import APIHelper
from fdxapi.configuration import Server
from fdxapi.http.api_response import ApiResponse
from fdxapi.controllers.base_controller import BaseController
from apimatic_core.request_builder import RequestBuilder
from apimatic_core.response_handler import ResponseHandler
from apimatic_core.types.parameter import Parameter
from fdxapi.http.http_method_enum import HttpMethodEnum
from apimatic_core.authentication.multiple.single_auth import Single
from apimatic_core.authentication.multiple.or_auth_group import Or
from fdxapi.models.tax_statement_list import TaxStatementList
from fdxapi.models.tax_statement_4 import TaxStatement4
from fdxapi.exceptions.error_exception import ErrorException


class TaxFormsController(BaseController):

    """A Controller to access Endpoints in the fdxapi API."""
    def __init__(self, config):
        super(TaxFormsController, self).__init__(config)

    def search_for_tax_forms(self,
                             authorization,
                             x_fapi_interaction_id,
                             accept,
                             fdx_api_actor_type=None,
                             account_id=None,
                             tax_year=None,
                             tax_forms=None,
                             tax_data_type=None,
                             result_type='lightweight'):
        """Does a GET request to /tax-forms.

        Get the full lists of tax document data and tax form images available
        for a specific year for the current authorized customer

        Args:
            authorization (str): The [Authorization HTTP request
                header](https://developer.mozilla.org/en-US/docs/Web/HTTP/Heade
                rs/Authorization) provides credentials to allow access to a
                protected resources
            x_fapi_interaction_id (uuid|str): Unique identifier for this
                interaction
            accept (str): Use the [Accept HTTP request
                header](https://developer.mozilla.org/en-US/docs/Web/HTTP/Heade
                rs/Accept) to indicate one or more content types to request
                for the search result response. Use `application/json` to
                request data, `application/pdf`, `application/zip` or
                `image/*` MIME-types to request images. In comma-separated
                array format using values typically from
                './fdxapi.components.yaml#/components/schemas/ContentTypes'
                enumeration. Use in combination with TaxDataTypeQuery
                parameter to request `application/json` responses in 'JSON' or
                'BASE64_PDF' format for tax form data
            fdx_api_actor_type (FdxApiActorType, optional): Identifies whether
                the customer is present (USER) or it is a BATCH operation
            account_id (str, optional): Account Identifier for use in
                searching or authorization. Optional
            tax_year (int, optional): Tax year in which to search for tax
                forms. Optional
            tax_forms (List[TypeFormType], optional): One or more tax form
                type enums for the specific documents being requested. Comma
                separated
            tax_data_type (TypeDataType, optional): Use taxDataType to request
                `application/json` tax form data response in 'JSON' or
                'BASE64_PDF' format. Omit if either format is acceptable. Used
                in combination with AcceptHeader requesting `application/json`
                response
            result_type (ResultType, optional): Flag to indicate if you want a
                lightweight array of metadata (AccountDescriptor or Tax or
                Operations) or full item details (Account or a Tax subclass or
                Availability details). If set to 'lightweight', should only
                return the fields associated with the metadata entity. This
                field is not required, defaults to lightweight

        Returns:
            ApiResponse: An object with the response value as well as other
                useful information such as status codes and headers. Array of
                all the tax document data and tax form images available for
                the customer matching search criteria

        Raises:
            ApiException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        return super().new_api_call_builder.request(
            RequestBuilder().server(Server.USTAX)
            .path('/tax-forms')
            .http_method(HttpMethodEnum.GET)
            .header_param(Parameter()
                          .key('Authorization')
                          .value(authorization)
                          .is_required(True))
            .header_param(Parameter()
                          .key('x-fapi-interaction-id')
                          .value(x_fapi_interaction_id)
                          .is_required(True))
            .header_param(Parameter()
                          .key('Accept')
                          .value(accept)
                          .is_required(True))
            .header_param(Parameter()
                          .key('FDX-API-Actor-Type')
                          .value(fdx_api_actor_type))
            .query_param(Parameter()
                         .key('accountId')
                         .value(account_id))
            .query_param(Parameter()
                         .key('taxYear')
                         .value(tax_year))
            .query_param(Parameter()
                         .key('taxForms')
                         .value(tax_forms))
            .query_param(Parameter()
                         .key('taxDataType')
                         .value(tax_data_type))
            .query_param(Parameter()
                         .key('resultType')
                         .value(result_type))
            .auth(Or(Single('TaxBasicAuth'), Single('bearerAuth')))
        ).response(
            ResponseHandler()
            .deserializer(APIHelper.json_deserialize)
            .deserialize_into(TaxStatementList.from_dictionary)
            .is_api_response(True)
            .local_error('400', 'Request is invalid or parameter values are not supported', ErrorException)
            .local_error('404', 'Tax Form not Found', ErrorException)
            .local_error('406', 'Content Type not Supported', ErrorException)
            .local_error('409', 'Tax forms are not currently available for this account or this year', ErrorException)
            .local_error('500', 'Catch-all exception where request was not processed due to an internal outage/issue. Consider other more specific errors before using this error', ErrorException)
            .local_error('501', 'Error when FdxVersion in Header is not one of those implemented at backend', ErrorException)
            .local_error('503', 'System is down for maintenance', ErrorException)
        ).execute()

    def get_tax_form(self,
                     tax_form_id,
                     authorization,
                     x_fapi_interaction_id,
                     accept,
                     fdx_api_actor_type=None,
                     tax_data_type=None):
        """Does a GET request to /tax-forms/{taxFormId}.

        Get the form image or TaxStatement as json for a single tax document
        for the customer. Use [HTTP Accept
        request-header](https://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html
        ) to specify desired content types. See `AcceptHeader` definition for
        typical values

        Args:
            tax_form_id (str): The unique ID for this tax form or tax statement
            authorization (str): The [Authorization HTTP request
                header](https://developer.mozilla.org/en-US/docs/Web/HTTP/Heade
                rs/Authorization) provides credentials to allow access to a
                protected resources
            x_fapi_interaction_id (uuid|str): Unique identifier for this
                interaction
            accept (str): Use the [Accept HTTP request
                header](https://developer.mozilla.org/en-US/docs/Web/HTTP/Heade
                rs/Accept) to indicate one or more content types to request
                for the search result response. Use `application/json` to
                request data, `application/pdf`, `application/zip` or
                `image/*` MIME-types to request images. In comma-separated
                array format using values typically from
                './fdxapi.components.yaml#/components/schemas/ContentTypes'
                enumeration. Use in combination with TaxDataTypeQuery
                parameter to request `application/json` responses in 'JSON' or
                'BASE64_PDF' format for tax form data
            fdx_api_actor_type (FdxApiActorType, optional): Identifies whether
                the customer is present (USER) or it is a BATCH operation
            tax_data_type (TypeDataType, optional): Use taxDataType to request
                `application/json` tax form data response in 'JSON' or
                'BASE64_PDF' format. Omit if either format is acceptable. Used
                in combination with AcceptHeader requesting `application/json`
                response

        Returns:
            ApiResponse: An object with the response value as well as other
                useful information such as status codes and headers. The
                document image or TaxStatement as json for a single tax
                document for the customer. A single document can include
                multiple IRS tax forms and/or other reporting statements as
                delivered by providers

        Raises:
            ApiException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        return super().new_api_call_builder.request(
            RequestBuilder().server(Server.USTAX)
            .path('/tax-forms/{taxFormId}')
            .http_method(HttpMethodEnum.GET)
            .template_param(Parameter()
                            .key('taxFormId')
                            .value(tax_form_id)
                            .is_required(True)
                            .should_encode(True))
            .header_param(Parameter()
                          .key('Authorization')
                          .value(authorization)
                          .is_required(True))
            .header_param(Parameter()
                          .key('x-fapi-interaction-id')
                          .value(x_fapi_interaction_id)
                          .is_required(True))
            .header_param(Parameter()
                          .key('Accept')
                          .value(accept)
                          .is_required(True))
            .header_param(Parameter()
                          .key('FDX-API-Actor-Type')
                          .value(fdx_api_actor_type))
            .query_param(Parameter()
                         .key('taxDataType')
                         .value(tax_data_type))
            .auth(Or(Single('TaxBasicAuth'), Single('bearerAuth')))
        ).response(
            ResponseHandler()
            .deserializer(APIHelper.json_deserialize)
            .deserialize_into(TaxStatement4.from_dictionary)
            .is_api_response(True)
            .local_error('400', 'Account ID is required for searching or validating authorization', ErrorException)
            .local_error('404', 'Tax Form for provided Tax Form ID was not found', ErrorException)
            .local_error('406', 'Content Type not Supported', ErrorException)
            .local_error('409', 'Tax forms are not currently available for this account or this year', ErrorException)
            .local_error('500', 'Catch-all exception where request was not processed due to an internal outage/issue. Consider other more specific errors before using this error', ErrorException)
            .local_error('501', 'Error when FdxVersion in Header is not one of those implemented at backend', ErrorException)
            .local_error('503', 'System is down for maintenance', ErrorException)
        ).execute()
