# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""

from fdxapi.api_helper import APIHelper
from fdxapi.configuration import Server
from fdxapi.http.api_response import ApiResponse
from fdxapi.controllers.base_controller import BaseController
from apimatic_core.request_builder import RequestBuilder
from apimatic_core.response_handler import ResponseHandler
from apimatic_core.types.parameter import Parameter
from fdxapi.http.http_method_enum import HttpMethodEnum
from apimatic_core.authentication.multiple.single_auth import Single
from fdxapi.models.consent_grant_entity import ConsentGrantEntity
from fdxapi.models.consent_revocation_list_entity import ConsentRevocationListEntity
from fdxapi.exceptions.error_exception import ErrorException


class UserConsentController(BaseController):

    """A Controller to access Endpoints in the fdxapi API."""
    def __init__(self, config):
        super(UserConsentController, self).__init__(config)

    def get_consent_grant(self,
                          consent_id,
                          x_fapi_interaction_id,
                          fdx_api_actor_type=None):
        """Does a GET request to /consents/{consentId}.

        Get a Consent Grant

        Args:
            consent_id (str): Consent Identifier
            x_fapi_interaction_id (uuid|str): Unique identifier for this
                interaction
            fdx_api_actor_type (FdxApiActorType, optional): Identifies whether
                the customer is present (USER) or it is a BATCH operation

        Returns:
            ApiResponse: An object with the response value as well as other
                useful information such as status codes and headers. Ok

        Raises:
            ApiException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        return super().new_api_call_builder.request(
            RequestBuilder().server(Server.CONSENT)
            .path('/consents/{consentId}')
            .http_method(HttpMethodEnum.GET)
            .template_param(Parameter()
                            .key('consentId')
                            .value(consent_id)
                            .is_required(True)
                            .should_encode(True))
            .header_param(Parameter()
                          .key('x-fapi-interaction-id')
                          .value(x_fapi_interaction_id)
                          .is_required(True))
            .header_param(Parameter()
                          .key('FDX-API-Actor-Type')
                          .value(fdx_api_actor_type))
            .header_param(Parameter()
                          .key('accept')
                          .value('application/json'))
            .auth(Single('bearerAuth'))
        ).response(
            ResponseHandler()
            .deserializer(APIHelper.json_deserialize)
            .deserialize_into(ConsentGrantEntity.from_dictionary)
            .is_api_response(True)
            .local_error('401', 'Request lacks valid authentication credentials for the target resource', ErrorException)
            .local_error('404', 'Data not found for request parameters', ErrorException)
        ).execute()

    def revoke_consent_grant(self,
                             consent_id,
                             x_fapi_interaction_id,
                             body,
                             fdx_api_actor_type=None):
        """Does a PUT request to /consents/{consentId}/revocation.

        Revoke a Consent Grant

        Args:
            consent_id (str): Consent Identifier
            x_fapi_interaction_id (uuid|str): Unique identifier for this
                interaction
            body (ConsentRevocationRequestEntity): Reason and initiator of
                revocation
            fdx_api_actor_type (FdxApiActorType, optional): Identifies whether
                the customer is present (USER) or it is a BATCH operation

        Returns:
            ApiResponse: An object with the response value as well as other
                useful information such as status codes and headers. No Content

        Raises:
            ApiException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        return super().new_api_call_builder.request(
            RequestBuilder().server(Server.CONSENT)
            .path('/consents/{consentId}/revocation')
            .http_method(HttpMethodEnum.PUT)
            .template_param(Parameter()
                            .key('consentId')
                            .value(consent_id)
                            .is_required(True)
                            .should_encode(True))
            .header_param(Parameter()
                          .key('x-fapi-interaction-id')
                          .value(x_fapi_interaction_id)
                          .is_required(True))
            .header_param(Parameter()
                          .key('Content-Type')
                          .value('application/json'))
            .body_param(Parameter()
                        .value(body)
                        .is_required(True))
            .header_param(Parameter()
                          .key('FDX-API-Actor-Type')
                          .value(fdx_api_actor_type))
            .body_serializer(APIHelper.json_serialize)
            .auth(Single('bearerAuth'))
        ).response(
            ResponseHandler()
            .is_api_response(True)
            .local_error('400', 'Input sent by client does not satisfy API specification', ErrorException)
            .local_error('401', 'Request lacks valid authentication credentials for the target resource', ErrorException)
            .local_error('403', 'Forbidden, server understands the request but refuses to authorize it', ErrorException)
            .local_error('404', 'Data not found for request parameters', ErrorException)
            .local_error('409', 'Conflict with current state of target resource', ErrorException)
        ).execute()

    def get_consent_revocation(self,
                               consent_id,
                               x_fapi_interaction_id,
                               fdx_api_actor_type=None):
        """Does a GET request to /consents/{consentId}/revocation.

        Retrieve Consent Revocation record

        Args:
            consent_id (str): Consent Identifier
            x_fapi_interaction_id (uuid|str): Unique identifier for this
                interaction
            fdx_api_actor_type (FdxApiActorType, optional): Identifies whether
                the customer is present (USER) or it is a BATCH operation

        Returns:
            ApiResponse: An object with the response value as well as other
                useful information such as status codes and headers. Ok

        Raises:
            ApiException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        return super().new_api_call_builder.request(
            RequestBuilder().server(Server.CONSENT)
            .path('/consents/{consentId}/revocation')
            .http_method(HttpMethodEnum.GET)
            .template_param(Parameter()
                            .key('consentId')
                            .value(consent_id)
                            .is_required(True)
                            .should_encode(True))
            .header_param(Parameter()
                          .key('x-fapi-interaction-id')
                          .value(x_fapi_interaction_id)
                          .is_required(True))
            .header_param(Parameter()
                          .key('FDX-API-Actor-Type')
                          .value(fdx_api_actor_type))
            .header_param(Parameter()
                          .key('accept')
                          .value('application/json'))
            .auth(Single('bearerAuth'))
        ).response(
            ResponseHandler()
            .deserializer(APIHelper.json_deserialize)
            .deserialize_into(ConsentRevocationListEntity.from_dictionary)
            .is_api_response(True)
        ).execute()
