# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""

from fdxapi.api_helper import APIHelper
from fdxapi.exceptions.api_exception import ApiException
from fdxapi.models.merchant_entity_1 import MerchantEntity1


class PayeeEntityErrorException(ApiException):
    def __init__(self, reason, response):
        """Constructor for the PayeeEntityErrorException class

        Args:
            reason (string): The reason (or error message) for the Exception
                to be raised.
            response (HttpResponse): The HttpResponse of the API call.

        """
        super(PayeeEntityErrorException, self).__init__(reason, response)
        dictionary = APIHelper.json_deserialize(self.response.text)
        if isinstance(dictionary, dict):
            self.unbox(dictionary)

    def unbox(self, dictionary):
        """Populates the properties of this object by extracting them from a dictionary.

        Args:
            dictionary (dictionary): A dictionary representation of the object as
            obtained from the deserialization of the server's response. The keys
            MUST match property names in the API description.

        """
        self.merchant = MerchantEntity1.from_dictionary(dictionary.get('merchant')) if dictionary.get('merchant') else None

    def __str__(self):
        base_str = super().__str__()
        return (f'{self.__class__.__name__}('
                f'{base_str[base_str.find("(") + 1:-1]}, '
                f'merchant={self.merchant!s})')
