# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""

from apimatic_core.configurations.global_configuration import GlobalConfiguration
from apimatic_core.decorators.lazy_property import LazyProperty
from fdxapi.configuration import Configuration
from fdxapi.controllers.base_controller import BaseController
from fdxapi.configuration import Environment
from fdxapi.http.auth.bearer_auth import BearerAuth
from fdxapi.http.auth.tax_basic_auth import TaxBasicAuth
from fdxapi.controllers.user_consent_controller import UserConsentController
from fdxapi.controllers.account_information_controller\
    import AccountInformationController
from fdxapi.controllers.account_statements_controller\
    import AccountStatementsController
from fdxapi.controllers.account_transactions_controller\
    import AccountTransactionsController
from fdxapi.controllers.money_movement_controller\
    import MoneyMovementController
from fdxapi.controllers.personal_information_controller\
    import PersonalInformationController
from fdxapi.controllers.reward_program_categories_controller\
    import RewardProgramCategoriesController
from fdxapi.controllers.reward_program_information_controller\
    import RewardProgramInformationController
from fdxapi.controllers.event_notifications_controller\
    import EventNotificationsController
from fdxapi.controllers.fraud_notification_controller\
    import FraudNotificationController
from fdxapi.controllers.meta_controller import MetaController
from fdxapi.controllers.internal_transfers_controller\
    import InternalTransfersController
from fdxapi.controllers.payee_management_controller\
    import PayeeManagementController
from fdxapi.controllers.payment_initiation_parties_controller\
    import PaymentInitiationPartiesController
from fdxapi.controllers.payments_controller import PaymentsController
from fdxapi.controllers.recurring_payments_controller\
    import RecurringPaymentsController
from fdxapi.controllers.payroll_information_controller\
    import PayrollInformationController
from fdxapi.controllers.recipients_controller import RecipientsController
from fdxapi.controllers.submit_tax_forms_controller\
    import SubmitTaxFormsController
from fdxapi.controllers.tax_forms_controller import TaxFormsController
from fdxapi.controllers.resource_information_controller\
    import ResourceInformationController


class FdxapiClient(object):
    @LazyProperty
    def user_consent(self):
        return UserConsentController(self.global_configuration)

    @LazyProperty
    def account_information(self):
        return AccountInformationController(self.global_configuration)

    @LazyProperty
    def account_statements(self):
        return AccountStatementsController(self.global_configuration)

    @LazyProperty
    def account_transactions(self):
        return AccountTransactionsController(self.global_configuration)

    @LazyProperty
    def money_movement(self):
        return MoneyMovementController(self.global_configuration)

    @LazyProperty
    def personal_information(self):
        return PersonalInformationController(self.global_configuration)

    @LazyProperty
    def reward_program_categories(self):
        return RewardProgramCategoriesController(self.global_configuration)

    @LazyProperty
    def reward_program_information(self):
        return RewardProgramInformationController(self.global_configuration)

    @LazyProperty
    def event_notifications(self):
        return EventNotificationsController(self.global_configuration)

    @LazyProperty
    def fraud_notification(self):
        return FraudNotificationController(self.global_configuration)

    @LazyProperty
    def meta(self):
        return MetaController(self.global_configuration)

    @LazyProperty
    def internal_transfers(self):
        return InternalTransfersController(self.global_configuration)

    @LazyProperty
    def payee_management(self):
        return PayeeManagementController(self.global_configuration)

    @LazyProperty
    def payment_initiation_parties(self):
        return PaymentInitiationPartiesController(self.global_configuration)

    @LazyProperty
    def payments(self):
        return PaymentsController(self.global_configuration)

    @LazyProperty
    def recurring_payments(self):
        return RecurringPaymentsController(self.global_configuration)

    @LazyProperty
    def payroll_information(self):
        return PayrollInformationController(self.global_configuration)

    @LazyProperty
    def recipients(self):
        return RecipientsController(self.global_configuration)

    @LazyProperty
    def submit_tax_forms(self):
        return SubmitTaxFormsController(self.global_configuration)

    @LazyProperty
    def tax_forms(self):
        return TaxFormsController(self.global_configuration)

    @LazyProperty
    def resource_information(self):
        return ResourceInformationController(self.global_configuration)

    def __init__(self, http_client_instance=None,
                 override_http_client_configuration=False, http_call_back=None,
                 timeout=60, max_retries=0, backoff_factor=2,
                 retry_statuses=None, retry_methods=None, proxy_settings=None,
                 logging_configuration=None, environment=Environment.PRODUCTION,
                 bearer_auth_credentials=None, tax_basic_auth_credentials=None,
                 config=None):
        self.config = config or Configuration(
            http_client_instance=http_client_instance,
            override_http_client_configuration=override_http_client_configuration,
            http_call_back=http_call_back, timeout=timeout,
            max_retries=max_retries, backoff_factor=backoff_factor,
            retry_statuses=retry_statuses, retry_methods=retry_methods,
            proxy_settings=proxy_settings,
            logging_configuration=logging_configuration,
            environment=environment,
            bearer_auth_credentials=bearer_auth_credentials,
            tax_basic_auth_credentials=tax_basic_auth_credentials)

        self.global_configuration = GlobalConfiguration(self.config)\
            .global_errors(BaseController.global_errors())\
            .base_uri_executor(self.config.get_base_uri)\
            .user_agent(BaseController.user_agent(), BaseController.user_agent_parameters())

        self.auth_managers = {key: None for key in ['bearerAuth',
                                                    'TaxBasicAuth']}
        self.auth_managers['bearerAuth'] = BearerAuth(
            self.config.bearer_auth_credentials)
        self.auth_managers['TaxBasicAuth'] = TaxBasicAuth(
            self.config.tax_basic_auth_credentials)
        self.global_configuration = self.global_configuration.auth_managers(self.auth_managers)

