# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
import dateutil.parser

from fdxapi.api_helper import APIHelper
from fdxapi.models.account_contact_entity_2 import AccountContactEntity2
from fdxapi.models.bills_entity import BillsEntity
from fdxapi.models.card_art_entity_2 import CardArtEntity2
from fdxapi.models.commercial_balance_entity import CommercialBalanceEntity
from fdxapi.models.contribution_entity import ContributionEntity
from fdxapi.models.currency_entity_4 import CurrencyEntity4
from fdxapi.models.domicile_entity_1 import DomicileEntity1
from fdxapi.models.error_1 import Error1
from fdxapi.models.fi_attribute_entity import FiAttributeEntity
from fdxapi.models.holding_entity import HoldingEntity
from fdxapi.models.investment_balance_entity import InvestmentBalanceEntity
from fdxapi.models.investment_loan_entity import InvestmentLoanEntity
from fdxapi.models.open_order_entity import OpenOrderEntity
from fdxapi.models.pension_source_entity import PensionSourceEntity
from fdxapi.models.transaction import CommercialTransactionEntity
from fdxapi.models.transaction import DepositTransactionEntity
from fdxapi.models.transaction import DigitalWalletTransactionEntity
from fdxapi.models.transaction import InsuranceTransactionEntity
from fdxapi.models.transaction import InvestmentTransactionEntity
from fdxapi.models.transaction import LineOfCreditTransactionEntity
from fdxapi.models.transaction import LoanTransactionEntity
from fdxapi.models.vesting_entity import VestingEntity


class AccountDescriptorEntity(object):

    """Implementation of the 'Account Descriptor entity' model.

    This descriptor provides minimal information about the account for use in
    lightweight arrays

    Attributes:
        account_category (str): The model property of type str.
        account_id (str): Long-term persistent identity of the account, though
            not an account number. This identity must be unique to the owning
            institution
        error (Error1): Present if an error was encountered while retrieving
            this account
        account_type (AccountType): Account type
        account_number (str): Full account number for the end user for this
            account at the owning institution. If not masked this is sensitive
            data which should only be exchanged if encrypted. For detailed
            information on implementing encryption see "Part 4 End to End
            Encryption" of the FDX API Security Model document in the Security
            section of the latest FDX Release download
        account_number_display (str): Account display number for the end
            user's handle at the owning institution. This is to be displayed
            by the Interface Provider
        product_name (str): Marketed product name for this account. Used in
            UIs to assist in account selection
        nickname (str): Name given by the user. Used in UIs to assist in
            account selection
        status (AccountStatus2): Account status. Suggested values are: OPEN,
            CLOSED, PENDINGOPEN, PENDINGCLOSE, PAID, DELINQUENT,
            NEGATIVECURRENTBALANCE, RESTRICTED
        description (str): Description of account
        account_open_date (date): Account opening date
        account_close_date (date): Account closing date
        currency (CurrencyEntity4): Account currency
        fi_attributes (List[FiAttributeEntity]): Array of Financial
            institution-specific attributes
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "account_category": 'accountCategory',
        "account_id": 'accountId',
        "error": 'error',
        "account_type": 'accountType',
        "account_number": 'accountNumber',
        "account_number_display": 'accountNumberDisplay',
        "product_name": 'productName',
        "nickname": 'nickname',
        "status": 'status',
        "description": 'description',
        "account_open_date": 'accountOpenDate',
        "account_close_date": 'accountCloseDate',
        "currency": 'currency',
        "fi_attributes": 'fiAttributes'
    }

    _optionals = [
        'account_category',
        'account_id',
        'error',
        'account_type',
        'account_number',
        'account_number_display',
        'product_name',
        'nickname',
        'status',
        'description',
        'account_open_date',
        'account_close_date',
        'currency',
        'fi_attributes',
    ]

    def __init__(self,
                 account_category='Account Descriptor entity',
                 account_id=APIHelper.SKIP,
                 error=APIHelper.SKIP,
                 account_type=APIHelper.SKIP,
                 account_number=APIHelper.SKIP,
                 account_number_display=APIHelper.SKIP,
                 product_name=APIHelper.SKIP,
                 nickname=APIHelper.SKIP,
                 status=APIHelper.SKIP,
                 description=APIHelper.SKIP,
                 account_open_date=APIHelper.SKIP,
                 account_close_date=APIHelper.SKIP,
                 currency=APIHelper.SKIP,
                 fi_attributes=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the AccountDescriptorEntity class"""

        # Initialize members of the class
        self.account_category = account_category 
        if account_id is not APIHelper.SKIP:
            self.account_id = account_id 
        if error is not APIHelper.SKIP:
            self.error = error 
        if account_type is not APIHelper.SKIP:
            self.account_type = account_type 
        if account_number is not APIHelper.SKIP:
            self.account_number = account_number 
        if account_number_display is not APIHelper.SKIP:
            self.account_number_display = account_number_display 
        if product_name is not APIHelper.SKIP:
            self.product_name = product_name 
        if nickname is not APIHelper.SKIP:
            self.nickname = nickname 
        if status is not APIHelper.SKIP:
            self.status = status 
        if description is not APIHelper.SKIP:
            self.description = description 
        if account_open_date is not APIHelper.SKIP:
            self.account_open_date = account_open_date 
        if account_close_date is not APIHelper.SKIP:
            self.account_close_date = account_close_date 
        if currency is not APIHelper.SKIP:
            self.currency = currency 
        if fi_attributes is not APIHelper.SKIP:
            self.fi_attributes = fi_attributes 

        # Add additional model properties to the instance
        if additional_properties is None:
            additional_properties = {}
        self.additional_properties = additional_properties

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        discriminators = {
            'Account entity': AccountEntity.from_dictionary,
            'Annuity Account entity': AnnuityAccountEntity.from_dictionary,
            'Commercial Account entity': CommercialAccountEntity.from_dictionary,
            'Deposit Account entity': DepositAccountEntity.from_dictionary,
            'Digital Wallet account entity': DigitalWalletAccountEntity.from_dictionary,
            'Insurance Account entity': InsuranceAccountEntity.from_dictionary,
            'Investment Account entity': InvestmentAccountEntity.from_dictionary,
            'Line of Credit Account entity': LineOfCreditAccountEntity.from_dictionary,
            'Loan Account entity': LoanAccountEntity.from_dictionary
        }
        unboxer = discriminators.get(dictionary.get('accountCategory'))

        # Delegate unboxing to another function if a discriminator
        # value for a child class is present.
        if unboxer:
            return unboxer(dictionary)

        # Extract variables from the dictionary
        account_category = dictionary.get("accountCategory") if dictionary.get("accountCategory") else 'Account Descriptor entity'
        account_id = dictionary.get("accountId") if dictionary.get("accountId") else APIHelper.SKIP
        error = Error1.from_dictionary(dictionary.get('error')) if 'error' in dictionary.keys() else APIHelper.SKIP
        account_type = dictionary.get("accountType") if dictionary.get("accountType") else APIHelper.SKIP
        account_number = dictionary.get("accountNumber") if dictionary.get("accountNumber") else APIHelper.SKIP
        account_number_display = dictionary.get("accountNumberDisplay") if dictionary.get("accountNumberDisplay") else APIHelper.SKIP
        product_name = dictionary.get("productName") if dictionary.get("productName") else APIHelper.SKIP
        nickname = dictionary.get("nickname") if dictionary.get("nickname") else APIHelper.SKIP
        status = dictionary.get("status") if dictionary.get("status") else APIHelper.SKIP
        description = dictionary.get("description") if dictionary.get("description") else APIHelper.SKIP
        account_open_date = dateutil.parser.parse(dictionary.get('accountOpenDate')).date() if dictionary.get('accountOpenDate') else APIHelper.SKIP
        account_close_date = dateutil.parser.parse(dictionary.get('accountCloseDate')).date() if dictionary.get('accountCloseDate') else APIHelper.SKIP
        currency = CurrencyEntity4.from_dictionary(dictionary.get('currency')) if 'currency' in dictionary.keys() else APIHelper.SKIP
        fi_attributes = None
        if dictionary.get('fiAttributes') is not None:
            fi_attributes = [FiAttributeEntity.from_dictionary(x) for x in dictionary.get('fiAttributes')]
        else:
            fi_attributes = APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(account_category,
                   account_id,
                   error,
                   account_type,
                   account_number,
                   account_number_display,
                   product_name,
                   nickname,
                   status,
                   description,
                   account_open_date,
                   account_close_date,
                   currency,
                   fi_attributes,
                   additional_properties)

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'account_category={(self.account_category if hasattr(self, "account_category") else None)!r}, '
                f'account_id={(self.account_id if hasattr(self, "account_id") else None)!r}, '
                f'error={(self.error if hasattr(self, "error") else None)!r}, '
                f'account_type={(self.account_type if hasattr(self, "account_type") else None)!r}, '
                f'account_number={(self.account_number if hasattr(self, "account_number") else None)!r}, '
                f'account_number_display={(self.account_number_display if hasattr(self, "account_number_display") else None)!r}, '
                f'product_name={(self.product_name if hasattr(self, "product_name") else None)!r}, '
                f'nickname={(self.nickname if hasattr(self, "nickname") else None)!r}, '
                f'status={(self.status if hasattr(self, "status") else None)!r}, '
                f'description={(self.description if hasattr(self, "description") else None)!r}, '
                f'account_open_date={(self.account_open_date if hasattr(self, "account_open_date") else None)!r}, '
                f'account_close_date={(self.account_close_date if hasattr(self, "account_close_date") else None)!r}, '
                f'currency={(self.currency if hasattr(self, "currency") else None)!r}, '
                f'fi_attributes={(self.fi_attributes if hasattr(self, "fi_attributes") else None)!r}, '
                f'additional_properties={self.additional_properties!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'account_category={(self.account_category if hasattr(self, "account_category") else None)!s}, '
                f'account_id={(self.account_id if hasattr(self, "account_id") else None)!s}, '
                f'error={(self.error if hasattr(self, "error") else None)!s}, '
                f'account_type={(self.account_type if hasattr(self, "account_type") else None)!s}, '
                f'account_number={(self.account_number if hasattr(self, "account_number") else None)!s}, '
                f'account_number_display={(self.account_number_display if hasattr(self, "account_number_display") else None)!s}, '
                f'product_name={(self.product_name if hasattr(self, "product_name") else None)!s}, '
                f'nickname={(self.nickname if hasattr(self, "nickname") else None)!s}, '
                f'status={(self.status if hasattr(self, "status") else None)!s}, '
                f'description={(self.description if hasattr(self, "description") else None)!s}, '
                f'account_open_date={(self.account_open_date if hasattr(self, "account_open_date") else None)!s}, '
                f'account_close_date={(self.account_close_date if hasattr(self, "account_close_date") else None)!s}, '
                f'currency={(self.currency if hasattr(self, "currency") else None)!s}, '
                f'fi_attributes={(self.fi_attributes if hasattr(self, "fi_attributes") else None)!s}, '
                f'additional_properties={self.additional_properties!s})')

class AccountEntity(AccountDescriptorEntity):

    """Implementation of the 'Account entity' model.

    An abstract account entity that concrete account entities extend
    NOTE: This class inherits from 'AccountDescriptorEntity'.

    Attributes:
        parent_account_id (str): Long-term persistent identity of the parent
            account. This is used to group accounts
        line_of_business (str): The line of business, such as consumer,
            consumer joint, small business, corporate, etc.
        routing_transit_number (str): The routing transit number (RTN)
            associated with the account number at the owning institution. This
            also serves as the 3-digit Institution (FID) and 5-digit Transit
            numbers for Canadian institutions, including leading zeroes
        balance_type (BalanceType2): ASSET (positive transaction amount
            increases balance), LIABILITY (positive transaction amount
            decreases balance)
        contact (AccountContactEntity2): Contact information associated with
            this account
        interest_rate (float): Interest Rate of Account
        interest_rate_type (InterestRateType2): FIXED or VARIABLE
        interest_rate_as_of (datetime): Date of account's interest rate
        prior_interest_rate (float): Previous Interest Rate of Account
        interest_rate_index (str): Variable rate index name such as EONIA,
            EURIBOR, EURREPO, FEFUND, LIBOR, PRIME, SOFR, SONIA, etc.
        early_penalty_flag (bool): Flag that indicates if there is an early
            penalty for withdrawal/payoff
        transfer_in (bool): Account is eligible for incoming transfers
        transfer_out (bool): Account is eligible for outgoing transfers
        bill_pay_status (AccountBillPayStatus2): Defines account's ability to
            participate in bill payments
        micr_number (str): MICR Number
        last_activity_date (date): Date that last transaction occurred on
            account
        reward_program_id (str): Long-term persistent identity of rewards
            program associated with this account
        transactions_included (bool): Default is false. If present and true, a
            call to retrieve transactions will not return any further details
            about this account. This is an optimization that allows an FDX API
            server to return transactions and account details in a single call
        domicile (DomicileEntity1): The country and region of the account's
            legal jurisdiction
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "parent_account_id": 'parentAccountId',
        "line_of_business": 'lineOfBusiness',
        "routing_transit_number": 'routingTransitNumber',
        "balance_type": 'balanceType',
        "contact": 'contact',
        "interest_rate": 'interestRate',
        "interest_rate_type": 'interestRateType',
        "interest_rate_as_of": 'interestRateAsOf',
        "prior_interest_rate": 'priorInterestRate',
        "interest_rate_index": 'interestRateIndex',
        "early_penalty_flag": 'earlyPenaltyFlag',
        "transfer_in": 'transferIn',
        "transfer_out": 'transferOut',
        "bill_pay_status": 'billPayStatus',
        "micr_number": 'micrNumber',
        "last_activity_date": 'lastActivityDate',
        "reward_program_id": 'rewardProgramId',
        "transactions_included": 'transactionsIncluded',
        "domicile": 'domicile',
        "account_category": 'accountCategory',
        "account_id": 'accountId',
        "error": 'error',
        "account_type": 'accountType',
        "account_number": 'accountNumber',
        "account_number_display": 'accountNumberDisplay',
        "product_name": 'productName',
        "nickname": 'nickname',
        "status": 'status',
        "description": 'description',
        "account_open_date": 'accountOpenDate',
        "account_close_date": 'accountCloseDate',
        "currency": 'currency',
        "fi_attributes": 'fiAttributes'
    }

    _optionals = [
        'parent_account_id',
        'line_of_business',
        'routing_transit_number',
        'balance_type',
        'contact',
        'interest_rate',
        'interest_rate_type',
        'interest_rate_as_of',
        'prior_interest_rate',
        'interest_rate_index',
        'early_penalty_flag',
        'transfer_in',
        'transfer_out',
        'bill_pay_status',
        'micr_number',
        'last_activity_date',
        'reward_program_id',
        'transactions_included',
        'domicile',
    ]
    _optionals.extend(AccountDescriptorEntity._optionals)

    def __init__(self,
                 parent_account_id=APIHelper.SKIP,
                 line_of_business=APIHelper.SKIP,
                 routing_transit_number=APIHelper.SKIP,
                 balance_type=APIHelper.SKIP,
                 contact=APIHelper.SKIP,
                 interest_rate=APIHelper.SKIP,
                 interest_rate_type=APIHelper.SKIP,
                 interest_rate_as_of=APIHelper.SKIP,
                 prior_interest_rate=APIHelper.SKIP,
                 interest_rate_index=APIHelper.SKIP,
                 early_penalty_flag=APIHelper.SKIP,
                 transfer_in=APIHelper.SKIP,
                 transfer_out=APIHelper.SKIP,
                 bill_pay_status=APIHelper.SKIP,
                 micr_number=APIHelper.SKIP,
                 last_activity_date=APIHelper.SKIP,
                 reward_program_id=APIHelper.SKIP,
                 transactions_included=APIHelper.SKIP,
                 domicile=APIHelper.SKIP,
                 account_category='Account entity',
                 account_id=APIHelper.SKIP,
                 error=APIHelper.SKIP,
                 account_type=APIHelper.SKIP,
                 account_number=APIHelper.SKIP,
                 account_number_display=APIHelper.SKIP,
                 product_name=APIHelper.SKIP,
                 nickname=APIHelper.SKIP,
                 status=APIHelper.SKIP,
                 description=APIHelper.SKIP,
                 account_open_date=APIHelper.SKIP,
                 account_close_date=APIHelper.SKIP,
                 currency=APIHelper.SKIP,
                 fi_attributes=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the AccountEntity class"""

        # Initialize members of the class
        if parent_account_id is not APIHelper.SKIP:
            self.parent_account_id = parent_account_id 
        if line_of_business is not APIHelper.SKIP:
            self.line_of_business = line_of_business 
        if routing_transit_number is not APIHelper.SKIP:
            self.routing_transit_number = routing_transit_number 
        if balance_type is not APIHelper.SKIP:
            self.balance_type = balance_type 
        if contact is not APIHelper.SKIP:
            self.contact = contact 
        if interest_rate is not APIHelper.SKIP:
            self.interest_rate = interest_rate 
        if interest_rate_type is not APIHelper.SKIP:
            self.interest_rate_type = interest_rate_type 
        if interest_rate_as_of is not APIHelper.SKIP:
            self.interest_rate_as_of = APIHelper.apply_datetime_converter(interest_rate_as_of, APIHelper.RFC3339DateTime) if interest_rate_as_of else None 
        if prior_interest_rate is not APIHelper.SKIP:
            self.prior_interest_rate = prior_interest_rate 
        if interest_rate_index is not APIHelper.SKIP:
            self.interest_rate_index = interest_rate_index 
        if early_penalty_flag is not APIHelper.SKIP:
            self.early_penalty_flag = early_penalty_flag 
        if transfer_in is not APIHelper.SKIP:
            self.transfer_in = transfer_in 
        if transfer_out is not APIHelper.SKIP:
            self.transfer_out = transfer_out 
        if bill_pay_status is not APIHelper.SKIP:
            self.bill_pay_status = bill_pay_status 
        if micr_number is not APIHelper.SKIP:
            self.micr_number = micr_number 
        if last_activity_date is not APIHelper.SKIP:
            self.last_activity_date = last_activity_date 
        if reward_program_id is not APIHelper.SKIP:
            self.reward_program_id = reward_program_id 
        if transactions_included is not APIHelper.SKIP:
            self.transactions_included = transactions_included 
        if domicile is not APIHelper.SKIP:
            self.domicile = domicile 

        # Call the constructor for the base class
        super(AccountEntity, self).__init__(account_category,
                                            account_id,
                                            error,
                                            account_type,
                                            account_number,
                                            account_number_display,
                                            product_name,
                                            nickname,
                                            status,
                                            description,
                                            account_open_date,
                                            account_close_date,
                                            currency,
                                            fi_attributes,
                                            additional_properties)

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        discriminators = {
            'Annuity Account entity': AnnuityAccountEntity.from_dictionary,
            'Commercial Account entity': CommercialAccountEntity.from_dictionary,
            'Deposit Account entity': DepositAccountEntity.from_dictionary,
            'Digital Wallet account entity': DigitalWalletAccountEntity.from_dictionary,
            'Insurance Account entity': InsuranceAccountEntity.from_dictionary,
            'Investment Account entity': InvestmentAccountEntity.from_dictionary,
            'Line of Credit Account entity': LineOfCreditAccountEntity.from_dictionary,
            'Loan Account entity': LoanAccountEntity.from_dictionary
        }
        unboxer = discriminators.get(dictionary.get('accountCategory'))

        # Delegate unboxing to another function if a discriminator
        # value for a child class is present.
        if unboxer:
            return unboxer(dictionary)

        # Extract variables from the dictionary
        parent_account_id = dictionary.get("parentAccountId") if dictionary.get("parentAccountId") else APIHelper.SKIP
        line_of_business = dictionary.get("lineOfBusiness") if dictionary.get("lineOfBusiness") else APIHelper.SKIP
        routing_transit_number = dictionary.get("routingTransitNumber") if dictionary.get("routingTransitNumber") else APIHelper.SKIP
        balance_type = dictionary.get("balanceType") if dictionary.get("balanceType") else APIHelper.SKIP
        contact = AccountContactEntity2.from_dictionary(dictionary.get('contact')) if 'contact' in dictionary.keys() else APIHelper.SKIP
        interest_rate = dictionary.get("interestRate") if dictionary.get("interestRate") else APIHelper.SKIP
        interest_rate_type = dictionary.get("interestRateType") if dictionary.get("interestRateType") else APIHelper.SKIP
        interest_rate_as_of = APIHelper.RFC3339DateTime.from_value(dictionary.get("interestRateAsOf")).datetime if dictionary.get("interestRateAsOf") else APIHelper.SKIP
        prior_interest_rate = dictionary.get("priorInterestRate") if dictionary.get("priorInterestRate") else APIHelper.SKIP
        interest_rate_index = dictionary.get("interestRateIndex") if dictionary.get("interestRateIndex") else APIHelper.SKIP
        early_penalty_flag = dictionary.get("earlyPenaltyFlag") if "earlyPenaltyFlag" in dictionary.keys() else APIHelper.SKIP
        transfer_in = dictionary.get("transferIn") if "transferIn" in dictionary.keys() else APIHelper.SKIP
        transfer_out = dictionary.get("transferOut") if "transferOut" in dictionary.keys() else APIHelper.SKIP
        bill_pay_status = dictionary.get("billPayStatus") if dictionary.get("billPayStatus") else APIHelper.SKIP
        micr_number = dictionary.get("micrNumber") if dictionary.get("micrNumber") else APIHelper.SKIP
        last_activity_date = dateutil.parser.parse(dictionary.get('lastActivityDate')).date() if dictionary.get('lastActivityDate') else APIHelper.SKIP
        reward_program_id = dictionary.get("rewardProgramId") if dictionary.get("rewardProgramId") else APIHelper.SKIP
        transactions_included = dictionary.get("transactionsIncluded") if "transactionsIncluded" in dictionary.keys() else APIHelper.SKIP
        domicile = DomicileEntity1.from_dictionary(dictionary.get('domicile')) if 'domicile' in dictionary.keys() else APIHelper.SKIP
        account_category = dictionary.get("accountCategory") if dictionary.get("accountCategory") else 'Account entity'
        account_id = dictionary.get("accountId") if dictionary.get("accountId") else APIHelper.SKIP
        error = Error1.from_dictionary(dictionary.get('error')) if 'error' in dictionary.keys() else APIHelper.SKIP
        account_type = dictionary.get("accountType") if dictionary.get("accountType") else APIHelper.SKIP
        account_number = dictionary.get("accountNumber") if dictionary.get("accountNumber") else APIHelper.SKIP
        account_number_display = dictionary.get("accountNumberDisplay") if dictionary.get("accountNumberDisplay") else APIHelper.SKIP
        product_name = dictionary.get("productName") if dictionary.get("productName") else APIHelper.SKIP
        nickname = dictionary.get("nickname") if dictionary.get("nickname") else APIHelper.SKIP
        status = dictionary.get("status") if dictionary.get("status") else APIHelper.SKIP
        description = dictionary.get("description") if dictionary.get("description") else APIHelper.SKIP
        account_open_date = dateutil.parser.parse(dictionary.get('accountOpenDate')).date() if dictionary.get('accountOpenDate') else APIHelper.SKIP
        account_close_date = dateutil.parser.parse(dictionary.get('accountCloseDate')).date() if dictionary.get('accountCloseDate') else APIHelper.SKIP
        currency = CurrencyEntity4.from_dictionary(dictionary.get('currency')) if 'currency' in dictionary.keys() else APIHelper.SKIP
        fi_attributes = None
        if dictionary.get('fiAttributes') is not None:
            fi_attributes = [FiAttributeEntity.from_dictionary(x) for x in dictionary.get('fiAttributes')]
        else:
            fi_attributes = APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(parent_account_id,
                   line_of_business,
                   routing_transit_number,
                   balance_type,
                   contact,
                   interest_rate,
                   interest_rate_type,
                   interest_rate_as_of,
                   prior_interest_rate,
                   interest_rate_index,
                   early_penalty_flag,
                   transfer_in,
                   transfer_out,
                   bill_pay_status,
                   micr_number,
                   last_activity_date,
                   reward_program_id,
                   transactions_included,
                   domicile,
                   account_category,
                   account_id,
                   error,
                   account_type,
                   account_number,
                   account_number_display,
                   product_name,
                   nickname,
                   status,
                   description,
                   account_open_date,
                   account_close_date,
                   currency,
                   fi_attributes,
                   additional_properties)

    def __repr__(self):
        base_repr = super().__repr__()
        return (f'{self.__class__.__name__}('
                f'{base_repr[base_repr.find("(") + 1:-1]}, '
                f'parent_account_id={(self.parent_account_id if hasattr(self, "parent_account_id") else None)!r}, '
                f'line_of_business={(self.line_of_business if hasattr(self, "line_of_business") else None)!r}, '
                f'routing_transit_number={(self.routing_transit_number if hasattr(self, "routing_transit_number") else None)!r}, '
                f'balance_type={(self.balance_type if hasattr(self, "balance_type") else None)!r}, '
                f'contact={(self.contact if hasattr(self, "contact") else None)!r}, '
                f'interest_rate={(self.interest_rate if hasattr(self, "interest_rate") else None)!r}, '
                f'interest_rate_type={(self.interest_rate_type if hasattr(self, "interest_rate_type") else None)!r}, '
                f'interest_rate_as_of={(self.interest_rate_as_of if hasattr(self, "interest_rate_as_of") else None)!r}, '
                f'prior_interest_rate={(self.prior_interest_rate if hasattr(self, "prior_interest_rate") else None)!r}, '
                f'interest_rate_index={(self.interest_rate_index if hasattr(self, "interest_rate_index") else None)!r}, '
                f'early_penalty_flag={(self.early_penalty_flag if hasattr(self, "early_penalty_flag") else None)!r}, '
                f'transfer_in={(self.transfer_in if hasattr(self, "transfer_in") else None)!r}, '
                f'transfer_out={(self.transfer_out if hasattr(self, "transfer_out") else None)!r}, '
                f'bill_pay_status={(self.bill_pay_status if hasattr(self, "bill_pay_status") else None)!r}, '
                f'micr_number={(self.micr_number if hasattr(self, "micr_number") else None)!r}, '
                f'last_activity_date={(self.last_activity_date if hasattr(self, "last_activity_date") else None)!r}, '
                f'reward_program_id={(self.reward_program_id if hasattr(self, "reward_program_id") else None)!r}, '
                f'transactions_included={(self.transactions_included if hasattr(self, "transactions_included") else None)!r}, '
                f'domicile={(self.domicile if hasattr(self, "domicile") else None)!r})')

    def __str__(self):
        base_str = super().__str__()
        return (f'{self.__class__.__name__}('
                f'{base_str[base_str.find("(") + 1:-1]}, '
                f'parent_account_id={(self.parent_account_id if hasattr(self, "parent_account_id") else None)!s}, '
                f'line_of_business={(self.line_of_business if hasattr(self, "line_of_business") else None)!s}, '
                f'routing_transit_number={(self.routing_transit_number if hasattr(self, "routing_transit_number") else None)!s}, '
                f'balance_type={(self.balance_type if hasattr(self, "balance_type") else None)!s}, '
                f'contact={(self.contact if hasattr(self, "contact") else None)!s}, '
                f'interest_rate={(self.interest_rate if hasattr(self, "interest_rate") else None)!s}, '
                f'interest_rate_type={(self.interest_rate_type if hasattr(self, "interest_rate_type") else None)!s}, '
                f'interest_rate_as_of={(self.interest_rate_as_of if hasattr(self, "interest_rate_as_of") else None)!s}, '
                f'prior_interest_rate={(self.prior_interest_rate if hasattr(self, "prior_interest_rate") else None)!s}, '
                f'interest_rate_index={(self.interest_rate_index if hasattr(self, "interest_rate_index") else None)!s}, '
                f'early_penalty_flag={(self.early_penalty_flag if hasattr(self, "early_penalty_flag") else None)!s}, '
                f'transfer_in={(self.transfer_in if hasattr(self, "transfer_in") else None)!s}, '
                f'transfer_out={(self.transfer_out if hasattr(self, "transfer_out") else None)!s}, '
                f'bill_pay_status={(self.bill_pay_status if hasattr(self, "bill_pay_status") else None)!s}, '
                f'micr_number={(self.micr_number if hasattr(self, "micr_number") else None)!s}, '
                f'last_activity_date={(self.last_activity_date if hasattr(self, "last_activity_date") else None)!s}, '
                f'reward_program_id={(self.reward_program_id if hasattr(self, "reward_program_id") else None)!s}, '
                f'transactions_included={(self.transactions_included if hasattr(self, "transactions_included") else None)!s}, '
                f'domicile={(self.domicile if hasattr(self, "domicile") else None)!s})')

class AnnuityAccountEntity(AccountEntity):

    """Implementation of the 'Annuity Account entity' model.

    An annuity account type
    NOTE: This class inherits from 'AccountEntity'.

    Attributes:
        payout_type (PayoutType2): Indicates type of payout such as immediate
            or deferred
        policy_product_type (PolicyProductType2): The type of annuity product,
            e.g. Fixed or Variable
        payout_amount (float): Amount paid out, based on mode frequency
        payout_mode (PayoutMode2): Frequency of annuity payments
        payout_start_date (date): Date the payout starts
        payout_end_date (date): Date the payout ends
        number_modal_payouts (int): Total number of payouts
        surrender_value (float): Cash surrender value (net) available if
            contract is surrendered
        payout_change_percentage (float): Percentage of the accumulated value
            to be paid to the payee each year; used exclusive of
            payoutChangeAmount
        payout_change_amount (float): Incremental modal amount (positive or
            negative) by which the payout amount will be changed; used
            exclusive of payoutPercentage
        period_certain_type (PeriodCertainType2): The number of modal periods
            comprising the duration of the certain period of an annuity payout
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "payout_type": 'payoutType',
        "policy_product_type": 'policyProductType',
        "payout_amount": 'payoutAmount',
        "payout_mode": 'payoutMode',
        "payout_start_date": 'payoutStartDate',
        "payout_end_date": 'payoutEndDate',
        "number_modal_payouts": 'numberModalPayouts',
        "surrender_value": 'surrenderValue',
        "payout_change_percentage": 'payoutChangePercentage',
        "payout_change_amount": 'payoutChangeAmount',
        "period_certain_type": 'periodCertainType',
        "parent_account_id": 'parentAccountId',
        "line_of_business": 'lineOfBusiness',
        "routing_transit_number": 'routingTransitNumber',
        "balance_type": 'balanceType',
        "contact": 'contact',
        "interest_rate": 'interestRate',
        "interest_rate_type": 'interestRateType',
        "interest_rate_as_of": 'interestRateAsOf',
        "prior_interest_rate": 'priorInterestRate',
        "interest_rate_index": 'interestRateIndex',
        "early_penalty_flag": 'earlyPenaltyFlag',
        "transfer_in": 'transferIn',
        "transfer_out": 'transferOut',
        "bill_pay_status": 'billPayStatus',
        "micr_number": 'micrNumber',
        "last_activity_date": 'lastActivityDate',
        "reward_program_id": 'rewardProgramId',
        "transactions_included": 'transactionsIncluded',
        "domicile": 'domicile',
        "account_category": 'accountCategory',
        "account_id": 'accountId',
        "error": 'error',
        "account_type": 'accountType',
        "account_number": 'accountNumber',
        "account_number_display": 'accountNumberDisplay',
        "product_name": 'productName',
        "nickname": 'nickname',
        "status": 'status',
        "description": 'description',
        "account_open_date": 'accountOpenDate',
        "account_close_date": 'accountCloseDate',
        "currency": 'currency',
        "fi_attributes": 'fiAttributes'
    }

    _optionals = [
        'payout_type',
        'policy_product_type',
        'payout_amount',
        'payout_mode',
        'payout_start_date',
        'payout_end_date',
        'number_modal_payouts',
        'surrender_value',
        'payout_change_percentage',
        'payout_change_amount',
        'period_certain_type',
    ]
    _optionals.extend(AccountEntity._optionals)

    def __init__(self,
                 payout_type=APIHelper.SKIP,
                 policy_product_type=APIHelper.SKIP,
                 payout_amount=APIHelper.SKIP,
                 payout_mode=APIHelper.SKIP,
                 payout_start_date=APIHelper.SKIP,
                 payout_end_date=APIHelper.SKIP,
                 number_modal_payouts=APIHelper.SKIP,
                 surrender_value=APIHelper.SKIP,
                 payout_change_percentage=APIHelper.SKIP,
                 payout_change_amount=APIHelper.SKIP,
                 period_certain_type=APIHelper.SKIP,
                 parent_account_id=APIHelper.SKIP,
                 line_of_business=APIHelper.SKIP,
                 routing_transit_number=APIHelper.SKIP,
                 balance_type=APIHelper.SKIP,
                 contact=APIHelper.SKIP,
                 interest_rate=APIHelper.SKIP,
                 interest_rate_type=APIHelper.SKIP,
                 interest_rate_as_of=APIHelper.SKIP,
                 prior_interest_rate=APIHelper.SKIP,
                 interest_rate_index=APIHelper.SKIP,
                 early_penalty_flag=APIHelper.SKIP,
                 transfer_in=APIHelper.SKIP,
                 transfer_out=APIHelper.SKIP,
                 bill_pay_status=APIHelper.SKIP,
                 micr_number=APIHelper.SKIP,
                 last_activity_date=APIHelper.SKIP,
                 reward_program_id=APIHelper.SKIP,
                 transactions_included=APIHelper.SKIP,
                 domicile=APIHelper.SKIP,
                 account_category='Annuity Account entity',
                 account_id=APIHelper.SKIP,
                 error=APIHelper.SKIP,
                 account_type=APIHelper.SKIP,
                 account_number=APIHelper.SKIP,
                 account_number_display=APIHelper.SKIP,
                 product_name=APIHelper.SKIP,
                 nickname=APIHelper.SKIP,
                 status=APIHelper.SKIP,
                 description=APIHelper.SKIP,
                 account_open_date=APIHelper.SKIP,
                 account_close_date=APIHelper.SKIP,
                 currency=APIHelper.SKIP,
                 fi_attributes=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the AnnuityAccountEntity class"""

        # Initialize members of the class
        if payout_type is not APIHelper.SKIP:
            self.payout_type = payout_type 
        if policy_product_type is not APIHelper.SKIP:
            self.policy_product_type = policy_product_type 
        if payout_amount is not APIHelper.SKIP:
            self.payout_amount = payout_amount 
        if payout_mode is not APIHelper.SKIP:
            self.payout_mode = payout_mode 
        if payout_start_date is not APIHelper.SKIP:
            self.payout_start_date = payout_start_date 
        if payout_end_date is not APIHelper.SKIP:
            self.payout_end_date = payout_end_date 
        if number_modal_payouts is not APIHelper.SKIP:
            self.number_modal_payouts = number_modal_payouts 
        if surrender_value is not APIHelper.SKIP:
            self.surrender_value = surrender_value 
        if payout_change_percentage is not APIHelper.SKIP:
            self.payout_change_percentage = payout_change_percentage 
        if payout_change_amount is not APIHelper.SKIP:
            self.payout_change_amount = payout_change_amount 
        if period_certain_type is not APIHelper.SKIP:
            self.period_certain_type = period_certain_type 

        # Call the constructor for the base class
        super(AnnuityAccountEntity, self).__init__(parent_account_id,
                                                   line_of_business,
                                                   routing_transit_number,
                                                   balance_type,
                                                   contact,
                                                   interest_rate,
                                                   interest_rate_type,
                                                   interest_rate_as_of,
                                                   prior_interest_rate,
                                                   interest_rate_index,
                                                   early_penalty_flag,
                                                   transfer_in,
                                                   transfer_out,
                                                   bill_pay_status,
                                                   micr_number,
                                                   last_activity_date,
                                                   reward_program_id,
                                                   transactions_included,
                                                   domicile,
                                                   account_category,
                                                   account_id,
                                                   error,
                                                   account_type,
                                                   account_number,
                                                   account_number_display,
                                                   product_name,
                                                   nickname,
                                                   status,
                                                   description,
                                                   account_open_date,
                                                   account_close_date,
                                                   currency,
                                                   fi_attributes,
                                                   additional_properties)

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        payout_type = dictionary.get("payoutType") if dictionary.get("payoutType") else APIHelper.SKIP
        policy_product_type = dictionary.get("policyProductType") if dictionary.get("policyProductType") else APIHelper.SKIP
        payout_amount = dictionary.get("payoutAmount") if dictionary.get("payoutAmount") else APIHelper.SKIP
        payout_mode = dictionary.get("payoutMode") if dictionary.get("payoutMode") else APIHelper.SKIP
        payout_start_date = dateutil.parser.parse(dictionary.get('payoutStartDate')).date() if dictionary.get('payoutStartDate') else APIHelper.SKIP
        payout_end_date = dateutil.parser.parse(dictionary.get('payoutEndDate')).date() if dictionary.get('payoutEndDate') else APIHelper.SKIP
        number_modal_payouts = dictionary.get("numberModalPayouts") if dictionary.get("numberModalPayouts") else APIHelper.SKIP
        surrender_value = dictionary.get("surrenderValue") if dictionary.get("surrenderValue") else APIHelper.SKIP
        payout_change_percentage = dictionary.get("payoutChangePercentage") if dictionary.get("payoutChangePercentage") else APIHelper.SKIP
        payout_change_amount = dictionary.get("payoutChangeAmount") if dictionary.get("payoutChangeAmount") else APIHelper.SKIP
        period_certain_type = dictionary.get("periodCertainType") if dictionary.get("periodCertainType") else APIHelper.SKIP
        parent_account_id = dictionary.get("parentAccountId") if dictionary.get("parentAccountId") else APIHelper.SKIP
        line_of_business = dictionary.get("lineOfBusiness") if dictionary.get("lineOfBusiness") else APIHelper.SKIP
        routing_transit_number = dictionary.get("routingTransitNumber") if dictionary.get("routingTransitNumber") else APIHelper.SKIP
        balance_type = dictionary.get("balanceType") if dictionary.get("balanceType") else APIHelper.SKIP
        contact = AccountContactEntity2.from_dictionary(dictionary.get('contact')) if 'contact' in dictionary.keys() else APIHelper.SKIP
        interest_rate = dictionary.get("interestRate") if dictionary.get("interestRate") else APIHelper.SKIP
        interest_rate_type = dictionary.get("interestRateType") if dictionary.get("interestRateType") else APIHelper.SKIP
        interest_rate_as_of = APIHelper.RFC3339DateTime.from_value(dictionary.get("interestRateAsOf")).datetime if dictionary.get("interestRateAsOf") else APIHelper.SKIP
        prior_interest_rate = dictionary.get("priorInterestRate") if dictionary.get("priorInterestRate") else APIHelper.SKIP
        interest_rate_index = dictionary.get("interestRateIndex") if dictionary.get("interestRateIndex") else APIHelper.SKIP
        early_penalty_flag = dictionary.get("earlyPenaltyFlag") if "earlyPenaltyFlag" in dictionary.keys() else APIHelper.SKIP
        transfer_in = dictionary.get("transferIn") if "transferIn" in dictionary.keys() else APIHelper.SKIP
        transfer_out = dictionary.get("transferOut") if "transferOut" in dictionary.keys() else APIHelper.SKIP
        bill_pay_status = dictionary.get("billPayStatus") if dictionary.get("billPayStatus") else APIHelper.SKIP
        micr_number = dictionary.get("micrNumber") if dictionary.get("micrNumber") else APIHelper.SKIP
        last_activity_date = dateutil.parser.parse(dictionary.get('lastActivityDate')).date() if dictionary.get('lastActivityDate') else APIHelper.SKIP
        reward_program_id = dictionary.get("rewardProgramId") if dictionary.get("rewardProgramId") else APIHelper.SKIP
        transactions_included = dictionary.get("transactionsIncluded") if "transactionsIncluded" in dictionary.keys() else APIHelper.SKIP
        domicile = DomicileEntity1.from_dictionary(dictionary.get('domicile')) if 'domicile' in dictionary.keys() else APIHelper.SKIP
        account_category = dictionary.get("accountCategory") if dictionary.get("accountCategory") else 'Annuity Account entity'
        account_id = dictionary.get("accountId") if dictionary.get("accountId") else APIHelper.SKIP
        error = Error1.from_dictionary(dictionary.get('error')) if 'error' in dictionary.keys() else APIHelper.SKIP
        account_type = dictionary.get("accountType") if dictionary.get("accountType") else APIHelper.SKIP
        account_number = dictionary.get("accountNumber") if dictionary.get("accountNumber") else APIHelper.SKIP
        account_number_display = dictionary.get("accountNumberDisplay") if dictionary.get("accountNumberDisplay") else APIHelper.SKIP
        product_name = dictionary.get("productName") if dictionary.get("productName") else APIHelper.SKIP
        nickname = dictionary.get("nickname") if dictionary.get("nickname") else APIHelper.SKIP
        status = dictionary.get("status") if dictionary.get("status") else APIHelper.SKIP
        description = dictionary.get("description") if dictionary.get("description") else APIHelper.SKIP
        account_open_date = dateutil.parser.parse(dictionary.get('accountOpenDate')).date() if dictionary.get('accountOpenDate') else APIHelper.SKIP
        account_close_date = dateutil.parser.parse(dictionary.get('accountCloseDate')).date() if dictionary.get('accountCloseDate') else APIHelper.SKIP
        currency = CurrencyEntity4.from_dictionary(dictionary.get('currency')) if 'currency' in dictionary.keys() else APIHelper.SKIP
        fi_attributes = None
        if dictionary.get('fiAttributes') is not None:
            fi_attributes = [FiAttributeEntity.from_dictionary(x) for x in dictionary.get('fiAttributes')]
        else:
            fi_attributes = APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(payout_type,
                   policy_product_type,
                   payout_amount,
                   payout_mode,
                   payout_start_date,
                   payout_end_date,
                   number_modal_payouts,
                   surrender_value,
                   payout_change_percentage,
                   payout_change_amount,
                   period_certain_type,
                   parent_account_id,
                   line_of_business,
                   routing_transit_number,
                   balance_type,
                   contact,
                   interest_rate,
                   interest_rate_type,
                   interest_rate_as_of,
                   prior_interest_rate,
                   interest_rate_index,
                   early_penalty_flag,
                   transfer_in,
                   transfer_out,
                   bill_pay_status,
                   micr_number,
                   last_activity_date,
                   reward_program_id,
                   transactions_included,
                   domicile,
                   account_category,
                   account_id,
                   error,
                   account_type,
                   account_number,
                   account_number_display,
                   product_name,
                   nickname,
                   status,
                   description,
                   account_open_date,
                   account_close_date,
                   currency,
                   fi_attributes,
                   additional_properties)

    @classmethod
    def validate(cls, dictionary):
        """Validates dictionary against class required properties

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            boolean : if dictionary is valid contains required properties.

        """

        if isinstance(dictionary, cls):
            return True

        if not isinstance(dictionary, dict):
            return False

        return True

    def __repr__(self):
        base_repr = super().__repr__()
        return (f'{self.__class__.__name__}('
                f'{base_repr[base_repr.find("(") + 1:-1]}, '
                f'payout_type={(self.payout_type if hasattr(self, "payout_type") else None)!r}, '
                f'policy_product_type={(self.policy_product_type if hasattr(self, "policy_product_type") else None)!r}, '
                f'payout_amount={(self.payout_amount if hasattr(self, "payout_amount") else None)!r}, '
                f'payout_mode={(self.payout_mode if hasattr(self, "payout_mode") else None)!r}, '
                f'payout_start_date={(self.payout_start_date if hasattr(self, "payout_start_date") else None)!r}, '
                f'payout_end_date={(self.payout_end_date if hasattr(self, "payout_end_date") else None)!r}, '
                f'number_modal_payouts={(self.number_modal_payouts if hasattr(self, "number_modal_payouts") else None)!r}, '
                f'surrender_value={(self.surrender_value if hasattr(self, "surrender_value") else None)!r}, '
                f'payout_change_percentage={(self.payout_change_percentage if hasattr(self, "payout_change_percentage") else None)!r}, '
                f'payout_change_amount={(self.payout_change_amount if hasattr(self, "payout_change_amount") else None)!r}, '
                f'period_certain_type={(self.period_certain_type if hasattr(self, "period_certain_type") else None)!r})')

    def __str__(self):
        base_str = super().__str__()
        return (f'{self.__class__.__name__}('
                f'{base_str[base_str.find("(") + 1:-1]}, '
                f'payout_type={(self.payout_type if hasattr(self, "payout_type") else None)!s}, '
                f'policy_product_type={(self.policy_product_type if hasattr(self, "policy_product_type") else None)!s}, '
                f'payout_amount={(self.payout_amount if hasattr(self, "payout_amount") else None)!s}, '
                f'payout_mode={(self.payout_mode if hasattr(self, "payout_mode") else None)!s}, '
                f'payout_start_date={(self.payout_start_date if hasattr(self, "payout_start_date") else None)!s}, '
                f'payout_end_date={(self.payout_end_date if hasattr(self, "payout_end_date") else None)!s}, '
                f'number_modal_payouts={(self.number_modal_payouts if hasattr(self, "number_modal_payouts") else None)!s}, '
                f'surrender_value={(self.surrender_value if hasattr(self, "surrender_value") else None)!s}, '
                f'payout_change_percentage={(self.payout_change_percentage if hasattr(self, "payout_change_percentage") else None)!s}, '
                f'payout_change_amount={(self.payout_change_amount if hasattr(self, "payout_change_amount") else None)!s}, '
                f'period_certain_type={(self.period_certain_type if hasattr(self, "period_certain_type") else None)!s})')

class CommercialAccountEntity(AccountEntity):

    """Implementation of the 'Commercial Account entity' model.

    Information for a commercial account type
    NOTE: This class inherits from 'AccountEntity'.

    Attributes:
        balance_as_of (datetime): As-of date of balances
        opening_ledger_balance (float): Opening ledger balance
        closing_ledger_balance (float): Closing ledger balance
        current_ledger_balance (float): Current ledger balance
        opening_available_balance (float): Opening available balance
        current_available_balance (float): Current available balance
        closing_available_balance (float): Closing available balance
        next_day_available_balance (float): Next day's available balance
        two_days_plus_available_balance (float): Two days out's available
            balance
        number_of_outstanding_credits (int): Number of outstanding credit
            transactions
        outstanding_credits_amount (float): Total amount of outstanding credits
        number_of_outstanding_debits (int): Number of outstanding debit
            transactions
        outstanding_debits_amount (float): Total amount of outstanding debits
        transactions (List[CommercialTransactionEntity]): Transactions on the
            commercial account
        commercial_balances (List[CommercialBalanceEntity]): A list of
            specific treasury management defined balances
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "balance_as_of": 'balanceAsOf',
        "opening_ledger_balance": 'openingLedgerBalance',
        "closing_ledger_balance": 'closingLedgerBalance',
        "current_ledger_balance": 'currentLedgerBalance',
        "opening_available_balance": 'openingAvailableBalance',
        "current_available_balance": 'currentAvailableBalance',
        "closing_available_balance": 'closingAvailableBalance',
        "next_day_available_balance": 'nextDayAvailableBalance',
        "two_days_plus_available_balance": 'twoDaysPlusAvailableBalance',
        "number_of_outstanding_credits": 'numberOfOutstandingCredits',
        "outstanding_credits_amount": 'outstandingCreditsAmount',
        "number_of_outstanding_debits": 'numberOfOutstandingDebits',
        "outstanding_debits_amount": 'outstandingDebitsAmount',
        "transactions": 'transactions',
        "commercial_balances": 'commercialBalances',
        "parent_account_id": 'parentAccountId',
        "line_of_business": 'lineOfBusiness',
        "routing_transit_number": 'routingTransitNumber',
        "balance_type": 'balanceType',
        "contact": 'contact',
        "interest_rate": 'interestRate',
        "interest_rate_type": 'interestRateType',
        "interest_rate_as_of": 'interestRateAsOf',
        "prior_interest_rate": 'priorInterestRate',
        "interest_rate_index": 'interestRateIndex',
        "early_penalty_flag": 'earlyPenaltyFlag',
        "transfer_in": 'transferIn',
        "transfer_out": 'transferOut',
        "bill_pay_status": 'billPayStatus',
        "micr_number": 'micrNumber',
        "last_activity_date": 'lastActivityDate',
        "reward_program_id": 'rewardProgramId',
        "transactions_included": 'transactionsIncluded',
        "domicile": 'domicile',
        "account_category": 'accountCategory',
        "account_id": 'accountId',
        "error": 'error',
        "account_type": 'accountType',
        "account_number": 'accountNumber',
        "account_number_display": 'accountNumberDisplay',
        "product_name": 'productName',
        "nickname": 'nickname',
        "status": 'status',
        "description": 'description',
        "account_open_date": 'accountOpenDate',
        "account_close_date": 'accountCloseDate',
        "currency": 'currency',
        "fi_attributes": 'fiAttributes'
    }

    _optionals = [
        'balance_as_of',
        'opening_ledger_balance',
        'closing_ledger_balance',
        'current_ledger_balance',
        'opening_available_balance',
        'current_available_balance',
        'closing_available_balance',
        'next_day_available_balance',
        'two_days_plus_available_balance',
        'number_of_outstanding_credits',
        'outstanding_credits_amount',
        'number_of_outstanding_debits',
        'outstanding_debits_amount',
        'transactions',
        'commercial_balances',
    ]
    _optionals.extend(AccountEntity._optionals)

    def __init__(self,
                 balance_as_of=APIHelper.SKIP,
                 opening_ledger_balance=APIHelper.SKIP,
                 closing_ledger_balance=APIHelper.SKIP,
                 current_ledger_balance=APIHelper.SKIP,
                 opening_available_balance=APIHelper.SKIP,
                 current_available_balance=APIHelper.SKIP,
                 closing_available_balance=APIHelper.SKIP,
                 next_day_available_balance=APIHelper.SKIP,
                 two_days_plus_available_balance=APIHelper.SKIP,
                 number_of_outstanding_credits=APIHelper.SKIP,
                 outstanding_credits_amount=APIHelper.SKIP,
                 number_of_outstanding_debits=APIHelper.SKIP,
                 outstanding_debits_amount=APIHelper.SKIP,
                 transactions=APIHelper.SKIP,
                 commercial_balances=APIHelper.SKIP,
                 parent_account_id=APIHelper.SKIP,
                 line_of_business=APIHelper.SKIP,
                 routing_transit_number=APIHelper.SKIP,
                 balance_type=APIHelper.SKIP,
                 contact=APIHelper.SKIP,
                 interest_rate=APIHelper.SKIP,
                 interest_rate_type=APIHelper.SKIP,
                 interest_rate_as_of=APIHelper.SKIP,
                 prior_interest_rate=APIHelper.SKIP,
                 interest_rate_index=APIHelper.SKIP,
                 early_penalty_flag=APIHelper.SKIP,
                 transfer_in=APIHelper.SKIP,
                 transfer_out=APIHelper.SKIP,
                 bill_pay_status=APIHelper.SKIP,
                 micr_number=APIHelper.SKIP,
                 last_activity_date=APIHelper.SKIP,
                 reward_program_id=APIHelper.SKIP,
                 transactions_included=APIHelper.SKIP,
                 domicile=APIHelper.SKIP,
                 account_category='Commercial Account entity',
                 account_id=APIHelper.SKIP,
                 error=APIHelper.SKIP,
                 account_type=APIHelper.SKIP,
                 account_number=APIHelper.SKIP,
                 account_number_display=APIHelper.SKIP,
                 product_name=APIHelper.SKIP,
                 nickname=APIHelper.SKIP,
                 status=APIHelper.SKIP,
                 description=APIHelper.SKIP,
                 account_open_date=APIHelper.SKIP,
                 account_close_date=APIHelper.SKIP,
                 currency=APIHelper.SKIP,
                 fi_attributes=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the CommercialAccountEntity class"""

        # Initialize members of the class
        if balance_as_of is not APIHelper.SKIP:
            self.balance_as_of = APIHelper.apply_datetime_converter(balance_as_of, APIHelper.RFC3339DateTime) if balance_as_of else None 
        if opening_ledger_balance is not APIHelper.SKIP:
            self.opening_ledger_balance = opening_ledger_balance 
        if closing_ledger_balance is not APIHelper.SKIP:
            self.closing_ledger_balance = closing_ledger_balance 
        if current_ledger_balance is not APIHelper.SKIP:
            self.current_ledger_balance = current_ledger_balance 
        if opening_available_balance is not APIHelper.SKIP:
            self.opening_available_balance = opening_available_balance 
        if current_available_balance is not APIHelper.SKIP:
            self.current_available_balance = current_available_balance 
        if closing_available_balance is not APIHelper.SKIP:
            self.closing_available_balance = closing_available_balance 
        if next_day_available_balance is not APIHelper.SKIP:
            self.next_day_available_balance = next_day_available_balance 
        if two_days_plus_available_balance is not APIHelper.SKIP:
            self.two_days_plus_available_balance = two_days_plus_available_balance 
        if number_of_outstanding_credits is not APIHelper.SKIP:
            self.number_of_outstanding_credits = number_of_outstanding_credits 
        if outstanding_credits_amount is not APIHelper.SKIP:
            self.outstanding_credits_amount = outstanding_credits_amount 
        if number_of_outstanding_debits is not APIHelper.SKIP:
            self.number_of_outstanding_debits = number_of_outstanding_debits 
        if outstanding_debits_amount is not APIHelper.SKIP:
            self.outstanding_debits_amount = outstanding_debits_amount 
        if transactions is not APIHelper.SKIP:
            self.transactions = transactions 
        if commercial_balances is not APIHelper.SKIP:
            self.commercial_balances = commercial_balances 

        # Call the constructor for the base class
        super(CommercialAccountEntity, self).__init__(parent_account_id,
                                                      line_of_business,
                                                      routing_transit_number,
                                                      balance_type,
                                                      contact,
                                                      interest_rate,
                                                      interest_rate_type,
                                                      interest_rate_as_of,
                                                      prior_interest_rate,
                                                      interest_rate_index,
                                                      early_penalty_flag,
                                                      transfer_in,
                                                      transfer_out,
                                                      bill_pay_status,
                                                      micr_number,
                                                      last_activity_date,
                                                      reward_program_id,
                                                      transactions_included,
                                                      domicile,
                                                      account_category,
                                                      account_id,
                                                      error,
                                                      account_type,
                                                      account_number,
                                                      account_number_display,
                                                      product_name,
                                                      nickname,
                                                      status,
                                                      description,
                                                      account_open_date,
                                                      account_close_date,
                                                      currency,
                                                      fi_attributes,
                                                      additional_properties)

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        balance_as_of = APIHelper.RFC3339DateTime.from_value(dictionary.get("balanceAsOf")).datetime if dictionary.get("balanceAsOf") else APIHelper.SKIP
        opening_ledger_balance = dictionary.get("openingLedgerBalance") if dictionary.get("openingLedgerBalance") else APIHelper.SKIP
        closing_ledger_balance = dictionary.get("closingLedgerBalance") if dictionary.get("closingLedgerBalance") else APIHelper.SKIP
        current_ledger_balance = dictionary.get("currentLedgerBalance") if dictionary.get("currentLedgerBalance") else APIHelper.SKIP
        opening_available_balance = dictionary.get("openingAvailableBalance") if dictionary.get("openingAvailableBalance") else APIHelper.SKIP
        current_available_balance = dictionary.get("currentAvailableBalance") if dictionary.get("currentAvailableBalance") else APIHelper.SKIP
        closing_available_balance = dictionary.get("closingAvailableBalance") if dictionary.get("closingAvailableBalance") else APIHelper.SKIP
        next_day_available_balance = dictionary.get("nextDayAvailableBalance") if dictionary.get("nextDayAvailableBalance") else APIHelper.SKIP
        two_days_plus_available_balance = dictionary.get("twoDaysPlusAvailableBalance") if dictionary.get("twoDaysPlusAvailableBalance") else APIHelper.SKIP
        number_of_outstanding_credits = dictionary.get("numberOfOutstandingCredits") if dictionary.get("numberOfOutstandingCredits") else APIHelper.SKIP
        outstanding_credits_amount = dictionary.get("outstandingCreditsAmount") if dictionary.get("outstandingCreditsAmount") else APIHelper.SKIP
        number_of_outstanding_debits = dictionary.get("numberOfOutstandingDebits") if dictionary.get("numberOfOutstandingDebits") else APIHelper.SKIP
        outstanding_debits_amount = dictionary.get("outstandingDebitsAmount") if dictionary.get("outstandingDebitsAmount") else APIHelper.SKIP
        transactions = None
        if dictionary.get('transactions') is not None:
            transactions = [CommercialTransactionEntity.from_dictionary(x) for x in dictionary.get('transactions')]
        else:
            transactions = APIHelper.SKIP
        commercial_balances = None
        if dictionary.get('commercialBalances') is not None:
            commercial_balances = [CommercialBalanceEntity.from_dictionary(x) for x in dictionary.get('commercialBalances')]
        else:
            commercial_balances = APIHelper.SKIP
        parent_account_id = dictionary.get("parentAccountId") if dictionary.get("parentAccountId") else APIHelper.SKIP
        line_of_business = dictionary.get("lineOfBusiness") if dictionary.get("lineOfBusiness") else APIHelper.SKIP
        routing_transit_number = dictionary.get("routingTransitNumber") if dictionary.get("routingTransitNumber") else APIHelper.SKIP
        balance_type = dictionary.get("balanceType") if dictionary.get("balanceType") else APIHelper.SKIP
        contact = AccountContactEntity2.from_dictionary(dictionary.get('contact')) if 'contact' in dictionary.keys() else APIHelper.SKIP
        interest_rate = dictionary.get("interestRate") if dictionary.get("interestRate") else APIHelper.SKIP
        interest_rate_type = dictionary.get("interestRateType") if dictionary.get("interestRateType") else APIHelper.SKIP
        interest_rate_as_of = APIHelper.RFC3339DateTime.from_value(dictionary.get("interestRateAsOf")).datetime if dictionary.get("interestRateAsOf") else APIHelper.SKIP
        prior_interest_rate = dictionary.get("priorInterestRate") if dictionary.get("priorInterestRate") else APIHelper.SKIP
        interest_rate_index = dictionary.get("interestRateIndex") if dictionary.get("interestRateIndex") else APIHelper.SKIP
        early_penalty_flag = dictionary.get("earlyPenaltyFlag") if "earlyPenaltyFlag" in dictionary.keys() else APIHelper.SKIP
        transfer_in = dictionary.get("transferIn") if "transferIn" in dictionary.keys() else APIHelper.SKIP
        transfer_out = dictionary.get("transferOut") if "transferOut" in dictionary.keys() else APIHelper.SKIP
        bill_pay_status = dictionary.get("billPayStatus") if dictionary.get("billPayStatus") else APIHelper.SKIP
        micr_number = dictionary.get("micrNumber") if dictionary.get("micrNumber") else APIHelper.SKIP
        last_activity_date = dateutil.parser.parse(dictionary.get('lastActivityDate')).date() if dictionary.get('lastActivityDate') else APIHelper.SKIP
        reward_program_id = dictionary.get("rewardProgramId") if dictionary.get("rewardProgramId") else APIHelper.SKIP
        transactions_included = dictionary.get("transactionsIncluded") if "transactionsIncluded" in dictionary.keys() else APIHelper.SKIP
        domicile = DomicileEntity1.from_dictionary(dictionary.get('domicile')) if 'domicile' in dictionary.keys() else APIHelper.SKIP
        account_category = dictionary.get("accountCategory") if dictionary.get("accountCategory") else 'Commercial Account entity'
        account_id = dictionary.get("accountId") if dictionary.get("accountId") else APIHelper.SKIP
        error = Error1.from_dictionary(dictionary.get('error')) if 'error' in dictionary.keys() else APIHelper.SKIP
        account_type = dictionary.get("accountType") if dictionary.get("accountType") else APIHelper.SKIP
        account_number = dictionary.get("accountNumber") if dictionary.get("accountNumber") else APIHelper.SKIP
        account_number_display = dictionary.get("accountNumberDisplay") if dictionary.get("accountNumberDisplay") else APIHelper.SKIP
        product_name = dictionary.get("productName") if dictionary.get("productName") else APIHelper.SKIP
        nickname = dictionary.get("nickname") if dictionary.get("nickname") else APIHelper.SKIP
        status = dictionary.get("status") if dictionary.get("status") else APIHelper.SKIP
        description = dictionary.get("description") if dictionary.get("description") else APIHelper.SKIP
        account_open_date = dateutil.parser.parse(dictionary.get('accountOpenDate')).date() if dictionary.get('accountOpenDate') else APIHelper.SKIP
        account_close_date = dateutil.parser.parse(dictionary.get('accountCloseDate')).date() if dictionary.get('accountCloseDate') else APIHelper.SKIP
        currency = CurrencyEntity4.from_dictionary(dictionary.get('currency')) if 'currency' in dictionary.keys() else APIHelper.SKIP
        fi_attributes = None
        if dictionary.get('fiAttributes') is not None:
            fi_attributes = [FiAttributeEntity.from_dictionary(x) for x in dictionary.get('fiAttributes')]
        else:
            fi_attributes = APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(balance_as_of,
                   opening_ledger_balance,
                   closing_ledger_balance,
                   current_ledger_balance,
                   opening_available_balance,
                   current_available_balance,
                   closing_available_balance,
                   next_day_available_balance,
                   two_days_plus_available_balance,
                   number_of_outstanding_credits,
                   outstanding_credits_amount,
                   number_of_outstanding_debits,
                   outstanding_debits_amount,
                   transactions,
                   commercial_balances,
                   parent_account_id,
                   line_of_business,
                   routing_transit_number,
                   balance_type,
                   contact,
                   interest_rate,
                   interest_rate_type,
                   interest_rate_as_of,
                   prior_interest_rate,
                   interest_rate_index,
                   early_penalty_flag,
                   transfer_in,
                   transfer_out,
                   bill_pay_status,
                   micr_number,
                   last_activity_date,
                   reward_program_id,
                   transactions_included,
                   domicile,
                   account_category,
                   account_id,
                   error,
                   account_type,
                   account_number,
                   account_number_display,
                   product_name,
                   nickname,
                   status,
                   description,
                   account_open_date,
                   account_close_date,
                   currency,
                   fi_attributes,
                   additional_properties)

    @classmethod
    def validate(cls, dictionary):
        """Validates dictionary against class required properties

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            boolean : if dictionary is valid contains required properties.

        """

        if isinstance(dictionary, cls):
            return True

        if not isinstance(dictionary, dict):
            return False

        return True

    def __repr__(self):
        base_repr = super().__repr__()
        return (f'{self.__class__.__name__}('
                f'{base_repr[base_repr.find("(") + 1:-1]}, '
                f'balance_as_of={(self.balance_as_of if hasattr(self, "balance_as_of") else None)!r}, '
                f'opening_ledger_balance={(self.opening_ledger_balance if hasattr(self, "opening_ledger_balance") else None)!r}, '
                f'closing_ledger_balance={(self.closing_ledger_balance if hasattr(self, "closing_ledger_balance") else None)!r}, '
                f'current_ledger_balance={(self.current_ledger_balance if hasattr(self, "current_ledger_balance") else None)!r}, '
                f'opening_available_balance={(self.opening_available_balance if hasattr(self, "opening_available_balance") else None)!r}, '
                f'current_available_balance={(self.current_available_balance if hasattr(self, "current_available_balance") else None)!r}, '
                f'closing_available_balance={(self.closing_available_balance if hasattr(self, "closing_available_balance") else None)!r}, '
                f'next_day_available_balance={(self.next_day_available_balance if hasattr(self, "next_day_available_balance") else None)!r}, '
                f'two_days_plus_available_balance={(self.two_days_plus_available_balance if hasattr(self, "two_days_plus_available_balance") else None)!r}, '
                f'number_of_outstanding_credits={(self.number_of_outstanding_credits if hasattr(self, "number_of_outstanding_credits") else None)!r}, '
                f'outstanding_credits_amount={(self.outstanding_credits_amount if hasattr(self, "outstanding_credits_amount") else None)!r}, '
                f'number_of_outstanding_debits={(self.number_of_outstanding_debits if hasattr(self, "number_of_outstanding_debits") else None)!r}, '
                f'outstanding_debits_amount={(self.outstanding_debits_amount if hasattr(self, "outstanding_debits_amount") else None)!r}, '
                f'transactions={(self.transactions if hasattr(self, "transactions") else None)!r}, '
                f'commercial_balances={(self.commercial_balances if hasattr(self, "commercial_balances") else None)!r})')

    def __str__(self):
        base_str = super().__str__()
        return (f'{self.__class__.__name__}('
                f'{base_str[base_str.find("(") + 1:-1]}, '
                f'balance_as_of={(self.balance_as_of if hasattr(self, "balance_as_of") else None)!s}, '
                f'opening_ledger_balance={(self.opening_ledger_balance if hasattr(self, "opening_ledger_balance") else None)!s}, '
                f'closing_ledger_balance={(self.closing_ledger_balance if hasattr(self, "closing_ledger_balance") else None)!s}, '
                f'current_ledger_balance={(self.current_ledger_balance if hasattr(self, "current_ledger_balance") else None)!s}, '
                f'opening_available_balance={(self.opening_available_balance if hasattr(self, "opening_available_balance") else None)!s}, '
                f'current_available_balance={(self.current_available_balance if hasattr(self, "current_available_balance") else None)!s}, '
                f'closing_available_balance={(self.closing_available_balance if hasattr(self, "closing_available_balance") else None)!s}, '
                f'next_day_available_balance={(self.next_day_available_balance if hasattr(self, "next_day_available_balance") else None)!s}, '
                f'two_days_plus_available_balance={(self.two_days_plus_available_balance if hasattr(self, "two_days_plus_available_balance") else None)!s}, '
                f'number_of_outstanding_credits={(self.number_of_outstanding_credits if hasattr(self, "number_of_outstanding_credits") else None)!s}, '
                f'outstanding_credits_amount={(self.outstanding_credits_amount if hasattr(self, "outstanding_credits_amount") else None)!s}, '
                f'number_of_outstanding_debits={(self.number_of_outstanding_debits if hasattr(self, "number_of_outstanding_debits") else None)!s}, '
                f'outstanding_debits_amount={(self.outstanding_debits_amount if hasattr(self, "outstanding_debits_amount") else None)!s}, '
                f'transactions={(self.transactions if hasattr(self, "transactions") else None)!s}, '
                f'commercial_balances={(self.commercial_balances if hasattr(self, "commercial_balances") else None)!s})')

class DepositAccountEntity(AccountEntity):

    """Implementation of the 'Deposit Account entity' model.

    Information for a deposit account type
    NOTE: This class inherits from 'AccountEntity'.

    Attributes:
        balance_as_of (datetime): As-of date of balances
        current_balance (float): Balance of funds in account
        opening_day_balance (float): Day's opening fund balance
        available_balance (float): Balance of funds available for use
        annual_percentage_yield (float): Annual Percentage Yield
        interest_ytd (float): YTD Interest
        term (int): Term of CD in months
        maturity_date (date): Maturity date for CDs
        transactions (List[DepositTransactionEntity]): Transactions on the
            deposit account
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "balance_as_of": 'balanceAsOf',
        "current_balance": 'currentBalance',
        "opening_day_balance": 'openingDayBalance',
        "available_balance": 'availableBalance',
        "annual_percentage_yield": 'annualPercentageYield',
        "interest_ytd": 'interestYtd',
        "term": 'term',
        "maturity_date": 'maturityDate',
        "transactions": 'transactions',
        "parent_account_id": 'parentAccountId',
        "line_of_business": 'lineOfBusiness',
        "routing_transit_number": 'routingTransitNumber',
        "balance_type": 'balanceType',
        "contact": 'contact',
        "interest_rate": 'interestRate',
        "interest_rate_type": 'interestRateType',
        "interest_rate_as_of": 'interestRateAsOf',
        "prior_interest_rate": 'priorInterestRate',
        "interest_rate_index": 'interestRateIndex',
        "early_penalty_flag": 'earlyPenaltyFlag',
        "transfer_in": 'transferIn',
        "transfer_out": 'transferOut',
        "bill_pay_status": 'billPayStatus',
        "micr_number": 'micrNumber',
        "last_activity_date": 'lastActivityDate',
        "reward_program_id": 'rewardProgramId',
        "transactions_included": 'transactionsIncluded',
        "domicile": 'domicile',
        "account_category": 'accountCategory',
        "account_id": 'accountId',
        "error": 'error',
        "account_type": 'accountType',
        "account_number": 'accountNumber',
        "account_number_display": 'accountNumberDisplay',
        "product_name": 'productName',
        "nickname": 'nickname',
        "status": 'status',
        "description": 'description',
        "account_open_date": 'accountOpenDate',
        "account_close_date": 'accountCloseDate',
        "currency": 'currency',
        "fi_attributes": 'fiAttributes'
    }

    _optionals = [
        'balance_as_of',
        'current_balance',
        'opening_day_balance',
        'available_balance',
        'annual_percentage_yield',
        'interest_ytd',
        'term',
        'maturity_date',
        'transactions',
    ]
    _optionals.extend(AccountEntity._optionals)

    def __init__(self,
                 balance_as_of=APIHelper.SKIP,
                 current_balance=APIHelper.SKIP,
                 opening_day_balance=APIHelper.SKIP,
                 available_balance=APIHelper.SKIP,
                 annual_percentage_yield=APIHelper.SKIP,
                 interest_ytd=APIHelper.SKIP,
                 term=APIHelper.SKIP,
                 maturity_date=APIHelper.SKIP,
                 transactions=APIHelper.SKIP,
                 parent_account_id=APIHelper.SKIP,
                 line_of_business=APIHelper.SKIP,
                 routing_transit_number=APIHelper.SKIP,
                 balance_type=APIHelper.SKIP,
                 contact=APIHelper.SKIP,
                 interest_rate=APIHelper.SKIP,
                 interest_rate_type=APIHelper.SKIP,
                 interest_rate_as_of=APIHelper.SKIP,
                 prior_interest_rate=APIHelper.SKIP,
                 interest_rate_index=APIHelper.SKIP,
                 early_penalty_flag=APIHelper.SKIP,
                 transfer_in=APIHelper.SKIP,
                 transfer_out=APIHelper.SKIP,
                 bill_pay_status=APIHelper.SKIP,
                 micr_number=APIHelper.SKIP,
                 last_activity_date=APIHelper.SKIP,
                 reward_program_id=APIHelper.SKIP,
                 transactions_included=APIHelper.SKIP,
                 domicile=APIHelper.SKIP,
                 account_category='Deposit Account entity',
                 account_id=APIHelper.SKIP,
                 error=APIHelper.SKIP,
                 account_type=APIHelper.SKIP,
                 account_number=APIHelper.SKIP,
                 account_number_display=APIHelper.SKIP,
                 product_name=APIHelper.SKIP,
                 nickname=APIHelper.SKIP,
                 status=APIHelper.SKIP,
                 description=APIHelper.SKIP,
                 account_open_date=APIHelper.SKIP,
                 account_close_date=APIHelper.SKIP,
                 currency=APIHelper.SKIP,
                 fi_attributes=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the DepositAccountEntity class"""

        # Initialize members of the class
        if balance_as_of is not APIHelper.SKIP:
            self.balance_as_of = APIHelper.apply_datetime_converter(balance_as_of, APIHelper.RFC3339DateTime) if balance_as_of else None 
        if current_balance is not APIHelper.SKIP:
            self.current_balance = current_balance 
        if opening_day_balance is not APIHelper.SKIP:
            self.opening_day_balance = opening_day_balance 
        if available_balance is not APIHelper.SKIP:
            self.available_balance = available_balance 
        if annual_percentage_yield is not APIHelper.SKIP:
            self.annual_percentage_yield = annual_percentage_yield 
        if interest_ytd is not APIHelper.SKIP:
            self.interest_ytd = interest_ytd 
        if term is not APIHelper.SKIP:
            self.term = term 
        if maturity_date is not APIHelper.SKIP:
            self.maturity_date = maturity_date 
        if transactions is not APIHelper.SKIP:
            self.transactions = transactions 

        # Call the constructor for the base class
        super(DepositAccountEntity, self).__init__(parent_account_id,
                                                   line_of_business,
                                                   routing_transit_number,
                                                   balance_type,
                                                   contact,
                                                   interest_rate,
                                                   interest_rate_type,
                                                   interest_rate_as_of,
                                                   prior_interest_rate,
                                                   interest_rate_index,
                                                   early_penalty_flag,
                                                   transfer_in,
                                                   transfer_out,
                                                   bill_pay_status,
                                                   micr_number,
                                                   last_activity_date,
                                                   reward_program_id,
                                                   transactions_included,
                                                   domicile,
                                                   account_category,
                                                   account_id,
                                                   error,
                                                   account_type,
                                                   account_number,
                                                   account_number_display,
                                                   product_name,
                                                   nickname,
                                                   status,
                                                   description,
                                                   account_open_date,
                                                   account_close_date,
                                                   currency,
                                                   fi_attributes,
                                                   additional_properties)

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        balance_as_of = APIHelper.RFC3339DateTime.from_value(dictionary.get("balanceAsOf")).datetime if dictionary.get("balanceAsOf") else APIHelper.SKIP
        current_balance = dictionary.get("currentBalance") if dictionary.get("currentBalance") else APIHelper.SKIP
        opening_day_balance = dictionary.get("openingDayBalance") if dictionary.get("openingDayBalance") else APIHelper.SKIP
        available_balance = dictionary.get("availableBalance") if dictionary.get("availableBalance") else APIHelper.SKIP
        annual_percentage_yield = dictionary.get("annualPercentageYield") if dictionary.get("annualPercentageYield") else APIHelper.SKIP
        interest_ytd = dictionary.get("interestYtd") if dictionary.get("interestYtd") else APIHelper.SKIP
        term = dictionary.get("term") if dictionary.get("term") else APIHelper.SKIP
        maturity_date = dateutil.parser.parse(dictionary.get('maturityDate')).date() if dictionary.get('maturityDate') else APIHelper.SKIP
        transactions = None
        if dictionary.get('transactions') is not None:
            transactions = [DepositTransactionEntity.from_dictionary(x) for x in dictionary.get('transactions')]
        else:
            transactions = APIHelper.SKIP
        parent_account_id = dictionary.get("parentAccountId") if dictionary.get("parentAccountId") else APIHelper.SKIP
        line_of_business = dictionary.get("lineOfBusiness") if dictionary.get("lineOfBusiness") else APIHelper.SKIP
        routing_transit_number = dictionary.get("routingTransitNumber") if dictionary.get("routingTransitNumber") else APIHelper.SKIP
        balance_type = dictionary.get("balanceType") if dictionary.get("balanceType") else APIHelper.SKIP
        contact = AccountContactEntity2.from_dictionary(dictionary.get('contact')) if 'contact' in dictionary.keys() else APIHelper.SKIP
        interest_rate = dictionary.get("interestRate") if dictionary.get("interestRate") else APIHelper.SKIP
        interest_rate_type = dictionary.get("interestRateType") if dictionary.get("interestRateType") else APIHelper.SKIP
        interest_rate_as_of = APIHelper.RFC3339DateTime.from_value(dictionary.get("interestRateAsOf")).datetime if dictionary.get("interestRateAsOf") else APIHelper.SKIP
        prior_interest_rate = dictionary.get("priorInterestRate") if dictionary.get("priorInterestRate") else APIHelper.SKIP
        interest_rate_index = dictionary.get("interestRateIndex") if dictionary.get("interestRateIndex") else APIHelper.SKIP
        early_penalty_flag = dictionary.get("earlyPenaltyFlag") if "earlyPenaltyFlag" in dictionary.keys() else APIHelper.SKIP
        transfer_in = dictionary.get("transferIn") if "transferIn" in dictionary.keys() else APIHelper.SKIP
        transfer_out = dictionary.get("transferOut") if "transferOut" in dictionary.keys() else APIHelper.SKIP
        bill_pay_status = dictionary.get("billPayStatus") if dictionary.get("billPayStatus") else APIHelper.SKIP
        micr_number = dictionary.get("micrNumber") if dictionary.get("micrNumber") else APIHelper.SKIP
        last_activity_date = dateutil.parser.parse(dictionary.get('lastActivityDate')).date() if dictionary.get('lastActivityDate') else APIHelper.SKIP
        reward_program_id = dictionary.get("rewardProgramId") if dictionary.get("rewardProgramId") else APIHelper.SKIP
        transactions_included = dictionary.get("transactionsIncluded") if "transactionsIncluded" in dictionary.keys() else APIHelper.SKIP
        domicile = DomicileEntity1.from_dictionary(dictionary.get('domicile')) if 'domicile' in dictionary.keys() else APIHelper.SKIP
        account_category = dictionary.get("accountCategory") if dictionary.get("accountCategory") else 'Deposit Account entity'
        account_id = dictionary.get("accountId") if dictionary.get("accountId") else APIHelper.SKIP
        error = Error1.from_dictionary(dictionary.get('error')) if 'error' in dictionary.keys() else APIHelper.SKIP
        account_type = dictionary.get("accountType") if dictionary.get("accountType") else APIHelper.SKIP
        account_number = dictionary.get("accountNumber") if dictionary.get("accountNumber") else APIHelper.SKIP
        account_number_display = dictionary.get("accountNumberDisplay") if dictionary.get("accountNumberDisplay") else APIHelper.SKIP
        product_name = dictionary.get("productName") if dictionary.get("productName") else APIHelper.SKIP
        nickname = dictionary.get("nickname") if dictionary.get("nickname") else APIHelper.SKIP
        status = dictionary.get("status") if dictionary.get("status") else APIHelper.SKIP
        description = dictionary.get("description") if dictionary.get("description") else APIHelper.SKIP
        account_open_date = dateutil.parser.parse(dictionary.get('accountOpenDate')).date() if dictionary.get('accountOpenDate') else APIHelper.SKIP
        account_close_date = dateutil.parser.parse(dictionary.get('accountCloseDate')).date() if dictionary.get('accountCloseDate') else APIHelper.SKIP
        currency = CurrencyEntity4.from_dictionary(dictionary.get('currency')) if 'currency' in dictionary.keys() else APIHelper.SKIP
        fi_attributes = None
        if dictionary.get('fiAttributes') is not None:
            fi_attributes = [FiAttributeEntity.from_dictionary(x) for x in dictionary.get('fiAttributes')]
        else:
            fi_attributes = APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(balance_as_of,
                   current_balance,
                   opening_day_balance,
                   available_balance,
                   annual_percentage_yield,
                   interest_ytd,
                   term,
                   maturity_date,
                   transactions,
                   parent_account_id,
                   line_of_business,
                   routing_transit_number,
                   balance_type,
                   contact,
                   interest_rate,
                   interest_rate_type,
                   interest_rate_as_of,
                   prior_interest_rate,
                   interest_rate_index,
                   early_penalty_flag,
                   transfer_in,
                   transfer_out,
                   bill_pay_status,
                   micr_number,
                   last_activity_date,
                   reward_program_id,
                   transactions_included,
                   domicile,
                   account_category,
                   account_id,
                   error,
                   account_type,
                   account_number,
                   account_number_display,
                   product_name,
                   nickname,
                   status,
                   description,
                   account_open_date,
                   account_close_date,
                   currency,
                   fi_attributes,
                   additional_properties)

    @classmethod
    def validate(cls, dictionary):
        """Validates dictionary against class required properties

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            boolean : if dictionary is valid contains required properties.

        """

        if isinstance(dictionary, cls):
            return True

        if not isinstance(dictionary, dict):
            return False

        return True

    def __repr__(self):
        base_repr = super().__repr__()
        return (f'{self.__class__.__name__}('
                f'{base_repr[base_repr.find("(") + 1:-1]}, '
                f'balance_as_of={(self.balance_as_of if hasattr(self, "balance_as_of") else None)!r}, '
                f'current_balance={(self.current_balance if hasattr(self, "current_balance") else None)!r}, '
                f'opening_day_balance={(self.opening_day_balance if hasattr(self, "opening_day_balance") else None)!r}, '
                f'available_balance={(self.available_balance if hasattr(self, "available_balance") else None)!r}, '
                f'annual_percentage_yield={(self.annual_percentage_yield if hasattr(self, "annual_percentage_yield") else None)!r}, '
                f'interest_ytd={(self.interest_ytd if hasattr(self, "interest_ytd") else None)!r}, '
                f'term={(self.term if hasattr(self, "term") else None)!r}, '
                f'maturity_date={(self.maturity_date if hasattr(self, "maturity_date") else None)!r}, '
                f'transactions={(self.transactions if hasattr(self, "transactions") else None)!r})')

    def __str__(self):
        base_str = super().__str__()
        return (f'{self.__class__.__name__}('
                f'{base_str[base_str.find("(") + 1:-1]}, '
                f'balance_as_of={(self.balance_as_of if hasattr(self, "balance_as_of") else None)!s}, '
                f'current_balance={(self.current_balance if hasattr(self, "current_balance") else None)!s}, '
                f'opening_day_balance={(self.opening_day_balance if hasattr(self, "opening_day_balance") else None)!s}, '
                f'available_balance={(self.available_balance if hasattr(self, "available_balance") else None)!s}, '
                f'annual_percentage_yield={(self.annual_percentage_yield if hasattr(self, "annual_percentage_yield") else None)!s}, '
                f'interest_ytd={(self.interest_ytd if hasattr(self, "interest_ytd") else None)!s}, '
                f'term={(self.term if hasattr(self, "term") else None)!s}, '
                f'maturity_date={(self.maturity_date if hasattr(self, "maturity_date") else None)!s}, '
                f'transactions={(self.transactions if hasattr(self, "transactions") else None)!s})')

class DigitalWalletAccountEntity(AccountEntity):

    """Implementation of the 'Digital Wallet account entity' model.

    Information for a digital wallet account
    NOTE: This class inherits from 'AccountEntity'.

    Attributes:
        balance_as_of (datetime): As-of date of balances
        current_balance (float): Balance of funds in account
        opening_day_balance (float): Day's opening fund balance
        available_balance (float): Balance of funds available for use
        annual_percentage_yield (float): Annual Percentage Yield
        interest_ytd (float): YTD Interest
        transactions (List[DigitalWalletTransactionEntity]): Transactions on
            the digital wallet
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "balance_as_of": 'balanceAsOf',
        "current_balance": 'currentBalance',
        "opening_day_balance": 'openingDayBalance',
        "available_balance": 'availableBalance',
        "annual_percentage_yield": 'annualPercentageYield',
        "interest_ytd": 'interestYtd',
        "transactions": 'transactions',
        "parent_account_id": 'parentAccountId',
        "line_of_business": 'lineOfBusiness',
        "routing_transit_number": 'routingTransitNumber',
        "balance_type": 'balanceType',
        "contact": 'contact',
        "interest_rate": 'interestRate',
        "interest_rate_type": 'interestRateType',
        "interest_rate_as_of": 'interestRateAsOf',
        "prior_interest_rate": 'priorInterestRate',
        "interest_rate_index": 'interestRateIndex',
        "early_penalty_flag": 'earlyPenaltyFlag',
        "transfer_in": 'transferIn',
        "transfer_out": 'transferOut',
        "bill_pay_status": 'billPayStatus',
        "micr_number": 'micrNumber',
        "last_activity_date": 'lastActivityDate',
        "reward_program_id": 'rewardProgramId',
        "transactions_included": 'transactionsIncluded',
        "domicile": 'domicile',
        "account_category": 'accountCategory',
        "account_id": 'accountId',
        "error": 'error',
        "account_type": 'accountType',
        "account_number": 'accountNumber',
        "account_number_display": 'accountNumberDisplay',
        "product_name": 'productName',
        "nickname": 'nickname',
        "status": 'status',
        "description": 'description',
        "account_open_date": 'accountOpenDate',
        "account_close_date": 'accountCloseDate',
        "currency": 'currency',
        "fi_attributes": 'fiAttributes'
    }

    _optionals = [
        'balance_as_of',
        'current_balance',
        'opening_day_balance',
        'available_balance',
        'annual_percentage_yield',
        'interest_ytd',
        'transactions',
    ]
    _optionals.extend(AccountEntity._optionals)

    def __init__(self,
                 balance_as_of=APIHelper.SKIP,
                 current_balance=APIHelper.SKIP,
                 opening_day_balance=APIHelper.SKIP,
                 available_balance=APIHelper.SKIP,
                 annual_percentage_yield=APIHelper.SKIP,
                 interest_ytd=APIHelper.SKIP,
                 transactions=APIHelper.SKIP,
                 parent_account_id=APIHelper.SKIP,
                 line_of_business=APIHelper.SKIP,
                 routing_transit_number=APIHelper.SKIP,
                 balance_type=APIHelper.SKIP,
                 contact=APIHelper.SKIP,
                 interest_rate=APIHelper.SKIP,
                 interest_rate_type=APIHelper.SKIP,
                 interest_rate_as_of=APIHelper.SKIP,
                 prior_interest_rate=APIHelper.SKIP,
                 interest_rate_index=APIHelper.SKIP,
                 early_penalty_flag=APIHelper.SKIP,
                 transfer_in=APIHelper.SKIP,
                 transfer_out=APIHelper.SKIP,
                 bill_pay_status=APIHelper.SKIP,
                 micr_number=APIHelper.SKIP,
                 last_activity_date=APIHelper.SKIP,
                 reward_program_id=APIHelper.SKIP,
                 transactions_included=APIHelper.SKIP,
                 domicile=APIHelper.SKIP,
                 account_category='Digital Wallet account entity',
                 account_id=APIHelper.SKIP,
                 error=APIHelper.SKIP,
                 account_type=APIHelper.SKIP,
                 account_number=APIHelper.SKIP,
                 account_number_display=APIHelper.SKIP,
                 product_name=APIHelper.SKIP,
                 nickname=APIHelper.SKIP,
                 status=APIHelper.SKIP,
                 description=APIHelper.SKIP,
                 account_open_date=APIHelper.SKIP,
                 account_close_date=APIHelper.SKIP,
                 currency=APIHelper.SKIP,
                 fi_attributes=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the DigitalWalletAccountEntity class"""

        # Initialize members of the class
        if balance_as_of is not APIHelper.SKIP:
            self.balance_as_of = APIHelper.apply_datetime_converter(balance_as_of, APIHelper.RFC3339DateTime) if balance_as_of else None 
        if current_balance is not APIHelper.SKIP:
            self.current_balance = current_balance 
        if opening_day_balance is not APIHelper.SKIP:
            self.opening_day_balance = opening_day_balance 
        if available_balance is not APIHelper.SKIP:
            self.available_balance = available_balance 
        if annual_percentage_yield is not APIHelper.SKIP:
            self.annual_percentage_yield = annual_percentage_yield 
        if interest_ytd is not APIHelper.SKIP:
            self.interest_ytd = interest_ytd 
        if transactions is not APIHelper.SKIP:
            self.transactions = transactions 

        # Call the constructor for the base class
        super(DigitalWalletAccountEntity, self).__init__(parent_account_id,
                                                         line_of_business,
                                                         routing_transit_number,
                                                         balance_type,
                                                         contact,
                                                         interest_rate,
                                                         interest_rate_type,
                                                         interest_rate_as_of,
                                                         prior_interest_rate,
                                                         interest_rate_index,
                                                         early_penalty_flag,
                                                         transfer_in,
                                                         transfer_out,
                                                         bill_pay_status,
                                                         micr_number,
                                                         last_activity_date,
                                                         reward_program_id,
                                                         transactions_included,
                                                         domicile,
                                                         account_category,
                                                         account_id,
                                                         error,
                                                         account_type,
                                                         account_number,
                                                         account_number_display,
                                                         product_name,
                                                         nickname,
                                                         status,
                                                         description,
                                                         account_open_date,
                                                         account_close_date,
                                                         currency,
                                                         fi_attributes,
                                                         additional_properties)

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        balance_as_of = APIHelper.RFC3339DateTime.from_value(dictionary.get("balanceAsOf")).datetime if dictionary.get("balanceAsOf") else APIHelper.SKIP
        current_balance = dictionary.get("currentBalance") if dictionary.get("currentBalance") else APIHelper.SKIP
        opening_day_balance = dictionary.get("openingDayBalance") if dictionary.get("openingDayBalance") else APIHelper.SKIP
        available_balance = dictionary.get("availableBalance") if dictionary.get("availableBalance") else APIHelper.SKIP
        annual_percentage_yield = dictionary.get("annualPercentageYield") if dictionary.get("annualPercentageYield") else APIHelper.SKIP
        interest_ytd = dictionary.get("interestYtd") if dictionary.get("interestYtd") else APIHelper.SKIP
        transactions = None
        if dictionary.get('transactions') is not None:
            transactions = [DigitalWalletTransactionEntity.from_dictionary(x) for x in dictionary.get('transactions')]
        else:
            transactions = APIHelper.SKIP
        parent_account_id = dictionary.get("parentAccountId") if dictionary.get("parentAccountId") else APIHelper.SKIP
        line_of_business = dictionary.get("lineOfBusiness") if dictionary.get("lineOfBusiness") else APIHelper.SKIP
        routing_transit_number = dictionary.get("routingTransitNumber") if dictionary.get("routingTransitNumber") else APIHelper.SKIP
        balance_type = dictionary.get("balanceType") if dictionary.get("balanceType") else APIHelper.SKIP
        contact = AccountContactEntity2.from_dictionary(dictionary.get('contact')) if 'contact' in dictionary.keys() else APIHelper.SKIP
        interest_rate = dictionary.get("interestRate") if dictionary.get("interestRate") else APIHelper.SKIP
        interest_rate_type = dictionary.get("interestRateType") if dictionary.get("interestRateType") else APIHelper.SKIP
        interest_rate_as_of = APIHelper.RFC3339DateTime.from_value(dictionary.get("interestRateAsOf")).datetime if dictionary.get("interestRateAsOf") else APIHelper.SKIP
        prior_interest_rate = dictionary.get("priorInterestRate") if dictionary.get("priorInterestRate") else APIHelper.SKIP
        interest_rate_index = dictionary.get("interestRateIndex") if dictionary.get("interestRateIndex") else APIHelper.SKIP
        early_penalty_flag = dictionary.get("earlyPenaltyFlag") if "earlyPenaltyFlag" in dictionary.keys() else APIHelper.SKIP
        transfer_in = dictionary.get("transferIn") if "transferIn" in dictionary.keys() else APIHelper.SKIP
        transfer_out = dictionary.get("transferOut") if "transferOut" in dictionary.keys() else APIHelper.SKIP
        bill_pay_status = dictionary.get("billPayStatus") if dictionary.get("billPayStatus") else APIHelper.SKIP
        micr_number = dictionary.get("micrNumber") if dictionary.get("micrNumber") else APIHelper.SKIP
        last_activity_date = dateutil.parser.parse(dictionary.get('lastActivityDate')).date() if dictionary.get('lastActivityDate') else APIHelper.SKIP
        reward_program_id = dictionary.get("rewardProgramId") if dictionary.get("rewardProgramId") else APIHelper.SKIP
        transactions_included = dictionary.get("transactionsIncluded") if "transactionsIncluded" in dictionary.keys() else APIHelper.SKIP
        domicile = DomicileEntity1.from_dictionary(dictionary.get('domicile')) if 'domicile' in dictionary.keys() else APIHelper.SKIP
        account_category = dictionary.get("accountCategory") if dictionary.get("accountCategory") else 'Digital Wallet account entity'
        account_id = dictionary.get("accountId") if dictionary.get("accountId") else APIHelper.SKIP
        error = Error1.from_dictionary(dictionary.get('error')) if 'error' in dictionary.keys() else APIHelper.SKIP
        account_type = dictionary.get("accountType") if dictionary.get("accountType") else APIHelper.SKIP
        account_number = dictionary.get("accountNumber") if dictionary.get("accountNumber") else APIHelper.SKIP
        account_number_display = dictionary.get("accountNumberDisplay") if dictionary.get("accountNumberDisplay") else APIHelper.SKIP
        product_name = dictionary.get("productName") if dictionary.get("productName") else APIHelper.SKIP
        nickname = dictionary.get("nickname") if dictionary.get("nickname") else APIHelper.SKIP
        status = dictionary.get("status") if dictionary.get("status") else APIHelper.SKIP
        description = dictionary.get("description") if dictionary.get("description") else APIHelper.SKIP
        account_open_date = dateutil.parser.parse(dictionary.get('accountOpenDate')).date() if dictionary.get('accountOpenDate') else APIHelper.SKIP
        account_close_date = dateutil.parser.parse(dictionary.get('accountCloseDate')).date() if dictionary.get('accountCloseDate') else APIHelper.SKIP
        currency = CurrencyEntity4.from_dictionary(dictionary.get('currency')) if 'currency' in dictionary.keys() else APIHelper.SKIP
        fi_attributes = None
        if dictionary.get('fiAttributes') is not None:
            fi_attributes = [FiAttributeEntity.from_dictionary(x) for x in dictionary.get('fiAttributes')]
        else:
            fi_attributes = APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(balance_as_of,
                   current_balance,
                   opening_day_balance,
                   available_balance,
                   annual_percentage_yield,
                   interest_ytd,
                   transactions,
                   parent_account_id,
                   line_of_business,
                   routing_transit_number,
                   balance_type,
                   contact,
                   interest_rate,
                   interest_rate_type,
                   interest_rate_as_of,
                   prior_interest_rate,
                   interest_rate_index,
                   early_penalty_flag,
                   transfer_in,
                   transfer_out,
                   bill_pay_status,
                   micr_number,
                   last_activity_date,
                   reward_program_id,
                   transactions_included,
                   domicile,
                   account_category,
                   account_id,
                   error,
                   account_type,
                   account_number,
                   account_number_display,
                   product_name,
                   nickname,
                   status,
                   description,
                   account_open_date,
                   account_close_date,
                   currency,
                   fi_attributes,
                   additional_properties)

    @classmethod
    def validate(cls, dictionary):
        """Validates dictionary against class required properties

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            boolean : if dictionary is valid contains required properties.

        """

        if isinstance(dictionary, cls):
            return True

        if not isinstance(dictionary, dict):
            return False

        return True

    def __repr__(self):
        base_repr = super().__repr__()
        return (f'{self.__class__.__name__}('
                f'{base_repr[base_repr.find("(") + 1:-1]}, '
                f'balance_as_of={(self.balance_as_of if hasattr(self, "balance_as_of") else None)!r}, '
                f'current_balance={(self.current_balance if hasattr(self, "current_balance") else None)!r}, '
                f'opening_day_balance={(self.opening_day_balance if hasattr(self, "opening_day_balance") else None)!r}, '
                f'available_balance={(self.available_balance if hasattr(self, "available_balance") else None)!r}, '
                f'annual_percentage_yield={(self.annual_percentage_yield if hasattr(self, "annual_percentage_yield") else None)!r}, '
                f'interest_ytd={(self.interest_ytd if hasattr(self, "interest_ytd") else None)!r}, '
                f'transactions={(self.transactions if hasattr(self, "transactions") else None)!r})')

    def __str__(self):
        base_str = super().__str__()
        return (f'{self.__class__.__name__}('
                f'{base_str[base_str.find("(") + 1:-1]}, '
                f'balance_as_of={(self.balance_as_of if hasattr(self, "balance_as_of") else None)!s}, '
                f'current_balance={(self.current_balance if hasattr(self, "current_balance") else None)!s}, '
                f'opening_day_balance={(self.opening_day_balance if hasattr(self, "opening_day_balance") else None)!s}, '
                f'available_balance={(self.available_balance if hasattr(self, "available_balance") else None)!s}, '
                f'annual_percentage_yield={(self.annual_percentage_yield if hasattr(self, "annual_percentage_yield") else None)!s}, '
                f'interest_ytd={(self.interest_ytd if hasattr(self, "interest_ytd") else None)!s}, '
                f'transactions={(self.transactions if hasattr(self, "transactions") else None)!s})')

class InsuranceAccountEntity(AccountEntity):

    """Implementation of the 'Insurance Account entity' model.

    An insurance account type and properties such as category, premium, and
    payment term information
    NOTE: This class inherits from 'AccountEntity'.

    Attributes:
        policy_premium (float): The amount of the user's premium
        policy_premium_term (PolicyPremiumTermType2): The payment term for the
            premium
        policy_start_date (date): The premium start date
        policy_status (PolicyStatus2): The status of an insurance policy
            account
        policy_end_date (date): The premium end date
        policy_coverage_amount (float): Total amount of money the user is
            insured for
        transactions (List[InsuranceTransactionEntity]): Transactions on the
            insurance account
        bills (List[BillsEntity]): Payments due on the insurance account
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "policy_premium": 'policyPremium',
        "policy_premium_term": 'policyPremiumTerm',
        "policy_start_date": 'policyStartDate',
        "policy_status": 'policyStatus',
        "policy_end_date": 'policyEndDate',
        "policy_coverage_amount": 'policyCoverageAmount',
        "transactions": 'transactions',
        "bills": 'bills',
        "parent_account_id": 'parentAccountId',
        "line_of_business": 'lineOfBusiness',
        "routing_transit_number": 'routingTransitNumber',
        "balance_type": 'balanceType',
        "contact": 'contact',
        "interest_rate": 'interestRate',
        "interest_rate_type": 'interestRateType',
        "interest_rate_as_of": 'interestRateAsOf',
        "prior_interest_rate": 'priorInterestRate',
        "interest_rate_index": 'interestRateIndex',
        "early_penalty_flag": 'earlyPenaltyFlag',
        "transfer_in": 'transferIn',
        "transfer_out": 'transferOut',
        "bill_pay_status": 'billPayStatus',
        "micr_number": 'micrNumber',
        "last_activity_date": 'lastActivityDate',
        "reward_program_id": 'rewardProgramId',
        "transactions_included": 'transactionsIncluded',
        "domicile": 'domicile',
        "account_category": 'accountCategory',
        "account_id": 'accountId',
        "error": 'error',
        "account_type": 'accountType',
        "account_number": 'accountNumber',
        "account_number_display": 'accountNumberDisplay',
        "product_name": 'productName',
        "nickname": 'nickname',
        "status": 'status',
        "description": 'description',
        "account_open_date": 'accountOpenDate',
        "account_close_date": 'accountCloseDate',
        "currency": 'currency',
        "fi_attributes": 'fiAttributes'
    }

    _optionals = [
        'policy_premium',
        'policy_premium_term',
        'policy_start_date',
        'policy_status',
        'policy_end_date',
        'policy_coverage_amount',
        'transactions',
        'bills',
    ]
    _optionals.extend(AccountEntity._optionals)

    def __init__(self,
                 policy_premium=APIHelper.SKIP,
                 policy_premium_term=APIHelper.SKIP,
                 policy_start_date=APIHelper.SKIP,
                 policy_status=APIHelper.SKIP,
                 policy_end_date=APIHelper.SKIP,
                 policy_coverage_amount=APIHelper.SKIP,
                 transactions=APIHelper.SKIP,
                 bills=APIHelper.SKIP,
                 parent_account_id=APIHelper.SKIP,
                 line_of_business=APIHelper.SKIP,
                 routing_transit_number=APIHelper.SKIP,
                 balance_type=APIHelper.SKIP,
                 contact=APIHelper.SKIP,
                 interest_rate=APIHelper.SKIP,
                 interest_rate_type=APIHelper.SKIP,
                 interest_rate_as_of=APIHelper.SKIP,
                 prior_interest_rate=APIHelper.SKIP,
                 interest_rate_index=APIHelper.SKIP,
                 early_penalty_flag=APIHelper.SKIP,
                 transfer_in=APIHelper.SKIP,
                 transfer_out=APIHelper.SKIP,
                 bill_pay_status=APIHelper.SKIP,
                 micr_number=APIHelper.SKIP,
                 last_activity_date=APIHelper.SKIP,
                 reward_program_id=APIHelper.SKIP,
                 transactions_included=APIHelper.SKIP,
                 domicile=APIHelper.SKIP,
                 account_category='Insurance Account entity',
                 account_id=APIHelper.SKIP,
                 error=APIHelper.SKIP,
                 account_type=APIHelper.SKIP,
                 account_number=APIHelper.SKIP,
                 account_number_display=APIHelper.SKIP,
                 product_name=APIHelper.SKIP,
                 nickname=APIHelper.SKIP,
                 status=APIHelper.SKIP,
                 description=APIHelper.SKIP,
                 account_open_date=APIHelper.SKIP,
                 account_close_date=APIHelper.SKIP,
                 currency=APIHelper.SKIP,
                 fi_attributes=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the InsuranceAccountEntity class"""

        # Initialize members of the class
        if policy_premium is not APIHelper.SKIP:
            self.policy_premium = policy_premium 
        if policy_premium_term is not APIHelper.SKIP:
            self.policy_premium_term = policy_premium_term 
        if policy_start_date is not APIHelper.SKIP:
            self.policy_start_date = policy_start_date 
        if policy_status is not APIHelper.SKIP:
            self.policy_status = policy_status 
        if policy_end_date is not APIHelper.SKIP:
            self.policy_end_date = policy_end_date 
        if policy_coverage_amount is not APIHelper.SKIP:
            self.policy_coverage_amount = policy_coverage_amount 
        if transactions is not APIHelper.SKIP:
            self.transactions = transactions 
        if bills is not APIHelper.SKIP:
            self.bills = bills 

        # Call the constructor for the base class
        super(InsuranceAccountEntity, self).__init__(parent_account_id,
                                                     line_of_business,
                                                     routing_transit_number,
                                                     balance_type,
                                                     contact,
                                                     interest_rate,
                                                     interest_rate_type,
                                                     interest_rate_as_of,
                                                     prior_interest_rate,
                                                     interest_rate_index,
                                                     early_penalty_flag,
                                                     transfer_in,
                                                     transfer_out,
                                                     bill_pay_status,
                                                     micr_number,
                                                     last_activity_date,
                                                     reward_program_id,
                                                     transactions_included,
                                                     domicile,
                                                     account_category,
                                                     account_id,
                                                     error,
                                                     account_type,
                                                     account_number,
                                                     account_number_display,
                                                     product_name,
                                                     nickname,
                                                     status,
                                                     description,
                                                     account_open_date,
                                                     account_close_date,
                                                     currency,
                                                     fi_attributes,
                                                     additional_properties)

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        policy_premium = dictionary.get("policyPremium") if dictionary.get("policyPremium") else APIHelper.SKIP
        policy_premium_term = dictionary.get("policyPremiumTerm") if dictionary.get("policyPremiumTerm") else APIHelper.SKIP
        policy_start_date = dateutil.parser.parse(dictionary.get('policyStartDate')).date() if dictionary.get('policyStartDate') else APIHelper.SKIP
        policy_status = dictionary.get("policyStatus") if dictionary.get("policyStatus") else APIHelper.SKIP
        policy_end_date = dateutil.parser.parse(dictionary.get('policyEndDate')).date() if dictionary.get('policyEndDate') else APIHelper.SKIP
        policy_coverage_amount = dictionary.get("policyCoverageAmount") if dictionary.get("policyCoverageAmount") else APIHelper.SKIP
        transactions = None
        if dictionary.get('transactions') is not None:
            transactions = [InsuranceTransactionEntity.from_dictionary(x) for x in dictionary.get('transactions')]
        else:
            transactions = APIHelper.SKIP
        bills = None
        if dictionary.get('bills') is not None:
            bills = [BillsEntity.from_dictionary(x) for x in dictionary.get('bills')]
        else:
            bills = APIHelper.SKIP
        parent_account_id = dictionary.get("parentAccountId") if dictionary.get("parentAccountId") else APIHelper.SKIP
        line_of_business = dictionary.get("lineOfBusiness") if dictionary.get("lineOfBusiness") else APIHelper.SKIP
        routing_transit_number = dictionary.get("routingTransitNumber") if dictionary.get("routingTransitNumber") else APIHelper.SKIP
        balance_type = dictionary.get("balanceType") if dictionary.get("balanceType") else APIHelper.SKIP
        contact = AccountContactEntity2.from_dictionary(dictionary.get('contact')) if 'contact' in dictionary.keys() else APIHelper.SKIP
        interest_rate = dictionary.get("interestRate") if dictionary.get("interestRate") else APIHelper.SKIP
        interest_rate_type = dictionary.get("interestRateType") if dictionary.get("interestRateType") else APIHelper.SKIP
        interest_rate_as_of = APIHelper.RFC3339DateTime.from_value(dictionary.get("interestRateAsOf")).datetime if dictionary.get("interestRateAsOf") else APIHelper.SKIP
        prior_interest_rate = dictionary.get("priorInterestRate") if dictionary.get("priorInterestRate") else APIHelper.SKIP
        interest_rate_index = dictionary.get("interestRateIndex") if dictionary.get("interestRateIndex") else APIHelper.SKIP
        early_penalty_flag = dictionary.get("earlyPenaltyFlag") if "earlyPenaltyFlag" in dictionary.keys() else APIHelper.SKIP
        transfer_in = dictionary.get("transferIn") if "transferIn" in dictionary.keys() else APIHelper.SKIP
        transfer_out = dictionary.get("transferOut") if "transferOut" in dictionary.keys() else APIHelper.SKIP
        bill_pay_status = dictionary.get("billPayStatus") if dictionary.get("billPayStatus") else APIHelper.SKIP
        micr_number = dictionary.get("micrNumber") if dictionary.get("micrNumber") else APIHelper.SKIP
        last_activity_date = dateutil.parser.parse(dictionary.get('lastActivityDate')).date() if dictionary.get('lastActivityDate') else APIHelper.SKIP
        reward_program_id = dictionary.get("rewardProgramId") if dictionary.get("rewardProgramId") else APIHelper.SKIP
        transactions_included = dictionary.get("transactionsIncluded") if "transactionsIncluded" in dictionary.keys() else APIHelper.SKIP
        domicile = DomicileEntity1.from_dictionary(dictionary.get('domicile')) if 'domicile' in dictionary.keys() else APIHelper.SKIP
        account_category = dictionary.get("accountCategory") if dictionary.get("accountCategory") else 'Insurance Account entity'
        account_id = dictionary.get("accountId") if dictionary.get("accountId") else APIHelper.SKIP
        error = Error1.from_dictionary(dictionary.get('error')) if 'error' in dictionary.keys() else APIHelper.SKIP
        account_type = dictionary.get("accountType") if dictionary.get("accountType") else APIHelper.SKIP
        account_number = dictionary.get("accountNumber") if dictionary.get("accountNumber") else APIHelper.SKIP
        account_number_display = dictionary.get("accountNumberDisplay") if dictionary.get("accountNumberDisplay") else APIHelper.SKIP
        product_name = dictionary.get("productName") if dictionary.get("productName") else APIHelper.SKIP
        nickname = dictionary.get("nickname") if dictionary.get("nickname") else APIHelper.SKIP
        status = dictionary.get("status") if dictionary.get("status") else APIHelper.SKIP
        description = dictionary.get("description") if dictionary.get("description") else APIHelper.SKIP
        account_open_date = dateutil.parser.parse(dictionary.get('accountOpenDate')).date() if dictionary.get('accountOpenDate') else APIHelper.SKIP
        account_close_date = dateutil.parser.parse(dictionary.get('accountCloseDate')).date() if dictionary.get('accountCloseDate') else APIHelper.SKIP
        currency = CurrencyEntity4.from_dictionary(dictionary.get('currency')) if 'currency' in dictionary.keys() else APIHelper.SKIP
        fi_attributes = None
        if dictionary.get('fiAttributes') is not None:
            fi_attributes = [FiAttributeEntity.from_dictionary(x) for x in dictionary.get('fiAttributes')]
        else:
            fi_attributes = APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(policy_premium,
                   policy_premium_term,
                   policy_start_date,
                   policy_status,
                   policy_end_date,
                   policy_coverage_amount,
                   transactions,
                   bills,
                   parent_account_id,
                   line_of_business,
                   routing_transit_number,
                   balance_type,
                   contact,
                   interest_rate,
                   interest_rate_type,
                   interest_rate_as_of,
                   prior_interest_rate,
                   interest_rate_index,
                   early_penalty_flag,
                   transfer_in,
                   transfer_out,
                   bill_pay_status,
                   micr_number,
                   last_activity_date,
                   reward_program_id,
                   transactions_included,
                   domicile,
                   account_category,
                   account_id,
                   error,
                   account_type,
                   account_number,
                   account_number_display,
                   product_name,
                   nickname,
                   status,
                   description,
                   account_open_date,
                   account_close_date,
                   currency,
                   fi_attributes,
                   additional_properties)

    @classmethod
    def validate(cls, dictionary):
        """Validates dictionary against class required properties

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            boolean : if dictionary is valid contains required properties.

        """

        if isinstance(dictionary, cls):
            return True

        if not isinstance(dictionary, dict):
            return False

        return True

    def __repr__(self):
        base_repr = super().__repr__()
        return (f'{self.__class__.__name__}('
                f'{base_repr[base_repr.find("(") + 1:-1]}, '
                f'policy_premium={(self.policy_premium if hasattr(self, "policy_premium") else None)!r}, '
                f'policy_premium_term={(self.policy_premium_term if hasattr(self, "policy_premium_term") else None)!r}, '
                f'policy_start_date={(self.policy_start_date if hasattr(self, "policy_start_date") else None)!r}, '
                f'policy_status={(self.policy_status if hasattr(self, "policy_status") else None)!r}, '
                f'policy_end_date={(self.policy_end_date if hasattr(self, "policy_end_date") else None)!r}, '
                f'policy_coverage_amount={(self.policy_coverage_amount if hasattr(self, "policy_coverage_amount") else None)!r}, '
                f'transactions={(self.transactions if hasattr(self, "transactions") else None)!r}, '
                f'bills={(self.bills if hasattr(self, "bills") else None)!r})')

    def __str__(self):
        base_str = super().__str__()
        return (f'{self.__class__.__name__}('
                f'{base_str[base_str.find("(") + 1:-1]}, '
                f'policy_premium={(self.policy_premium if hasattr(self, "policy_premium") else None)!s}, '
                f'policy_premium_term={(self.policy_premium_term if hasattr(self, "policy_premium_term") else None)!s}, '
                f'policy_start_date={(self.policy_start_date if hasattr(self, "policy_start_date") else None)!s}, '
                f'policy_status={(self.policy_status if hasattr(self, "policy_status") else None)!s}, '
                f'policy_end_date={(self.policy_end_date if hasattr(self, "policy_end_date") else None)!s}, '
                f'policy_coverage_amount={(self.policy_coverage_amount if hasattr(self, "policy_coverage_amount") else None)!s}, '
                f'transactions={(self.transactions if hasattr(self, "transactions") else None)!s}, '
                f'bills={(self.bills if hasattr(self, "bills") else None)!s})')

class InvestmentAccountEntity(AccountEntity):

    """Implementation of the 'Investment Account entity' model.

    An investment account type and information such as balances, transactions,
    holdings and privileges
    NOTE: This class inherits from 'AccountEntity'.

    Attributes:
        balance_as_of (datetime): As-of date for balances
        allowed_check_writing (bool): Check writing privileges
        allowed_option_trade (bool): Allowed to trade options
        current_value (float): Total current value of all investments
        holdings (List[HoldingEntity]): Holdings in the investment account
        open_orders (List[OpenOrderEntity]): Open orders in the investment
            account
        contribution (List[ContributionEntity]): Describes how new
            contributions are distributed among the available securities
        vesting (List[VestingEntity]): Provides the past, present, and future
            vesting schedule and percentages
        investment_loans (List[InvestmentLoanEntity]): Investment loans in the
            account
        available_cash_balance (float): Cash balance across all sub-accounts.
            Should include sweep funds
        margin (bool): Margin trading is allowed
        margin_balance (float): Margin balance
        short_balance (float): Short balance
        rollover_amount (float): Rollover amount
        employer_name (str): Name of the employer in investment 401k Plan
        broker_id (str): Unique identifier FI
        plan_id (str): Plan number for Investment 401k plan
        calendar_year_for_401_k (int): The calendar year for this 401k account
        balance_list (List[InvestmentBalanceEntity]): List of balances.
            Aggregate of name value pairs
        daily_change (float): Daily change
        percentage_change (float): Percentage change
        transactions (List[InvestmentTransactionEntity]): Transactions on the
            investment account
        pension_source (List[PensionSourceEntity]): Pension sources in the
            investment account
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "balance_as_of": 'balanceAsOf',
        "allowed_check_writing": 'allowedCheckWriting',
        "allowed_option_trade": 'allowedOptionTrade',
        "current_value": 'currentValue',
        "holdings": 'holdings',
        "open_orders": 'openOrders',
        "contribution": 'contribution',
        "vesting": 'vesting',
        "investment_loans": 'investmentLoans',
        "available_cash_balance": 'availableCashBalance',
        "margin": 'margin',
        "margin_balance": 'marginBalance',
        "short_balance": 'shortBalance',
        "rollover_amount": 'rolloverAmount',
        "employer_name": 'employerName',
        "broker_id": 'brokerId',
        "plan_id": 'planId',
        "calendar_year_for_401_k": 'calendarYearFor401K',
        "balance_list": 'balanceList',
        "daily_change": 'dailyChange',
        "percentage_change": 'percentageChange',
        "transactions": 'transactions',
        "pension_source": 'pensionSource',
        "parent_account_id": 'parentAccountId',
        "line_of_business": 'lineOfBusiness',
        "routing_transit_number": 'routingTransitNumber',
        "balance_type": 'balanceType',
        "contact": 'contact',
        "interest_rate": 'interestRate',
        "interest_rate_type": 'interestRateType',
        "interest_rate_as_of": 'interestRateAsOf',
        "prior_interest_rate": 'priorInterestRate',
        "interest_rate_index": 'interestRateIndex',
        "early_penalty_flag": 'earlyPenaltyFlag',
        "transfer_in": 'transferIn',
        "transfer_out": 'transferOut',
        "bill_pay_status": 'billPayStatus',
        "micr_number": 'micrNumber',
        "last_activity_date": 'lastActivityDate',
        "reward_program_id": 'rewardProgramId',
        "transactions_included": 'transactionsIncluded',
        "domicile": 'domicile',
        "account_category": 'accountCategory',
        "account_id": 'accountId',
        "error": 'error',
        "account_type": 'accountType',
        "account_number": 'accountNumber',
        "account_number_display": 'accountNumberDisplay',
        "product_name": 'productName',
        "nickname": 'nickname',
        "status": 'status',
        "description": 'description',
        "account_open_date": 'accountOpenDate',
        "account_close_date": 'accountCloseDate',
        "currency": 'currency',
        "fi_attributes": 'fiAttributes'
    }

    _optionals = [
        'balance_as_of',
        'allowed_check_writing',
        'allowed_option_trade',
        'current_value',
        'holdings',
        'open_orders',
        'contribution',
        'vesting',
        'investment_loans',
        'available_cash_balance',
        'margin',
        'margin_balance',
        'short_balance',
        'rollover_amount',
        'employer_name',
        'broker_id',
        'plan_id',
        'calendar_year_for_401_k',
        'balance_list',
        'daily_change',
        'percentage_change',
        'transactions',
        'pension_source',
    ]
    _optionals.extend(AccountEntity._optionals)

    def __init__(self,
                 balance_as_of=APIHelper.SKIP,
                 allowed_check_writing=APIHelper.SKIP,
                 allowed_option_trade=APIHelper.SKIP,
                 current_value=APIHelper.SKIP,
                 holdings=APIHelper.SKIP,
                 open_orders=APIHelper.SKIP,
                 contribution=APIHelper.SKIP,
                 vesting=APIHelper.SKIP,
                 investment_loans=APIHelper.SKIP,
                 available_cash_balance=APIHelper.SKIP,
                 margin=APIHelper.SKIP,
                 margin_balance=APIHelper.SKIP,
                 short_balance=APIHelper.SKIP,
                 rollover_amount=APIHelper.SKIP,
                 employer_name=APIHelper.SKIP,
                 broker_id=APIHelper.SKIP,
                 plan_id=APIHelper.SKIP,
                 calendar_year_for_401_k=APIHelper.SKIP,
                 balance_list=APIHelper.SKIP,
                 daily_change=APIHelper.SKIP,
                 percentage_change=APIHelper.SKIP,
                 transactions=APIHelper.SKIP,
                 pension_source=APIHelper.SKIP,
                 parent_account_id=APIHelper.SKIP,
                 line_of_business=APIHelper.SKIP,
                 routing_transit_number=APIHelper.SKIP,
                 balance_type=APIHelper.SKIP,
                 contact=APIHelper.SKIP,
                 interest_rate=APIHelper.SKIP,
                 interest_rate_type=APIHelper.SKIP,
                 interest_rate_as_of=APIHelper.SKIP,
                 prior_interest_rate=APIHelper.SKIP,
                 interest_rate_index=APIHelper.SKIP,
                 early_penalty_flag=APIHelper.SKIP,
                 transfer_in=APIHelper.SKIP,
                 transfer_out=APIHelper.SKIP,
                 bill_pay_status=APIHelper.SKIP,
                 micr_number=APIHelper.SKIP,
                 last_activity_date=APIHelper.SKIP,
                 reward_program_id=APIHelper.SKIP,
                 transactions_included=APIHelper.SKIP,
                 domicile=APIHelper.SKIP,
                 account_category='Investment Account entity',
                 account_id=APIHelper.SKIP,
                 error=APIHelper.SKIP,
                 account_type=APIHelper.SKIP,
                 account_number=APIHelper.SKIP,
                 account_number_display=APIHelper.SKIP,
                 product_name=APIHelper.SKIP,
                 nickname=APIHelper.SKIP,
                 status=APIHelper.SKIP,
                 description=APIHelper.SKIP,
                 account_open_date=APIHelper.SKIP,
                 account_close_date=APIHelper.SKIP,
                 currency=APIHelper.SKIP,
                 fi_attributes=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the InvestmentAccountEntity class"""

        # Initialize members of the class
        if balance_as_of is not APIHelper.SKIP:
            self.balance_as_of = APIHelper.apply_datetime_converter(balance_as_of, APIHelper.RFC3339DateTime) if balance_as_of else None 
        if allowed_check_writing is not APIHelper.SKIP:
            self.allowed_check_writing = allowed_check_writing 
        if allowed_option_trade is not APIHelper.SKIP:
            self.allowed_option_trade = allowed_option_trade 
        if current_value is not APIHelper.SKIP:
            self.current_value = current_value 
        if holdings is not APIHelper.SKIP:
            self.holdings = holdings 
        if open_orders is not APIHelper.SKIP:
            self.open_orders = open_orders 
        if contribution is not APIHelper.SKIP:
            self.contribution = contribution 
        if vesting is not APIHelper.SKIP:
            self.vesting = vesting 
        if investment_loans is not APIHelper.SKIP:
            self.investment_loans = investment_loans 
        if available_cash_balance is not APIHelper.SKIP:
            self.available_cash_balance = available_cash_balance 
        if margin is not APIHelper.SKIP:
            self.margin = margin 
        if margin_balance is not APIHelper.SKIP:
            self.margin_balance = margin_balance 
        if short_balance is not APIHelper.SKIP:
            self.short_balance = short_balance 
        if rollover_amount is not APIHelper.SKIP:
            self.rollover_amount = rollover_amount 
        if employer_name is not APIHelper.SKIP:
            self.employer_name = employer_name 
        if broker_id is not APIHelper.SKIP:
            self.broker_id = broker_id 
        if plan_id is not APIHelper.SKIP:
            self.plan_id = plan_id 
        if calendar_year_for_401_k is not APIHelper.SKIP:
            self.calendar_year_for_401_k = calendar_year_for_401_k 
        if balance_list is not APIHelper.SKIP:
            self.balance_list = balance_list 
        if daily_change is not APIHelper.SKIP:
            self.daily_change = daily_change 
        if percentage_change is not APIHelper.SKIP:
            self.percentage_change = percentage_change 
        if transactions is not APIHelper.SKIP:
            self.transactions = transactions 
        if pension_source is not APIHelper.SKIP:
            self.pension_source = pension_source 

        # Call the constructor for the base class
        super(InvestmentAccountEntity, self).__init__(parent_account_id,
                                                      line_of_business,
                                                      routing_transit_number,
                                                      balance_type,
                                                      contact,
                                                      interest_rate,
                                                      interest_rate_type,
                                                      interest_rate_as_of,
                                                      prior_interest_rate,
                                                      interest_rate_index,
                                                      early_penalty_flag,
                                                      transfer_in,
                                                      transfer_out,
                                                      bill_pay_status,
                                                      micr_number,
                                                      last_activity_date,
                                                      reward_program_id,
                                                      transactions_included,
                                                      domicile,
                                                      account_category,
                                                      account_id,
                                                      error,
                                                      account_type,
                                                      account_number,
                                                      account_number_display,
                                                      product_name,
                                                      nickname,
                                                      status,
                                                      description,
                                                      account_open_date,
                                                      account_close_date,
                                                      currency,
                                                      fi_attributes,
                                                      additional_properties)

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        balance_as_of = APIHelper.RFC3339DateTime.from_value(dictionary.get("balanceAsOf")).datetime if dictionary.get("balanceAsOf") else APIHelper.SKIP
        allowed_check_writing = dictionary.get("allowedCheckWriting") if "allowedCheckWriting" in dictionary.keys() else APIHelper.SKIP
        allowed_option_trade = dictionary.get("allowedOptionTrade") if "allowedOptionTrade" in dictionary.keys() else APIHelper.SKIP
        current_value = dictionary.get("currentValue") if dictionary.get("currentValue") else APIHelper.SKIP
        holdings = None
        if dictionary.get('holdings') is not None:
            holdings = [HoldingEntity.from_dictionary(x) for x in dictionary.get('holdings')]
        else:
            holdings = APIHelper.SKIP
        open_orders = None
        if dictionary.get('openOrders') is not None:
            open_orders = [OpenOrderEntity.from_dictionary(x) for x in dictionary.get('openOrders')]
        else:
            open_orders = APIHelper.SKIP
        contribution = None
        if dictionary.get('contribution') is not None:
            contribution = [ContributionEntity.from_dictionary(x) for x in dictionary.get('contribution')]
        else:
            contribution = APIHelper.SKIP
        vesting = None
        if dictionary.get('vesting') is not None:
            vesting = [VestingEntity.from_dictionary(x) for x in dictionary.get('vesting')]
        else:
            vesting = APIHelper.SKIP
        investment_loans = None
        if dictionary.get('investmentLoans') is not None:
            investment_loans = [InvestmentLoanEntity.from_dictionary(x) for x in dictionary.get('investmentLoans')]
        else:
            investment_loans = APIHelper.SKIP
        available_cash_balance = dictionary.get("availableCashBalance") if dictionary.get("availableCashBalance") else APIHelper.SKIP
        margin = dictionary.get("margin") if "margin" in dictionary.keys() else APIHelper.SKIP
        margin_balance = dictionary.get("marginBalance") if dictionary.get("marginBalance") else APIHelper.SKIP
        short_balance = dictionary.get("shortBalance") if dictionary.get("shortBalance") else APIHelper.SKIP
        rollover_amount = dictionary.get("rolloverAmount") if dictionary.get("rolloverAmount") else APIHelper.SKIP
        employer_name = dictionary.get("employerName") if dictionary.get("employerName") else APIHelper.SKIP
        broker_id = dictionary.get("brokerId") if dictionary.get("brokerId") else APIHelper.SKIP
        plan_id = dictionary.get("planId") if dictionary.get("planId") else APIHelper.SKIP
        calendar_year_for_401_k = dictionary.get("calendarYearFor401K") if dictionary.get("calendarYearFor401K") else APIHelper.SKIP
        balance_list = None
        if dictionary.get('balanceList') is not None:
            balance_list = [InvestmentBalanceEntity.from_dictionary(x) for x in dictionary.get('balanceList')]
        else:
            balance_list = APIHelper.SKIP
        daily_change = dictionary.get("dailyChange") if dictionary.get("dailyChange") else APIHelper.SKIP
        percentage_change = dictionary.get("percentageChange") if dictionary.get("percentageChange") else APIHelper.SKIP
        transactions = None
        if dictionary.get('transactions') is not None:
            transactions = [InvestmentTransactionEntity.from_dictionary(x) for x in dictionary.get('transactions')]
        else:
            transactions = APIHelper.SKIP
        pension_source = None
        if dictionary.get('pensionSource') is not None:
            pension_source = [PensionSourceEntity.from_dictionary(x) for x in dictionary.get('pensionSource')]
        else:
            pension_source = APIHelper.SKIP
        parent_account_id = dictionary.get("parentAccountId") if dictionary.get("parentAccountId") else APIHelper.SKIP
        line_of_business = dictionary.get("lineOfBusiness") if dictionary.get("lineOfBusiness") else APIHelper.SKIP
        routing_transit_number = dictionary.get("routingTransitNumber") if dictionary.get("routingTransitNumber") else APIHelper.SKIP
        balance_type = dictionary.get("balanceType") if dictionary.get("balanceType") else APIHelper.SKIP
        contact = AccountContactEntity2.from_dictionary(dictionary.get('contact')) if 'contact' in dictionary.keys() else APIHelper.SKIP
        interest_rate = dictionary.get("interestRate") if dictionary.get("interestRate") else APIHelper.SKIP
        interest_rate_type = dictionary.get("interestRateType") if dictionary.get("interestRateType") else APIHelper.SKIP
        interest_rate_as_of = APIHelper.RFC3339DateTime.from_value(dictionary.get("interestRateAsOf")).datetime if dictionary.get("interestRateAsOf") else APIHelper.SKIP
        prior_interest_rate = dictionary.get("priorInterestRate") if dictionary.get("priorInterestRate") else APIHelper.SKIP
        interest_rate_index = dictionary.get("interestRateIndex") if dictionary.get("interestRateIndex") else APIHelper.SKIP
        early_penalty_flag = dictionary.get("earlyPenaltyFlag") if "earlyPenaltyFlag" in dictionary.keys() else APIHelper.SKIP
        transfer_in = dictionary.get("transferIn") if "transferIn" in dictionary.keys() else APIHelper.SKIP
        transfer_out = dictionary.get("transferOut") if "transferOut" in dictionary.keys() else APIHelper.SKIP
        bill_pay_status = dictionary.get("billPayStatus") if dictionary.get("billPayStatus") else APIHelper.SKIP
        micr_number = dictionary.get("micrNumber") if dictionary.get("micrNumber") else APIHelper.SKIP
        last_activity_date = dateutil.parser.parse(dictionary.get('lastActivityDate')).date() if dictionary.get('lastActivityDate') else APIHelper.SKIP
        reward_program_id = dictionary.get("rewardProgramId") if dictionary.get("rewardProgramId") else APIHelper.SKIP
        transactions_included = dictionary.get("transactionsIncluded") if "transactionsIncluded" in dictionary.keys() else APIHelper.SKIP
        domicile = DomicileEntity1.from_dictionary(dictionary.get('domicile')) if 'domicile' in dictionary.keys() else APIHelper.SKIP
        account_category = dictionary.get("accountCategory") if dictionary.get("accountCategory") else 'Investment Account entity'
        account_id = dictionary.get("accountId") if dictionary.get("accountId") else APIHelper.SKIP
        error = Error1.from_dictionary(dictionary.get('error')) if 'error' in dictionary.keys() else APIHelper.SKIP
        account_type = dictionary.get("accountType") if dictionary.get("accountType") else APIHelper.SKIP
        account_number = dictionary.get("accountNumber") if dictionary.get("accountNumber") else APIHelper.SKIP
        account_number_display = dictionary.get("accountNumberDisplay") if dictionary.get("accountNumberDisplay") else APIHelper.SKIP
        product_name = dictionary.get("productName") if dictionary.get("productName") else APIHelper.SKIP
        nickname = dictionary.get("nickname") if dictionary.get("nickname") else APIHelper.SKIP
        status = dictionary.get("status") if dictionary.get("status") else APIHelper.SKIP
        description = dictionary.get("description") if dictionary.get("description") else APIHelper.SKIP
        account_open_date = dateutil.parser.parse(dictionary.get('accountOpenDate')).date() if dictionary.get('accountOpenDate') else APIHelper.SKIP
        account_close_date = dateutil.parser.parse(dictionary.get('accountCloseDate')).date() if dictionary.get('accountCloseDate') else APIHelper.SKIP
        currency = CurrencyEntity4.from_dictionary(dictionary.get('currency')) if 'currency' in dictionary.keys() else APIHelper.SKIP
        fi_attributes = None
        if dictionary.get('fiAttributes') is not None:
            fi_attributes = [FiAttributeEntity.from_dictionary(x) for x in dictionary.get('fiAttributes')]
        else:
            fi_attributes = APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(balance_as_of,
                   allowed_check_writing,
                   allowed_option_trade,
                   current_value,
                   holdings,
                   open_orders,
                   contribution,
                   vesting,
                   investment_loans,
                   available_cash_balance,
                   margin,
                   margin_balance,
                   short_balance,
                   rollover_amount,
                   employer_name,
                   broker_id,
                   plan_id,
                   calendar_year_for_401_k,
                   balance_list,
                   daily_change,
                   percentage_change,
                   transactions,
                   pension_source,
                   parent_account_id,
                   line_of_business,
                   routing_transit_number,
                   balance_type,
                   contact,
                   interest_rate,
                   interest_rate_type,
                   interest_rate_as_of,
                   prior_interest_rate,
                   interest_rate_index,
                   early_penalty_flag,
                   transfer_in,
                   transfer_out,
                   bill_pay_status,
                   micr_number,
                   last_activity_date,
                   reward_program_id,
                   transactions_included,
                   domicile,
                   account_category,
                   account_id,
                   error,
                   account_type,
                   account_number,
                   account_number_display,
                   product_name,
                   nickname,
                   status,
                   description,
                   account_open_date,
                   account_close_date,
                   currency,
                   fi_attributes,
                   additional_properties)

    @classmethod
    def validate(cls, dictionary):
        """Validates dictionary against class required properties

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            boolean : if dictionary is valid contains required properties.

        """

        if isinstance(dictionary, cls):
            return True

        if not isinstance(dictionary, dict):
            return False

        return True

    def __repr__(self):
        base_repr = super().__repr__()
        return (f'{self.__class__.__name__}('
                f'{base_repr[base_repr.find("(") + 1:-1]}, '
                f'balance_as_of={(self.balance_as_of if hasattr(self, "balance_as_of") else None)!r}, '
                f'allowed_check_writing={(self.allowed_check_writing if hasattr(self, "allowed_check_writing") else None)!r}, '
                f'allowed_option_trade={(self.allowed_option_trade if hasattr(self, "allowed_option_trade") else None)!r}, '
                f'current_value={(self.current_value if hasattr(self, "current_value") else None)!r}, '
                f'holdings={(self.holdings if hasattr(self, "holdings") else None)!r}, '
                f'open_orders={(self.open_orders if hasattr(self, "open_orders") else None)!r}, '
                f'contribution={(self.contribution if hasattr(self, "contribution") else None)!r}, '
                f'vesting={(self.vesting if hasattr(self, "vesting") else None)!r}, '
                f'investment_loans={(self.investment_loans if hasattr(self, "investment_loans") else None)!r}, '
                f'available_cash_balance={(self.available_cash_balance if hasattr(self, "available_cash_balance") else None)!r}, '
                f'margin={(self.margin if hasattr(self, "margin") else None)!r}, '
                f'margin_balance={(self.margin_balance if hasattr(self, "margin_balance") else None)!r}, '
                f'short_balance={(self.short_balance if hasattr(self, "short_balance") else None)!r}, '
                f'rollover_amount={(self.rollover_amount if hasattr(self, "rollover_amount") else None)!r}, '
                f'employer_name={(self.employer_name if hasattr(self, "employer_name") else None)!r}, '
                f'broker_id={(self.broker_id if hasattr(self, "broker_id") else None)!r}, '
                f'plan_id={(self.plan_id if hasattr(self, "plan_id") else None)!r}, '
                f'calendar_year_for_401_k={(self.calendar_year_for_401_k if hasattr(self, "calendar_year_for_401_k") else None)!r}, '
                f'balance_list={(self.balance_list if hasattr(self, "balance_list") else None)!r}, '
                f'daily_change={(self.daily_change if hasattr(self, "daily_change") else None)!r}, '
                f'percentage_change={(self.percentage_change if hasattr(self, "percentage_change") else None)!r}, '
                f'transactions={(self.transactions if hasattr(self, "transactions") else None)!r}, '
                f'pension_source={(self.pension_source if hasattr(self, "pension_source") else None)!r})')

    def __str__(self):
        base_str = super().__str__()
        return (f'{self.__class__.__name__}('
                f'{base_str[base_str.find("(") + 1:-1]}, '
                f'balance_as_of={(self.balance_as_of if hasattr(self, "balance_as_of") else None)!s}, '
                f'allowed_check_writing={(self.allowed_check_writing if hasattr(self, "allowed_check_writing") else None)!s}, '
                f'allowed_option_trade={(self.allowed_option_trade if hasattr(self, "allowed_option_trade") else None)!s}, '
                f'current_value={(self.current_value if hasattr(self, "current_value") else None)!s}, '
                f'holdings={(self.holdings if hasattr(self, "holdings") else None)!s}, '
                f'open_orders={(self.open_orders if hasattr(self, "open_orders") else None)!s}, '
                f'contribution={(self.contribution if hasattr(self, "contribution") else None)!s}, '
                f'vesting={(self.vesting if hasattr(self, "vesting") else None)!s}, '
                f'investment_loans={(self.investment_loans if hasattr(self, "investment_loans") else None)!s}, '
                f'available_cash_balance={(self.available_cash_balance if hasattr(self, "available_cash_balance") else None)!s}, '
                f'margin={(self.margin if hasattr(self, "margin") else None)!s}, '
                f'margin_balance={(self.margin_balance if hasattr(self, "margin_balance") else None)!s}, '
                f'short_balance={(self.short_balance if hasattr(self, "short_balance") else None)!s}, '
                f'rollover_amount={(self.rollover_amount if hasattr(self, "rollover_amount") else None)!s}, '
                f'employer_name={(self.employer_name if hasattr(self, "employer_name") else None)!s}, '
                f'broker_id={(self.broker_id if hasattr(self, "broker_id") else None)!s}, '
                f'plan_id={(self.plan_id if hasattr(self, "plan_id") else None)!s}, '
                f'calendar_year_for_401_k={(self.calendar_year_for_401_k if hasattr(self, "calendar_year_for_401_k") else None)!s}, '
                f'balance_list={(self.balance_list if hasattr(self, "balance_list") else None)!s}, '
                f'daily_change={(self.daily_change if hasattr(self, "daily_change") else None)!s}, '
                f'percentage_change={(self.percentage_change if hasattr(self, "percentage_change") else None)!s}, '
                f'transactions={(self.transactions if hasattr(self, "transactions") else None)!s}, '
                f'pension_source={(self.pension_source if hasattr(self, "pension_source") else None)!s})')

class LineOfCreditAccountEntity(AccountEntity):

    """Implementation of the 'Line of Credit Account entity' model.

    A line of credit account
    NOTE: This class inherits from 'AccountEntity'.

    Attributes:
        balance_as_of (datetime): As-of date for balances
        credit_line (float): Credit limit
        available_credit (float): Available credit
        next_payment_amount (float): Amount of next payment
        next_payment_date (date): Due date of next payment
        principal_balance (float): Principal balance
        current_balance (float): Current balance of the line of credit
        minimum_payment_amount (float): Minimum payment amount, which is due
            at the date specified in `nextPaymentDate`
        last_payment_amount (float): Last payment amount
        last_payment_date (date): Last payment date
        past_due_amount (float): Past Due Amount
        last_stmt_balance (float): Last Statement Balance
        last_stmt_date (date): Last Statement Date
        purchases_apr (float): Purchases APR
        advances_apr (float): Advances APR
        cash_advance_limit (float): Cash advance limit
        available_cash (float): Available cash
        finance_charges (float): Finance charges
        card_network (str): Card network, e.g. "VISA", "MASTERCARD",
            "AMERICAN_EXPRESS", "DISCOVER", "INTERLINK", "STAR" etc.
        card_art (CardArtEntity2): Any Art associated to the Card related to
            the account
        transactions (List[LineOfCreditTransactionEntity]): Transactions on
            the line-of-credit account
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "balance_as_of": 'balanceAsOf',
        "credit_line": 'creditLine',
        "available_credit": 'availableCredit',
        "next_payment_amount": 'nextPaymentAmount',
        "next_payment_date": 'nextPaymentDate',
        "principal_balance": 'principalBalance',
        "current_balance": 'currentBalance',
        "minimum_payment_amount": 'minimumPaymentAmount',
        "last_payment_amount": 'lastPaymentAmount',
        "last_payment_date": 'lastPaymentDate',
        "past_due_amount": 'pastDueAmount',
        "last_stmt_balance": 'lastStmtBalance',
        "last_stmt_date": 'lastStmtDate',
        "purchases_apr": 'purchasesApr',
        "advances_apr": 'advancesApr',
        "cash_advance_limit": 'cashAdvanceLimit',
        "available_cash": 'availableCash',
        "finance_charges": 'financeCharges',
        "card_network": 'cardNetwork',
        "card_art": 'cardArt',
        "transactions": 'transactions',
        "parent_account_id": 'parentAccountId',
        "line_of_business": 'lineOfBusiness',
        "routing_transit_number": 'routingTransitNumber',
        "balance_type": 'balanceType',
        "contact": 'contact',
        "interest_rate": 'interestRate',
        "interest_rate_type": 'interestRateType',
        "interest_rate_as_of": 'interestRateAsOf',
        "prior_interest_rate": 'priorInterestRate',
        "interest_rate_index": 'interestRateIndex',
        "early_penalty_flag": 'earlyPenaltyFlag',
        "transfer_in": 'transferIn',
        "transfer_out": 'transferOut',
        "bill_pay_status": 'billPayStatus',
        "micr_number": 'micrNumber',
        "last_activity_date": 'lastActivityDate',
        "reward_program_id": 'rewardProgramId',
        "transactions_included": 'transactionsIncluded',
        "domicile": 'domicile',
        "account_category": 'accountCategory',
        "account_id": 'accountId',
        "error": 'error',
        "account_type": 'accountType',
        "account_number": 'accountNumber',
        "account_number_display": 'accountNumberDisplay',
        "product_name": 'productName',
        "nickname": 'nickname',
        "status": 'status',
        "description": 'description',
        "account_open_date": 'accountOpenDate',
        "account_close_date": 'accountCloseDate',
        "currency": 'currency',
        "fi_attributes": 'fiAttributes'
    }

    _optionals = [
        'balance_as_of',
        'credit_line',
        'available_credit',
        'next_payment_amount',
        'next_payment_date',
        'principal_balance',
        'current_balance',
        'minimum_payment_amount',
        'last_payment_amount',
        'last_payment_date',
        'past_due_amount',
        'last_stmt_balance',
        'last_stmt_date',
        'purchases_apr',
        'advances_apr',
        'cash_advance_limit',
        'available_cash',
        'finance_charges',
        'card_network',
        'card_art',
        'transactions',
    ]
    _optionals.extend(AccountEntity._optionals)

    def __init__(self,
                 balance_as_of=APIHelper.SKIP,
                 credit_line=APIHelper.SKIP,
                 available_credit=APIHelper.SKIP,
                 next_payment_amount=APIHelper.SKIP,
                 next_payment_date=APIHelper.SKIP,
                 principal_balance=APIHelper.SKIP,
                 current_balance=APIHelper.SKIP,
                 minimum_payment_amount=APIHelper.SKIP,
                 last_payment_amount=APIHelper.SKIP,
                 last_payment_date=APIHelper.SKIP,
                 past_due_amount=APIHelper.SKIP,
                 last_stmt_balance=APIHelper.SKIP,
                 last_stmt_date=APIHelper.SKIP,
                 purchases_apr=APIHelper.SKIP,
                 advances_apr=APIHelper.SKIP,
                 cash_advance_limit=APIHelper.SKIP,
                 available_cash=APIHelper.SKIP,
                 finance_charges=APIHelper.SKIP,
                 card_network=APIHelper.SKIP,
                 card_art=APIHelper.SKIP,
                 transactions=APIHelper.SKIP,
                 parent_account_id=APIHelper.SKIP,
                 line_of_business=APIHelper.SKIP,
                 routing_transit_number=APIHelper.SKIP,
                 balance_type=APIHelper.SKIP,
                 contact=APIHelper.SKIP,
                 interest_rate=APIHelper.SKIP,
                 interest_rate_type=APIHelper.SKIP,
                 interest_rate_as_of=APIHelper.SKIP,
                 prior_interest_rate=APIHelper.SKIP,
                 interest_rate_index=APIHelper.SKIP,
                 early_penalty_flag=APIHelper.SKIP,
                 transfer_in=APIHelper.SKIP,
                 transfer_out=APIHelper.SKIP,
                 bill_pay_status=APIHelper.SKIP,
                 micr_number=APIHelper.SKIP,
                 last_activity_date=APIHelper.SKIP,
                 reward_program_id=APIHelper.SKIP,
                 transactions_included=APIHelper.SKIP,
                 domicile=APIHelper.SKIP,
                 account_category='Line of Credit Account entity',
                 account_id=APIHelper.SKIP,
                 error=APIHelper.SKIP,
                 account_type=APIHelper.SKIP,
                 account_number=APIHelper.SKIP,
                 account_number_display=APIHelper.SKIP,
                 product_name=APIHelper.SKIP,
                 nickname=APIHelper.SKIP,
                 status=APIHelper.SKIP,
                 description=APIHelper.SKIP,
                 account_open_date=APIHelper.SKIP,
                 account_close_date=APIHelper.SKIP,
                 currency=APIHelper.SKIP,
                 fi_attributes=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the LineOfCreditAccountEntity class"""

        # Initialize members of the class
        if balance_as_of is not APIHelper.SKIP:
            self.balance_as_of = APIHelper.apply_datetime_converter(balance_as_of, APIHelper.RFC3339DateTime) if balance_as_of else None 
        if credit_line is not APIHelper.SKIP:
            self.credit_line = credit_line 
        if available_credit is not APIHelper.SKIP:
            self.available_credit = available_credit 
        if next_payment_amount is not APIHelper.SKIP:
            self.next_payment_amount = next_payment_amount 
        if next_payment_date is not APIHelper.SKIP:
            self.next_payment_date = next_payment_date 
        if principal_balance is not APIHelper.SKIP:
            self.principal_balance = principal_balance 
        if current_balance is not APIHelper.SKIP:
            self.current_balance = current_balance 
        if minimum_payment_amount is not APIHelper.SKIP:
            self.minimum_payment_amount = minimum_payment_amount 
        if last_payment_amount is not APIHelper.SKIP:
            self.last_payment_amount = last_payment_amount 
        if last_payment_date is not APIHelper.SKIP:
            self.last_payment_date = last_payment_date 
        if past_due_amount is not APIHelper.SKIP:
            self.past_due_amount = past_due_amount 
        if last_stmt_balance is not APIHelper.SKIP:
            self.last_stmt_balance = last_stmt_balance 
        if last_stmt_date is not APIHelper.SKIP:
            self.last_stmt_date = last_stmt_date 
        if purchases_apr is not APIHelper.SKIP:
            self.purchases_apr = purchases_apr 
        if advances_apr is not APIHelper.SKIP:
            self.advances_apr = advances_apr 
        if cash_advance_limit is not APIHelper.SKIP:
            self.cash_advance_limit = cash_advance_limit 
        if available_cash is not APIHelper.SKIP:
            self.available_cash = available_cash 
        if finance_charges is not APIHelper.SKIP:
            self.finance_charges = finance_charges 
        if card_network is not APIHelper.SKIP:
            self.card_network = card_network 
        if card_art is not APIHelper.SKIP:
            self.card_art = card_art 
        if transactions is not APIHelper.SKIP:
            self.transactions = transactions 

        # Call the constructor for the base class
        super(LineOfCreditAccountEntity, self).__init__(parent_account_id,
                                                        line_of_business,
                                                        routing_transit_number,
                                                        balance_type,
                                                        contact,
                                                        interest_rate,
                                                        interest_rate_type,
                                                        interest_rate_as_of,
                                                        prior_interest_rate,
                                                        interest_rate_index,
                                                        early_penalty_flag,
                                                        transfer_in,
                                                        transfer_out,
                                                        bill_pay_status,
                                                        micr_number,
                                                        last_activity_date,
                                                        reward_program_id,
                                                        transactions_included,
                                                        domicile,
                                                        account_category,
                                                        account_id,
                                                        error,
                                                        account_type,
                                                        account_number,
                                                        account_number_display,
                                                        product_name,
                                                        nickname,
                                                        status,
                                                        description,
                                                        account_open_date,
                                                        account_close_date,
                                                        currency,
                                                        fi_attributes,
                                                        additional_properties)

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        balance_as_of = APIHelper.RFC3339DateTime.from_value(dictionary.get("balanceAsOf")).datetime if dictionary.get("balanceAsOf") else APIHelper.SKIP
        credit_line = dictionary.get("creditLine") if dictionary.get("creditLine") else APIHelper.SKIP
        available_credit = dictionary.get("availableCredit") if dictionary.get("availableCredit") else APIHelper.SKIP
        next_payment_amount = dictionary.get("nextPaymentAmount") if dictionary.get("nextPaymentAmount") else APIHelper.SKIP
        next_payment_date = dateutil.parser.parse(dictionary.get('nextPaymentDate')).date() if dictionary.get('nextPaymentDate') else APIHelper.SKIP
        principal_balance = dictionary.get("principalBalance") if dictionary.get("principalBalance") else APIHelper.SKIP
        current_balance = dictionary.get("currentBalance") if dictionary.get("currentBalance") else APIHelper.SKIP
        minimum_payment_amount = dictionary.get("minimumPaymentAmount") if dictionary.get("minimumPaymentAmount") else APIHelper.SKIP
        last_payment_amount = dictionary.get("lastPaymentAmount") if dictionary.get("lastPaymentAmount") else APIHelper.SKIP
        last_payment_date = dateutil.parser.parse(dictionary.get('lastPaymentDate')).date() if dictionary.get('lastPaymentDate') else APIHelper.SKIP
        past_due_amount = dictionary.get("pastDueAmount") if dictionary.get("pastDueAmount") else APIHelper.SKIP
        last_stmt_balance = dictionary.get("lastStmtBalance") if dictionary.get("lastStmtBalance") else APIHelper.SKIP
        last_stmt_date = dateutil.parser.parse(dictionary.get('lastStmtDate')).date() if dictionary.get('lastStmtDate') else APIHelper.SKIP
        purchases_apr = dictionary.get("purchasesApr") if dictionary.get("purchasesApr") else APIHelper.SKIP
        advances_apr = dictionary.get("advancesApr") if dictionary.get("advancesApr") else APIHelper.SKIP
        cash_advance_limit = dictionary.get("cashAdvanceLimit") if dictionary.get("cashAdvanceLimit") else APIHelper.SKIP
        available_cash = dictionary.get("availableCash") if dictionary.get("availableCash") else APIHelper.SKIP
        finance_charges = dictionary.get("financeCharges") if dictionary.get("financeCharges") else APIHelper.SKIP
        card_network = dictionary.get("cardNetwork") if dictionary.get("cardNetwork") else APIHelper.SKIP
        card_art = CardArtEntity2.from_dictionary(dictionary.get('cardArt')) if 'cardArt' in dictionary.keys() else APIHelper.SKIP
        transactions = None
        if dictionary.get('transactions') is not None:
            transactions = [LineOfCreditTransactionEntity.from_dictionary(x) for x in dictionary.get('transactions')]
        else:
            transactions = APIHelper.SKIP
        parent_account_id = dictionary.get("parentAccountId") if dictionary.get("parentAccountId") else APIHelper.SKIP
        line_of_business = dictionary.get("lineOfBusiness") if dictionary.get("lineOfBusiness") else APIHelper.SKIP
        routing_transit_number = dictionary.get("routingTransitNumber") if dictionary.get("routingTransitNumber") else APIHelper.SKIP
        balance_type = dictionary.get("balanceType") if dictionary.get("balanceType") else APIHelper.SKIP
        contact = AccountContactEntity2.from_dictionary(dictionary.get('contact')) if 'contact' in dictionary.keys() else APIHelper.SKIP
        interest_rate = dictionary.get("interestRate") if dictionary.get("interestRate") else APIHelper.SKIP
        interest_rate_type = dictionary.get("interestRateType") if dictionary.get("interestRateType") else APIHelper.SKIP
        interest_rate_as_of = APIHelper.RFC3339DateTime.from_value(dictionary.get("interestRateAsOf")).datetime if dictionary.get("interestRateAsOf") else APIHelper.SKIP
        prior_interest_rate = dictionary.get("priorInterestRate") if dictionary.get("priorInterestRate") else APIHelper.SKIP
        interest_rate_index = dictionary.get("interestRateIndex") if dictionary.get("interestRateIndex") else APIHelper.SKIP
        early_penalty_flag = dictionary.get("earlyPenaltyFlag") if "earlyPenaltyFlag" in dictionary.keys() else APIHelper.SKIP
        transfer_in = dictionary.get("transferIn") if "transferIn" in dictionary.keys() else APIHelper.SKIP
        transfer_out = dictionary.get("transferOut") if "transferOut" in dictionary.keys() else APIHelper.SKIP
        bill_pay_status = dictionary.get("billPayStatus") if dictionary.get("billPayStatus") else APIHelper.SKIP
        micr_number = dictionary.get("micrNumber") if dictionary.get("micrNumber") else APIHelper.SKIP
        last_activity_date = dateutil.parser.parse(dictionary.get('lastActivityDate')).date() if dictionary.get('lastActivityDate') else APIHelper.SKIP
        reward_program_id = dictionary.get("rewardProgramId") if dictionary.get("rewardProgramId") else APIHelper.SKIP
        transactions_included = dictionary.get("transactionsIncluded") if "transactionsIncluded" in dictionary.keys() else APIHelper.SKIP
        domicile = DomicileEntity1.from_dictionary(dictionary.get('domicile')) if 'domicile' in dictionary.keys() else APIHelper.SKIP
        account_category = dictionary.get("accountCategory") if dictionary.get("accountCategory") else 'Line of Credit Account entity'
        account_id = dictionary.get("accountId") if dictionary.get("accountId") else APIHelper.SKIP
        error = Error1.from_dictionary(dictionary.get('error')) if 'error' in dictionary.keys() else APIHelper.SKIP
        account_type = dictionary.get("accountType") if dictionary.get("accountType") else APIHelper.SKIP
        account_number = dictionary.get("accountNumber") if dictionary.get("accountNumber") else APIHelper.SKIP
        account_number_display = dictionary.get("accountNumberDisplay") if dictionary.get("accountNumberDisplay") else APIHelper.SKIP
        product_name = dictionary.get("productName") if dictionary.get("productName") else APIHelper.SKIP
        nickname = dictionary.get("nickname") if dictionary.get("nickname") else APIHelper.SKIP
        status = dictionary.get("status") if dictionary.get("status") else APIHelper.SKIP
        description = dictionary.get("description") if dictionary.get("description") else APIHelper.SKIP
        account_open_date = dateutil.parser.parse(dictionary.get('accountOpenDate')).date() if dictionary.get('accountOpenDate') else APIHelper.SKIP
        account_close_date = dateutil.parser.parse(dictionary.get('accountCloseDate')).date() if dictionary.get('accountCloseDate') else APIHelper.SKIP
        currency = CurrencyEntity4.from_dictionary(dictionary.get('currency')) if 'currency' in dictionary.keys() else APIHelper.SKIP
        fi_attributes = None
        if dictionary.get('fiAttributes') is not None:
            fi_attributes = [FiAttributeEntity.from_dictionary(x) for x in dictionary.get('fiAttributes')]
        else:
            fi_attributes = APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(balance_as_of,
                   credit_line,
                   available_credit,
                   next_payment_amount,
                   next_payment_date,
                   principal_balance,
                   current_balance,
                   minimum_payment_amount,
                   last_payment_amount,
                   last_payment_date,
                   past_due_amount,
                   last_stmt_balance,
                   last_stmt_date,
                   purchases_apr,
                   advances_apr,
                   cash_advance_limit,
                   available_cash,
                   finance_charges,
                   card_network,
                   card_art,
                   transactions,
                   parent_account_id,
                   line_of_business,
                   routing_transit_number,
                   balance_type,
                   contact,
                   interest_rate,
                   interest_rate_type,
                   interest_rate_as_of,
                   prior_interest_rate,
                   interest_rate_index,
                   early_penalty_flag,
                   transfer_in,
                   transfer_out,
                   bill_pay_status,
                   micr_number,
                   last_activity_date,
                   reward_program_id,
                   transactions_included,
                   domicile,
                   account_category,
                   account_id,
                   error,
                   account_type,
                   account_number,
                   account_number_display,
                   product_name,
                   nickname,
                   status,
                   description,
                   account_open_date,
                   account_close_date,
                   currency,
                   fi_attributes,
                   additional_properties)

    @classmethod
    def validate(cls, dictionary):
        """Validates dictionary against class required properties

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            boolean : if dictionary is valid contains required properties.

        """

        if isinstance(dictionary, cls):
            return True

        if not isinstance(dictionary, dict):
            return False

        return True

    def __repr__(self):
        base_repr = super().__repr__()
        return (f'{self.__class__.__name__}('
                f'{base_repr[base_repr.find("(") + 1:-1]}, '
                f'balance_as_of={(self.balance_as_of if hasattr(self, "balance_as_of") else None)!r}, '
                f'credit_line={(self.credit_line if hasattr(self, "credit_line") else None)!r}, '
                f'available_credit={(self.available_credit if hasattr(self, "available_credit") else None)!r}, '
                f'next_payment_amount={(self.next_payment_amount if hasattr(self, "next_payment_amount") else None)!r}, '
                f'next_payment_date={(self.next_payment_date if hasattr(self, "next_payment_date") else None)!r}, '
                f'principal_balance={(self.principal_balance if hasattr(self, "principal_balance") else None)!r}, '
                f'current_balance={(self.current_balance if hasattr(self, "current_balance") else None)!r}, '
                f'minimum_payment_amount={(self.minimum_payment_amount if hasattr(self, "minimum_payment_amount") else None)!r}, '
                f'last_payment_amount={(self.last_payment_amount if hasattr(self, "last_payment_amount") else None)!r}, '
                f'last_payment_date={(self.last_payment_date if hasattr(self, "last_payment_date") else None)!r}, '
                f'past_due_amount={(self.past_due_amount if hasattr(self, "past_due_amount") else None)!r}, '
                f'last_stmt_balance={(self.last_stmt_balance if hasattr(self, "last_stmt_balance") else None)!r}, '
                f'last_stmt_date={(self.last_stmt_date if hasattr(self, "last_stmt_date") else None)!r}, '
                f'purchases_apr={(self.purchases_apr if hasattr(self, "purchases_apr") else None)!r}, '
                f'advances_apr={(self.advances_apr if hasattr(self, "advances_apr") else None)!r}, '
                f'cash_advance_limit={(self.cash_advance_limit if hasattr(self, "cash_advance_limit") else None)!r}, '
                f'available_cash={(self.available_cash if hasattr(self, "available_cash") else None)!r}, '
                f'finance_charges={(self.finance_charges if hasattr(self, "finance_charges") else None)!r}, '
                f'card_network={(self.card_network if hasattr(self, "card_network") else None)!r}, '
                f'card_art={(self.card_art if hasattr(self, "card_art") else None)!r}, '
                f'transactions={(self.transactions if hasattr(self, "transactions") else None)!r})')

    def __str__(self):
        base_str = super().__str__()
        return (f'{self.__class__.__name__}('
                f'{base_str[base_str.find("(") + 1:-1]}, '
                f'balance_as_of={(self.balance_as_of if hasattr(self, "balance_as_of") else None)!s}, '
                f'credit_line={(self.credit_line if hasattr(self, "credit_line") else None)!s}, '
                f'available_credit={(self.available_credit if hasattr(self, "available_credit") else None)!s}, '
                f'next_payment_amount={(self.next_payment_amount if hasattr(self, "next_payment_amount") else None)!s}, '
                f'next_payment_date={(self.next_payment_date if hasattr(self, "next_payment_date") else None)!s}, '
                f'principal_balance={(self.principal_balance if hasattr(self, "principal_balance") else None)!s}, '
                f'current_balance={(self.current_balance if hasattr(self, "current_balance") else None)!s}, '
                f'minimum_payment_amount={(self.minimum_payment_amount if hasattr(self, "minimum_payment_amount") else None)!s}, '
                f'last_payment_amount={(self.last_payment_amount if hasattr(self, "last_payment_amount") else None)!s}, '
                f'last_payment_date={(self.last_payment_date if hasattr(self, "last_payment_date") else None)!s}, '
                f'past_due_amount={(self.past_due_amount if hasattr(self, "past_due_amount") else None)!s}, '
                f'last_stmt_balance={(self.last_stmt_balance if hasattr(self, "last_stmt_balance") else None)!s}, '
                f'last_stmt_date={(self.last_stmt_date if hasattr(self, "last_stmt_date") else None)!s}, '
                f'purchases_apr={(self.purchases_apr if hasattr(self, "purchases_apr") else None)!s}, '
                f'advances_apr={(self.advances_apr if hasattr(self, "advances_apr") else None)!s}, '
                f'cash_advance_limit={(self.cash_advance_limit if hasattr(self, "cash_advance_limit") else None)!s}, '
                f'available_cash={(self.available_cash if hasattr(self, "available_cash") else None)!s}, '
                f'finance_charges={(self.finance_charges if hasattr(self, "finance_charges") else None)!s}, '
                f'card_network={(self.card_network if hasattr(self, "card_network") else None)!s}, '
                f'card_art={(self.card_art if hasattr(self, "card_art") else None)!s}, '
                f'transactions={(self.transactions if hasattr(self, "transactions") else None)!s})')

class LoanAccountEntity(AccountEntity):

    """Implementation of the 'Loan Account entity' model.

    A loan account type
    NOTE: This class inherits from 'AccountEntity'.

    Attributes:
        balance_as_of (datetime): As-of date for balances
        principal_balance (float): Principal balance of loan
        escrow_balance (float): Escrow balance of loan
        original_principal (float): Original principal of loan
        originating_date (date): Loan origination date
        loan_term (int): Term of loan in months
        total_number_of_payments (int): Total number of payments
        next_payment_amount (float): Amount of next payment
        next_payment_date (date): Date of next payment
        payment_frequency (PaymentFrequency1): DAILY, WEEKLY, BIWEEKLY,
            SEMIMONTHLY, MONTHLY, SEMIANNUALLY, ANNUALLY
        compounding_period (CompoundingPeriod2): DAILY, WEEKLY, BIWEEKLY,
            SEMIMONTHLY, MONTHLY, SEMIANNUALLY, ANNUALLY
        pay_off_amount (float): Payoff amount
        last_payment_amount (float): Last payment amount
        last_payment_date (date): Last payment date
        maturity_date (date): Maturity date
        interest_paid_year_to_date (float): Interest paid year to date
        transactions (List[LoanTransactionEntity]): Transactions on the loan
            account
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "balance_as_of": 'balanceAsOf',
        "principal_balance": 'principalBalance',
        "escrow_balance": 'escrowBalance',
        "original_principal": 'originalPrincipal',
        "originating_date": 'originatingDate',
        "loan_term": 'loanTerm',
        "total_number_of_payments": 'totalNumberOfPayments',
        "next_payment_amount": 'nextPaymentAmount',
        "next_payment_date": 'nextPaymentDate',
        "payment_frequency": 'paymentFrequency',
        "compounding_period": 'compoundingPeriod',
        "pay_off_amount": 'payOffAmount',
        "last_payment_amount": 'lastPaymentAmount',
        "last_payment_date": 'lastPaymentDate',
        "maturity_date": 'maturityDate',
        "interest_paid_year_to_date": 'interestPaidYearToDate',
        "transactions": 'transactions',
        "parent_account_id": 'parentAccountId',
        "line_of_business": 'lineOfBusiness',
        "routing_transit_number": 'routingTransitNumber',
        "balance_type": 'balanceType',
        "contact": 'contact',
        "interest_rate": 'interestRate',
        "interest_rate_type": 'interestRateType',
        "interest_rate_as_of": 'interestRateAsOf',
        "prior_interest_rate": 'priorInterestRate',
        "interest_rate_index": 'interestRateIndex',
        "early_penalty_flag": 'earlyPenaltyFlag',
        "transfer_in": 'transferIn',
        "transfer_out": 'transferOut',
        "bill_pay_status": 'billPayStatus',
        "micr_number": 'micrNumber',
        "last_activity_date": 'lastActivityDate',
        "reward_program_id": 'rewardProgramId',
        "transactions_included": 'transactionsIncluded',
        "domicile": 'domicile',
        "account_category": 'accountCategory',
        "account_id": 'accountId',
        "error": 'error',
        "account_type": 'accountType',
        "account_number": 'accountNumber',
        "account_number_display": 'accountNumberDisplay',
        "product_name": 'productName',
        "nickname": 'nickname',
        "status": 'status',
        "description": 'description',
        "account_open_date": 'accountOpenDate',
        "account_close_date": 'accountCloseDate',
        "currency": 'currency',
        "fi_attributes": 'fiAttributes'
    }

    _optionals = [
        'balance_as_of',
        'principal_balance',
        'escrow_balance',
        'original_principal',
        'originating_date',
        'loan_term',
        'total_number_of_payments',
        'next_payment_amount',
        'next_payment_date',
        'payment_frequency',
        'compounding_period',
        'pay_off_amount',
        'last_payment_amount',
        'last_payment_date',
        'maturity_date',
        'interest_paid_year_to_date',
        'transactions',
    ]
    _optionals.extend(AccountEntity._optionals)

    def __init__(self,
                 balance_as_of=APIHelper.SKIP,
                 principal_balance=APIHelper.SKIP,
                 escrow_balance=APIHelper.SKIP,
                 original_principal=APIHelper.SKIP,
                 originating_date=APIHelper.SKIP,
                 loan_term=APIHelper.SKIP,
                 total_number_of_payments=APIHelper.SKIP,
                 next_payment_amount=APIHelper.SKIP,
                 next_payment_date=APIHelper.SKIP,
                 payment_frequency=APIHelper.SKIP,
                 compounding_period=APIHelper.SKIP,
                 pay_off_amount=APIHelper.SKIP,
                 last_payment_amount=APIHelper.SKIP,
                 last_payment_date=APIHelper.SKIP,
                 maturity_date=APIHelper.SKIP,
                 interest_paid_year_to_date=APIHelper.SKIP,
                 transactions=APIHelper.SKIP,
                 parent_account_id=APIHelper.SKIP,
                 line_of_business=APIHelper.SKIP,
                 routing_transit_number=APIHelper.SKIP,
                 balance_type=APIHelper.SKIP,
                 contact=APIHelper.SKIP,
                 interest_rate=APIHelper.SKIP,
                 interest_rate_type=APIHelper.SKIP,
                 interest_rate_as_of=APIHelper.SKIP,
                 prior_interest_rate=APIHelper.SKIP,
                 interest_rate_index=APIHelper.SKIP,
                 early_penalty_flag=APIHelper.SKIP,
                 transfer_in=APIHelper.SKIP,
                 transfer_out=APIHelper.SKIP,
                 bill_pay_status=APIHelper.SKIP,
                 micr_number=APIHelper.SKIP,
                 last_activity_date=APIHelper.SKIP,
                 reward_program_id=APIHelper.SKIP,
                 transactions_included=APIHelper.SKIP,
                 domicile=APIHelper.SKIP,
                 account_category='Loan Account entity',
                 account_id=APIHelper.SKIP,
                 error=APIHelper.SKIP,
                 account_type=APIHelper.SKIP,
                 account_number=APIHelper.SKIP,
                 account_number_display=APIHelper.SKIP,
                 product_name=APIHelper.SKIP,
                 nickname=APIHelper.SKIP,
                 status=APIHelper.SKIP,
                 description=APIHelper.SKIP,
                 account_open_date=APIHelper.SKIP,
                 account_close_date=APIHelper.SKIP,
                 currency=APIHelper.SKIP,
                 fi_attributes=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the LoanAccountEntity class"""

        # Initialize members of the class
        if balance_as_of is not APIHelper.SKIP:
            self.balance_as_of = APIHelper.apply_datetime_converter(balance_as_of, APIHelper.RFC3339DateTime) if balance_as_of else None 
        if principal_balance is not APIHelper.SKIP:
            self.principal_balance = principal_balance 
        if escrow_balance is not APIHelper.SKIP:
            self.escrow_balance = escrow_balance 
        if original_principal is not APIHelper.SKIP:
            self.original_principal = original_principal 
        if originating_date is not APIHelper.SKIP:
            self.originating_date = originating_date 
        if loan_term is not APIHelper.SKIP:
            self.loan_term = loan_term 
        if total_number_of_payments is not APIHelper.SKIP:
            self.total_number_of_payments = total_number_of_payments 
        if next_payment_amount is not APIHelper.SKIP:
            self.next_payment_amount = next_payment_amount 
        if next_payment_date is not APIHelper.SKIP:
            self.next_payment_date = next_payment_date 
        if payment_frequency is not APIHelper.SKIP:
            self.payment_frequency = payment_frequency 
        if compounding_period is not APIHelper.SKIP:
            self.compounding_period = compounding_period 
        if pay_off_amount is not APIHelper.SKIP:
            self.pay_off_amount = pay_off_amount 
        if last_payment_amount is not APIHelper.SKIP:
            self.last_payment_amount = last_payment_amount 
        if last_payment_date is not APIHelper.SKIP:
            self.last_payment_date = last_payment_date 
        if maturity_date is not APIHelper.SKIP:
            self.maturity_date = maturity_date 
        if interest_paid_year_to_date is not APIHelper.SKIP:
            self.interest_paid_year_to_date = interest_paid_year_to_date 
        if transactions is not APIHelper.SKIP:
            self.transactions = transactions 

        # Call the constructor for the base class
        super(LoanAccountEntity, self).__init__(parent_account_id,
                                                line_of_business,
                                                routing_transit_number,
                                                balance_type,
                                                contact,
                                                interest_rate,
                                                interest_rate_type,
                                                interest_rate_as_of,
                                                prior_interest_rate,
                                                interest_rate_index,
                                                early_penalty_flag,
                                                transfer_in,
                                                transfer_out,
                                                bill_pay_status,
                                                micr_number,
                                                last_activity_date,
                                                reward_program_id,
                                                transactions_included,
                                                domicile,
                                                account_category,
                                                account_id,
                                                error,
                                                account_type,
                                                account_number,
                                                account_number_display,
                                                product_name,
                                                nickname,
                                                status,
                                                description,
                                                account_open_date,
                                                account_close_date,
                                                currency,
                                                fi_attributes,
                                                additional_properties)

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        balance_as_of = APIHelper.RFC3339DateTime.from_value(dictionary.get("balanceAsOf")).datetime if dictionary.get("balanceAsOf") else APIHelper.SKIP
        principal_balance = dictionary.get("principalBalance") if dictionary.get("principalBalance") else APIHelper.SKIP
        escrow_balance = dictionary.get("escrowBalance") if dictionary.get("escrowBalance") else APIHelper.SKIP
        original_principal = dictionary.get("originalPrincipal") if dictionary.get("originalPrincipal") else APIHelper.SKIP
        originating_date = dateutil.parser.parse(dictionary.get('originatingDate')).date() if dictionary.get('originatingDate') else APIHelper.SKIP
        loan_term = dictionary.get("loanTerm") if dictionary.get("loanTerm") else APIHelper.SKIP
        total_number_of_payments = dictionary.get("totalNumberOfPayments") if dictionary.get("totalNumberOfPayments") else APIHelper.SKIP
        next_payment_amount = dictionary.get("nextPaymentAmount") if dictionary.get("nextPaymentAmount") else APIHelper.SKIP
        next_payment_date = dateutil.parser.parse(dictionary.get('nextPaymentDate')).date() if dictionary.get('nextPaymentDate') else APIHelper.SKIP
        payment_frequency = dictionary.get("paymentFrequency") if dictionary.get("paymentFrequency") else APIHelper.SKIP
        compounding_period = dictionary.get("compoundingPeriod") if dictionary.get("compoundingPeriod") else APIHelper.SKIP
        pay_off_amount = dictionary.get("payOffAmount") if dictionary.get("payOffAmount") else APIHelper.SKIP
        last_payment_amount = dictionary.get("lastPaymentAmount") if dictionary.get("lastPaymentAmount") else APIHelper.SKIP
        last_payment_date = dateutil.parser.parse(dictionary.get('lastPaymentDate')).date() if dictionary.get('lastPaymentDate') else APIHelper.SKIP
        maturity_date = dateutil.parser.parse(dictionary.get('maturityDate')).date() if dictionary.get('maturityDate') else APIHelper.SKIP
        interest_paid_year_to_date = dictionary.get("interestPaidYearToDate") if dictionary.get("interestPaidYearToDate") else APIHelper.SKIP
        transactions = None
        if dictionary.get('transactions') is not None:
            transactions = [LoanTransactionEntity.from_dictionary(x) for x in dictionary.get('transactions')]
        else:
            transactions = APIHelper.SKIP
        parent_account_id = dictionary.get("parentAccountId") if dictionary.get("parentAccountId") else APIHelper.SKIP
        line_of_business = dictionary.get("lineOfBusiness") if dictionary.get("lineOfBusiness") else APIHelper.SKIP
        routing_transit_number = dictionary.get("routingTransitNumber") if dictionary.get("routingTransitNumber") else APIHelper.SKIP
        balance_type = dictionary.get("balanceType") if dictionary.get("balanceType") else APIHelper.SKIP
        contact = AccountContactEntity2.from_dictionary(dictionary.get('contact')) if 'contact' in dictionary.keys() else APIHelper.SKIP
        interest_rate = dictionary.get("interestRate") if dictionary.get("interestRate") else APIHelper.SKIP
        interest_rate_type = dictionary.get("interestRateType") if dictionary.get("interestRateType") else APIHelper.SKIP
        interest_rate_as_of = APIHelper.RFC3339DateTime.from_value(dictionary.get("interestRateAsOf")).datetime if dictionary.get("interestRateAsOf") else APIHelper.SKIP
        prior_interest_rate = dictionary.get("priorInterestRate") if dictionary.get("priorInterestRate") else APIHelper.SKIP
        interest_rate_index = dictionary.get("interestRateIndex") if dictionary.get("interestRateIndex") else APIHelper.SKIP
        early_penalty_flag = dictionary.get("earlyPenaltyFlag") if "earlyPenaltyFlag" in dictionary.keys() else APIHelper.SKIP
        transfer_in = dictionary.get("transferIn") if "transferIn" in dictionary.keys() else APIHelper.SKIP
        transfer_out = dictionary.get("transferOut") if "transferOut" in dictionary.keys() else APIHelper.SKIP
        bill_pay_status = dictionary.get("billPayStatus") if dictionary.get("billPayStatus") else APIHelper.SKIP
        micr_number = dictionary.get("micrNumber") if dictionary.get("micrNumber") else APIHelper.SKIP
        last_activity_date = dateutil.parser.parse(dictionary.get('lastActivityDate')).date() if dictionary.get('lastActivityDate') else APIHelper.SKIP
        reward_program_id = dictionary.get("rewardProgramId") if dictionary.get("rewardProgramId") else APIHelper.SKIP
        transactions_included = dictionary.get("transactionsIncluded") if "transactionsIncluded" in dictionary.keys() else APIHelper.SKIP
        domicile = DomicileEntity1.from_dictionary(dictionary.get('domicile')) if 'domicile' in dictionary.keys() else APIHelper.SKIP
        account_category = dictionary.get("accountCategory") if dictionary.get("accountCategory") else 'Loan Account entity'
        account_id = dictionary.get("accountId") if dictionary.get("accountId") else APIHelper.SKIP
        error = Error1.from_dictionary(dictionary.get('error')) if 'error' in dictionary.keys() else APIHelper.SKIP
        account_type = dictionary.get("accountType") if dictionary.get("accountType") else APIHelper.SKIP
        account_number = dictionary.get("accountNumber") if dictionary.get("accountNumber") else APIHelper.SKIP
        account_number_display = dictionary.get("accountNumberDisplay") if dictionary.get("accountNumberDisplay") else APIHelper.SKIP
        product_name = dictionary.get("productName") if dictionary.get("productName") else APIHelper.SKIP
        nickname = dictionary.get("nickname") if dictionary.get("nickname") else APIHelper.SKIP
        status = dictionary.get("status") if dictionary.get("status") else APIHelper.SKIP
        description = dictionary.get("description") if dictionary.get("description") else APIHelper.SKIP
        account_open_date = dateutil.parser.parse(dictionary.get('accountOpenDate')).date() if dictionary.get('accountOpenDate') else APIHelper.SKIP
        account_close_date = dateutil.parser.parse(dictionary.get('accountCloseDate')).date() if dictionary.get('accountCloseDate') else APIHelper.SKIP
        currency = CurrencyEntity4.from_dictionary(dictionary.get('currency')) if 'currency' in dictionary.keys() else APIHelper.SKIP
        fi_attributes = None
        if dictionary.get('fiAttributes') is not None:
            fi_attributes = [FiAttributeEntity.from_dictionary(x) for x in dictionary.get('fiAttributes')]
        else:
            fi_attributes = APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(balance_as_of,
                   principal_balance,
                   escrow_balance,
                   original_principal,
                   originating_date,
                   loan_term,
                   total_number_of_payments,
                   next_payment_amount,
                   next_payment_date,
                   payment_frequency,
                   compounding_period,
                   pay_off_amount,
                   last_payment_amount,
                   last_payment_date,
                   maturity_date,
                   interest_paid_year_to_date,
                   transactions,
                   parent_account_id,
                   line_of_business,
                   routing_transit_number,
                   balance_type,
                   contact,
                   interest_rate,
                   interest_rate_type,
                   interest_rate_as_of,
                   prior_interest_rate,
                   interest_rate_index,
                   early_penalty_flag,
                   transfer_in,
                   transfer_out,
                   bill_pay_status,
                   micr_number,
                   last_activity_date,
                   reward_program_id,
                   transactions_included,
                   domicile,
                   account_category,
                   account_id,
                   error,
                   account_type,
                   account_number,
                   account_number_display,
                   product_name,
                   nickname,
                   status,
                   description,
                   account_open_date,
                   account_close_date,
                   currency,
                   fi_attributes,
                   additional_properties)

    @classmethod
    def validate(cls, dictionary):
        """Validates dictionary against class required properties

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            boolean : if dictionary is valid contains required properties.

        """

        if isinstance(dictionary, cls):
            return True

        if not isinstance(dictionary, dict):
            return False

        return True

    def __repr__(self):
        base_repr = super().__repr__()
        return (f'{self.__class__.__name__}('
                f'{base_repr[base_repr.find("(") + 1:-1]}, '
                f'balance_as_of={(self.balance_as_of if hasattr(self, "balance_as_of") else None)!r}, '
                f'principal_balance={(self.principal_balance if hasattr(self, "principal_balance") else None)!r}, '
                f'escrow_balance={(self.escrow_balance if hasattr(self, "escrow_balance") else None)!r}, '
                f'original_principal={(self.original_principal if hasattr(self, "original_principal") else None)!r}, '
                f'originating_date={(self.originating_date if hasattr(self, "originating_date") else None)!r}, '
                f'loan_term={(self.loan_term if hasattr(self, "loan_term") else None)!r}, '
                f'total_number_of_payments={(self.total_number_of_payments if hasattr(self, "total_number_of_payments") else None)!r}, '
                f'next_payment_amount={(self.next_payment_amount if hasattr(self, "next_payment_amount") else None)!r}, '
                f'next_payment_date={(self.next_payment_date if hasattr(self, "next_payment_date") else None)!r}, '
                f'payment_frequency={(self.payment_frequency if hasattr(self, "payment_frequency") else None)!r}, '
                f'compounding_period={(self.compounding_period if hasattr(self, "compounding_period") else None)!r}, '
                f'pay_off_amount={(self.pay_off_amount if hasattr(self, "pay_off_amount") else None)!r}, '
                f'last_payment_amount={(self.last_payment_amount if hasattr(self, "last_payment_amount") else None)!r}, '
                f'last_payment_date={(self.last_payment_date if hasattr(self, "last_payment_date") else None)!r}, '
                f'maturity_date={(self.maturity_date if hasattr(self, "maturity_date") else None)!r}, '
                f'interest_paid_year_to_date={(self.interest_paid_year_to_date if hasattr(self, "interest_paid_year_to_date") else None)!r}, '
                f'transactions={(self.transactions if hasattr(self, "transactions") else None)!r})')

    def __str__(self):
        base_str = super().__str__()
        return (f'{self.__class__.__name__}('
                f'{base_str[base_str.find("(") + 1:-1]}, '
                f'balance_as_of={(self.balance_as_of if hasattr(self, "balance_as_of") else None)!s}, '
                f'principal_balance={(self.principal_balance if hasattr(self, "principal_balance") else None)!s}, '
                f'escrow_balance={(self.escrow_balance if hasattr(self, "escrow_balance") else None)!s}, '
                f'original_principal={(self.original_principal if hasattr(self, "original_principal") else None)!s}, '
                f'originating_date={(self.originating_date if hasattr(self, "originating_date") else None)!s}, '
                f'loan_term={(self.loan_term if hasattr(self, "loan_term") else None)!s}, '
                f'total_number_of_payments={(self.total_number_of_payments if hasattr(self, "total_number_of_payments") else None)!s}, '
                f'next_payment_amount={(self.next_payment_amount if hasattr(self, "next_payment_amount") else None)!s}, '
                f'next_payment_date={(self.next_payment_date if hasattr(self, "next_payment_date") else None)!s}, '
                f'payment_frequency={(self.payment_frequency if hasattr(self, "payment_frequency") else None)!s}, '
                f'compounding_period={(self.compounding_period if hasattr(self, "compounding_period") else None)!s}, '
                f'pay_off_amount={(self.pay_off_amount if hasattr(self, "pay_off_amount") else None)!s}, '
                f'last_payment_amount={(self.last_payment_amount if hasattr(self, "last_payment_amount") else None)!s}, '
                f'last_payment_date={(self.last_payment_date if hasattr(self, "last_payment_date") else None)!s}, '
                f'maturity_date={(self.maturity_date if hasattr(self, "maturity_date") else None)!s}, '
                f'interest_paid_year_to_date={(self.interest_paid_year_to_date if hasattr(self, "interest_paid_year_to_date") else None)!s}, '
                f'transactions={(self.transactions if hasattr(self, "transactions") else None)!s})')
