# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from fdxapi.api_helper import APIHelper
from fdxapi.models.basic_auth_credentials_1 import BasicAuthCredentials1


class BasicAuthForQr(object):

    """Implementation of the 'Basic Auth for QR' model.

    Tax form credentials container for QR Code purposes

    Attributes:
        basic_auth (BasicAuthCredentials1): The Basic Authentication
            credentials to retrieve a tax form
        version (FdxVersion): [Financial Data Exchange
            (FDX)](https://financialdataexchange.org/) schema version number
            (e.g. "V5.0").
        software_id (str): The FDX registration ID of company or software
            generating this tax data
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "basic_auth": 'basicAuth',
        "version": 'version',
        "software_id": 'softwareId'
    }

    _optionals = [
        'basic_auth',
        'version',
        'software_id',
    ]

    def __init__(self,
                 basic_auth=APIHelper.SKIP,
                 version=APIHelper.SKIP,
                 software_id=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the BasicAuthForQr class"""

        # Initialize members of the class
        if basic_auth is not APIHelper.SKIP:
            self.basic_auth = basic_auth 
        if version is not APIHelper.SKIP:
            self.version = version 
        if software_id is not APIHelper.SKIP:
            self.software_id = software_id 

        # Add additional model properties to the instance
        if additional_properties is None:
            additional_properties = {}
        self.additional_properties = additional_properties

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        basic_auth = BasicAuthCredentials1.from_dictionary(dictionary.get('basicAuth')) if 'basicAuth' in dictionary.keys() else APIHelper.SKIP
        version = dictionary.get("version") if dictionary.get("version") else APIHelper.SKIP
        software_id = dictionary.get("softwareId") if dictionary.get("softwareId") else APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(basic_auth,
                   version,
                   software_id,
                   additional_properties)

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'basic_auth={(self.basic_auth if hasattr(self, "basic_auth") else None)!r}, '
                f'version={(self.version if hasattr(self, "version") else None)!r}, '
                f'software_id={(self.software_id if hasattr(self, "software_id") else None)!r}, '
                f'additional_properties={self.additional_properties!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'basic_auth={(self.basic_auth if hasattr(self, "basic_auth") else None)!s}, '
                f'version={(self.version if hasattr(self, "version") else None)!s}, '
                f'software_id={(self.software_id if hasattr(self, "software_id") else None)!s}, '
                f'additional_properties={self.additional_properties!s})')
