# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
import dateutil.parser

from fdxapi.api_helper import APIHelper


class BillsEntity(object):

    """Implementation of the 'Bills entity' model.

    The payments due on an account

    Attributes:
        total_payment_due (float): Total payment due or next payment due. 
            Monthly payment due for loans
        minimum_payment_due (float): The minimum amount which is due
        due_date (date): The date that the payment is due
        auto_pay_enabled (bool): Whether the user's bill is paid automatically
        auto_pay_amount (float): The amount of money the user has set to
            autopay this bill
        auto_pay_date (date): The date the autopayment is set to trigger for
            this bill
        past_due_amount (float): The amount that the user should have already
            paid. The value is negative if user owes money
        last_payment_amount (float): The amount of the most recent payment
        last_payment_date (date): The date of most recent payment
        statement_balance (float): The amount of the last statement.  The
            value is negative if the user owes money
        statement_date (date): The date the statement was issued
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "total_payment_due": 'totalPaymentDue',
        "minimum_payment_due": 'minimumPaymentDue',
        "due_date": 'dueDate',
        "auto_pay_enabled": 'autoPayEnabled',
        "auto_pay_amount": 'autoPayAmount',
        "auto_pay_date": 'autoPayDate',
        "past_due_amount": 'pastDueAmount',
        "last_payment_amount": 'lastPaymentAmount',
        "last_payment_date": 'lastPaymentDate',
        "statement_balance": 'statementBalance',
        "statement_date": 'statementDate'
    }

    _optionals = [
        'total_payment_due',
        'minimum_payment_due',
        'due_date',
        'auto_pay_enabled',
        'auto_pay_amount',
        'auto_pay_date',
        'past_due_amount',
        'last_payment_amount',
        'last_payment_date',
        'statement_balance',
        'statement_date',
    ]

    def __init__(self,
                 total_payment_due=APIHelper.SKIP,
                 minimum_payment_due=APIHelper.SKIP,
                 due_date=APIHelper.SKIP,
                 auto_pay_enabled=APIHelper.SKIP,
                 auto_pay_amount=APIHelper.SKIP,
                 auto_pay_date=APIHelper.SKIP,
                 past_due_amount=APIHelper.SKIP,
                 last_payment_amount=APIHelper.SKIP,
                 last_payment_date=APIHelper.SKIP,
                 statement_balance=APIHelper.SKIP,
                 statement_date=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the BillsEntity class"""

        # Initialize members of the class
        if total_payment_due is not APIHelper.SKIP:
            self.total_payment_due = total_payment_due 
        if minimum_payment_due is not APIHelper.SKIP:
            self.minimum_payment_due = minimum_payment_due 
        if due_date is not APIHelper.SKIP:
            self.due_date = due_date 
        if auto_pay_enabled is not APIHelper.SKIP:
            self.auto_pay_enabled = auto_pay_enabled 
        if auto_pay_amount is not APIHelper.SKIP:
            self.auto_pay_amount = auto_pay_amount 
        if auto_pay_date is not APIHelper.SKIP:
            self.auto_pay_date = auto_pay_date 
        if past_due_amount is not APIHelper.SKIP:
            self.past_due_amount = past_due_amount 
        if last_payment_amount is not APIHelper.SKIP:
            self.last_payment_amount = last_payment_amount 
        if last_payment_date is not APIHelper.SKIP:
            self.last_payment_date = last_payment_date 
        if statement_balance is not APIHelper.SKIP:
            self.statement_balance = statement_balance 
        if statement_date is not APIHelper.SKIP:
            self.statement_date = statement_date 

        # Add additional model properties to the instance
        if additional_properties is None:
            additional_properties = {}
        self.additional_properties = additional_properties

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        total_payment_due = dictionary.get("totalPaymentDue") if dictionary.get("totalPaymentDue") else APIHelper.SKIP
        minimum_payment_due = dictionary.get("minimumPaymentDue") if dictionary.get("minimumPaymentDue") else APIHelper.SKIP
        due_date = dateutil.parser.parse(dictionary.get('dueDate')).date() if dictionary.get('dueDate') else APIHelper.SKIP
        auto_pay_enabled = dictionary.get("autoPayEnabled") if "autoPayEnabled" in dictionary.keys() else APIHelper.SKIP
        auto_pay_amount = dictionary.get("autoPayAmount") if dictionary.get("autoPayAmount") else APIHelper.SKIP
        auto_pay_date = dateutil.parser.parse(dictionary.get('autoPayDate')).date() if dictionary.get('autoPayDate') else APIHelper.SKIP
        past_due_amount = dictionary.get("pastDueAmount") if dictionary.get("pastDueAmount") else APIHelper.SKIP
        last_payment_amount = dictionary.get("lastPaymentAmount") if dictionary.get("lastPaymentAmount") else APIHelper.SKIP
        last_payment_date = dateutil.parser.parse(dictionary.get('lastPaymentDate')).date() if dictionary.get('lastPaymentDate') else APIHelper.SKIP
        statement_balance = dictionary.get("statementBalance") if dictionary.get("statementBalance") else APIHelper.SKIP
        statement_date = dateutil.parser.parse(dictionary.get('statementDate')).date() if dictionary.get('statementDate') else APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(total_payment_due,
                   minimum_payment_due,
                   due_date,
                   auto_pay_enabled,
                   auto_pay_amount,
                   auto_pay_date,
                   past_due_amount,
                   last_payment_amount,
                   last_payment_date,
                   statement_balance,
                   statement_date,
                   additional_properties)

    @classmethod
    def validate(cls, dictionary):
        """Validates dictionary against class required properties

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            boolean : if dictionary is valid contains required properties.

        """

        if isinstance(dictionary, cls):
            return True

        if not isinstance(dictionary, dict):
            return False

        return True

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'total_payment_due={(self.total_payment_due if hasattr(self, "total_payment_due") else None)!r}, '
                f'minimum_payment_due={(self.minimum_payment_due if hasattr(self, "minimum_payment_due") else None)!r}, '
                f'due_date={(self.due_date if hasattr(self, "due_date") else None)!r}, '
                f'auto_pay_enabled={(self.auto_pay_enabled if hasattr(self, "auto_pay_enabled") else None)!r}, '
                f'auto_pay_amount={(self.auto_pay_amount if hasattr(self, "auto_pay_amount") else None)!r}, '
                f'auto_pay_date={(self.auto_pay_date if hasattr(self, "auto_pay_date") else None)!r}, '
                f'past_due_amount={(self.past_due_amount if hasattr(self, "past_due_amount") else None)!r}, '
                f'last_payment_amount={(self.last_payment_amount if hasattr(self, "last_payment_amount") else None)!r}, '
                f'last_payment_date={(self.last_payment_date if hasattr(self, "last_payment_date") else None)!r}, '
                f'statement_balance={(self.statement_balance if hasattr(self, "statement_balance") else None)!r}, '
                f'statement_date={(self.statement_date if hasattr(self, "statement_date") else None)!r}, '
                f'additional_properties={self.additional_properties!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'total_payment_due={(self.total_payment_due if hasattr(self, "total_payment_due") else None)!s}, '
                f'minimum_payment_due={(self.minimum_payment_due if hasattr(self, "minimum_payment_due") else None)!s}, '
                f'due_date={(self.due_date if hasattr(self, "due_date") else None)!s}, '
                f'auto_pay_enabled={(self.auto_pay_enabled if hasattr(self, "auto_pay_enabled") else None)!s}, '
                f'auto_pay_amount={(self.auto_pay_amount if hasattr(self, "auto_pay_amount") else None)!s}, '
                f'auto_pay_date={(self.auto_pay_date if hasattr(self, "auto_pay_date") else None)!s}, '
                f'past_due_amount={(self.past_due_amount if hasattr(self, "past_due_amount") else None)!s}, '
                f'last_payment_amount={(self.last_payment_amount if hasattr(self, "last_payment_amount") else None)!s}, '
                f'last_payment_date={(self.last_payment_date if hasattr(self, "last_payment_date") else None)!s}, '
                f'statement_balance={(self.statement_balance if hasattr(self, "statement_balance") else None)!s}, '
                f'statement_date={(self.statement_date if hasattr(self, "statement_date") else None)!s}, '
                f'additional_properties={self.additional_properties!s})')
