# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from fdxapi.api_helper import APIHelper
from fdxapi.models.financial_institution_entity_2 import FinancialInstitutionEntity2
from fdxapi.models.payment_delivery_address_entity import PaymentDeliveryAddressEntity


class BranchEntity(object):

    """Implementation of the 'Branch entity' model.

    Details on the Branch that is owning the destination account

    Attributes:
        branch_id (str): Branch number
        name (str): Name of the branch
        locations (List[PaymentDeliveryAddressEntity]): Location of the branch
        financial_institution (FinancialInstitutionEntity2): Financial
            institution associated with the branch
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "branch_id": 'branchId',
        "name": 'name',
        "locations": 'locations',
        "financial_institution": 'financialInstitution'
    }

    _optionals = [
        'branch_id',
        'name',
        'locations',
        'financial_institution',
    ]

    def __init__(self,
                 branch_id=APIHelper.SKIP,
                 name=APIHelper.SKIP,
                 locations=APIHelper.SKIP,
                 financial_institution=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the BranchEntity class"""

        # Initialize members of the class
        if branch_id is not APIHelper.SKIP:
            self.branch_id = branch_id 
        if name is not APIHelper.SKIP:
            self.name = name 
        if locations is not APIHelper.SKIP:
            self.locations = locations 
        if financial_institution is not APIHelper.SKIP:
            self.financial_institution = financial_institution 

        # Add additional model properties to the instance
        if additional_properties is None:
            additional_properties = {}
        self.additional_properties = additional_properties

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        branch_id = dictionary.get("branchId") if dictionary.get("branchId") else APIHelper.SKIP
        name = dictionary.get("name") if dictionary.get("name") else APIHelper.SKIP
        locations = None
        if dictionary.get('locations') is not None:
            locations = [PaymentDeliveryAddressEntity.from_dictionary(x) for x in dictionary.get('locations')]
        else:
            locations = APIHelper.SKIP
        financial_institution = FinancialInstitutionEntity2.from_dictionary(dictionary.get('financialInstitution')) if 'financialInstitution' in dictionary.keys() else APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(branch_id,
                   name,
                   locations,
                   financial_institution,
                   additional_properties)

    @classmethod
    def validate(cls, dictionary):
        """Validates dictionary against class required properties

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            boolean : if dictionary is valid contains required properties.

        """

        if isinstance(dictionary, cls):
            return True

        if not isinstance(dictionary, dict):
            return False

        return True

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'branch_id={(self.branch_id if hasattr(self, "branch_id") else None)!r}, '
                f'name={(self.name if hasattr(self, "name") else None)!r}, '
                f'locations={(self.locations if hasattr(self, "locations") else None)!r}, '
                f'financial_institution={(self.financial_institution if hasattr(self, "financial_institution") else None)!r}, '
                f'additional_properties={self.additional_properties!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'branch_id={(self.branch_id if hasattr(self, "branch_id") else None)!s}, '
                f'name={(self.name if hasattr(self, "name") else None)!s}, '
                f'locations={(self.locations if hasattr(self, "locations") else None)!s}, '
                f'financial_institution={(self.financial_institution if hasattr(self, "financial_institution") else None)!s}, '
                f'additional_properties={self.additional_properties!s})')
